-- mod-version:3
local syntax = require 'core.syntax'

syntax.add {
	name = "Gravity",
	files = { "%.gravity$" },
	comment = "//",
	block_comment = {"/*", "*/"},
	patterns = {
		{ pattern = "#![^\n]+", type = "comment" },
		{ pattern = "//[^\n]+", type = "comment" },
		{ pattern = { "/%*", "%*/" }, type = "comment" },
		{ pattern = { '"', '"', "\\" }, type = "string" },

		{ pattern = "[~=!<>]=?", type = "operator" },
		{ pattern = "[!=]==", type = "operator" },
		{ pattern = "[%+%-%*/%%&|^]", type = "operator" },
		{ pattern = "%.%.[%.<]", type = "operator" },

		{ pattern = "0[bB][0-1]+%f[%D]", type = "number" },
		{ pattern = "0[oO][0-7]+", type = "number" },
		{ pattern = "0[xX]%x+", type = "number" },
		{ pattern = "%.?%d+[eE]?%-?%d*", type = "number" },

		{ pattern = "#%s*include%s*%f[\"]", type = "literal"},
		{ pattern = "#%s*unittest%s*%f[{]", type = "literal"},

		--{ pattern = "[%+%-%*/]%s*()%(", type = { "function", "normal" }},
		{ pattern = "[%a_][%w_]+%s*%f[%(]", type = "function"},
		{ pattern = "[%a_][%w_]*", type = "symbol" },
	},
	symbols = {
		["true"]  = "literal",
		["false"] = "literal",
		["null"]  = "literal",
		["self"]  = "keyword2",

		["Object"]   = "literal",
		["Int"]      = "literal",
		["Float"]    = "literal",
		["String"]   = "literal",
		["Bool"]     = "literal",
		["Null"]     = "literal",
		["Class"]    = "literal",
		["Function"] = "literal",
		["Fiber"]    = "literal",
		["Instance"] = "literal",
		["List"]     = "literal",
		["Map"]      = "literal",
		["Range"]    = "literal",

		["System"] = "literal",
		["Math"]   = "literal",
		["File"]   = "literal",
		["ENV"]    = "literal",

		["if"]        = "keyword",
		["in"]        = "keyword",
		["or"]        = "keyword",
		["is"]        = "operator",
		["for"]       = "keyword",
		["var"]       = "keyword",
		["and"]       = "keyword",
		["not"]       = "keyword",
		["func"]      = "keyword",
		["else"]      = "keyword",
		["true"]      = "keyword",
		["enum"]      = "keyword",
		["case"]      = "keyword",
		["null"]      = "keyword",
		["file"]      = "keyword",
		["lazy"]      = "keyword",
		["super"]     = "keyword",
		["break"]     = "keyword",
		["while"]     = "keyword",
		["class"]     = "keyword",
		["const"]     = "keyword",
		["event"]     = "keyword",
		["_func"]     = "keyword",
		["_args"]     = "keyword",
		["struct"]    = "keyword",
		["repeat"]    = "keyword",
		["switch"]    = "keyword",
		["return"]    = "keyword",
		["public"]    = "keyword",
		["static"]    = "keyword",
		["extern"]    = "keyword",
		["import"]    = "keyword",
		["module"]    = "keyword",
		["default"]   = "keyword",
		["private"]   = "keyword",
		["continue"]  = "keyword",
		["internal"]  = "keyword",
		["undefined"] = "keyword",
	}
}


