# -*- coding:utf-8 -*-
import pytest
# node-semver/test/index.js

cands = [
    ['1.0.0 - 2.0.0', '1.2.3', False, False],
    ['^1.2.3+build', '1.2.3', False, False],
    ['^1.2.3+build', '1.3.0', False, False],
    ['1.2.3-pre+asdf - 2.4.3-pre+asdf', '1.2.3', False, False],
    ['1.2.3pre+asdf - 2.4.3-pre+asdf', '1.2.3', True, False],
    ['1.2.3-pre+asdf - 2.4.3pre+asdf', '1.2.3', True, False],
    ['1.2.3pre+asdf - 2.4.3pre+asdf', '1.2.3', True, False],
    ['1.2.3-pre+asdf - 2.4.3-pre+asdf', '1.2.3-pre.2', False, False],
    ['1.2.3-pre+asdf - 2.4.3-pre+asdf', '2.4.3-alpha', False, False],
    ['1.2.3+asdf - 2.4.3+asdf', '1.2.3', False, False],
    ['1.0.0', '1.0.0', False, False],
    ['>=*', '0.2.4', False, False],
    ['', '1.0.0', False, False],
    ['*', '1.2.3', False, False],
    ['*', 'v1.2.3', True, False],
    ['>=1.0.0', '1.0.0', False, False],
    ['>=1.0.0', '1.0.1', False, False],
    ['>=1.0.0', '1.1.0', False, False],
    ['>1.0.0', '1.0.1', False, False],
    ['>1.0.0', '1.0.1-pre.1', False, True],
    ['>1.0.0', '1.1.0', False, False],
    ['<=2.0.0', '2.0.0', False, False],
    ['<=2.0.0', '1.9999.9999', False, False],
    ['<=2.0.0', '0.2.9', False, False],
    ['<2.0.0', '1.9999.9999', False, False],
    ['<2.0.0', '0.2.9', False, False],
    ['>= 1.0.0', '1.0.0', False, False],
    ['>=  1.0.0', '1.0.1', False, False],
    ['>=   1.0.0', '1.1.0', False, False],
    ['> 1.0.0', '1.0.1', False, False],
    ['>  1.0.0', '1.1.0', False, False],
    ['<=   2.0.0', '2.0.0', False, False],
    ['<= 2.0.0', '1.9999.9999', False, False],
    ['<=  2.0.0', '0.2.9', False, False],
    ['<    2.0.0', '1.9999.9999', False, False],
    ['<\t2.0.0', '0.2.9', False, False],
    ['>=0.1.97', 'v0.1.97', True, False],
    ['>=0.1.97', '0.1.97', False, False],
    ['0.1.20 || 1.2.4', '1.2.4', False, False],
    ['>=0.2.3 || <0.0.1', '0.0.0', False, False],
    ['>=0.2.3 || <0.0.1', '0.2.3', False, False],
    ['>=0.2.3 || <0.0.1', '0.2.4', False, False],
    ['||', '1.3.4', False, False],
    ['2.x.x', '2.1.3', False, False],
    ['1.2.x', '1.2.3', False, False],
    ['1.2.x || 2.x', '2.1.3', False, False],
    ['1.2.x || 2.x', '1.2.3', False, False],
    ['x', '1.2.3', False, False],
    ['2.*.*', '2.1.3', False, False],
    ['1.2.*', '1.2.3', False, False],
    ['1.2.* || 2.*', '2.1.3', False, False],
    ['1.2.* || 2.*', '1.2.3', False, False],
    ['*', '1.2.3', False, False],
    ['2', '2.1.2', False, False],
    ['2.3', '2.3.1', False, False],
    ['~x', '0.0.9', False, False],  # >=2.4.0 <2.5.0
    ['~2', '2.0.9', False, False],  # >=2.4.0 <2.5.0
    ['~2.4', '2.4.0', False, False],  # >=2.4.0 <2.5.0
    ['~2.4', '2.4.5', False, False],
    ['~>3.2.1', '3.2.2', False, False],  # >=3.2.1 <3.3.0,
    ['~1', '1.2.3', False, False],  # >=1.0.0 <2.0.0
    ['~>1', '1.2.3', False, False],
    ['~> 1', '1.2.3', False, False],
    ['~1.0', '1.0.2', False, False],  # >=1.0.0 <1.1.0,
    ['~ 1.0', '1.0.2', False, False],
    ['~ 1.0.3', '1.0.12', False, False],
    ['>=1', '1.0.0', False, False],
    ['>= 1', '1.0.0', False, False],
    ['<1.2', '1.1.1', False, False],
    ['< 1.2', '1.1.1', False, False],
    ['~v0.5.4-pre', '0.5.5', False, False],
    ['~v0.5.4-pre', '0.5.4', False, False],
    ['=0.7.x', '0.7.2', False, False],
    ['<=0.7.x', '0.7.2', False, False],
    ['>=0.7.x', '0.7.2', False, False],
    ['<=0.7.x', '0.6.2', False, False],
    ['~1.2.1 >=1.2.3', '1.2.3', False, False],
    ['~1.2.1 =1.2.3', '1.2.3', False, False],
    ['~1.2.1 1.2.3', '1.2.3', False, False],
    ['~1.2.1 >=1.2.3 1.2.3', '1.2.3', False, False],
    ['~1.2.1 1.2.3 >=1.2.3', '1.2.3', False, False],
    ['~1.2.1 1.2.3', '1.2.3', False, False],
    ['>=1.2.1 1.2.3', '1.2.3', False, False],
    ['1.2.3 >=1.2.1', '1.2.3', False, False],
    ['>=1.2.3 >=1.2.1', '1.2.3', False, False],
    ['>=1.2.1 >=1.2.3', '1.2.3', False, False],
    ['>=1.2', '1.2.8', False, False],
    ['^1.2.3', '1.8.1', False, False],
    ['^0.1.2', '0.1.2', False, False],
    ['^0.1', '0.1.2', False, False],
    ['^0.0.1', '0.0.1', False, False],
    ['^1.2', '1.4.2', False, False],
    ['^1.2 ^1', '1.4.2', False, False],
    ['^1.2.3-alpha', '1.2.3-pre', False, False],
    ['^1.2.3-alpha', '1.2.4-pre', False, True],
    ['^1.2.0-alpha', '1.2.0-pre', False, False],
    ['^0.0.1-alpha', '0.0.1-beta', False, False],
    ['^0.1.1-alpha', '0.1.1-beta', False, False],
    ['^x', '1.2.3', False, False],
    ['x - 1.0.0', '0.9.7', False, False],
    ['x - 1.x', '0.9.7', False, False],
    ['1.0.0 - x', '1.9.7', False, False],
    ['1.x - x', '1.9.7', False, False],
    ['<=7.x', '7.9.9', False, False]
]


@pytest.mark.parametrize("range_, version, loose, include_prerelease", cands)
def test_it(range_, version, loose, include_prerelease):
    from semver import satisfies
    assert satisfies(version, range_, loose, include_prerelease) is True
