(function() {var type_impls = {
"std":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2227\">source</a></span><a href=\"#impl-PartialOrd-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2229\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2235\">source</a><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2241\">source</a><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2247\">source</a><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2253\">source</a><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","std::os::windows::raw::HANDLE"],["<section id=\"impl-CoerceUnsized%3C*mut+U%3E-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ops/unsize.rs.html#62\">source</a><a href=\"#impl-CoerceUnsized%3C*mut+U%3E-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U&gt; <a class=\"trait\" href=\"std/ops/trait.CoerceUnsized.html\" title=\"trait std::ops::CoerceUnsized\">CoerceUnsized</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut U</a>&gt; for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/marker/trait.Unsize.html\" title=\"trait std::marker::Unsize\">Unsize</a>&lt;U&gt; + ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,\n    U: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","CoerceUnsized<*mut U>","std::os::windows::raw::HANDLE"],["<section id=\"impl-CoerceUnsized%3C*const+U%3E-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ops/unsize.rs.html#65\">source</a><a href=\"#impl-CoerceUnsized%3C*const+U%3E-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U&gt; <a class=\"trait\" href=\"std/ops/trait.CoerceUnsized.html\" title=\"trait std::ops::CoerceUnsized\">CoerceUnsized</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*const U</a>&gt; for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/marker/trait.Unsize.html\" title=\"trait std::marker::Unsize\">Unsize</a>&lt;U&gt; + ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,\n    U: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","CoerceUnsized<*const U>","std::os::windows::raw::HANDLE"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Hash-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#964\">source</a></span><a href=\"#impl-Hash-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/hash/trait.Hash.html\" title=\"trait std::hash::Hash\">Hash</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/hash/mod.rs.html#966\">source</a><a href=\"#method.hash\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/hash/trait.Hash.html#tymethod.hash\" class=\"fn\">hash</a>&lt;H&gt;(&amp;self, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut H</a>)<div class=\"where\">where\n    H: <a class=\"trait\" href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\">Hasher</a>,</div></h4></section></summary><div class='docblock'>Feeds this value into the given <a href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\"><code>Hasher</code></a>. <a href=\"std/hash/trait.Hash.html#tymethod.hash\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash_slice\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.3.0\">1.3.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#238-240\">source</a></span><a href=\"#method.hash_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/hash/trait.Hash.html#method.hash_slice\" class=\"fn\">hash_slice</a>&lt;H&gt;(data: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[Self]</a>, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut H</a>)<div class=\"where\">where\n    H: <a class=\"trait\" href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\">Hasher</a>,\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Feeds a slice of this type into the given <a href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\"><code>Hasher</code></a>. <a href=\"std/hash/trait.Hash.html#method.hash_slice\">Read more</a></div></details></div></details>","Hash","std::os::windows::raw::HANDLE"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Pointer-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/fmt/mod.rs.html#2436\">source</a></span><a href=\"#impl-Pointer-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/fmt/trait.Pointer.html\" title=\"trait std::fmt::Pointer\">Pointer</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/fmt/mod.rs.html#2437\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/fmt/trait.Pointer.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"std/fmt/struct.Formatter.html\" title=\"struct std::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"primitive.unit.html\">()</a>, <a class=\"struct\" href=\"std/fmt/struct.Error.html\" title=\"struct std::fmt::Error\">Error</a>&gt;</h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","Pointer","std::os::windows::raw::HANDLE"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/clone.rs.html#251\">source</a></span><a href=\"#impl-Clone-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/clone.rs.html#253\">source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class='docblock'>Returns a copy of the value. <a href=\"std/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/clone.rs.html#169\">source</a></span><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Self</a>)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"std/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","std::os::windows::raw::HANDLE"],["<section id=\"impl-Send-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#89\">source</a></span><a href=\"#impl-Send-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; !<a class=\"trait\" href=\"std/marker/trait.Send.html\" title=\"trait std::marker::Send\">Send</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","Send","std::os::windows::raw::HANDLE"],["<section id=\"impl-UnwindSafe-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.9.0\">1.9.0</span> · <a class=\"src\" href=\"src/core/panic/unwind_safe.rs.html#187\">source</a></span><a href=\"#impl-UnwindSafe-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/panic/trait.UnwindSafe.html\" title=\"trait std::panic::UnwindSafe\">UnwindSafe</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/panic/trait.RefUnwindSafe.html\" title=\"trait std::panic::RefUnwindSafe\">RefUnwindSafe</a> + ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","UnwindSafe","std::os::windows::raw::HANDLE"],["<section id=\"impl-Sync-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#673\">source</a></span><a href=\"#impl-Sync-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; !<a class=\"trait\" href=\"std/marker/trait.Sync.html\" title=\"trait std::marker::Sync\">Sync</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","Sync","std::os::windows::raw::HANDLE"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/fmt/mod.rs.html#2465\">source</a></span><a href=\"#impl-Debug-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/fmt/mod.rs.html#2466\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"std/fmt/struct.Formatter.html\" title=\"struct std::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"primitive.unit.html\">()</a>, <a class=\"struct\" href=\"std/fmt/struct.Error.html\" title=\"struct std::fmt::Error\">Error</a>&gt;</h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"std/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","std::os::windows::raw::HANDLE"],["<section id=\"impl-Eq-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2209\">source</a></span><a href=\"#impl-Eq-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/cmp/trait.Eq.html\" title=\"trait std::cmp::Eq\">Eq</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","Eq","std::os::windows::raw::HANDLE"],["<section id=\"impl-Unpin-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.38.0\">1.38.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#994-999\">source</a></span><a href=\"#impl-Unpin-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/marker/trait.Unpin.html\" title=\"trait std::marker::Unpin\">Unpin</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","Unpin","std::os::windows::raw::HANDLE"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-SimdElement-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/portable-simd\\crates\\core_simd\\src/vector.rs.html#976-978\">source</a><a href=\"#impl-SimdElement-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/simd/trait.SimdElement.html\" title=\"trait std::simd::SimdElement\">SimdElement</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/ptr/trait.Pointee.html\" title=\"trait std::ptr::Pointee\">Pointee</a>&lt;Metadata = <a class=\"primitive\" href=\"primitive.unit.html\">()</a>&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Mask\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Mask\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/simd/trait.SimdElement.html#associatedtype.Mask\" class=\"associatedtype\">Mask</a> = <a class=\"primitive\" href=\"primitive.isize.html\">isize</a></h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>portable_simd</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/86656\">#86656</a>)</span></div></span><div class='docblock'>The mask element type corresponding to this element type.</div></details></div></details>","SimdElement","std::os::windows::raw::HANDLE"],["<section id=\"impl-Copy-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/marker.rs.html#491-501\">source</a></span><a href=\"#impl-Copy-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/marker/trait.Copy.html\" title=\"trait std::marker::Copy\">Copy</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","Copy","std::os::windows::raw::HANDLE"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2200\">source</a></span><a href=\"#impl-PartialEq-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2203\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#242\">source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq","std::os::windows::raw::HANDLE"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-*mut+T\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#2212\">source</a></span><a href=\"#impl-Ord-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/cmp/trait.Ord.html\" title=\"trait std::cmp::Ord\">Ord</a> for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#2215\">source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"std/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#830-832\">source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"std/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#850-852\">source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"std/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#875-878\">source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<div class=\"where\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>,</div></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"std/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","std::os::windows::raw::HANDLE"],["<section id=\"impl-DispatchFromDyn%3C*mut+U%3E-for-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ops/unsize.rs.html#132\">source</a><a href=\"#impl-DispatchFromDyn%3C*mut+U%3E-for-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U&gt; <a class=\"trait\" href=\"std/ops/trait.DispatchFromDyn.html\" title=\"trait std::ops::DispatchFromDyn\">DispatchFromDyn</a>&lt;<a class=\"primitive\" href=\"primitive.pointer.html\">*mut U</a>&gt; for <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: <a class=\"trait\" href=\"std/marker/trait.Unsize.html\" title=\"trait std::marker::Unsize\">Unsize</a>&lt;U&gt; + ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,\n    U: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section>","DispatchFromDyn<*mut U>","std::os::windows::raw::HANDLE"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-*mut+T\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#7\">source</a><a href=\"#impl-*mut+T\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a><div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_null\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const unstable\">1.0.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/74939\" title=\"Tracking issue for const_ptr_is_null\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#35\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.is_null\" class=\"fn\">is_null</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the pointer is null.</p>\n<p>Note that unsized types have many possible null pointers, as only the\nraw data pointer is considered, not their length, vtable, etc.\nTherefore, two pointers that are null may still not compare equal to\neach other.</p>\n<h6 id=\"behavior-during-const-evaluation\"><a class=\"doc-anchor\" href=\"#behavior-during-const-evaluation\">§</a>Behavior during const evaluation</h6>\n<p>When this function is used during const evaluation, it may return <code>false</code> for pointers\nthat turn out to be null at runtime. Specifically, when a pointer to some memory\nis offset beyond its bounds in such a way that the resulting pointer is null,\nthe function will still return <code>false</code>. There is no way for CTFE to know\nthe absolute position of that memory, so we cannot tell if the pointer is\nnull or not.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n<span class=\"macro\">assert!</span>(!ptr.is_null());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+s+=+%5B1,+2,+3%5D;%0Alet+ptr:+*mut+u32+=+s.as_mut_ptr();%0Aassert!(!ptr.is_null());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.38.0, const since 1.38.0\">1.38.0 (const: 1.38.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#60\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"std/primitive.pointer.html#tymethod.cast\" class=\"fn\">cast</a>&lt;U&gt;(self) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut U</a></h4></section></summary><div class=\"docblock\"><p>Casts to a pointer of another type.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.with_metadata_of\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/75091\" title=\"Tracking issue for set_ptr_value\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#96-98\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.with_metadata_of\" class=\"fn\">with_metadata_of</a>&lt;U&gt;(self, meta: <a class=\"primitive\" href=\"primitive.pointer.html\">*const U</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut U</a><div class=\"where\">where\n    U: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>set_ptr_value</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/75091\">#75091</a>)</span></div></span></summary><div class=\"docblock\"><p>Use the pointer value in a new pointer of another type.</p>\n<p>In case <code>meta</code> is a (fat) pointer to an unsized type, this operation\nwill ignore the pointer part, whereas for (thin) pointers to sized\ntypes, this has the same effect as a simple cast.</p>\n<p>The resulting pointer will have provenance of <code>self</code>, i.e., for a fat\npointer, this operation is semantically the same as creating a new\nfat pointer with the data pointer value of <code>self</code> but the metadata of\n<code>meta</code>.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<p>This function is primarily useful for allowing byte-wise pointer\narithmetic on potentially fat pointers:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(set_ptr_value)]\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>arr: [i32; <span class=\"number\">3</span>] = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>ptr = arr.as_mut_ptr() <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span><span class=\"kw\">dyn </span>Debug;\n<span class=\"kw\">let </span>thin = ptr <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n<span class=\"kw\">unsafe </span>{\n    ptr = thin.add(<span class=\"number\">8</span>).with_metadata_of(ptr);\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"{:?}\"</span>, <span class=\"kw-2\">&amp;*</span>ptr); <span class=\"comment\">// will print \"3\"\n</span>}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(set_ptr_value)%5D%0Afn+main()+%7B%0Ause+core::fmt::Debug;%0Alet+mut+arr:+%5Bi32;+3%5D+=+%5B1,+2,+3%5D;%0Alet+mut+ptr+=+arr.as_mut_ptr()+as+*mut+dyn+Debug;%0Alet+thin+=+ptr+as+*mut+u8;%0Aunsafe+%7B%0A++++ptr+=+thin.add(8).with_metadata_of(ptr);%0Aassert_eq!(*(ptr+as+*mut+i32),+3);%0A++++println!(%22%7B:?%7D%22,+%26*ptr);+//+will+print+%223%22%0A%7D%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.cast_const\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.65.0, const since 1.65.0\">1.65.0 (const: 1.65.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#117\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"std/primitive.pointer.html#tymethod.cast_const\" class=\"fn\">cast_const</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a></h4></section></summary><div class=\"docblock\"><p>Changes constness without changing the type.</p>\n<p>This is a bit safer than <code>as</code> because it wouldn’t silently change the type if the code is\nrefactored.</p>\n<p>While not strictly required (<code>*mut T</code> coerces to <code>*const T</code>), this is provided for symmetry\nwith <a href=\"std/primitive.pointer.html#method.cast_mut\" title=\"method pointer::cast_mut\"><code>cast_mut</code></a> on <code>*const T</code> and may have documentation value if used instead of implicit\ncoercion.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_bits\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#150-152\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.to_bits\" class=\"fn\">to_bits</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section><span class=\"item-info\"><div class=\"stab deprecated\"><span class=\"emoji\">👎</span><span>Deprecated since 1.67.0: replaced by the <code>expose_addr</code> method, or update your code to follow the strict provenance rules using its APIs</span></div><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_to_from_bits</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91126\">#91126</a>)</span></div></span></summary><div class=\"docblock\"><p>Casts a pointer to its raw bits.</p>\n<p>This is equivalent to <code>as usize</code>, but is more specific to enhance readability.\nThe inverse method is <a href=\"std/primitive.pointer.html#method.from_bits-1\" title=\"primitive pointer\"><code>from_bits</code></a>.</p>\n<p>In particular, <code>*p as usize</code> and <code>p as usize</code> will both compile for\npointers to numeric types but do very different things, so using this\nhelps emphasize that reading the bits was intentional.</p>\n<h5 id=\"examples-2\"><a class=\"doc-anchor\" href=\"#examples-2\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_to_from_bits)]\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>array = [<span class=\"number\">13</span>, <span class=\"number\">42</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>it = array.iter_mut();\n<span class=\"kw\">let </span>p0: <span class=\"kw-2\">*mut </span>i32 = it.next().unwrap();\n<span class=\"macro\">assert_eq!</span>(&lt;<span class=\"kw-2\">*mut </span><span class=\"kw\">_</span>&gt;::from_bits(p0.to_bits()), p0);\n<span class=\"kw\">let </span>p1: <span class=\"kw-2\">*mut </span>i32 = it.next().unwrap();\n<span class=\"macro\">assert_eq!</span>(p1.to_bits() - p0.to_bits(), <span class=\"number\">4</span>);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_to_from_bits)%5D%0Afn+main()+%7B%0A%23%5Bcfg(not(miri))%5D+%7B+//+doctest+does+not+work+with+strict+provenance%0Alet+mut+array+=+%5B13,+42%5D;%0Alet+mut+it+=+array.iter_mut();%0Alet+p0:+*mut+i32+=+it.next().unwrap();%0Aassert_eq!(%3C*mut+_%3E::from_bits(p0.to_bits()),+p0);%0Alet+p1:+*mut+i32+=+it.next().unwrap();%0Aassert_eq!(p1.to_bits()+-+p0.to_bits(),+4);%0A%7D%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_bits\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#180-182\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.from_bits\" class=\"fn\">from_bits</a>(bits: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section><span class=\"item-info\"><div class=\"stab deprecated\"><span class=\"emoji\">👎</span><span>Deprecated since 1.67.0: replaced by the <code>ptr::from_exposed_addr_mut</code> function, or update your code to follow the strict provenance rules using its APIs</span></div><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_to_from_bits</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/91126\">#91126</a>)</span></div></span></summary><div class=\"docblock\"><p>Creates a pointer from its raw bits.</p>\n<p>This is equivalent to <code>as *mut T</code>, but is more specific to enhance readability.\nThe inverse method is <a href=\"std/primitive.pointer.html#method.to_bits-1\" title=\"primitive pointer\"><code>to_bits</code></a>.</p>\n<h5 id=\"examples-3\"><a class=\"doc-anchor\" href=\"#examples-3\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_to_from_bits)]\n</span><span class=\"kw\">use </span>std::ptr::NonNull;\n<span class=\"kw\">let </span>dangling: <span class=\"kw-2\">*mut </span>u8 = NonNull::dangling().as_ptr();\n<span class=\"macro\">assert_eq!</span>(&lt;<span class=\"kw-2\">*mut </span>u8&gt;::from_bits(<span class=\"number\">1</span>), dangling);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_to_from_bits)%5D%0Afn+main()+%7B%0A%23%5Bcfg(not(miri))%5D+%7B+//+doctest+does+not+work+with+strict+provenance%0Ause+std::ptr::NonNull;%0Alet+dangling:+*mut+u8+=+NonNull::dangling().as_ptr();%0Aassert_eq!(%3C*mut+u8%3E::from_bits(1),+dangling);%0A%7D%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.addr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#213\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.addr\" class=\"fn\">addr</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>strict_provenance</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/95228\">#95228</a>)</span></div></span></summary><div class=\"docblock\"><p>Gets the “address” portion of the pointer.</p>\n<p>This is similar to <code>self as usize</code>, which semantically discards <em>provenance</em> and\n<em>address-space</em> information. However, unlike <code>self as usize</code>, casting the returned address\nback to a pointer yields <a href=\"std/ptr/fn.invalid.html\" title=\"fn std::ptr::invalid\"><code>invalid</code></a>, which is undefined behavior to dereference. To\nproperly restore the lost information and obtain a dereferenceable pointer, use\n<a href=\"std/primitive.pointer.html#method.with_addr\" title=\"method pointer::with_addr\"><code>with_addr</code></a> or <a href=\"std/primitive.pointer.html#method.map_addr\" title=\"method pointer::map_addr\"><code>map_addr</code></a>.</p>\n<p>If using those APIs is not possible because there is no way to preserve a pointer with the\nrequired provenance, then Strict Provenance might not be for you. Use pointer-integer casts\nor <a href=\"std/primitive.pointer.html#method.expose_addr\" title=\"method pointer::expose_addr\"><code>expose_addr</code></a> and <a href=\"std/ptr/fn.from_exposed_addr.html\" title=\"fn std::ptr::from_exposed_addr\"><code>from_exposed_addr</code></a>\ninstead. However, note that this makes your code less portable and less amenable to tools\nthat check for compliance with the Rust memory model.</p>\n<p>On most platforms this will produce a value with the same bytes as the original\npointer, because all the bytes are dedicated to describing the address.\nPlatforms which need to store additional information in the pointer may\nperform a change of representation to produce a value containing only the address\nportion of the pointer. What that means is up to the platform to define.</p>\n<p>This API and its claimed semantics are part of the Strict Provenance experiment, and as such\nmight change in the future (including possibly weakening this so it becomes wholly\nequivalent to <code>self as usize</code>). See the <a href=\"std/ptr/index.html\" title=\"mod std::ptr\">module documentation</a> for details.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.expose_addr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#248\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.expose_addr\" class=\"fn\">expose_addr</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>exposed_provenance</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/95228\">#95228</a>)</span></div></span></summary><div class=\"docblock\"><p>Gets the “address” portion of the pointer, and ‘exposes’ the “provenance” part for future\nuse in <a href=\"std/ptr/fn.from_exposed_addr.html\" title=\"fn std::ptr::from_exposed_addr\"><code>from_exposed_addr</code></a>.</p>\n<p>This is equivalent to <code>self as usize</code>, which semantically discards <em>provenance</em> and\n<em>address-space</em> information. Furthermore, this (like the <code>as</code> cast) has the implicit\nside-effect of marking the provenance as ‘exposed’, so on platforms that support it you can\nlater call <a href=\"std/ptr/fn.from_exposed_addr_mut.html\" title=\"fn std::ptr::from_exposed_addr_mut\"><code>from_exposed_addr_mut</code></a> to reconstitute the original pointer including its\nprovenance. (Reconstructing address space information, if required, is your responsibility.)</p>\n<p>Using this method means that code is <em>not</em> following <a href=\"std/ptr/index.html#strict-provenance\" title=\"mod std::ptr\">Strict\nProvenance</a> rules. Supporting\n<a href=\"std/ptr/fn.from_exposed_addr_mut.html\" title=\"fn std::ptr::from_exposed_addr_mut\"><code>from_exposed_addr_mut</code></a> complicates specification and reasoning and may not be supported\nby tools that help you to stay conformant with the Rust memory model, so it is recommended\nto use <a href=\"std/primitive.pointer.html#method.addr\" title=\"method pointer::addr\"><code>addr</code></a> wherever possible.</p>\n<p>On most platforms this will produce a value with the same bytes as the original pointer,\nbecause all the bytes are dedicated to describing the address. Platforms which need to store\nadditional information in the pointer may not support this operation, since the ‘expose’\nside-effect which is required for <a href=\"std/ptr/fn.from_exposed_addr_mut.html\" title=\"fn std::ptr::from_exposed_addr_mut\"><code>from_exposed_addr_mut</code></a> to work is typically not\navailable.</p>\n<p>It is unclear whether this method can be given a satisfying unambiguous specification. This\nAPI and its claimed semantics are part of <a href=\"std/ptr/index.html#exposed-provenance\" title=\"mod std::ptr\">Exposed Provenance</a>.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.with_addr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#268\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.with_addr\" class=\"fn\">with_addr</a>(self, addr: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>strict_provenance</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/95228\">#95228</a>)</span></div></span></summary><div class=\"docblock\"><p>Creates a new pointer with the given address.</p>\n<p>This performs the same operation as an <code>addr as ptr</code> cast, but copies\nthe <em>address-space</em> and <em>provenance</em> of <code>self</code> to the new pointer.\nThis allows us to dynamically preserve and propagate this important\ninformation in a way that is otherwise impossible with a unary cast.</p>\n<p>This is equivalent to using <a href=\"std/primitive.pointer.html#method.wrapping_offset\" title=\"method pointer::wrapping_offset\"><code>wrapping_offset</code></a> to offset\n<code>self</code> to the given address, and therefore has all the same capabilities and restrictions.</p>\n<p>This API and its claimed semantics are an extension to the Strict Provenance experiment,\nsee the <a href=\"std/ptr/index.html\" title=\"mod std::ptr\">module documentation</a> for details.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.map_addr\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#291\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.map_addr\" class=\"fn\">map_addr</a>(self, f: impl <a class=\"trait\" href=\"std/ops/trait.FnOnce.html\" title=\"trait std::ops::FnOnce\">FnOnce</a>(<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>strict_provenance</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/95228\">#95228</a>)</span></div></span></summary><div class=\"docblock\"><p>Creates a new pointer by mapping <code>self</code>’s address to a new one.</p>\n<p>This is a convenience for <a href=\"std/primitive.pointer.html#method.with_addr\" title=\"method pointer::with_addr\"><code>with_addr</code></a>, see that method for details.</p>\n<p>This API and its claimed semantics are part of the Strict Provenance experiment,\nsee the <a href=\"std/ptr/index.html\" title=\"mod std::ptr\">module documentation</a> for details.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.to_raw_parts\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/81513\" title=\"Tracking issue for ptr_metadata\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#301\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.to_raw_parts\" class=\"fn\">to_raw_parts</a>(self) -&gt; (<a class=\"primitive\" href=\"primitive.pointer.html\">*mut </a><a class=\"primitive\" href=\"primitive.unit.html\">()</a>, &lt;T as <a class=\"trait\" href=\"std/ptr/trait.Pointee.html\" title=\"trait std::ptr::Pointee\">Pointee</a>&gt;::<a class=\"associatedtype\" href=\"std/ptr/trait.Pointee.html#associatedtype.Metadata\" title=\"type std::ptr::Pointee::Metadata\">Metadata</a>)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_metadata</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/81513\">#81513</a>)</span></div></span></summary><div class=\"docblock\"><p>Decompose a (possibly wide) pointer into its data pointer and metadata components.</p>\n<p>The pointer can be later reconstructed with <a href=\"std/ptr/fn.from_raw_parts_mut.html\" title=\"fn std::ptr::from_raw_parts_mut\"><code>from_raw_parts_mut</code></a>.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.9.0, const unstable\">1.9.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/91822\" title=\"Tracking issue for const_ptr_as_ref\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#365\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.as_ref\" class=\"fn\">as_ref</a>&lt;'a&gt;(self) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"primitive.reference.html\">&amp;'a T</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>None</code> if the pointer is null, or else returns a shared reference to\nthe value wrapped in <code>Some</code>. If the value may be uninitialized, <a href=\"std/primitive.pointer.html#method.as_uninit_ref-1\" title=\"primitive pointer\"><code>as_uninit_ref</code></a>\nmust be used instead.</p>\n<p>For the mutable counterpart see <a href=\"#method.as_mut\"><code>as_mut</code></a>.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that <em>either</em> the pointer is null <em>or</em>\nall of the following is true:</p>\n<ul>\n<li>\n<p>The pointer must be properly aligned.</p>\n</li>\n<li>\n<p>It must be “dereferenceable” in the sense defined in <a href=\"std/ptr/index.html#safety\" title=\"mod std::ptr\">the module documentation</a>.</p>\n</li>\n<li>\n<p>The pointer must point to an initialized instance of <code>T</code>.</p>\n</li>\n<li>\n<p>You must enforce Rust’s aliasing rules, since the returned lifetime <code>'a</code> is\narbitrarily chosen and does not necessarily reflect the actual lifetime of the data.\nIn particular, while this reference exists, the memory the pointer points to must\nnot get mutated (except inside <code>UnsafeCell</code>).</p>\n</li>\n</ul>\n<p>This applies even if the result of this method is unused!\n(The part about being initialized is not yet fully decided, but until\nit is, the only safe approach is to ensure that they are indeed initialized.)</p>\n<h5 id=\"examples-4\"><a class=\"doc-anchor\" href=\"#examples-4\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u8 = <span class=\"kw-2\">&amp;mut </span><span class=\"number\">10u8 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">if let </span><span class=\"prelude-val\">Some</span>(val_back) = ptr.as_ref() {\n        <span class=\"macro\">println!</span>(<span class=\"string\">\"We got back the value: {val_back}!\"</span>);\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+ptr:+*mut+u8+=+%26mut+10u8+as+*mut+u8;%0A%0Aunsafe+%7B%0A++++if+let+Some(val_back)+=+ptr.as_ref()+%7B%0A++++++++println!(%22We+got+back+the+value:+%7Bval_back%7D!%22);%0A++++%7D%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n<h5 id=\"null-unchecked-version\"><a class=\"doc-anchor\" href=\"#null-unchecked-version\">§</a>Null-unchecked version</h5>\n<p>If you are sure the pointer can never be null and are looking for some kind of\n<code>as_ref_unchecked</code> that returns the <code>&amp;T</code> instead of <code>Option&lt;&amp;T&gt;</code>, know that you can\ndereference the pointer directly.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u8 = <span class=\"kw-2\">&amp;mut </span><span class=\"number\">10u8 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>val_back = <span class=\"kw-2\">&amp;*</span>ptr;\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"We got back the value: {val_back}!\"</span>);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+ptr:+*mut+u8+=+%26mut+10u8+as+*mut+u8;%0A%0Aunsafe+%7B%0A++++let+val_back+=+%26*ptr;%0A++++println!(%22We+got+back+the+value:+%7Bval_back%7D!%22);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_uninit_ref\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/91822\" title=\"Tracking issue for const_ptr_as_ref\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#414-416\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.as_uninit_ref\" class=\"fn\">as_uninit_ref</a>&lt;'a&gt;(self) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;&amp;'a <a class=\"union\" href=\"std/mem/union.MaybeUninit.html\" title=\"union std::mem::MaybeUninit\">MaybeUninit</a>&lt;T&gt;&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_as_uninit</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/75402\">#75402</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns <code>None</code> if the pointer is null, or else returns a shared reference to\nthe value wrapped in <code>Some</code>. In contrast to <a href=\"std/primitive.pointer.html#method.as_ref-1\" title=\"primitive pointer\"><code>as_ref</code></a>, this does not require\nthat the value has to be initialized.</p>\n<p>For the mutable counterpart see <a href=\"#method.as_uninit_mut\"><code>as_uninit_mut</code></a>.</p>\n<h5 id=\"safety-1\"><a class=\"doc-anchor\" href=\"#safety-1\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that <em>either</em> the pointer is null <em>or</em>\nall of the following is true:</p>\n<ul>\n<li>\n<p>The pointer must be properly aligned.</p>\n</li>\n<li>\n<p>It must be “dereferenceable” in the sense defined in <a href=\"std/ptr/index.html#safety\" title=\"mod std::ptr\">the module documentation</a>.</p>\n</li>\n<li>\n<p>You must enforce Rust’s aliasing rules, since the returned lifetime <code>'a</code> is\narbitrarily chosen and does not necessarily reflect the actual lifetime of the data.\nIn particular, while this reference exists, the memory the pointer points to must\nnot get mutated (except inside <code>UnsafeCell</code>).</p>\n</li>\n</ul>\n<p>This applies even if the result of this method is unused!</p>\n<h5 id=\"examples-5\"><a class=\"doc-anchor\" href=\"#examples-5\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_as_uninit)]\n\n</span><span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u8 = <span class=\"kw-2\">&amp;mut </span><span class=\"number\">10u8 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">if let </span><span class=\"prelude-val\">Some</span>(val_back) = ptr.as_uninit_ref() {\n        <span class=\"macro\">println!</span>(<span class=\"string\">\"We got back the value: {}!\"</span>, val_back.assume_init());\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_as_uninit)%5D%0A%0Afn+main()+%7B%0Alet+ptr:+*mut+u8+=+%26mut+10u8+as+*mut+u8;%0A%0Aunsafe+%7B%0A++++if+let+Some(val_back)+=+ptr.as_uninit_ref()+%7B%0A++++++++println!(%22We+got+back+the+value:+%7B%7D!%22,+val_back.assume_init());%0A++++%7D%0A%7D%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0, const since 1.61.0\">1.0.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#477-479\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.offset\" class=\"fn\">offset</a>(self, count: <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer.</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-2\"><a class=\"doc-anchor\" href=\"#safety-2\">§</a>Safety</h5>\n<p>If any of the following conditions are violated, the result is Undefined\nBehavior:</p>\n<ul>\n<li>\n<p>Both the starting and resulting pointer must be either in bounds or one\nbyte past the end of the same <a href=\"std/ptr/index.html#allocated-object\" title=\"mod std::ptr\">allocated object</a>.</p>\n</li>\n<li>\n<p>The computed offset, <strong>in bytes</strong>, cannot overflow an <code>isize</code>.</p>\n</li>\n<li>\n<p>The offset being in bounds cannot rely on “wrapping around” the address\nspace. That is, the infinite-precision sum, <strong>in bytes</strong> must fit in a usize.</p>\n</li>\n</ul>\n<p>The compiler and standard library generally tries to ensure allocations\nnever reach a size where an offset is a concern. For instance, <code>Vec</code>\nand <code>Box</code> ensure they never allocate more than <code>isize::MAX</code> bytes, so\n<code>vec.as_ptr().add(vec.len())</code> is always safe.</p>\n<p>Most platforms fundamentally can’t even construct such an allocation.\nFor instance, no known 64-bit platform can ever serve a request\nfor 2<sup>63</sup> bytes due to page-table limitations or splitting the address space.\nHowever, some 32-bit and 16-bit platforms may successfully serve a request for\nmore than <code>isize::MAX</code> bytes with things like Physical Address\nExtension. As such, memory acquired directly from allocators or memory\nmapped files <em>may</em> be too large to handle with this function.</p>\n<p>Consider using <a href=\"#method.wrapping_offset\"><code>wrapping_offset</code></a> instead if these constraints are\ndifficult to satisfy. The only advantage of this method is that it\nenables more aggressive compiler optimizations.</p>\n<h5 id=\"examples-6\"><a class=\"doc-anchor\" href=\"#examples-6\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"{}\"</span>, <span class=\"kw-2\">*</span>ptr.offset(<span class=\"number\">1</span>));\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"{}\"</span>, <span class=\"kw-2\">*</span>ptr.offset(<span class=\"number\">2</span>));\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+s+=+%5B1,+2,+3%5D;%0Alet+ptr:+*mut+u32+=+s.as_mut_ptr();%0A%0Aunsafe+%7B%0A++++println!(%22%7B%7D%22,+*ptr.offset(1));%0A++++println!(%22%7B%7D%22,+*ptr.offset(2));%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#503\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.byte_offset\" class=\"fn\">byte_offset</a>(self, count: <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer in bytes.</p>\n<p><code>count</code> is in units of <strong>bytes</strong>.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"std/primitive.pointer.html#method.offset\" title=\"method pointer::offset\">offset</a> on it. See that method for documentation\nand safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0, const since 1.61.0\">1.16.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#559-561\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"std/primitive.pointer.html#tymethod.wrapping_offset\" class=\"fn\">wrapping_offset</a>(self, count: <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer using wrapping arithmetic.\n<code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-3\"><a class=\"doc-anchor\" href=\"#safety-3\">§</a>Safety</h5>\n<p>This operation itself is always safe, but using the resulting pointer is not.</p>\n<p>The resulting pointer “remembers” the <a href=\"std/ptr/index.html#allocated-object\" title=\"mod std::ptr\">allocated object</a> that <code>self</code> points to; it must not\nbe used to read or write other allocated objects.</p>\n<p>In other words, <code>let z = x.wrapping_offset((y as isize) - (x as isize))</code> does <em>not</em> make <code>z</code>\nthe same as <code>y</code> even if we assume <code>T</code> has size <code>1</code> and there is no overflow: <code>z</code> is still\nattached to the object <code>x</code> is attached to, and dereferencing it is Undefined Behavior unless\n<code>x</code> and <code>y</code> point into the same allocated object.</p>\n<p>Compared to <a href=\"#method.offset\"><code>offset</code></a>, this method basically delays the requirement of staying within the\nsame allocated object: <a href=\"#method.offset\"><code>offset</code></a> is immediate Undefined Behavior when crossing object\nboundaries; <code>wrapping_offset</code> produces a pointer but still leads to Undefined Behavior if a\npointer is dereferenced when it is out-of-bounds of the object it is attached to. <a href=\"#method.offset\"><code>offset</code></a>\ncan be optimized better and is thus preferable in performance-sensitive code.</p>\n<p>The delayed check only considers the value of the pointer that was dereferenced, not the\nintermediate values used during the computation of the final result. For example,\n<code>x.wrapping_offset(o).wrapping_offset(o.wrapping_neg())</code> is always the same as <code>x</code>. In other\nwords, leaving the allocated object and then re-entering it later is permitted.</p>\n<h5 id=\"examples-7\"><a class=\"doc-anchor\" href=\"#examples-7\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// Iterate using a raw pointer in increments of two elements\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>data = [<span class=\"number\">1u8</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>ptr: <span class=\"kw-2\">*mut </span>u8 = data.as_mut_ptr();\n<span class=\"kw\">let </span>step = <span class=\"number\">2</span>;\n<span class=\"kw\">let </span>end_rounded_up = ptr.wrapping_offset(<span class=\"number\">6</span>);\n\n<span class=\"kw\">while </span>ptr != end_rounded_up {\n    <span class=\"kw\">unsafe </span>{\n        <span class=\"kw-2\">*</span>ptr = <span class=\"number\">0</span>;\n    }\n    ptr = ptr.wrapping_offset(step);\n}\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>data, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">0</span>, <span class=\"number\">2</span>, <span class=\"number\">0</span>, <span class=\"number\">4</span>, <span class=\"number\">0</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A//+Iterate+using+a+raw+pointer+in+increments+of+two+elements%0Afn+main()+%7B%0Alet+mut+data+=+%5B1u8,+2,+3,+4,+5%5D;%0Alet+mut+ptr:+*mut+u8+=+data.as_mut_ptr();%0Alet+step+=+2;%0Alet+end_rounded_up+=+ptr.wrapping_offset(6);%0A%0Awhile+ptr+!=+end_rounded_up+%7B%0A++++unsafe+%7B%0A++++++++*ptr+=+0;%0A++++%7D%0A++++ptr+=+ptr.wrapping_offset(step);%0A%7D%0Aassert_eq!(%26data,+%26%5B0,+2,+0,+4,+0%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_byte_offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#582\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"std/primitive.pointer.html#tymethod.wrapping_byte_offset\" class=\"fn\">wrapping_byte_offset</a>(self, count: <a class=\"primitive\" href=\"primitive.isize.html\">isize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer in bytes using wrapping arithmetic.</p>\n<p><code>count</code> is in units of <strong>bytes</strong>.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"std/primitive.pointer.html#method.wrapping_offset\" title=\"method pointer::wrapping_offset\">wrapping_offset</a> on it. See that method\nfor documentation.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.mask\" class=\"method\"><a class=\"src rightside\" href=\"src/core/ptr/mut_ptr.rs.html#623\">source</a><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.mask\" class=\"fn\">mask</a>(self, mask: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_mask</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/98290\">#98290</a>)</span></div></span></summary><div class=\"docblock\"><p>Masks out bits of the pointer according to a mask.</p>\n<p>This is convenience for <code>ptr.map_addr(|a| a &amp; mask)</code>.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n<h6 id=\"examples-8\"><a class=\"doc-anchor\" href=\"#examples-8\">§</a>Examples</h6>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_mask, strict_provenance)]\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"number\">17_u32</span>;\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = <span class=\"kw-2\">&amp;mut </span>v;\n\n<span class=\"comment\">// `u32` is 4 bytes aligned,\n// which means that lower 2 bits are always 0.\n</span><span class=\"kw\">let </span>tag_mask = <span class=\"number\">0b11</span>;\n<span class=\"kw\">let </span>ptr_mask = !tag_mask;\n\n<span class=\"comment\">// We can store something in these lower bits\n</span><span class=\"kw\">let </span>tagged_ptr = ptr.map_addr(|a| a | <span class=\"number\">0b10</span>);\n\n<span class=\"comment\">// Get the \"tag\" back\n</span><span class=\"kw\">let </span>tag = tagged_ptr.addr() &amp; tag_mask;\n<span class=\"macro\">assert_eq!</span>(tag, <span class=\"number\">0b10</span>);\n\n<span class=\"comment\">// Note that `tagged_ptr` is unaligned, it's UB to read from/write to it.\n// To get original pointer `mask` can be used:\n</span><span class=\"kw\">let </span>masked_ptr = tagged_ptr.mask(ptr_mask);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw\">unsafe </span>{ <span class=\"kw-2\">*</span>masked_ptr }, <span class=\"number\">17</span>);\n\n<span class=\"kw\">unsafe </span>{ <span class=\"kw-2\">*</span>masked_ptr = <span class=\"number\">0 </span>};\n<span class=\"macro\">assert_eq!</span>(v, <span class=\"number\">0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_mask,+strict_provenance)%5D%0Afn+main()+%7B%0Alet+mut+v+=+17_u32;%0Alet+ptr:+*mut+u32+=+%26mut+v;%0A%0A//+%60u32%60+is+4+bytes+aligned,%0A//+which+means+that+lower+2+bits+are+always+0.%0Alet+tag_mask+=+0b11;%0Alet+ptr_mask+=+!tag_mask;%0A%0A//+We+can+store+something+in+these+lower+bits%0Alet+tagged_ptr+=+ptr.map_addr(%7Ca%7C+a+%7C+0b10);%0A%0A//+Get+the+%22tag%22+back%0Alet+tag+=+tagged_ptr.addr()+%26+tag_mask;%0Aassert_eq!(tag,+0b10);%0A%0A//+Note+that+%60tagged_ptr%60+is+unaligned,+it's+UB+to+read+from/write+to+it.%0A//+To+get+original+pointer+%60mask%60+can+be+used:%0Alet+masked_ptr+=+tagged_ptr.mask(ptr_mask);%0Aassert_eq!(unsafe+%7B+*masked_ptr+%7D,+17);%0A%0Aunsafe+%7B+*masked_ptr+=+0+%7D;%0Aassert_eq!(v,+0);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.9.0, const unstable\">1.9.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/91822\" title=\"Tracking issue for const_ptr_as_ref\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#686\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.as_mut\" class=\"fn\">as_mut</a>&lt;'a&gt;(self) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"primitive.reference.html\">&amp;'a mut T</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Returns <code>None</code> if the pointer is null, or else returns a unique reference to\nthe value wrapped in <code>Some</code>. If the value may be uninitialized, <a href=\"#method.as_uninit_mut\"><code>as_uninit_mut</code></a>\nmust be used instead.</p>\n<p>For the shared counterpart see <a href=\"std/primitive.pointer.html#method.as_ref-1\" title=\"primitive pointer\"><code>as_ref</code></a>.</p>\n<h5 id=\"safety-4\"><a class=\"doc-anchor\" href=\"#safety-4\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that <em>either</em> the pointer is null <em>or</em>\nall of the following is true:</p>\n<ul>\n<li>\n<p>The pointer must be properly aligned.</p>\n</li>\n<li>\n<p>It must be “dereferenceable” in the sense defined in <a href=\"std/ptr/index.html#safety\" title=\"mod std::ptr\">the module documentation</a>.</p>\n</li>\n<li>\n<p>The pointer must point to an initialized instance of <code>T</code>.</p>\n</li>\n<li>\n<p>You must enforce Rust’s aliasing rules, since the returned lifetime <code>'a</code> is\narbitrarily chosen and does not necessarily reflect the actual lifetime of the data.\nIn particular, while this reference exists, the memory the pointer points to must\nnot get accessed (read or written) through any other pointer.</p>\n</li>\n</ul>\n<p>This applies even if the result of this method is unused!\n(The part about being initialized is not yet fully decided, but until\nit is, the only safe approach is to ensure that they are indeed initialized.)</p>\n<h5 id=\"examples-9\"><a class=\"doc-anchor\" href=\"#examples-9\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n<span class=\"kw\">let </span>first_value = <span class=\"kw\">unsafe </span>{ ptr.as_mut().unwrap() };\n<span class=\"kw-2\">*</span>first_value = <span class=\"number\">4</span>;\n<span class=\"macro\">println!</span>(<span class=\"string\">\"{s:?}\"</span>); <span class=\"comment\">// It'll print: \"[4, 2, 3]\".</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+s+=+%5B1,+2,+3%5D;%0Alet+ptr:+*mut+u32+=+s.as_mut_ptr();%0Alet+first_value+=+unsafe+%7B+ptr.as_mut().unwrap()+%7D;%0A*first_value+=+4;%0Aassert_eq!(s,+%5B4,+2,+3%5D);%0Aprintln!(%22%7Bs:?%7D%22);+//+It'll+print:+%22%5B4,+2,+3%5D%22.%0A%7D&amp;edition=2021\">Run</a></div>\n<h5 id=\"null-unchecked-version-1\"><a class=\"doc-anchor\" href=\"#null-unchecked-version-1\">§</a>Null-unchecked version</h5>\n<p>If you are sure the pointer can never be null and are looking for some kind of\n<code>as_mut_unchecked</code> that returns the <code>&amp;mut T</code> instead of <code>Option&lt;&amp;mut T&gt;</code>, know that\nyou can dereference the pointer directly.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>s = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*mut </span>u32 = s.as_mut_ptr();\n<span class=\"kw\">let </span>first_value = <span class=\"kw\">unsafe </span>{ <span class=\"kw-2\">&amp;mut *</span>ptr };\n<span class=\"kw-2\">*</span>first_value = <span class=\"number\">4</span>;\n<span class=\"macro\">println!</span>(<span class=\"string\">\"{s:?}\"</span>); <span class=\"comment\">// It'll print: \"[4, 2, 3]\".</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+s+=+%5B1,+2,+3%5D;%0Alet+ptr:+*mut+u32+=+s.as_mut_ptr();%0Alet+first_value+=+unsafe+%7B+%26mut+*ptr+%7D;%0A*first_value+=+4;%0Aassert_eq!(s,+%5B4,+2,+3%5D);%0Aprintln!(%22%7Bs:?%7D%22);+//+It'll+print:+%22%5B4,+2,+3%5D%22.%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_uninit_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/91822\" title=\"Tracking issue for const_ptr_as_ref\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#721-723\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.as_uninit_mut\" class=\"fn\">as_uninit_mut</a>&lt;'a&gt;(self) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;&amp;'a mut <a class=\"union\" href=\"std/mem/union.MaybeUninit.html\" title=\"union std::mem::MaybeUninit\">MaybeUninit</a>&lt;T&gt;&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_as_uninit</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/75402\">#75402</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns <code>None</code> if the pointer is null, or else returns a unique reference to\nthe value wrapped in <code>Some</code>. In contrast to <a href=\"#method.as_mut\"><code>as_mut</code></a>, this does not require\nthat the value has to be initialized.</p>\n<p>For the shared counterpart see <a href=\"std/primitive.pointer.html#method.as_uninit_ref-1\" title=\"primitive pointer\"><code>as_uninit_ref</code></a>.</p>\n<h5 id=\"safety-5\"><a class=\"doc-anchor\" href=\"#safety-5\">§</a>Safety</h5>\n<p>When calling this method, you have to ensure that <em>either</em> the pointer is null <em>or</em>\nall of the following is true:</p>\n<ul>\n<li>\n<p>The pointer must be properly aligned.</p>\n</li>\n<li>\n<p>It must be “dereferenceable” in the sense defined in <a href=\"std/ptr/index.html#safety\" title=\"mod std::ptr\">the module documentation</a>.</p>\n</li>\n<li>\n<p>You must enforce Rust’s aliasing rules, since the returned lifetime <code>'a</code> is\narbitrarily chosen and does not necessarily reflect the actual lifetime of the data.\nIn particular, while this reference exists, the memory the pointer points to must\nnot get accessed (read or written) through any other pointer.</p>\n</li>\n</ul>\n<p>This applies even if the result of this method is unused!</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.guaranteed_eq\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/53020\" title=\"Tracking issue for const_raw_ptr_comparison\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#750-752\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.guaranteed_eq\" class=\"fn\">guaranteed_eq</a>(self, other: <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"primitive.bool.html\">bool</a>&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>const_raw_ptr_comparison</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/53020\">#53020</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns whether two pointers are guaranteed to be equal.</p>\n<p>At runtime this function behaves like <code>Some(self == other)</code>.\nHowever, in some contexts (e.g., compile-time evaluation),\nit is not always possible to determine equality of two pointers, so this function may\nspuriously return <code>None</code> for pointers that later actually turn out to have its equality known.\nBut when it returns <code>Some</code>, the pointers’ equality is guaranteed to be known.</p>\n<p>The return value may change from <code>Some</code> to <code>None</code> and vice versa depending on the compiler\nversion and unsafe code must not\nrely on the result of this function for soundness. It is suggested to only use this function\nfor performance optimizations where spurious <code>None</code> return values by this function do not\naffect the outcome, but just the performance.\nThe consequences of using this method to make runtime and compile-time code behave\ndifferently have not been explored. This method should not be used to introduce such\ndifferences, and it should also not be stabilized before we have a better understanding\nof this issue.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.guaranteed_ne\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/53020\" title=\"Tracking issue for const_raw_ptr_comparison\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#777-779\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.guaranteed_ne\" class=\"fn\">guaranteed_ne</a>(self, other: <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"primitive\" href=\"primitive.bool.html\">bool</a>&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>const_raw_ptr_comparison</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/53020\">#53020</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns whether two pointers are guaranteed to be inequal.</p>\n<p>At runtime this function behaves like <code>Some(self != other)</code>.\nHowever, in some contexts (e.g., compile-time evaluation),\nit is not always possible to determine inequality of two pointers, so this function may\nspuriously return <code>None</code> for pointers that later actually turn out to have its inequality known.\nBut when it returns <code>Some</code>, the pointers’ inequality is guaranteed to be known.</p>\n<p>The return value may change from <code>Some</code> to <code>None</code> and vice versa depending on the compiler\nversion and unsafe code must not\nrely on the result of this function for soundness. It is suggested to only use this function\nfor performance optimizations where spurious <code>None</code> return values by this function do not\naffect the outcome, but just the performance.\nThe consequences of using this method to make runtime and compile-time code behave\ndifferently have not been explored. This method should not be used to introduce such\ndifferences, and it should also not be stabilized before we have a better understanding\nof this issue.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.offset_from\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0, const since 1.65.0\">1.47.0 (const: 1.65.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#886-888\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.offset_from\" class=\"fn\">offset_from</a>(self, origin: <a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a>) -&gt; <a class=\"primitive\" href=\"primitive.isize.html\">isize</a></h4></section></summary><div class=\"docblock\"><p>Calculates the distance between two pointers. The returned value is in\nunits of T: the distance in bytes divided by <code>mem::size_of::&lt;T&gt;()</code>.</p>\n<p>This is equivalent to <code>(self as isize - origin as isize) / (mem::size_of::&lt;T&gt;() as isize)</code>,\nexcept that it has a lot more opportunities for UB, in exchange for the compiler\nbetter understanding what you are doing.</p>\n<p>The primary motivation of this method is for computing the <code>len</code> of an array/slice\nof <code>T</code> that you are currently representing as a “start” and “end” pointer\n(and “end” is “one past the end” of the array).\nIn that case, <code>end.offset_from(start)</code> gets you the length of the array.</p>\n<p>All of the following safety requirements are trivially satisfied for this usecase.</p>\n<h5 id=\"safety-6\"><a class=\"doc-anchor\" href=\"#safety-6\">§</a>Safety</h5>\n<p>If any of the following conditions are violated, the result is Undefined\nBehavior:</p>\n<ul>\n<li>\n<p>Both <code>self</code> and <code>origin</code> must be either in bounds or one\nbyte past the end of the same <a href=\"std/ptr/index.html#allocated-object\" title=\"mod std::ptr\">allocated object</a>.</p>\n</li>\n<li>\n<p>Both pointers must be <em>derived from</em> a pointer to the same object.\n(See below for an example.)</p>\n</li>\n<li>\n<p>The distance between the pointers, in bytes, must be an exact multiple\nof the size of <code>T</code>.</p>\n</li>\n<li>\n<p>The distance between the pointers, <strong>in bytes</strong>, cannot overflow an <code>isize</code>.</p>\n</li>\n<li>\n<p>The distance being in bounds cannot rely on “wrapping around” the address space.</p>\n</li>\n</ul>\n<p>Rust types are never larger than <code>isize::MAX</code> and Rust allocations never wrap around the\naddress space, so two pointers within some value of any Rust type <code>T</code> will always satisfy\nthe last two conditions. The standard library also generally ensures that allocations\nnever reach a size where an offset is a concern. For instance, <code>Vec</code> and <code>Box</code> ensure they\nnever allocate more than <code>isize::MAX</code> bytes, so <code>ptr_into_vec.offset_from(vec.as_ptr())</code>\nalways satisfies the last two conditions.</p>\n<p>Most platforms fundamentally can’t even construct such a large allocation.\nFor instance, no known 64-bit platform can ever serve a request\nfor 2<sup>63</sup> bytes due to page-table limitations or splitting the address space.\nHowever, some 32-bit and 16-bit platforms may successfully serve a request for\nmore than <code>isize::MAX</code> bytes with things like Physical Address\nExtension. As such, memory acquired directly from allocators or memory\nmapped files <em>may</em> be too large to handle with this function.\n(Note that <a href=\"std/primitive.pointer.html#method.offset-1\" title=\"primitive pointer\"><code>offset</code></a> and <a href=\"#method.add\"><code>add</code></a> also have a similar limitation and hence cannot be used on\nsuch large allocations either.)</p>\n<p>The requirement for pointers to be derived from the same allocated object is primarily\nneeded for <code>const</code>-compatibility: the distance between pointers into <em>different</em> allocated\nobjects is not known at compile-time. However, the requirement also exists at\nruntime and may be exploited by optimizations. If you wish to compute the difference between\npointers that are not guaranteed to be from the same allocation, use <code>(self as isize - origin as isize) / mem::size_of::&lt;T&gt;()</code>.</p>\n<h5 id=\"panics\"><a class=\"doc-anchor\" href=\"#panics\">§</a>Panics</h5>\n<p>This function panics if <code>T</code> is a Zero-Sized Type (“ZST”).</p>\n<h5 id=\"examples-10\"><a class=\"doc-anchor\" href=\"#examples-10\">§</a>Examples</h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>a = [<span class=\"number\">0</span>; <span class=\"number\">5</span>];\n<span class=\"kw\">let </span>ptr1: <span class=\"kw-2\">*mut </span>i32 = <span class=\"kw-2\">&amp;mut </span>a[<span class=\"number\">1</span>];\n<span class=\"kw\">let </span>ptr2: <span class=\"kw-2\">*mut </span>i32 = <span class=\"kw-2\">&amp;mut </span>a[<span class=\"number\">3</span>];\n<span class=\"kw\">unsafe </span>{\n    <span class=\"macro\">assert_eq!</span>(ptr2.offset_from(ptr1), <span class=\"number\">2</span>);\n    <span class=\"macro\">assert_eq!</span>(ptr1.offset_from(ptr2), -<span class=\"number\">2</span>);\n    <span class=\"macro\">assert_eq!</span>(ptr1.offset(<span class=\"number\">2</span>), ptr2);\n    <span class=\"macro\">assert_eq!</span>(ptr2.offset(-<span class=\"number\">2</span>), ptr1);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+a+=+%5B0;+5%5D;%0Alet+ptr1:+*mut+i32+=+%26mut+a%5B1%5D;%0Alet+ptr2:+*mut+i32+=+%26mut+a%5B3%5D;%0Aunsafe+%7B%0A++++assert_eq!(ptr2.offset_from(ptr1),+2);%0A++++assert_eq!(ptr1.offset_from(ptr2),+-2);%0A++++assert_eq!(ptr1.offset(2),+ptr2);%0A++++assert_eq!(ptr2.offset(-2),+ptr1);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n<p><em>Incorrect</em> usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>ptr1 = Box::into_raw(Box::new(<span class=\"number\">0u8</span>));\n<span class=\"kw\">let </span>ptr2 = Box::into_raw(Box::new(<span class=\"number\">1u8</span>));\n<span class=\"kw\">let </span>diff = (ptr2 <span class=\"kw\">as </span>isize).wrapping_sub(ptr1 <span class=\"kw\">as </span>isize);\n<span class=\"comment\">// Make ptr2_other an \"alias\" of ptr2, but derived from ptr1.\n</span><span class=\"kw\">let </span>ptr2_other = (ptr1 <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8).wrapping_offset(diff);\n<span class=\"macro\">assert_eq!</span>(ptr2 <span class=\"kw\">as </span>usize, ptr2_other <span class=\"kw\">as </span>usize);\n<span class=\"comment\">// Since ptr2_other and ptr2 are derived from pointers to different objects,\n// computing their offset is undefined behavior, even though\n// they point to the same address!\n</span><span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>zero = ptr2_other.offset_from(ptr2); <span class=\"comment\">// Undefined Behavior\n</span>}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+ptr1+=+Box::into_raw(Box::new(0u8));%0Alet+ptr2+=+Box::into_raw(Box::new(1u8));%0Alet+diff+=+(ptr2+as+isize).wrapping_sub(ptr1+as+isize);%0A//+Make+ptr2_other+an+%22alias%22+of+ptr2,+but+derived+from+ptr1.%0Alet+ptr2_other+=+(ptr1+as+*mut+u8).wrapping_offset(diff);%0Aassert_eq!(ptr2+as+usize,+ptr2_other+as+usize);%0A//+Since+ptr2_other+and+ptr2+are+derived+from+pointers+to+different+objects,%0A//+computing+their+offset+is+undefined+behavior,+even+though%0A//+they+point+to+the+same+address!%0Aunsafe+%7B%0A++++let+zero+=+ptr2_other.offset_from(ptr2);+//+Undefined+Behavior%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_offset_from\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#908\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.byte_offset_from\" class=\"fn\">byte_offset_from</a>&lt;U&gt;(self, origin: <a class=\"primitive\" href=\"primitive.pointer.html\">*const U</a>) -&gt; <a class=\"primitive\" href=\"primitive.isize.html\">isize</a><div class=\"where\">where\n    U: ?<a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</div></h4></section></summary><div class=\"docblock\"><p>Calculates the distance between two pointers. The returned value is in\nunits of <strong>bytes</strong>.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"std/primitive.pointer.html#method.offset_from\" title=\"method pointer::offset_from\"><code>offset_from</code></a> on it. See that method for\ndocumentation and safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation considers only the data pointers,\nignoring the metadata.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub_ptr\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/95892\" title=\"Tracking issue for const_ptr_sub_ptr\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#978-980\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.sub_ptr\" class=\"fn\">sub_ptr</a>(self, origin: <a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a>) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>ptr_sub_ptr</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/95892\">#95892</a>)</span></div></span></summary><div class=\"docblock\"><p>Calculates the distance between two pointers, <em>where it’s known that\n<code>self</code> is equal to or greater than <code>origin</code></em>. The returned value is in\nunits of T: the distance in bytes is divided by <code>mem::size_of::&lt;T&gt;()</code>.</p>\n<p>This computes the same value that <a href=\"#method.offset_from\"><code>offset_from</code></a>\nwould compute, but with the added precondition that the offset is\nguaranteed to be non-negative.  This method is equivalent to\n<code>usize::try_from(self.offset_from(origin)).unwrap_unchecked()</code>,\nbut it provides slightly more information to the optimizer, which can\nsometimes allow it to optimize slightly better with some backends.</p>\n<p>This method can be though of as recovering the <code>count</code> that was passed\nto <a href=\"#method.add\"><code>add</code></a> (or, with the parameters in the other order,\nto <a href=\"#method.sub\"><code>sub</code></a>).  The following are all equivalent, assuming\nthat their safety preconditions are met:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>ptr.sub_ptr(origin) == count\norigin.add(count) == ptr\nptr.sub(count) == origin</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_sub_ptr)%5D%0Afn+main()+%7B%0Aunsafe+fn+blah(ptr:+*mut+i32,+origin:+*mut+i32,+count:+usize)+-%3E+bool+%7B%0Aptr.sub_ptr(origin)+==+count%0A%26%26%0Aorigin.add(count)+==+ptr%0A%26%26%0Aptr.sub(count)+==+origin%0A%7D%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<h5 id=\"safety-7\"><a class=\"doc-anchor\" href=\"#safety-7\">§</a>Safety</h5>\n<ul>\n<li>\n<p>The distance between the pointers must be non-negative (<code>self &gt;= origin</code>)</p>\n</li>\n<li>\n<p><em>All</em> the safety conditions of <a href=\"#method.offset_from\"><code>offset_from</code></a>\napply to this method as well; see it for the full details.</p>\n</li>\n</ul>\n<p>Importantly, despite the return type of this method being able to represent\na larger offset, it’s still <em>not permitted</em> to pass pointers which differ\nby more than <code>isize::MAX</code> <em>bytes</em>.  As such, the result of this method will\nalways be less than or equal to <code>isize::MAX as usize</code>.</p>\n<h5 id=\"panics-1\"><a class=\"doc-anchor\" href=\"#panics-1\">§</a>Panics</h5>\n<p>This function panics if <code>T</code> is a Zero-Sized Type (“ZST”).</p>\n<h5 id=\"examples-11\"><a class=\"doc-anchor\" href=\"#examples-11\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(ptr_sub_ptr)]\n\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>a = [<span class=\"number\">0</span>; <span class=\"number\">5</span>];\n<span class=\"kw\">let </span>p: <span class=\"kw-2\">*mut </span>i32 = a.as_mut_ptr();\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>ptr1: <span class=\"kw-2\">*mut </span>i32 = p.add(<span class=\"number\">1</span>);\n    <span class=\"kw\">let </span>ptr2: <span class=\"kw-2\">*mut </span>i32 = p.add(<span class=\"number\">3</span>);\n\n    <span class=\"macro\">assert_eq!</span>(ptr2.sub_ptr(ptr1), <span class=\"number\">2</span>);\n    <span class=\"macro\">assert_eq!</span>(ptr1.add(<span class=\"number\">2</span>), ptr2);\n    <span class=\"macro\">assert_eq!</span>(ptr2.sub(<span class=\"number\">2</span>), ptr1);\n    <span class=\"macro\">assert_eq!</span>(ptr2.sub_ptr(ptr2), <span class=\"number\">0</span>);\n}\n\n<span class=\"comment\">// This would be incorrect, as the pointers are not correctly ordered:\n// ptr1.offset_from(ptr2)</span></code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(ptr_sub_ptr)%5D%0A%0Afn+main()+%7B%0Alet+mut+a+=+%5B0;+5%5D;%0Alet+p:+*mut+i32+=+a.as_mut_ptr();%0Aunsafe+%7B%0A++++let+ptr1:+*mut+i32+=+p.add(1);%0A++++let+ptr2:+*mut+i32+=+p.add(3);%0A%0A++++assert_eq!(ptr2.sub_ptr(ptr1),+2);%0A++++assert_eq!(ptr1.add(2),+ptr2);%0A++++assert_eq!(ptr2.sub(2),+ptr1);%0A++++assert_eq!(ptr2.sub_ptr(ptr2),+0);%0A%7D%0A%0A//+This+would+be+incorrect,+as+the+pointers+are+not+correctly+ordered:%0A//+ptr1.offset_from(ptr2)%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.61.0\">1.26.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1040-1042\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.add\" class=\"fn\">add</a>(self, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer (convenience for <code>.offset(count as isize)</code>).</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-8\"><a class=\"doc-anchor\" href=\"#safety-8\">§</a>Safety</h5>\n<p>If any of the following conditions are violated, the result is Undefined\nBehavior:</p>\n<ul>\n<li>\n<p>Both the starting and resulting pointer must be either in bounds or one\nbyte past the end of the same <a href=\"std/ptr/index.html#allocated-object\" title=\"mod std::ptr\">allocated object</a>.</p>\n</li>\n<li>\n<p>The computed offset, <strong>in bytes</strong>, cannot overflow an <code>isize</code>.</p>\n</li>\n<li>\n<p>The offset being in bounds cannot rely on “wrapping around” the address\nspace. That is, the infinite-precision sum must fit in a <code>usize</code>.</p>\n</li>\n</ul>\n<p>The compiler and standard library generally tries to ensure allocations\nnever reach a size where an offset is a concern. For instance, <code>Vec</code>\nand <code>Box</code> ensure they never allocate more than <code>isize::MAX</code> bytes, so\n<code>vec.as_ptr().add(vec.len())</code> is always safe.</p>\n<p>Most platforms fundamentally can’t even construct such an allocation.\nFor instance, no known 64-bit platform can ever serve a request\nfor 2<sup>63</sup> bytes due to page-table limitations or splitting the address space.\nHowever, some 32-bit and 16-bit platforms may successfully serve a request for\nmore than <code>isize::MAX</code> bytes with things like Physical Address\nExtension. As such, memory acquired directly from allocators or memory\nmapped files <em>may</em> be too large to handle with this function.</p>\n<p>Consider using <a href=\"#method.wrapping_add\"><code>wrapping_add</code></a> instead if these constraints are\ndifficult to satisfy. The only advantage of this method is that it\nenables more aggressive compiler optimizations.</p>\n<h5 id=\"examples-12\"><a class=\"doc-anchor\" href=\"#examples-12\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>s: <span class=\"kw-2\">&amp;</span>str = <span class=\"string\">\"123\"</span>;\n<span class=\"kw\">let </span>ptr: <span class=\"kw-2\">*const </span>u8 = s.as_ptr();\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"{}\"</span>, <span class=\"kw-2\">*</span>ptr.add(<span class=\"number\">1</span>) <span class=\"kw\">as </span>char);\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"{}\"</span>, <span class=\"kw-2\">*</span>ptr.add(<span class=\"number\">2</span>) <span class=\"kw\">as </span>char);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+s:+%26str+=+%22123%22;%0Alet+ptr:+*const+u8+=+s.as_ptr();%0A%0Aunsafe+%7B%0A++++println!(%22%7B%7D%22,+*ptr.add(1)+as+char);%0A++++println!(%22%7B%7D%22,+*ptr.add(2)+as+char);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1064\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.byte_add\" class=\"fn\">byte_add</a>(self, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer in bytes (convenience for <code>.byte_offset(count as isize)</code>).</p>\n<p><code>count</code> is in units of bytes.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"std/primitive.pointer.html#method.add\" title=\"method pointer::add\">add</a> on it. See that method for documentation\nand safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.sub\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.61.0\">1.26.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1126-1128\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.sub\" class=\"fn\">sub</a>(self, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer (convenience for\n<code>.offset((count as isize).wrapping_neg())</code>).</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-9\"><a class=\"doc-anchor\" href=\"#safety-9\">§</a>Safety</h5>\n<p>If any of the following conditions are violated, the result is Undefined\nBehavior:</p>\n<ul>\n<li>\n<p>Both the starting and resulting pointer must be either in bounds or one\nbyte past the end of the same <a href=\"std/ptr/index.html#allocated-object\" title=\"mod std::ptr\">allocated object</a>.</p>\n</li>\n<li>\n<p>The computed offset cannot exceed <code>isize::MAX</code> <strong>bytes</strong>.</p>\n</li>\n<li>\n<p>The offset being in bounds cannot rely on “wrapping around” the address\nspace. That is, the infinite-precision sum must fit in a usize.</p>\n</li>\n</ul>\n<p>The compiler and standard library generally tries to ensure allocations\nnever reach a size where an offset is a concern. For instance, <code>Vec</code>\nand <code>Box</code> ensure they never allocate more than <code>isize::MAX</code> bytes, so\n<code>vec.as_ptr().add(vec.len()).sub(vec.len())</code> is always safe.</p>\n<p>Most platforms fundamentally can’t even construct such an allocation.\nFor instance, no known 64-bit platform can ever serve a request\nfor 2<sup>63</sup> bytes due to page-table limitations or splitting the address space.\nHowever, some 32-bit and 16-bit platforms may successfully serve a request for\nmore than <code>isize::MAX</code> bytes with things like Physical Address\nExtension. As such, memory acquired directly from allocators or memory\nmapped files <em>may</em> be too large to handle with this function.</p>\n<p>Consider using <a href=\"#method.wrapping_sub\"><code>wrapping_sub</code></a> instead if these constraints are\ndifficult to satisfy. The only advantage of this method is that it\nenables more aggressive compiler optimizations.</p>\n<h5 id=\"examples-13\"><a class=\"doc-anchor\" href=\"#examples-13\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>s: <span class=\"kw-2\">&amp;</span>str = <span class=\"string\">\"123\"</span>;\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>end: <span class=\"kw-2\">*const </span>u8 = s.as_ptr().add(<span class=\"number\">3</span>);\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"{}\"</span>, <span class=\"kw-2\">*</span>end.sub(<span class=\"number\">1</span>) <span class=\"kw\">as </span>char);\n    <span class=\"macro\">println!</span>(<span class=\"string\">\"{}\"</span>, <span class=\"kw-2\">*</span>end.sub(<span class=\"number\">2</span>) <span class=\"kw\">as </span>char);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+s:+%26str+=+%22123%22;%0A%0Aunsafe+%7B%0A++++let+end:+*const+u8+=+s.as_ptr().add(3);%0A++++println!(%22%7B%7D%22,+*end.sub(1)+as+char);%0A++++println!(%22%7B%7D%22,+*end.sub(2)+as+char);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.byte_sub\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1158\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.byte_sub\" class=\"fn\">byte_sub</a>(self, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer in bytes (convenience for\n<code>.byte_offset((count as isize).wrapping_neg())</code>).</p>\n<p><code>count</code> is in units of bytes.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"std/primitive.pointer.html#method.sub\" title=\"method pointer::sub\">sub</a> on it. See that method for documentation\nand safety requirements.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.61.0\">1.26.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1216-1218\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"std/primitive.pointer.html#tymethod.wrapping_add\" class=\"fn\">wrapping_add</a>(self, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer using wrapping arithmetic.\n(convenience for <code>.wrapping_offset(count as isize)</code>)</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-10\"><a class=\"doc-anchor\" href=\"#safety-10\">§</a>Safety</h5>\n<p>This operation itself is always safe, but using the resulting pointer is not.</p>\n<p>The resulting pointer “remembers” the <a href=\"std/ptr/index.html#allocated-object\" title=\"mod std::ptr\">allocated object</a> that <code>self</code> points to; it must not\nbe used to read or write other allocated objects.</p>\n<p>In other words, <code>let z = x.wrapping_add((y as usize) - (x as usize))</code> does <em>not</em> make <code>z</code>\nthe same as <code>y</code> even if we assume <code>T</code> has size <code>1</code> and there is no overflow: <code>z</code> is still\nattached to the object <code>x</code> is attached to, and dereferencing it is Undefined Behavior unless\n<code>x</code> and <code>y</code> point into the same allocated object.</p>\n<p>Compared to <a href=\"#method.add\"><code>add</code></a>, this method basically delays the requirement of staying within the\nsame allocated object: <a href=\"#method.add\"><code>add</code></a> is immediate Undefined Behavior when crossing object\nboundaries; <code>wrapping_add</code> produces a pointer but still leads to Undefined Behavior if a\npointer is dereferenced when it is out-of-bounds of the object it is attached to. <a href=\"#method.add\"><code>add</code></a>\ncan be optimized better and is thus preferable in performance-sensitive code.</p>\n<p>The delayed check only considers the value of the pointer that was dereferenced, not the\nintermediate values used during the computation of the final result. For example,\n<code>x.wrapping_add(o).wrapping_sub(o)</code> is always the same as <code>x</code>. In other words, leaving the\nallocated object and then re-entering it later is permitted.</p>\n<h5 id=\"examples-14\"><a class=\"doc-anchor\" href=\"#examples-14\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// Iterate using a raw pointer in increments of two elements\n</span><span class=\"kw\">let </span>data = [<span class=\"number\">1u8</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>ptr: <span class=\"kw-2\">*const </span>u8 = data.as_ptr();\n<span class=\"kw\">let </span>step = <span class=\"number\">2</span>;\n<span class=\"kw\">let </span>end_rounded_up = ptr.wrapping_add(<span class=\"number\">6</span>);\n\n<span class=\"comment\">// This loop prints \"1, 3, 5, \"\n</span><span class=\"kw\">while </span>ptr != end_rounded_up {\n    <span class=\"kw\">unsafe </span>{\n        <span class=\"macro\">print!</span>(<span class=\"string\">\"{}, \"</span>, <span class=\"kw-2\">*</span>ptr);\n    }\n    ptr = ptr.wrapping_add(step);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A//+Iterate+using+a+raw+pointer+in+increments+of+two+elements%0Afn+main()+%7B%0Alet+data+=+%5B1u8,+2,+3,+4,+5%5D;%0Alet+mut+ptr:+*const+u8+=+data.as_ptr();%0Alet+step+=+2;%0Alet+end_rounded_up+=+ptr.wrapping_add(6);%0A%0A//+This+loop+prints+%221,+3,+5,+%22%0Awhile+ptr+!=+end_rounded_up+%7B%0A++++unsafe+%7B%0A++++++++print!(%22%7B%7D,+%22,+*ptr);%0A++++%7D%0A++++ptr+=+ptr.wrapping_add(step);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_byte_add\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1238\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"std/primitive.pointer.html#tymethod.wrapping_byte_add\" class=\"fn\">wrapping_byte_add</a>(self, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer in bytes using wrapping arithmetic.\n(convenience for <code>.wrapping_byte_offset(count as isize)</code>)</p>\n<p><code>count</code> is in units of bytes.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"std/primitive.pointer.html#method.wrapping_add\" title=\"method pointer::wrapping_add\">wrapping_add</a> on it. See that method for documentation.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_sub\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.61.0\">1.26.0 (const: 1.61.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1295-1297\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"std/primitive.pointer.html#tymethod.wrapping_sub\" class=\"fn\">wrapping_sub</a>(self, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer using wrapping arithmetic.\n(convenience for <code>.wrapping_offset((count as isize).wrapping_neg())</code>)</p>\n<p><code>count</code> is in units of T; e.g., a <code>count</code> of 3 represents a pointer\noffset of <code>3 * size_of::&lt;T&gt;()</code> bytes.</p>\n<h5 id=\"safety-11\"><a class=\"doc-anchor\" href=\"#safety-11\">§</a>Safety</h5>\n<p>This operation itself is always safe, but using the resulting pointer is not.</p>\n<p>The resulting pointer “remembers” the <a href=\"std/ptr/index.html#allocated-object\" title=\"mod std::ptr\">allocated object</a> that <code>self</code> points to; it must not\nbe used to read or write other allocated objects.</p>\n<p>In other words, <code>let z = x.wrapping_sub((x as usize) - (y as usize))</code> does <em>not</em> make <code>z</code>\nthe same as <code>y</code> even if we assume <code>T</code> has size <code>1</code> and there is no overflow: <code>z</code> is still\nattached to the object <code>x</code> is attached to, and dereferencing it is Undefined Behavior unless\n<code>x</code> and <code>y</code> point into the same allocated object.</p>\n<p>Compared to <a href=\"#method.sub\"><code>sub</code></a>, this method basically delays the requirement of staying within the\nsame allocated object: <a href=\"#method.sub\"><code>sub</code></a> is immediate Undefined Behavior when crossing object\nboundaries; <code>wrapping_sub</code> produces a pointer but still leads to Undefined Behavior if a\npointer is dereferenced when it is out-of-bounds of the object it is attached to. <a href=\"#method.sub\"><code>sub</code></a>\ncan be optimized better and is thus preferable in performance-sensitive code.</p>\n<p>The delayed check only considers the value of the pointer that was dereferenced, not the\nintermediate values used during the computation of the final result. For example,\n<code>x.wrapping_add(o).wrapping_sub(o)</code> is always the same as <code>x</code>. In other words, leaving the\nallocated object and then re-entering it later is permitted.</p>\n<h5 id=\"examples-15\"><a class=\"doc-anchor\" href=\"#examples-15\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// Iterate using a raw pointer in increments of two elements (backwards)\n</span><span class=\"kw\">let </span>data = [<span class=\"number\">1u8</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>ptr: <span class=\"kw-2\">*const </span>u8 = data.as_ptr();\n<span class=\"kw\">let </span>start_rounded_down = ptr.wrapping_sub(<span class=\"number\">2</span>);\nptr = ptr.wrapping_add(<span class=\"number\">4</span>);\n<span class=\"kw\">let </span>step = <span class=\"number\">2</span>;\n<span class=\"comment\">// This loop prints \"5, 3, 1, \"\n</span><span class=\"kw\">while </span>ptr != start_rounded_down {\n    <span class=\"kw\">unsafe </span>{\n        <span class=\"macro\">print!</span>(<span class=\"string\">\"{}, \"</span>, <span class=\"kw-2\">*</span>ptr);\n    }\n    ptr = ptr.wrapping_sub(step);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A//+Iterate+using+a+raw+pointer+in+increments+of+two+elements+(backwards)%0Afn+main()+%7B%0Alet+data+=+%5B1u8,+2,+3,+4,+5%5D;%0Alet+mut+ptr:+*const+u8+=+data.as_ptr();%0Alet+start_rounded_down+=+ptr.wrapping_sub(2);%0Aptr+=+ptr.wrapping_add(4);%0Alet+step+=+2;%0A//+This+loop+prints+%225,+3,+1,+%22%0Awhile+ptr+!=+start_rounded_down+%7B%0A++++unsafe+%7B%0A++++++++print!(%22%7B%7D,+%22,+*ptr);%0A++++%7D%0A++++ptr+=+ptr.wrapping_sub(step);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_byte_sub\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.75.0, const since 1.75.0\">1.75.0 (const: 1.75.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1317\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"std/primitive.pointer.html#tymethod.wrapping_byte_sub\" class=\"fn\">wrapping_byte_sub</a>(self, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Calculates the offset from a pointer in bytes using wrapping arithmetic.\n(convenience for <code>.wrapping_offset((count as isize).wrapping_neg())</code>)</p>\n<p><code>count</code> is in units of bytes.</p>\n<p>This is purely a convenience for casting to a <code>u8</code> pointer and\nusing <a href=\"std/primitive.pointer.html#method.wrapping_sub\" title=\"method pointer::wrapping_sub\">wrapping_sub</a> on it. See that method for documentation.</p>\n<p>For non-<code>Sized</code> pointees this operation changes only the data pointer,\nleaving the metadata untouched.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.read\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.71.0\">1.26.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1331-1333\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.read\" class=\"fn\">read</a>(self) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Reads the value from <code>self</code> without moving it. This leaves the\nmemory in <code>self</code> unchanged.</p>\n<p>See <a href=\"std/ptr/fn.read.html\" title=\"fn std::ptr::read\"><code>ptr::read</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.read_volatile\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0\">1.26.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1352-1354\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.read_volatile\" class=\"fn\">read_volatile</a>(self) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Performs a volatile read of the value from <code>self</code> without moving it. This\nleaves the memory in <code>self</code> unchanged.</p>\n<p>Volatile operations are intended to act on I/O memory, and are guaranteed\nto not be elided or reordered by the compiler across other volatile\noperations.</p>\n<p>See <a href=\"std/ptr/fn.read_volatile.html\" title=\"fn std::ptr::read_volatile\"><code>ptr::read_volatile</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.read_unaligned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.71.0\">1.26.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1372-1374\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.read_unaligned\" class=\"fn\">read_unaligned</a>(self) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Reads the value from <code>self</code> without moving it. This leaves the\nmemory in <code>self</code> unchanged.</p>\n<p>Unlike <code>read</code>, the pointer may be unaligned.</p>\n<p>See <a href=\"std/ptr/fn.read_unaligned.html\" title=\"fn std::ptr::read_unaligned\"><code>ptr::read_unaligned</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_to\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.63.0\">1.26.0 (const: 1.63.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1392-1394\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.copy_to\" class=\"fn\">copy_to</a>(self, dest: <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Copies <code>count * size_of&lt;T&gt;</code> bytes from <code>self</code> to <code>dest</code>. The source\nand destination may overlap.</p>\n<p>NOTE: this has the <em>same</em> argument order as <a href=\"std/ptr/fn.copy.html\" title=\"fn std::ptr::copy\"><code>ptr::copy</code></a>.</p>\n<p>See <a href=\"std/ptr/fn.copy.html\" title=\"fn std::ptr::copy\"><code>ptr::copy</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_to_nonoverlapping\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.63.0\">1.26.0 (const: 1.63.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1412-1414\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.copy_to_nonoverlapping\" class=\"fn\">copy_to_nonoverlapping</a>(self, dest: <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Copies <code>count * size_of&lt;T&gt;</code> bytes from <code>self</code> to <code>dest</code>. The source\nand destination may <em>not</em> overlap.</p>\n<p>NOTE: this has the <em>same</em> argument order as <a href=\"std/ptr/fn.copy_nonoverlapping.html\" title=\"fn std::ptr::copy_nonoverlapping\"><code>ptr::copy_nonoverlapping</code></a>.</p>\n<p>See <a href=\"std/ptr/fn.copy_nonoverlapping.html\" title=\"fn std::ptr::copy_nonoverlapping\"><code>ptr::copy_nonoverlapping</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_from\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.63.0\">1.26.0 (const: 1.63.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1432-1434\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.copy_from\" class=\"fn\">copy_from</a>(self, src: <a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a>, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Copies <code>count * size_of&lt;T&gt;</code> bytes from <code>src</code> to <code>self</code>. The source\nand destination may overlap.</p>\n<p>NOTE: this has the <em>opposite</em> argument order of <a href=\"std/ptr/fn.copy.html\" title=\"fn std::ptr::copy\"><code>ptr::copy</code></a>.</p>\n<p>See <a href=\"std/ptr/fn.copy.html\" title=\"fn std::ptr::copy\"><code>ptr::copy</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.copy_from_nonoverlapping\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const since 1.63.0\">1.26.0 (const: 1.63.0)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1452-1454\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"std/primitive.pointer.html#tymethod.copy_from_nonoverlapping\" class=\"fn\">copy_from_nonoverlapping</a>(self, src: <a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a>, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Copies <code>count * size_of&lt;T&gt;</code> bytes from <code>src</code> to <code>self</code>. The source\nand destination may <em>not</em> overlap.</p>\n<p>NOTE: this has the <em>opposite</em> argument order of <a href=\"std/ptr/fn.copy_nonoverlapping.html\" title=\"fn std::ptr::copy_nonoverlapping\"><code>ptr::copy_nonoverlapping</code></a>.</p>\n<p>See <a href=\"std/ptr/fn.copy_nonoverlapping.html\" title=\"fn std::ptr::copy_nonoverlapping\"><code>ptr::copy_nonoverlapping</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop_in_place\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0\">1.26.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1467\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.drop_in_place\" class=\"fn\">drop_in_place</a>(self)</h4></section></summary><div class=\"docblock\"><p>Executes the destructor (if any) of the pointed-to value.</p>\n<p>See <a href=\"std/ptr/fn.drop_in_place.html\" title=\"fn std::ptr::drop_in_place\"><code>ptr::drop_in_place</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const unstable\">1.26.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/86302\" title=\"Tracking issue for const_ptr_write\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1482-1484\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.write\" class=\"fn\">write</a>(self, val: T)</h4></section></summary><div class=\"docblock\"><p>Overwrites a memory location with the given value without reading or\ndropping the old value.</p>\n<p>See <a href=\"std/ptr/fn.write.html\" title=\"fn std::ptr::write\"><code>ptr::write</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_bytes\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const unstable\">1.26.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/86302\" title=\"Tracking issue for const_ptr_write\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1501-1503\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.write_bytes\" class=\"fn\">write_bytes</a>(self, val: <a class=\"primitive\" href=\"primitive.u8.html\">u8</a>, count: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Invokes memset on the specified pointer, setting <code>count * size_of::&lt;T&gt;()</code>\nbytes of memory starting at <code>self</code> to <code>val</code>.</p>\n<p>See <a href=\"std/ptr/fn.write_bytes.html\" title=\"fn std::ptr::write_bytes\"><code>ptr::write_bytes</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_volatile\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0\">1.26.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1522-1524\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.write_volatile\" class=\"fn\">write_volatile</a>(self, val: T)</h4></section></summary><div class=\"docblock\"><p>Performs a volatile write of a memory location with the given value without\nreading or dropping the old value.</p>\n<p>Volatile operations are intended to act on I/O memory, and are guaranteed\nto not be elided or reordered by the compiler across other volatile\noperations.</p>\n<p>See <a href=\"std/ptr/fn.write_volatile.html\" title=\"fn std::ptr::write_volatile\"><code>ptr::write_volatile</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_unaligned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const unstable\">1.26.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/86302\" title=\"Tracking issue for const_ptr_write\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1542-1544\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.write_unaligned\" class=\"fn\">write_unaligned</a>(self, val: T)</h4></section></summary><div class=\"docblock\"><p>Overwrites a memory location with the given value without reading or\ndropping the old value.</p>\n<p>Unlike <code>write</code>, the pointer may be unaligned.</p>\n<p>See <a href=\"std/ptr/fn.write_unaligned.html\" title=\"fn std::ptr::write_unaligned\"><code>ptr::write_unaligned</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.replace\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0\">1.26.0</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1558-1560\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.replace\" class=\"fn\">replace</a>(self, src: T) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Replaces the value at <code>self</code> with <code>src</code>, returning the old\nvalue, without dropping either.</p>\n<p>See <a href=\"std/ptr/fn.replace.html\" title=\"fn std::ptr::replace\"><code>ptr::replace</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.swap\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.26.0, const unstable\">1.26.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/83163\" title=\"Tracking issue for const_swap\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1576-1578\">source</a></span><h4 class=\"code-header\">pub unsafe fn <a href=\"std/primitive.pointer.html#tymethod.swap\" class=\"fn\">swap</a>(self, with: <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>)</h4></section></summary><div class=\"docblock\"><p>Swaps the values at two mutable locations of the same type, without\ndeinitializing either. They may overlap, unlike <code>mem::swap</code> which is\notherwise equivalent.</p>\n<p>See <a href=\"std/ptr/fn.swap.html\" title=\"fn std::ptr::swap\"><code>ptr::swap</code></a> for safety concerns and examples.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.align_offset\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.36.0, const unstable\">1.36.0 (const: <a href=\"https://github.com/rust-lang/rust/issues/90962\" title=\"Tracking issue for const_align_offset\">unstable</a>)</span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1630-1632\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.align_offset\" class=\"fn\">align_offset</a>(self, align: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section></summary><div class=\"docblock\"><p>Computes the offset that needs to be applied to the pointer in order to make it aligned to\n<code>align</code>.</p>\n<p>If it is not possible to align the pointer, the implementation returns\n<code>usize::MAX</code>. It is permissible for the implementation to <em>always</em>\nreturn <code>usize::MAX</code>. Only your algorithm’s performance can depend\non getting a usable offset here, not its correctness.</p>\n<p>The offset is expressed in number of <code>T</code> elements, and not bytes. The value returned can be\nused with the <code>wrapping_add</code> method.</p>\n<p>There are no guarantees whatsoever that offsetting the pointer will not overflow or go\nbeyond the allocation that the pointer points into. It is up to the caller to ensure that\nthe returned offset is correct in all terms other than alignment.</p>\n<h5 id=\"panics-2\"><a class=\"doc-anchor\" href=\"#panics-2\">§</a>Panics</h5>\n<p>The function panics if <code>align</code> is not a power-of-two.</p>\n<h5 id=\"examples-16\"><a class=\"doc-anchor\" href=\"#examples-16\">§</a>Examples</h5>\n<p>Accessing adjacent <code>u8</code> as <code>u16</code></p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::mem::align_of;\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x = [<span class=\"number\">5_u8</span>, <span class=\"number\">6</span>, <span class=\"number\">7</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>];\n<span class=\"kw\">let </span>ptr = x.as_mut_ptr();\n<span class=\"kw\">let </span>offset = ptr.align_offset(align_of::&lt;u16&gt;());\n\n<span class=\"kw\">if </span>offset &lt; x.len() - <span class=\"number\">1 </span>{\n    <span class=\"kw\">let </span>u16_ptr = ptr.add(offset).cast::&lt;u16&gt;();\n    <span class=\"kw-2\">*</span>u16_ptr = <span class=\"number\">0</span>;\n\n    <span class=\"macro\">assert!</span>(x == [<span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">7</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>] || x == [<span class=\"number\">5</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>]);\n} <span class=\"kw\">else </span>{\n    <span class=\"comment\">// while the pointer can be aligned via `offset`, it would point\n    // outside the allocation\n</span>}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::mem::align_of;%0A%0Aunsafe+%7B%0Alet+mut+x+=+%5B5_u8,+6,+7,+8,+9%5D;%0Alet+ptr+=+x.as_mut_ptr();%0Alet+offset+=+ptr.align_offset(align_of::%3Cu16%3E());%0A%0Aif+offset+%3C+x.len()+-+1+%7B%0A++++let+u16_ptr+=+ptr.add(offset).cast::%3Cu16%3E();%0A++++*u16_ptr+=+0;%0A%0A++++assert!(x+==+%5B0,+0,+7,+8,+9%5D+%7C%7C+x+==+%5B5,+0,+0,+8,+9%5D);%0A%7D+else+%7B%0A++++//+while+the+pointer+can+be+aligned+via+%60offset%60,+it+would+point%0A++++//+outside+the+allocation%0A%7D%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_aligned\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/104203\" title=\"Tracking issue for const_pointer_is_aligned\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1762-1764\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.is_aligned\" class=\"fn\">is_aligned</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>pointer_is_aligned</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/96284\">#96284</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns whether the pointer is properly aligned for <code>T</code>.</p>\n<h5 id=\"examples-17\"><a class=\"doc-anchor\" href=\"#examples-17\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned)]\n\n</span><span class=\"comment\">// On some platforms, the alignment of i32 is less than 4.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>data = AlignedI32(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>ptr = <span class=\"kw-2\">&amp;mut </span>data <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>AlignedI32;\n\n<span class=\"macro\">assert!</span>(ptr.is_aligned());\n<span class=\"macro\">assert!</span>(!ptr.wrapping_byte_add(<span class=\"number\">1</span>).is_aligned());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned)%5D%0A%0A//+On+some+platforms,+the+alignment+of+i32+is+less+than+4.%0Afn+main()+%7B%0A%23%5Brepr(align(4))%5D%0Astruct+AlignedI32(i32);%0A%0Alet+mut+data+=+AlignedI32(42);%0Alet+ptr+=+%26mut+data+as+*mut+AlignedI32;%0A%0Aassert!(ptr.is_aligned());%0Aassert!(!ptr.wrapping_byte_add(1).is_aligned());%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<h5 id=\"at-compiletime\"><a class=\"doc-anchor\" href=\"#at-compiletime\">§</a>At compiletime</h5>\n<p><strong>Note: Alignment at compiletime is experimental and subject to change. See the\n<a href=\"https://github.com/rust-lang/rust/issues/104203\">tracking issue</a> for details.</strong></p>\n<p>At compiletime, the compiler may not know where a value will end up in memory.\nCalling this function on a pointer created from a reference at compiletime will only\nreturn <code>true</code> if the pointer is guaranteed to be aligned. This means that the pointer\nis never aligned if cast to a type with a stricter alignment than the reference’s\nunderlying allocation.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned)]\n#![feature(const_pointer_is_aligned)]\n#![feature(const_mut_refs)]\n\n</span><span class=\"comment\">// On some platforms, the alignment of primitives is less than their size.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n<span class=\"attr\">#[repr(align(<span class=\"number\">8</span>))]\n</span><span class=\"kw\">struct </span>AlignedI64(i64);\n\n<span class=\"kw\">const _</span>: () = {\n    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>data = AlignedI32(<span class=\"number\">42</span>);\n    <span class=\"kw\">let </span>ptr = <span class=\"kw-2\">&amp;mut </span>data <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>AlignedI32;\n    <span class=\"macro\">assert!</span>(ptr.is_aligned());\n\n    <span class=\"comment\">// At runtime either `ptr1` or `ptr2` would be aligned, but at compiletime neither is aligned.\n    </span><span class=\"kw\">let </span>ptr1 = ptr.cast::&lt;AlignedI64&gt;();\n    <span class=\"kw\">let </span>ptr2 = ptr.wrapping_add(<span class=\"number\">1</span>).cast::&lt;AlignedI64&gt;();\n    <span class=\"macro\">assert!</span>(!ptr1.is_aligned());\n    <span class=\"macro\">assert!</span>(!ptr2.is_aligned());\n};</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned)%5D%0A%23!%5Bfeature(const_pointer_is_aligned)%5D%0A%23!%5Bfeature(const_mut_refs)%5D%0A%0A//+On+some+platforms,+the+alignment+of+primitives+is+less+than+their+size.%0Afn+main()+%7B%0A%23%5Brepr(align(4))%5D%0Astruct+AlignedI32(i32);%0A%23%5Brepr(align(8))%5D%0Astruct+AlignedI64(i64);%0A%0Aconst+_:+()+=+%7B%0A++++let+mut+data+=+AlignedI32(42);%0A++++let+ptr+=+%26mut+data+as+*mut+AlignedI32;%0A++++assert!(ptr.is_aligned());%0A%0A++++//+At+runtime+either+%60ptr1%60+or+%60ptr2%60+would+be+aligned,+but+at+compiletime+neither+is+aligned.%0A++++let+ptr1+=+ptr.cast::%3CAlignedI64%3E();%0A++++let+ptr2+=+ptr.wrapping_add(1).cast::%3CAlignedI64%3E();%0A++++assert!(!ptr1.is_aligned());%0A++++assert!(!ptr2.is_aligned());%0A%7D;%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<p>Due to this behavior, it is possible that a runtime pointer derived from a compiletime\npointer is aligned, even if the compiletime pointer wasn’t aligned.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned)]\n#![feature(const_pointer_is_aligned)]\n\n</span><span class=\"comment\">// On some platforms, the alignment of primitives is less than their size.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n<span class=\"attr\">#[repr(align(<span class=\"number\">8</span>))]\n</span><span class=\"kw\">struct </span>AlignedI64(i64);\n\n<span class=\"comment\">// At compiletime, neither `COMPTIME_PTR` nor `COMPTIME_PTR + 1` is aligned.\n// Also, note that mutable references are not allowed in the final value of constants.\n</span><span class=\"kw\">const </span>COMPTIME_PTR: <span class=\"kw-2\">*mut </span>AlignedI32 = (<span class=\"kw-2\">&amp;</span>AlignedI32(<span class=\"number\">42</span>) <span class=\"kw\">as </span><span class=\"kw-2\">*const </span>AlignedI32).cast_mut();\n<span class=\"kw\">const _</span>: () = <span class=\"macro\">assert!</span>(!COMPTIME_PTR.cast::&lt;AlignedI64&gt;().is_aligned());\n<span class=\"kw\">const _</span>: () = <span class=\"macro\">assert!</span>(!COMPTIME_PTR.wrapping_add(<span class=\"number\">1</span>).cast::&lt;AlignedI64&gt;().is_aligned());\n\n<span class=\"comment\">// At runtime, either `runtime_ptr` or `runtime_ptr + 1` is aligned.\n</span><span class=\"kw\">let </span>runtime_ptr = COMPTIME_PTR;\n<span class=\"macro\">assert_ne!</span>(\n    runtime_ptr.cast::&lt;AlignedI64&gt;().is_aligned(),\n    runtime_ptr.wrapping_add(<span class=\"number\">1</span>).cast::&lt;AlignedI64&gt;().is_aligned(),\n);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned)%5D%0A%23!%5Bfeature(const_pointer_is_aligned)%5D%0A%0A//+On+some+platforms,+the+alignment+of+primitives+is+less+than+their+size.%0Afn+main()+%7B%0A%23%5Brepr(align(4))%5D%0Astruct+AlignedI32(i32);%0A%23%5Brepr(align(8))%5D%0Astruct+AlignedI64(i64);%0A%0A//+At+compiletime,+neither+%60COMPTIME_PTR%60+nor+%60COMPTIME_PTR+%2B+1%60+is+aligned.%0A//+Also,+note+that+mutable+references+are+not+allowed+in+the+final+value+of+constants.%0Aconst+COMPTIME_PTR:+*mut+AlignedI32+=+(%26AlignedI32(42)+as+*const+AlignedI32).cast_mut();%0Aconst+_:+()+=+assert!(!COMPTIME_PTR.cast::%3CAlignedI64%3E().is_aligned());%0Aconst+_:+()+=+assert!(!COMPTIME_PTR.wrapping_add(1).cast::%3CAlignedI64%3E().is_aligned());%0A%0A//+At+runtime,+either+%60runtime_ptr%60+or+%60runtime_ptr+%2B+1%60+is+aligned.%0Alet+runtime_ptr+=+COMPTIME_PTR;%0Aassert_ne!(%0A++++runtime_ptr.cast::%3CAlignedI64%3E().is_aligned(),%0A++++runtime_ptr.wrapping_add(1).cast::%3CAlignedI64%3E().is_aligned(),%0A);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<p>If a pointer is created from a fixed address, this function behaves the same during\nruntime and compiletime.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned)]\n#![feature(const_pointer_is_aligned)]\n\n</span><span class=\"comment\">// On some platforms, the alignment of primitives is less than their size.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n<span class=\"attr\">#[repr(align(<span class=\"number\">8</span>))]\n</span><span class=\"kw\">struct </span>AlignedI64(i64);\n\n<span class=\"kw\">const _</span>: () = {\n    <span class=\"kw\">let </span>ptr = <span class=\"number\">40 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>AlignedI32;\n    <span class=\"macro\">assert!</span>(ptr.is_aligned());\n\n    <span class=\"comment\">// For pointers with a known address, runtime and compiletime behavior are identical.\n    </span><span class=\"kw\">let </span>ptr1 = ptr.cast::&lt;AlignedI64&gt;();\n    <span class=\"kw\">let </span>ptr2 = ptr.wrapping_add(<span class=\"number\">1</span>).cast::&lt;AlignedI64&gt;();\n    <span class=\"macro\">assert!</span>(ptr1.is_aligned());\n    <span class=\"macro\">assert!</span>(!ptr2.is_aligned());\n};</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned)%5D%0A%23!%5Bfeature(const_pointer_is_aligned)%5D%0A%0A//+On+some+platforms,+the+alignment+of+primitives+is+less+than+their+size.%0Afn+main()+%7B%0A%23%5Brepr(align(4))%5D%0Astruct+AlignedI32(i32);%0A%23%5Brepr(align(8))%5D%0Astruct+AlignedI64(i64);%0A%0Aconst+_:+()+=+%7B%0A++++let+ptr+=+40+as+*mut+AlignedI32;%0A++++assert!(ptr.is_aligned());%0A%0A++++//+For+pointers+with+a+known+address,+runtime+and+compiletime+behavior+are+identical.%0A++++let+ptr1+=+ptr.cast::%3CAlignedI64%3E();%0A++++let+ptr2+=+ptr.wrapping_add(1).cast::%3CAlignedI64%3E();%0A++++assert!(ptr1.is_aligned());%0A++++assert!(!ptr2.is_aligned());%0A%7D;%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_aligned_to\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const unstable\">const: <a href=\"https://github.com/rust-lang/rust/issues/104203\" title=\"Tracking issue for const_pointer_is_aligned\">unstable</a></span> · <a class=\"src\" href=\"src/core/ptr/mut_ptr.rs.html#1879\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"std/primitive.pointer.html#tymethod.is_aligned_to\" class=\"fn\">is_aligned_to</a>(self, align: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>pointer_is_aligned</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/96284\">#96284</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns whether the pointer is aligned to <code>align</code>.</p>\n<p>For non-<code>Sized</code> pointees this operation considers only the data pointer,\nignoring the metadata.</p>\n<h5 id=\"panics-3\"><a class=\"doc-anchor\" href=\"#panics-3\">§</a>Panics</h5>\n<p>The function panics if <code>align</code> is not a power-of-two (this includes 0).</p>\n<h5 id=\"examples-18\"><a class=\"doc-anchor\" href=\"#examples-18\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned)]\n\n</span><span class=\"comment\">// On some platforms, the alignment of i32 is less than 4.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>data = AlignedI32(<span class=\"number\">42</span>);\n<span class=\"kw\">let </span>ptr = <span class=\"kw-2\">&amp;mut </span>data <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>AlignedI32;\n\n<span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">1</span>));\n<span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">2</span>));\n<span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">4</span>));\n\n<span class=\"macro\">assert!</span>(ptr.wrapping_byte_add(<span class=\"number\">2</span>).is_aligned_to(<span class=\"number\">2</span>));\n<span class=\"macro\">assert!</span>(!ptr.wrapping_byte_add(<span class=\"number\">2</span>).is_aligned_to(<span class=\"number\">4</span>));\n\n<span class=\"macro\">assert_ne!</span>(ptr.is_aligned_to(<span class=\"number\">8</span>), ptr.wrapping_add(<span class=\"number\">1</span>).is_aligned_to(<span class=\"number\">8</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned)%5D%0A%0A//+On+some+platforms,+the+alignment+of+i32+is+less+than+4.%0Afn+main()+%7B%0A%23%5Brepr(align(4))%5D%0Astruct+AlignedI32(i32);%0A%0Alet+mut+data+=+AlignedI32(42);%0Alet+ptr+=+%26mut+data+as+*mut+AlignedI32;%0A%0Aassert!(ptr.is_aligned_to(1));%0Aassert!(ptr.is_aligned_to(2));%0Aassert!(ptr.is_aligned_to(4));%0A%0Aassert!(ptr.wrapping_byte_add(2).is_aligned_to(2));%0Aassert!(!ptr.wrapping_byte_add(2).is_aligned_to(4));%0A%0Aassert_ne!(ptr.is_aligned_to(8),+ptr.wrapping_add(1).is_aligned_to(8));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<h5 id=\"at-compiletime-1\"><a class=\"doc-anchor\" href=\"#at-compiletime-1\">§</a>At compiletime</h5>\n<p><strong>Note: Alignment at compiletime is experimental and subject to change. See the\n<a href=\"https://github.com/rust-lang/rust/issues/104203\">tracking issue</a> for details.</strong></p>\n<p>At compiletime, the compiler may not know where a value will end up in memory.\nCalling this function on a pointer created from a reference at compiletime will only\nreturn <code>true</code> if the pointer is guaranteed to be aligned. This means that the pointer\ncannot be stricter aligned than the reference’s underlying allocation.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned)]\n#![feature(const_pointer_is_aligned)]\n#![feature(const_mut_refs)]\n\n</span><span class=\"comment\">// On some platforms, the alignment of i32 is less than 4.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n\n<span class=\"kw\">const _</span>: () = {\n    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>data = AlignedI32(<span class=\"number\">42</span>);\n    <span class=\"kw\">let </span>ptr = <span class=\"kw-2\">&amp;mut </span>data <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>AlignedI32;\n\n    <span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">1</span>));\n    <span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">2</span>));\n    <span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">4</span>));\n\n    <span class=\"comment\">// At compiletime, we know for sure that the pointer isn't aligned to 8.\n    </span><span class=\"macro\">assert!</span>(!ptr.is_aligned_to(<span class=\"number\">8</span>));\n    <span class=\"macro\">assert!</span>(!ptr.wrapping_add(<span class=\"number\">1</span>).is_aligned_to(<span class=\"number\">8</span>));\n};</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned)%5D%0A%23!%5Bfeature(const_pointer_is_aligned)%5D%0A%23!%5Bfeature(const_mut_refs)%5D%0A%0A//+On+some+platforms,+the+alignment+of+i32+is+less+than+4.%0Afn+main()+%7B%0A%23%5Brepr(align(4))%5D%0Astruct+AlignedI32(i32);%0A%0Aconst+_:+()+=+%7B%0A++++let+mut+data+=+AlignedI32(42);%0A++++let+ptr+=+%26mut+data+as+*mut+AlignedI32;%0A%0A++++assert!(ptr.is_aligned_to(1));%0A++++assert!(ptr.is_aligned_to(2));%0A++++assert!(ptr.is_aligned_to(4));%0A%0A++++//+At+compiletime,+we+know+for+sure+that+the+pointer+isn't+aligned+to+8.%0A++++assert!(!ptr.is_aligned_to(8));%0A++++assert!(!ptr.wrapping_add(1).is_aligned_to(8));%0A%7D;%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<p>Due to this behavior, it is possible that a runtime pointer derived from a compiletime\npointer is aligned, even if the compiletime pointer wasn’t aligned.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned)]\n#![feature(const_pointer_is_aligned)]\n\n</span><span class=\"comment\">// On some platforms, the alignment of i32 is less than 4.\n</span><span class=\"attr\">#[repr(align(<span class=\"number\">4</span>))]\n</span><span class=\"kw\">struct </span>AlignedI32(i32);\n\n<span class=\"comment\">// At compiletime, neither `COMPTIME_PTR` nor `COMPTIME_PTR + 1` is aligned.\n// Also, note that mutable references are not allowed in the final value of constants.\n</span><span class=\"kw\">const </span>COMPTIME_PTR: <span class=\"kw-2\">*mut </span>AlignedI32 = (<span class=\"kw-2\">&amp;</span>AlignedI32(<span class=\"number\">42</span>) <span class=\"kw\">as </span><span class=\"kw-2\">*const </span>AlignedI32).cast_mut();\n<span class=\"kw\">const _</span>: () = <span class=\"macro\">assert!</span>(!COMPTIME_PTR.is_aligned_to(<span class=\"number\">8</span>));\n<span class=\"kw\">const _</span>: () = <span class=\"macro\">assert!</span>(!COMPTIME_PTR.wrapping_add(<span class=\"number\">1</span>).is_aligned_to(<span class=\"number\">8</span>));\n\n<span class=\"comment\">// At runtime, either `runtime_ptr` or `runtime_ptr + 1` is aligned.\n</span><span class=\"kw\">let </span>runtime_ptr = COMPTIME_PTR;\n<span class=\"macro\">assert_ne!</span>(\n    runtime_ptr.is_aligned_to(<span class=\"number\">8</span>),\n    runtime_ptr.wrapping_add(<span class=\"number\">1</span>).is_aligned_to(<span class=\"number\">8</span>),\n);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned)%5D%0A%23!%5Bfeature(const_pointer_is_aligned)%5D%0A%0A//+On+some+platforms,+the+alignment+of+i32+is+less+than+4.%0Afn+main()+%7B%0A%23%5Brepr(align(4))%5D%0Astruct+AlignedI32(i32);%0A%0A//+At+compiletime,+neither+%60COMPTIME_PTR%60+nor+%60COMPTIME_PTR+%2B+1%60+is+aligned.%0A//+Also,+note+that+mutable+references+are+not+allowed+in+the+final+value+of+constants.%0Aconst+COMPTIME_PTR:+*mut+AlignedI32+=+(%26AlignedI32(42)+as+*const+AlignedI32).cast_mut();%0Aconst+_:+()+=+assert!(!COMPTIME_PTR.is_aligned_to(8));%0Aconst+_:+()+=+assert!(!COMPTIME_PTR.wrapping_add(1).is_aligned_to(8));%0A%0A//+At+runtime,+either+%60runtime_ptr%60+or+%60runtime_ptr+%2B+1%60+is+aligned.%0Alet+runtime_ptr+=+COMPTIME_PTR;%0Aassert_ne!(%0A++++runtime_ptr.is_aligned_to(8),%0A++++runtime_ptr.wrapping_add(1).is_aligned_to(8),%0A);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<p>If a pointer is created from a fixed address, this function behaves the same during\nruntime and compiletime.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(pointer_is_aligned)]\n#![feature(const_pointer_is_aligned)]\n\n</span><span class=\"kw\">const _</span>: () = {\n    <span class=\"kw\">let </span>ptr = <span class=\"number\">40 </span><span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u8;\n    <span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">1</span>));\n    <span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">2</span>));\n    <span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">4</span>));\n    <span class=\"macro\">assert!</span>(ptr.is_aligned_to(<span class=\"number\">8</span>));\n    <span class=\"macro\">assert!</span>(!ptr.is_aligned_to(<span class=\"number\">16</span>));\n};</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(pointer_is_aligned)%5D%0A%23!%5Bfeature(const_pointer_is_aligned)%5D%0A%0Afn+main()+%7B%0Aconst+_:+()+=+%7B%0A++++let+ptr+=+40+as+*mut+u8;%0A++++assert!(ptr.is_aligned_to(1));%0A++++assert!(ptr.is_aligned_to(2));%0A++++assert!(ptr.is_aligned_to(4));%0A++++assert!(ptr.is_aligned_to(8));%0A++++assert!(!ptr.is_aligned_to(16));%0A%7D;%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::os::windows::raw::HANDLE"]]
};if (window.register_type_impls) {window.register_type_impls(type_impls);} else {window.pending_type_impls = type_impls;}})()