# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/Tempus clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "Tempus requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/Tempus build
## ---------------------------------------------------------------------------

set(Tempus_CXX_COMPILER "D:/a/msys64/ucrt64/bin/g++.exe")

set(Tempus_C_COMPILER "D:/a/msys64/ucrt64/bin/gcc.exe")

set(Tempus_Fortran_COMPILER "D:/a/msys64/ucrt64/bin/gfortran.exe")
# Deprecated!
set(Tempus_FORTRAN_COMPILER "D:/a/msys64/ucrt64/bin/gfortran.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/Tempus build
## ---------------------------------------------------------------------------

## Give the build type
set(Tempus_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(Tempus_CXX_FLAGS [[ ]])

set(Tempus_C_FLAGS [[  -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(Tempus_Fortran_FLAGS [[ ]])
# Deprecated
set(Tempus_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(Tempus_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(Tempus_SHARED_LIB_RPATH_COMMAND "/ucrt64/lib")
set(Tempus_BUILD_SHARED_LIBS "ON")

set(Tempus_LINKER D:/a/msys64/ucrt64/bin/ld.exe)
set(Tempus_AR D:/a/msys64/ucrt64/bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(Tempus_INSTALL_DIR "/ucrt64")

## List of package libraries
set(Tempus_LIBRARIES Tempus::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(Tempus_MPI_LIBRARIES "")
set(Tempus_MPI_LIBRARY_DIRS "")
set(Tempus_MPI_INCLUDE_DIRS "")
set(Tempus_MPI_EXEC "")
set(Tempus_MPI_EXEC_MAX_NUMPROCS "")
set(Tempus_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(Tempus_ENABLE_Teuchos ON)
set(Tempus_ENABLE_Thyra ON)
set(Tempus_ENABLE_NOX ON)

# Exported cache variables
set(Tempus_ENABLE_EXPLICIT_INSTANTIATION "ON")
set(HAVE_TEMPUS_EXPLICIT_INSTANTIATION "ON")
set(Tempus_ENABLE_DEBUG "OFF")
set(HAVE_TEMPUS_DEBUG "OFF")

# Include configuration of dependent packages
if (NOT TARGET Teuchos::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Teuchos/TeuchosConfig.cmake")
endif()
if (NOT TARGET Thyra::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../Thyra/ThyraConfig.cmake")
endif()
if (NOT TARGET NOX::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../NOX/NOXConfig.cmake")
endif()

# Import Tempus targets
include("${CMAKE_CURRENT_LIST_DIR}/TempusTargets.cmake")

# Standard TriBITS-compliant external package variables
set(Tempus_IS_TRIBITS_COMPLIANT TRUE)
set(Tempus_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(Tempus_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(Tempus_EXPORTED_PACKAGE_LIBS_NAMES "tempus")

foreach(libname IN LISTS Tempus_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE Tempus::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'Tempus::${libname}', or better yet,"
      " 'Tempus::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'Tempus'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'Tempus_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
