/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ProjectsEvaluatedNotifier;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.util.internal.IncubationLogger;

public class DefaultProjectsPreparer
implements ProjectsPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectConfigurer projectConfigurer;
    private final BuildModelParameters buildModelParameters;
    private final ModelConfigurationListener modelConfigurationListener;

    public DefaultProjectsPreparer(ProjectConfigurer projectConfigurer, BuildModelParameters buildModelParameters, ModelConfigurationListener modelConfigurationListener, BuildOperationExecutor buildOperationExecutor) {
        this.projectConfigurer = projectConfigurer;
        this.buildModelParameters = buildModelParameters;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void prepareProjects(GradleInternal gradle) {
        if (this.buildModelParameters.isConfigureOnDemand() && gradle.isRootBuild()) {
            IncubationLogger.incubatingFeatureUsed((String)"Configuration on demand");
            this.projectConfigurer.configure(gradle.getRootProject());
        } else {
            this.projectConfigurer.configureHierarchy(gradle.getRootProject());
            new ProjectsEvaluatedNotifier(this.buildOperationExecutor).notify(gradle);
        }
        this.modelConfigurationListener.onConfigure(gradle);
    }
}

