/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.fingerprint.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.execution.fingerprint.FileNormalizationSpec;
import org.gradle.internal.execution.fingerprint.impl.DefaultFileNormalizationSpec;
import org.gradle.internal.fingerprint.DirectorySensitivity;

public class DefaultFileCollectionFingerprinterRegistry
implements FileCollectionFingerprinterRegistry {
    private final Map<FileNormalizationSpec, FileCollectionFingerprinter> fingerprinters;

    public DefaultFileCollectionFingerprinterRegistry(Collection<FileCollectionFingerprinter> fingerprinters) {
        this.fingerprinters = ImmutableMap.copyOf((Map)Maps.uniqueIndex(fingerprinters, input -> DefaultFileNormalizationSpec.from((Class)input.getRegisteredType(), (DirectorySensitivity)input.getDirectorySensitivity())));
    }

    public FileCollectionFingerprinter getFingerprinter(FileNormalizationSpec spec) {
        FileCollectionFingerprinter fingerprinter = this.fingerprinters.get(spec);
        if (fingerprinter == null) {
            throw new IllegalStateException(String.format("No fingerprinter registered with type '%s' and directory sensitivity '%s'", spec.getNormalizer().getName(), spec.getDirectorySensitivity().name()));
        }
        return fingerprinter;
    }
}

