/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactBackedResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.DefaultComponentArtifactResolver;
import org.gradle.internal.resolve.resolver.ResolvedVariantCache;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class DefaultVariantArtifactResolver
implements VariantArtifactResolver {
    private final ImmutableArtifactTypeRegistry artifactTypeRegistry;
    private final ArtifactResolver artifactResolver;
    private final ResolvedVariantCache resolvedVariantCache;

    public DefaultVariantArtifactResolver(ArtifactResolver artifactResolver, ImmutableArtifactTypeRegistry artifactTypeRegistry, ResolvedVariantCache resolvedVariantCache) {
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.artifactResolver = artifactResolver;
        this.resolvedVariantCache = resolvedVariantCache;
    }

    @Override
    public ResolvedVariant resolveAdhocVariant(ComponentArtifactResolveMetadata component, ImmutableList<? extends ComponentArtifactMetadata> artifacts) {
        SingleArtifactVariantIdentifier identifier = artifacts.size() == 1 ? new SingleArtifactVariantIdentifier(((ComponentArtifactMetadata)artifacts.iterator().next()).getId()) : null;
        DefaultVariantMetadata adhoc = new DefaultVariantMetadata("adhoc", identifier, Describables.of((Object)"adhoc variant for", (Object)component.getId()), component.getAttributes(), artifacts, ImmutableCapabilities.EMPTY);
        return this.toResolvedVariant(component, adhoc, identifier, artifacts);
    }

    @Override
    public ResolvedVariant resolveVariant(ComponentArtifactResolveMetadata component, VariantResolveMetadata artifactVariant) {
        return this.toResolvedVariant(component, artifactVariant, artifactVariant.getIdentifier(), artifactVariant.getArtifacts());
    }

    @Override
    public ResolvedVariant resolveVariant(ComponentArtifactResolveMetadata component, VariantResolveMetadata artifactVariant, ExcludeSpec exclusions) {
        ImmutableList<? extends ComponentArtifactMetadata> sourceArtifacts = artifactVariant.getArtifacts();
        ImmutableList<ComponentArtifactMetadata> overrideArtifacts = DefaultVariantArtifactResolver.maybeExcludeArtifacts(component, sourceArtifacts, exclusions);
        if (overrideArtifacts != null) {
            return this.toResolvedVariant(component, artifactVariant, null, overrideArtifacts);
        }
        return this.toResolvedVariant(component, artifactVariant, artifactVariant.getIdentifier(), sourceArtifacts);
    }

    @Nullable
    private static ImmutableList<ComponentArtifactMetadata> maybeExcludeArtifacts(ComponentArtifactResolveMetadata component, ImmutableList<? extends ComponentArtifactMetadata> artifacts, ExcludeSpec exclusions) {
        ModuleIdentifier module = component.getModuleVersionId().getModule();
        boolean hasExcludedArtifact = false;
        ImmutableList.Builder artifactsToResolveBuilder = ImmutableList.builderWithExpectedSize((int)artifacts.size());
        for (ComponentArtifactMetadata artifact : artifacts) {
            if (!exclusions.excludesArtifact(module, artifact.getName())) {
                artifactsToResolveBuilder.add((Object)artifact);
                continue;
            }
            hasExcludedArtifact = true;
        }
        if (hasExcludedArtifact) {
            return artifactsToResolveBuilder.build();
        }
        return null;
    }

    private ResolvedVariant toResolvedVariant(ComponentArtifactResolveMetadata component, VariantResolveMetadata artifactVariant, @Nullable VariantResolveMetadata.Identifier identifier, ImmutableList<? extends ComponentArtifactMetadata> artifacts) {
        if (identifier == null || !artifactVariant.isEligibleForCaching()) {
            return this.createResolvedVariant(identifier, component, artifactVariant, artifacts, this.artifactTypeRegistry);
        }
        ResolvedVariantCache.CacheKey key = new ResolvedVariantCache.CacheKey(identifier, this.artifactTypeRegistry);
        ResolvedVariant value = this.resolvedVariantCache.get(key);
        if (value != null) {
            return value;
        }
        return this.resolvedVariantCache.computeIfAbsent(key, k -> this.createResolvedVariant(k.variantIdentifier, component, artifactVariant, artifacts, k.artifactTypeRegistry));
    }

    private ResolvedVariant createResolvedVariant(@Nullable VariantResolveMetadata.Identifier identifier, ComponentArtifactResolveMetadata component, VariantResolveMetadata artifactVariant, ImmutableList<? extends ComponentArtifactMetadata> artifacts, ImmutableArtifactTypeRegistry artifactTypeRegistry) {
        DisplayName displayName = artifactVariant.asDescribable();
        ImmutableAttributes attributes = artifactTypeRegistry.mapAttributesFor(artifactVariant.getAttributes(), (Iterable<? extends ComponentArtifactMetadata>)artifacts);
        ImmutableCapabilities capabilities = DefaultVariantArtifactResolver.withImplicitCapability(artifactVariant.getCapabilities(), component);
        return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, capabilities, (List<? extends ComponentArtifactMetadata>)artifacts, new DefaultComponentArtifactResolver(component, this.artifactResolver));
    }

    private static ImmutableCapabilities withImplicitCapability(ImmutableCapabilities capabilities, ComponentArtifactResolveMetadata component) {
        if (capabilities.asSet().isEmpty()) {
            return ImmutableCapabilities.of((Capability)DefaultImmutableCapability.defaultCapabilityForComponent(component.getModuleVersionId()));
        }
        return capabilities;
    }

    private static class SingleArtifactVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final ComponentArtifactIdentifier artifactIdentifier;

        public SingleArtifactVariantIdentifier(ComponentArtifactIdentifier artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        public int hashCode() {
            return this.artifactIdentifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SingleArtifactVariantIdentifier other = (SingleArtifactVariantIdentifier)obj;
            return this.artifactIdentifier.equals(other.artifactIdentifier);
        }
    }
}

