; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs --show-mc-encoding | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd,nf -verify-machineinstrs --show-mc-encoding | FileCheck --check-prefix=NF %s

define i8 @xor8rr(i8 noundef %a, i8 noundef %b) {
; CHECK-LABEL: xor8rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x31,0xf7]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor8rr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl %esi, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x31,0xf7]
; NF-NEXT:    # kill: def $al killed $al killed $eax
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i8 %a, %b
    ret i8 %xor
}

define i16 @xor16rr(i16 noundef %a, i16 noundef %b) {
; CHECK-LABEL: xor16rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x31,0xf7]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor16rr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl %esi, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x31,0xf7]
; NF-NEXT:    # kill: def $ax killed $ax killed $eax
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i16 %a, %b
    ret i16 %xor
}

define i32 @xor32rr(i32 noundef %a, i32 noundef %b) {
; CHECK-LABEL: xor32rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x31,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor32rr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl %esi, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x31,0xf7]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i32 %a, %b
    ret i32 %xor
}

define i64 @xor64rr(i64 noundef %a, i64 noundef %b) {
; CHECK-LABEL: xor64rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq %rsi, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x31,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor64rr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorq %rsi, %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x31,0xf7]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i64 %a, %b
    ret i64 %xor
}

define i8 @xor8rm(i8 noundef %a, ptr %b) {
; CHECK-LABEL: xor8rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb (%rsi), %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x32,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor8rm:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorb (%rsi), %dil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x32,0x3e]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i8, ptr %b
    %xor = xor i8 %a, %t
    ret i8 %xor
}

define i16 @xor16rm(i16 noundef %a, ptr %b) {
; CHECK-LABEL: xor16rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw (%rsi), %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x33,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor16rm:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorw (%rsi), %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x33,0x3e]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i16, ptr %b
    %xor = xor i16 %a, %t
    ret i16 %xor
}

define i32 @xor32rm(i32 noundef %a, ptr %b) {
; CHECK-LABEL: xor32rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl (%rsi), %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x33,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor32rm:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl (%rsi), %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x33,0x3e]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i32, ptr %b
    %xor = xor i32 %a, %t
    ret i32 %xor
}

define i64 @xor64rm(i64 noundef %a, ptr %b) {
; CHECK-LABEL: xor64rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq (%rsi), %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x33,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor64rm:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorq (%rsi), %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x33,0x3e]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i64, ptr %b
    %xor = xor i64 %a, %t
    ret i64 %xor
}

define i16 @xor16ri8(i16 noundef %a) {
; CHECK-LABEL: xor16ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $123, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x83,0xf7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor16ri8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorw $123, %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x83,0xf7,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i16 %a, 123
    ret i16 %xor
}

define i32 @xor32ri8(i32 noundef %a) {
; CHECK-LABEL: xor32ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $123, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x83,0xf7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor32ri8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl $123, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x83,0xf7,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i32 %a, 123
    ret i32 %xor
}

define i64 @xor64ri8(i64 noundef %a) {
; CHECK-LABEL: xor64ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $123, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x83,0xf7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor64ri8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorq $123, %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x83,0xf7,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i64 %a, 123
    ret i64 %xor
}

define i8 @xor8ri(i8 noundef %a) {
; CHECK-LABEL: xor8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb $123, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0xf7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor8ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorb $123, %dil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x80,0xf7,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i8 %a, 123
    ret i8 %xor
}

define i16 @xor16ri(i16 noundef %a) {
; CHECK-LABEL: xor16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $1234, %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x81,0xf7,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor16ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorw $1234, %di, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x81,0xf7,0xd2,0x04]
; NF-NEXT:    # imm = 0x4D2
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i16 %a, 1234
    ret i16 %xor
}

define i32 @xor32ri(i32 noundef %a) {
; CHECK-LABEL: xor32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $123456, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xf7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor32ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl $123456, %edi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x81,0xf7,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i32 %a, 123456
    ret i32 %xor
}

define i64 @xor64ri(i64 noundef %a) {
; CHECK-LABEL: xor64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $123456, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0xf7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor64ri:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorq $123456, %rdi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x81,0xf7,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
    %xor = xor i64 %a, 123456
    ret i64 %xor
}

define i8 @xor8mr(ptr %a, i8 noundef %b) {
; CHECK-LABEL: xor8mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb (%rdi), %sil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x32,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor8mr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorb (%rdi), %sil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x32,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %xor = xor i8 %t, %b
  ret i8 %xor
}

define i16 @xor16mr(ptr %a, i16 noundef %b) {
; CHECK-LABEL: xor16mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw (%rdi), %si, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x33,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor16mr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorw (%rdi), %si, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x33,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %xor = xor i16 %t, %b
  ret i16 %xor
}

define i32 @xor32mr(ptr %a, i32 noundef %b) {
; CHECK-LABEL: xor32mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl (%rdi), %esi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x33,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor32mr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl (%rdi), %esi, %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x33,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %xor = xor i32 %t, %b
  ret i32 %xor
}

define i64 @xor64mr(ptr %a, i64 noundef %b) {
; CHECK-LABEL: xor64mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq (%rdi), %rsi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x33,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor64mr:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorq (%rdi), %rsi, %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x33,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %xor = xor i64 %t, %b
  ret i64 %xor
}

define i16 @xor16mi8(ptr %a) {
; CHECK-LABEL: xor16mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $123, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0x83,0x37,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor16mi8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorw $123, (%rdi), %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x83,0x37,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %xor = xor i16 %t, 123
  ret i16 %xor
}

define i32 @xor32mi8(ptr %a) {
; CHECK-LABEL: xor32mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $123, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x83,0x37,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor32mi8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl $123, (%rdi), %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x83,0x37,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %xor = xor i32 %t, 123
  ret i32 %xor
}

define i64 @xor64mi8(ptr %a) {
; CHECK-LABEL: xor64mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $123, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0x83,0x37,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor64mi8:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorq $123, (%rdi), %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x83,0x37,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %xor = xor i64 %t, 123
  ret i64 %xor
}

define i8 @xor8mi(ptr %a) {
; CHECK-LABEL: xor8mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb $123, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0x37,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor8mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorb $123, (%rdi), %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x80,0x37,0x7b]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %xor = xor i8 %t, 123
  ret i8 %xor
}

define i16 @xor16mi(ptr %a) {
; CHECK-LABEL: xor16mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw $1234, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0x81,0x37,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor16mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorw $1234, (%rdi), %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x81,0x37,0xd2,0x04]
; NF-NEXT:    # imm = 0x4D2
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %xor = xor i16 %t, 1234
  ret i16 %xor
}

define i32 @xor32mi(ptr %a) {
; CHECK-LABEL: xor32mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl $123456, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0x37,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor32mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorl $123456, (%rdi), %eax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x81,0x37,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %xor = xor i32 %t, 123456
  ret i32 %xor
}

define i64 @xor64mi(ptr %a) {
; CHECK-LABEL: xor64mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq $123456, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0x37,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor64mi:
; NF:       # %bb.0: # %entry
; NF-NEXT:    {nf} xorq $123456, (%rdi), %rax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0xfc,0x1c,0x81,0x37,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %xor = xor i64 %t, 123456
  ret i64 %xor
}

@d64 = dso_local global i64 0

define i1 @xorflag8rr(i8 %a, i8 %b) {
; CHECK-LABEL: xorflag8rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %edi, %esi # EVEX TO LEGACY Compression encoding: [0x31,0xfe]
; CHECK-NEXT:    xorb $-1, %sil, %cl # encoding: [0x62,0xf4,0x74,0x18,0x80,0xf6,0xff]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag8rr:
; NF:       # %bb.0:
; NF-NEXT:    xorl %edi, %esi # EVEX TO LEGACY Compression encoding: [0x31,0xfe]
; NF-NEXT:    xorb $-1, %sil, %cl # encoding: [0x62,0xf4,0x74,0x18,0x80,0xf6,0xff]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i8 %b, -1
  %v0 = xor i8 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i8 %v0, 0
  store i8 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag16rr(i16 %a, i16 %b) {
; CHECK-LABEL: xorflag16rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %edi, %esi # EVEX TO LEGACY Compression encoding: [0x31,0xfe]
; CHECK-NEXT:    xorw $-1, %si, %cx # encoding: [0x62,0xf4,0x75,0x18,0x83,0xf6,0xff]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag16rr:
; NF:       # %bb.0:
; NF-NEXT:    xorl %edi, %esi # EVEX TO LEGACY Compression encoding: [0x31,0xfe]
; NF-NEXT:    xorw $-1, %si, %cx # encoding: [0x62,0xf4,0x75,0x18,0x83,0xf6,0xff]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i16 %b, -1
  %v0 = xor i16 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i16 %v0, 0
  store i16 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag32rr(i32 %a, i32 %b) {
; CHECK-LABEL: xorflag32rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %edi, %esi # EVEX TO LEGACY Compression encoding: [0x31,0xfe]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movl %esi, d64(%rip) # encoding: [0x89,0x35,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag32rr:
; NF:       # %bb.0:
; NF-NEXT:    xorl %edi, %esi # EVEX TO LEGACY Compression encoding: [0x31,0xfe]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movl %esi, d64(%rip) # encoding: [0x89,0x35,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = xor i32 %a, %b  ; 0xff << 50
  %v1 = icmp eq i32 %v0, 0
  store i32 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag64rr(i64 %a, i64 %b) {
; CHECK-LABEL: xorflag64rr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorq %rdi, %rsi # EVEX TO LEGACY Compression encoding: [0x48,0x31,0xfe]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movq %rsi, d64(%rip) # encoding: [0x48,0x89,0x35,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag64rr:
; NF:       # %bb.0:
; NF-NEXT:    xorq %rdi, %rsi # EVEX TO LEGACY Compression encoding: [0x48,0x31,0xfe]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movq %rsi, d64(%rip) # encoding: [0x48,0x89,0x35,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = xor i64 %a, %b  ; 0xff << 50
  %v1 = icmp eq i64 %v0, 0
  store i64 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag8rm(ptr %ptr, i8 %b) {
; CHECK-LABEL: xorflag8rm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorb (%rdi), %sil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x32,0x37]
; CHECK-NEXT:    xorb $-1, %al, %cl # encoding: [0x62,0xf4,0x74,0x18,0x80,0xf0,0xff]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag8rm:
; NF:       # %bb.0:
; NF-NEXT:    {nf} xorb (%rdi), %sil, %al # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7c,0x1c,0x32,0x37]
; NF-NEXT:    xorb $-1, %al, %cl # encoding: [0x62,0xf4,0x74,0x18,0x80,0xf0,0xff]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %a = load i8, ptr %ptr
  %xor = xor i8 %b, -1
  %v0 = xor i8 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i8 %v0, 0
  store i8 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag16rm(ptr %ptr, i16 %b) {
; CHECK-LABEL: xorflag16rm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorw (%rdi), %si, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x33,0x37]
; CHECK-NEXT:    xorw $-1, %ax, %cx # encoding: [0x62,0xf4,0x75,0x18,0x83,0xf0,0xff]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag16rm:
; NF:       # %bb.0:
; NF-NEXT:    {nf} xorw (%rdi), %si, %ax # EVEX TO EVEX Compression encoding: [0x62,0xf4,0x7d,0x1c,0x33,0x37]
; NF-NEXT:    xorw $-1, %ax, %cx # encoding: [0x62,0xf4,0x75,0x18,0x83,0xf0,0xff]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %a = load i16, ptr %ptr
  %xor = xor i16 %b, -1
  %v0 = xor i16 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i16 %v0, 0
  store i16 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag32rm(ptr %ptr, i32 %b) {
; CHECK-LABEL: xorflag32rm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl (%rdi), %esi # EVEX TO LEGACY Compression encoding: [0x33,0x37]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movl %esi, d64(%rip) # encoding: [0x89,0x35,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag32rm:
; NF:       # %bb.0:
; NF-NEXT:    xorl (%rdi), %esi # EVEX TO LEGACY Compression encoding: [0x33,0x37]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movl %esi, d64(%rip) # encoding: [0x89,0x35,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %a = load i32, ptr %ptr
  %v0 = xor i32 %a, %b  ; 0xff << 50
  %v1 = icmp eq i32 %v0, 0
  store i32 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag64rm(ptr %ptr, i64 %b) {
; CHECK-LABEL: xorflag64rm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorq (%rdi), %rsi # EVEX TO LEGACY Compression encoding: [0x48,0x33,0x37]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movq %rsi, d64(%rip) # encoding: [0x48,0x89,0x35,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag64rm:
; NF:       # %bb.0:
; NF-NEXT:    xorq (%rdi), %rsi # EVEX TO LEGACY Compression encoding: [0x48,0x33,0x37]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movq %rsi, d64(%rip) # encoding: [0x48,0x89,0x35,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %a = load i64, ptr %ptr
  %v0 = xor i64 %a, %b  ; 0xff << 50
  %v1 = icmp eq i64 %v0, 0
  store i64 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag8ri(i8 %a) {
; CHECK-LABEL: xorflag8ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorb $-124, %dil, %cl # encoding: [0x62,0xf4,0x74,0x18,0x80,0xf7,0x84]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag8ri:
; NF:       # %bb.0:
; NF-NEXT:    xorb $-124, %dil, %cl # encoding: [0x62,0xf4,0x74,0x18,0x80,0xf7,0x84]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movb %cl, d64(%rip) # encoding: [0x88,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i8 123, -1
  %v0 = xor i8 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i8 %v0, 0
  store i8 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag16ri(i16 %a) {
; CHECK-LABEL: xorflag16ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorw $-1235, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x81,0xf7,0x2d,0xfb]
; CHECK-NEXT:    # imm = 0xFB2D
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag16ri:
; NF:       # %bb.0:
; NF-NEXT:    xorw $-1235, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x81,0xf7,0x2d,0xfb]
; NF-NEXT:    # imm = 0xFB2D
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i16 1234, -1
  %v0 = xor i16 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i16 %v0, 0
  store i16 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag32ri(i32 %a) {
; CHECK-LABEL: xorflag32ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl $123456, %edi # EVEX TO LEGACY Compression encoding: [0x81,0xf7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movl %edi, d64(%rip) # encoding: [0x89,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag32ri:
; NF:       # %bb.0:
; NF-NEXT:    xorl $123456, %edi # EVEX TO LEGACY Compression encoding: [0x81,0xf7,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movl %edi, d64(%rip) # encoding: [0x89,0x3d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = xor i32 %a, 123456  ; 0xff << 50
  %v1 = icmp eq i32 %v0, 0
  store i32 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag64ri(i64 %a) {
; CHECK-LABEL: xorflag64ri:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorq $123456, %rdi # EVEX TO LEGACY Compression encoding: [0x48,0x81,0xf7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movq %rdi, d64(%rip) # encoding: [0x48,0x89,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag64ri:
; NF:       # %bb.0:
; NF-NEXT:    xorq $123456, %rdi # EVEX TO LEGACY Compression encoding: [0x48,0x81,0xf7,0x40,0xe2,0x01,0x00]
; NF-NEXT:    # imm = 0x1E240
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movq %rdi, d64(%rip) # encoding: [0x48,0x89,0x3d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = xor i64 %a, 123456  ; 0xff << 50
  %v1 = icmp eq i64 %v0, 0
  store i64 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag16ri8(i16 %a) {
; CHECK-LABEL: xorflag16ri8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorw $-124, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x83,0xf7,0x84]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag16ri8:
; NF:       # %bb.0:
; NF-NEXT:    xorw $-124, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x83,0xf7,0x84]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movw %cx, d64(%rip) # encoding: [0x66,0x89,0x0d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %xor = xor i16 123, -1
  %v0 = xor i16 %a, %xor  ; 0xff << 50
  %v1 = icmp eq i16 %v0, 0
  store i16 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag32ri8(i32 %a) {
; CHECK-LABEL: xorflag32ri8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl $123, %edi # EVEX TO LEGACY Compression encoding: [0x83,0xf7,0x7b]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movl %edi, d64(%rip) # encoding: [0x89,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag32ri8:
; NF:       # %bb.0:
; NF-NEXT:    xorl $123, %edi # EVEX TO LEGACY Compression encoding: [0x83,0xf7,0x7b]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movl %edi, d64(%rip) # encoding: [0x89,0x3d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 2, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = xor i32 %a, 123  ; 0xff << 50
  %v1 = icmp eq i32 %v0, 0
  store i32 %v0, ptr @d64
  ret i1 %v1
}

define i1 @xorflag64ri8(i64 %a) {
; CHECK-LABEL: xorflag64ri8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorq $123, %rdi # EVEX TO LEGACY Compression encoding: [0x48,0x83,0xf7,0x7b]
; CHECK-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; CHECK-NEXT:    movq %rdi, d64(%rip) # encoding: [0x48,0x89,0x3d,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xorflag64ri8:
; NF:       # %bb.0:
; NF-NEXT:    xorq $123, %rdi # EVEX TO LEGACY Compression encoding: [0x48,0x83,0xf7,0x7b]
; NF-NEXT:    sete %al # encoding: [0x0f,0x94,0xc0]
; NF-NEXT:    movq %rdi, d64(%rip) # encoding: [0x48,0x89,0x3d,A,A,A,A]
; NF-NEXT:    # fixup A - offset: 3, value: d64-4, kind: reloc_riprel_4byte
; NF-NEXT:    retq # encoding: [0xc3]
  %v0 = xor i64 %a, 123  ; 0xff << 50
  %v1 = icmp eq i64 %v0, 0
  store i64 %v0, ptr @d64
  ret i1 %v1
}

define void @xor8mr_legacy(ptr %a, i8 noundef %b) {
; CHECK-LABEL: xor8mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorb %sil, (%rdi) # encoding: [0x40,0x30,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor8mr_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    xorb %sil, (%rdi) # encoding: [0x40,0x30,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %xor = xor i8 %t, %b
  store i8 %xor, ptr %a
  ret void
}

define void @xor16mr_legacy(ptr %a, i16 noundef %b) {
; CHECK-LABEL: xor16mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorw %si, (%rdi) # encoding: [0x66,0x31,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor16mr_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    xorw %si, (%rdi) # encoding: [0x66,0x31,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %xor = xor i16 %t, %b
  store i16 %xor, ptr %a
  ret void
}

define void @xor32mr_legacy(ptr %a, i32 noundef %b) {
; CHECK-LABEL: xor32mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %esi, (%rdi) # encoding: [0x31,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor32mr_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    xorl %esi, (%rdi) # encoding: [0x31,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %xor = xor i32 %t, %b
  store i32 %xor, ptr %a
  ret void
}

define void @xor64mr_legacy(ptr %a, i64 noundef %b) {
; CHECK-LABEL: xor64mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorq %rsi, (%rdi) # encoding: [0x48,0x31,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
;
; NF-LABEL: xor64mr_legacy:
; NF:       # %bb.0: # %entry
; NF-NEXT:    xorq %rsi, (%rdi) # encoding: [0x48,0x31,0x37]
; NF-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %xor = xor i64 %t, %b
  store i64 %xor, ptr %a
  ret void
}
