; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
; RUN: opt < %s -passes=instcombine -use-constant-int-for-fixed-length-splat -S | FileCheck %s

declare void @use(i32)

define i32 @test1(i32 %A) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
  %B = sdiv i32 %A, 1
  ret i32 %B
}

define i32 @test2(i32 %A) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[B1:%.*]] = lshr i32 [[A:%.*]], 3
; CHECK-NEXT:    ret i32 [[B1]]
;
  %B = udiv i32 %A, 8
  ret i32 %B
}

define i32 @sdiv_by_minus1(i32 %A) {
; CHECK-LABEL: @sdiv_by_minus1(
; CHECK-NEXT:    [[B:%.*]] = sub nsw i32 0, [[A:%.*]]
; CHECK-NEXT:    ret i32 [[B]]
;
  %B = sdiv i32 %A, -1
  ret i32 %B
}

define <2 x i64> @sdiv_by_minus1_vec(<2 x i64> %x) {
; CHECK-LABEL: @sdiv_by_minus1_vec(
; CHECK-NEXT:    [[DIV:%.*]] = sub nsw <2 x i64> zeroinitializer, [[X:%.*]]
; CHECK-NEXT:    ret <2 x i64> [[DIV]]
;
  %div = sdiv <2 x i64> %x, <i64 -1, i64 -1>
  ret <2 x i64> %div
}

define <2 x i64> @sdiv_by_minus1_vec_poison_elt(<2 x i64> %x) {
; CHECK-LABEL: @sdiv_by_minus1_vec_poison_elt(
; CHECK-NEXT:    ret <2 x i64> poison
;
  %div = sdiv <2 x i64> %x, <i64 -1, i64 poison>
  ret <2 x i64> %div
}

define i32 @sdiv_by_sext_minus1(i1 %x, i32 %y) {
; CHECK-LABEL: @sdiv_by_sext_minus1(
; CHECK-NEXT:    [[DIV:%.*]] = sub nsw i32 0, [[Y:%.*]]
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %sext = sext i1 %x to i32
  %div = sdiv i32 %y, %sext
  ret i32 %div
}

define <2 x i32> @sdiv_by_sext_minus1_vec(<2 x i1> %x, <2 x i32> %y) {
; CHECK-LABEL: @sdiv_by_sext_minus1_vec(
; CHECK-NEXT:    [[DIV:%.*]] = sub nsw <2 x i32> zeroinitializer, [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i32> [[DIV]]
;
  %sext = sext <2 x i1> %x to <2 x i32>
  %div = sdiv <2 x i32> %y, %sext
  ret <2 x i32> %div
}

define i8 @udiv_by_negative(i8 %x) {
; CHECK-LABEL: @udiv_by_negative(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ugt i8 [[X:%.*]], -7
; CHECK-NEXT:    [[A:%.*]] = zext i1 [[TMP1]] to i8
; CHECK-NEXT:    ret i8 [[A]]
;
  %A = udiv i8 %x, 250
  ret i8 %A
}

define i32 @udiv_by_minus1(i32 %A) {
; CHECK-LABEL: @udiv_by_minus1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[A:%.*]], -1
; CHECK-NEXT:    [[B:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[B]]
;
  %B = udiv i32 %A, -1
  ret i32 %B
}

define <2 x i64> @udiv_by_minus1_vec(<2 x i64> %x) {
; CHECK-LABEL: @udiv_by_minus1_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i64> [[X:%.*]], splat (i64 -1)
; CHECK-NEXT:    [[DIV:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i64>
; CHECK-NEXT:    ret <2 x i64> [[DIV]]
;
  %div = udiv <2 x i64> %x, <i64 -1, i64 -1>
  ret <2 x i64> %div
}

define i32 @udiv_by_sext_all_ones(i1 %x, i32 %y) {
; CHECK-LABEL: @udiv_by_sext_all_ones(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[Y:%.*]], -1
; CHECK-NEXT:    [[DIV:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %sext = sext i1 %x to i32
  %div = udiv i32 %y, %sext
  ret i32 %div
}

define <2 x i32> @udiv_by_sext_all_ones_vec(<2 x i1> %x, <2 x i32> %y) {
; CHECK-LABEL: @udiv_by_sext_all_ones_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i32> [[Y:%.*]], splat (i32 -1)
; CHECK-NEXT:    [[DIV:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[DIV]]
;
  %sext = sext <2 x i1> %x to <2 x i32>
  %div = udiv <2 x i32> %y, %sext
  ret <2 x i32> %div
}

define i32 @test5(i32 %A) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret i32 0
;
  %B = udiv i32 %A, -16
  %C = udiv i32 %B, -4
  ret i32 %C
}

define i1 @test6(i32 %A) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[A:%.*]], 123
; CHECK-NEXT:    ret i1 [[C]]
;
  %B = udiv i32 %A, 123
  ; A < 123
  %C = icmp eq i32 %B, 0
  ret i1 %C
}

define i1 @test7(i32 %A) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:    [[A_OFF:%.*]] = add i32 [[A:%.*]], -20
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[A_OFF]], 10
; CHECK-NEXT:    ret i1 [[C]]
;
  %B = udiv i32 %A, 10
  ; A >= 20 && A < 30
  %C = icmp eq i32 %B, 2
  ret i1 %C
}

define <2 x i1> @test7vec(<2 x i32> %A) {
; CHECK-LABEL: @test7vec(
; CHECK-NEXT:    [[A_OFF:%.*]] = add <2 x i32> [[A:%.*]], splat (i32 -20)
; CHECK-NEXT:    [[C:%.*]] = icmp ult <2 x i32> [[A_OFF]], splat (i32 10)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %B = udiv <2 x i32> %A, <i32 10, i32 10>
  %C = icmp eq <2 x i32> %B, <i32 2, i32 2>
  ret <2 x i1> %C
}

define i1 @test8(i8 %A) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[A:%.*]], -11
; CHECK-NEXT:    ret i1 [[C]]
;
  %B = udiv i8 %A, 123
  ; A >= 246
  %C = icmp eq i8 %B, 2
  ret i1 %C
}

define <2 x i1> @test8vec(<2 x i8> %A) {
; CHECK-LABEL: @test8vec(
; CHECK-NEXT:    [[C:%.*]] = icmp ugt <2 x i8> [[A:%.*]], splat (i8 -11)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %B = udiv <2 x i8> %A, <i8 123, i8 123>
  %C = icmp eq <2 x i8> %B, <i8 2, i8 2>
  ret <2 x i1> %C
}

define i1 @test9(i8 %A) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[A:%.*]], -10
; CHECK-NEXT:    ret i1 [[C]]
;
  %B = udiv i8 %A, 123
  ; A < 246
  %C = icmp ne i8 %B, 2
  ret i1 %C
}

define <2 x i1> @test9vec(<2 x i8> %A) {
; CHECK-LABEL: @test9vec(
; CHECK-NEXT:    [[C:%.*]] = icmp ult <2 x i8> [[A:%.*]], splat (i8 -10)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %B = udiv <2 x i8> %A, <i8 123, i8 123>
  %C = icmp ne <2 x i8> %B, <i8 2, i8 2>
  ret <2 x i1> %C
}

define i32 @test10(i32 %X, i1 %C) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C:%.*]], i32 6, i32 3
; CHECK-NEXT:    [[R1:%.*]] = lshr i32 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[R1]]
;
  %V = select i1 %C, i32 64, i32 8
  %R = udiv i32 %X, %V
  ret i32 %R
}

define i32 @test11(i32 %X, i1 %C) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C:%.*]], i32 10, i32 5
; CHECK-NEXT:    [[B1:%.*]] = lshr i32 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[B1]]
;
  %A = select i1 %C, i32 1024, i32 32
  %B = udiv i32 %X, %A
  ret i32 %B
}

; PR2328
define i32 @test12(i32 %x) {
; CHECK-LABEL: @test12(
; CHECK-NEXT:    ret i32 1
;
  %tmp3 = udiv i32 %x, %x		; 1
  ret i32 %tmp3
}

define i32 @test13(i32 %x) {
; CHECK-LABEL: @test13(
; CHECK-NEXT:    ret i32 1
;
  %tmp3 = sdiv i32 %x, %x		; 1
  ret i32 %tmp3
}

define i32 @test14(i8 %x) {
; CHECK-LABEL: @test14(
; CHECK-NEXT:    ret i32 0
;
  %zext = zext i8 %x to i32
  %div = udiv i32 %zext, 257	; 0
  ret i32 %div
}

; PR9814
define i32 @test15(i32 %a, i32 %b) {
; CHECK-LABEL: @test15(
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[B:%.*]], -2
; CHECK-NEXT:    [[DIV21:%.*]] = lshr i32 [[A:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[DIV21]]
;
  %shl = shl i32 1, %b
  %div = lshr i32 %shl, 2
  %div2 = udiv i32 %a, %div
  ret i32 %div2
}

define <2 x i64> @test16(<2 x i64> %x) {
; CHECK-LABEL: @test16(
; CHECK-NEXT:    [[DIV:%.*]] = udiv <2 x i64> [[X:%.*]], splat (i64 192)
; CHECK-NEXT:    ret <2 x i64> [[DIV]]
;
  %shr = lshr <2 x i64> %x, <i64 5, i64 5>
  %div = udiv <2 x i64> %shr, <i64 6, i64 6>
  ret <2 x i64> %div
}

define i32 @test19(i32 %x) {
; CHECK-LABEL: @test19(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[X:%.*]], 1
; CHECK-NEXT:    [[A:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[A]]
;
  %A = udiv i32 1, %x
  ret i32 %A
}

define <2 x i32> @test19vec(<2 x i32> %x) {
; CHECK-LABEL: @test19vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i32> [[X:%.*]], splat (i32 1)
; CHECK-NEXT:    [[A:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[A]]
;
  %A = udiv <2 x i32> <i32 1, i32 1>, %x
  ret <2 x i32> %A
}

define i32 @test20(i32 %x) {
; CHECK-LABEL: @test20(
; CHECK-NEXT:    [[X_FR:%.*]] = freeze i32 [[X:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[X_FR]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ult i32 [[TMP1]], 3
; CHECK-NEXT:    [[A:%.*]] = select i1 [[TMP2]], i32 [[X_FR]], i32 0
; CHECK-NEXT:    ret i32 [[A]]
;
  %A = sdiv i32 1, %x
  ret i32 %A
}

define <2 x i32> @test20vec(<2 x i32> %x) {
; CHECK-LABEL: @test20vec(
; CHECK-NEXT:    [[X_FR:%.*]] = freeze <2 x i32> [[X:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = add <2 x i32> [[X_FR]], splat (i32 1)
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ult <2 x i32> [[TMP1]], splat (i32 3)
; CHECK-NEXT:    [[A:%.*]] = select <2 x i1> [[TMP2]], <2 x i32> [[X_FR]], <2 x i32> zeroinitializer
; CHECK-NEXT:    ret <2 x i32> [[A]]
;
  %A = sdiv <2 x i32> <i32 1, i32 1>, %x
  ret <2 x i32> %A
}

define i32 @test21(i32 %a) {
; CHECK-LABEL: @test21(
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], 3
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %shl = shl nsw i32 %a, 2
  %div = sdiv i32 %shl, 12
  ret i32 %div
}

define i32 @test22(i32 %a) {
; CHECK-LABEL: @test22(
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], 4
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %mul = mul nsw i32 %a, 3
  %div = sdiv i32 %mul, 12
  ret i32 %div
}

define i32 @test23(i32 %a) {
; CHECK-LABEL: @test23(
; CHECK-NEXT:    [[DIV:%.*]] = udiv i32 [[A:%.*]], 3
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %shl = shl nuw i32 %a, 2
  %div = udiv i32 %shl, 12
  ret i32 %div
}

define i32 @test24(i32 %a) {
; CHECK-LABEL: @test24(
; CHECK-NEXT:    [[DIV1:%.*]] = lshr i32 [[A:%.*]], 2
; CHECK-NEXT:    ret i32 [[DIV1]]
;
  %mul = mul nuw i32 %a, 3
  %div = udiv i32 %mul, 12
  ret i32 %div
}

define i32 @test25(i32 %a) {
; CHECK-LABEL: @test25(
; CHECK-NEXT:    [[DIV:%.*]] = shl nsw i32 [[A:%.*]], 1
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %shl = shl nsw i32 %a, 2
  %div = sdiv i32 %shl, 2
  ret i32 %div
}

define i32 @test26(i32 %a) {
; CHECK-LABEL: @test26(
; CHECK-NEXT:    [[DIV:%.*]] = shl nsw i32 [[A:%.*]], 2
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %mul = mul nsw i32 %a, 12
  %div = sdiv i32 %mul, 3
  ret i32 %div
}

define i32 @test27(i32 %a) {
; CHECK-LABEL: @test27(
; CHECK-NEXT:    [[DIV:%.*]] = shl nuw i32 [[A:%.*]], 1
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %shl = shl nuw i32 %a, 2
  %div = udiv i32 %shl, 2
  ret i32 %div
}

define i32 @test28(i32 %a) {
; CHECK-LABEL: @test28(
; CHECK-NEXT:    [[DIV:%.*]] = mul nuw i32 [[A:%.*]], 12
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %mul = mul nuw i32 %a, 36
  %div = udiv i32 %mul, 3
  ret i32 %div
}

define i32 @test29(i32 %a) {
; CHECK-LABEL: @test29(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[A:%.*]], 0
; CHECK-NEXT:    [[DIV:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %mul = shl nsw i32 %a, 31
  %div = sdiv i32 %mul, -2147483648
  ret i32 %div
}

define i32 @test30(i32 %a) {
; CHECK-LABEL: @test30(
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
  %mul = shl nuw i32 %a, 31
  %div = udiv i32 %mul, -2147483648
  ret i32 %div
}

define <2 x i32> @test31(<2 x i32> %x) {
; CHECK-LABEL: @test31(
; CHECK-NEXT:    ret <2 x i32> zeroinitializer
;
  %shr = lshr <2 x i32> %x, <i32 31, i32 31>
  %div = udiv <2 x i32> %shr, <i32 2147483647, i32 2147483647>
  ret <2 x i32> %div
}

define i32 @test32(i32 %a, i32 %b) {
; CHECK-LABEL: @test32(
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[B:%.*]], -1
; CHECK-NEXT:    [[DIV2:%.*]] = lshr i32 [[A:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[DIV2]]
;
  %shl = shl i32 2, %b
  %div = lshr i32 %shl, 2
  %div2 = udiv i32 %a, %div
  ret i32 %div2
}

define <2 x i64> @test33(<2 x i64> %x) {
; CHECK-LABEL: @test33(
; CHECK-NEXT:    [[DIV:%.*]] = udiv exact <2 x i64> [[X:%.*]], splat (i64 192)
; CHECK-NEXT:    ret <2 x i64> [[DIV]]
;
  %shr = lshr exact <2 x i64> %x, <i64 5, i64 5>
  %div = udiv exact <2 x i64> %shr, <i64 6, i64 6>
  ret <2 x i64> %div
}

; -X / C --> X / -C (if negation does not overflow)

define i8 @sdiv_negated_dividend_constant_divisor(i8 %x) {
; CHECK-LABEL: @sdiv_negated_dividend_constant_divisor(
; CHECK-NEXT:    [[D:%.*]] = sdiv i8 [[X:%.*]], 42
; CHECK-NEXT:    ret i8 [[D]]
;
  %neg = sub nsw i8 0, %x
  %d = sdiv i8 %neg, -42
  ret i8 %d
}

define <2 x i8> @sdiv_negated_dividend_constant_divisor_vec_splat(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_negated_dividend_constant_divisor_vec_splat(
; CHECK-NEXT:    [[D:%.*]] = sdiv <2 x i8> [[X:%.*]], splat (i8 42)
; CHECK-NEXT:    ret <2 x i8> [[D]]
;
  %neg = sub nsw <2 x i8> zeroinitializer, %x
  %d = sdiv <2 x i8> %neg, <i8 -42, i8 -42>
  ret <2 x i8> %d
}

define i8 @sdiv_exact_negated_dividend_constant_divisor(i8 %x) {
; CHECK-LABEL: @sdiv_exact_negated_dividend_constant_divisor(
; CHECK-NEXT:    [[D:%.*]] = sdiv exact i8 [[X:%.*]], 42
; CHECK-NEXT:    ret i8 [[D]]
;
  %neg = sub nsw i8 0, %x
  %d = sdiv exact i8 %neg, -42
  ret i8 %d
}

define <2 x i8> @sdiv_exact_negated_dividend_constant_divisor_vec_splat(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_exact_negated_dividend_constant_divisor_vec_splat(
; CHECK-NEXT:    [[D:%.*]] = sdiv exact <2 x i8> [[X:%.*]], splat (i8 42)
; CHECK-NEXT:    ret <2 x i8> [[D]]
;
  %neg = sub nsw <2 x i8> zeroinitializer, %x
  %d = sdiv exact <2 x i8> %neg, <i8 -42, i8 -42>
  ret <2 x i8> %d
}

define i8 @sdiv_negated_dividend_constant_divisor_smin(i8 %x) {
; CHECK-LABEL: @sdiv_negated_dividend_constant_divisor_smin(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i8 [[X:%.*]], -128
; CHECK-NEXT:    [[D:%.*]] = zext i1 [[TMP1]] to i8
; CHECK-NEXT:    ret i8 [[D]]
;
  %neg = sub nsw i8 0, %x
  %d = sdiv i8 %neg, -128
  ret i8 %d
}

define <2 x i8> @sdiv_negated_dividend_constant_divisor_vec_splat_smin(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_negated_dividend_constant_divisor_vec_splat_smin(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> [[X:%.*]], splat (i8 -128)
; CHECK-NEXT:    [[D:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[D]]
;
  %neg = sub nsw <2 x i8> zeroinitializer, %x
  %d = sdiv <2 x i8> %neg, <i8 -128, i8 -128>
  ret <2 x i8> %d
}

define <2 x i8> @sdiv_negated_dividend_constant_divisor_vec_poison(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_negated_dividend_constant_divisor_vec_poison(
; CHECK-NEXT:    ret <2 x i8> poison
;
  %neg = sub nsw <2 x i8> zeroinitializer, %x
  %d = sdiv <2 x i8> %neg, <i8 -128, i8 poison>
  ret <2 x i8> %d
}

define <2 x i64> @sdiv_negated_dividend_constant_divisor_vec(<2 x i64> %x) {
; CHECK-LABEL: @sdiv_negated_dividend_constant_divisor_vec(
; CHECK-NEXT:    [[DIV1_NEG:%.*]] = sdiv <2 x i64> [[X:%.*]], <i64 -3, i64 -4>
; CHECK-NEXT:    ret <2 x i64> [[DIV1_NEG]]
;
  %neg = sub nsw <2 x i64> zeroinitializer, %x
  %div = sdiv <2 x i64> %neg, <i64 3, i64 4>
  ret <2 x i64> %div
}

define <2 x i64> @sdiv_exact_negated_dividend_constant_divisor_vec(<2 x i64> %x) {
; CHECK-LABEL: @sdiv_exact_negated_dividend_constant_divisor_vec(
; CHECK-NEXT:    [[DIV1_NEG:%.*]] = sdiv exact <2 x i64> [[X:%.*]], <i64 -3, i64 -4>
; CHECK-NEXT:    ret <2 x i64> [[DIV1_NEG]]
;
  %neg = sub nsw <2 x i64> zeroinitializer, %x
  %div = sdiv exact <2 x i64> %neg, <i64 3, i64 4>
  ret <2 x i64> %div
}

; Can't negate signed min vector element.

define <2 x i8> @sdiv_exact_negated_dividend_constant_divisor_vec_overflow(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_exact_negated_dividend_constant_divisor_vec_overflow(
; CHECK-NEXT:    [[DIV1:%.*]] = sdiv exact <2 x i8> [[X:%.*]], <i8 -128, i8 42>
; CHECK-NEXT:    [[DIV:%.*]] = sub nsw <2 x i8> zeroinitializer, [[DIV1]]
; CHECK-NEXT:    ret <2 x i8> [[DIV]]
;
  %neg = sub nsw <2 x i8> zeroinitializer, %x
  %div = sdiv exact <2 x i8> %neg, <i8 -128, i8 42>
  ret <2 x i8> %div
}

define i32 @test35(i32 %A) {
; CHECK-LABEL: @test35(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[A:%.*]], 2147483647
; CHECK-NEXT:    [[MUL:%.*]] = udiv exact i32 [[AND]], 2147483647
; CHECK-NEXT:    ret i32 [[MUL]]
;
  %and = and i32 %A, 2147483647
  %mul = sdiv exact i32 %and, 2147483647
  ret i32 %mul
}

define <2 x i32> @test35vec(<2 x i32> %A) {
; CHECK-LABEL: @test35vec(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i32> [[A:%.*]], splat (i32 2147483647)
; CHECK-NEXT:    [[MUL:%.*]] = udiv exact <2 x i32> [[AND]], splat (i32 2147483647)
; CHECK-NEXT:    ret <2 x i32> [[MUL]]
;
  %and = and <2 x i32> %A, <i32 2147483647, i32 2147483647>
  %mul = sdiv exact <2 x i32> %and, <i32 2147483647, i32 2147483647>
  ret <2 x i32> %mul
}

define i32 @test36(i32 %A) {
; CHECK-LABEL: @test36(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[A:%.*]], 2147483647
; CHECK-NEXT:    [[MUL:%.*]] = lshr exact i32 [[AND]], [[A]]
; CHECK-NEXT:    ret i32 [[MUL]]
;
  %and = and i32 %A, 2147483647
  %shl = shl nsw i32 1, %A
  %mul = sdiv exact i32 %and, %shl
  ret i32 %mul
}

define <2 x i32> @test36vec(<2 x i32> %A) {
; CHECK-LABEL: @test36vec(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i32> [[A:%.*]], splat (i32 2147483647)
; CHECK-NEXT:    [[MUL:%.*]] = lshr exact <2 x i32> [[AND]], [[A]]
; CHECK-NEXT:    ret <2 x i32> [[MUL]]
;
  %and = and <2 x i32> %A, <i32 2147483647, i32 2147483647>
  %shl = shl nsw <2 x i32> <i32 1, i32 1>, %A
  %mul = sdiv exact <2 x i32> %and, %shl
  ret <2 x i32> %mul
}

define i32 @test37(ptr %b, i1 %c1) {
; CHECK-LABEL: @test37(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 0, ptr [[B:%.*]], align 4
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[LOR_RHS:%.*]], label [[LOR_END:%.*]]
; CHECK:       lor.rhs:
; CHECK-NEXT:    br label [[LOR_END]]
; CHECK:       lor.end:
; CHECK-NEXT:    ret i32 0
;
entry:
  store i32 0, ptr %b, align 4
  %0 = load i32, ptr %b, align 4
  br i1 %c1, label %lor.rhs, label %lor.end

lor.rhs:                                          ; preds = %entry
  %mul = mul nsw i32 1, %0
  br label %lor.end

lor.end:                                          ; preds = %lor.rhs, %entry
  %t.0 = phi i32 [ %0, %entry ], [ %mul, %lor.rhs ]
  %div = sdiv i32 %t.0, 2
  ret i32 %div
}

; We can perform the division in the smaller type.

define i32 @shrink(i8 %x) {
; CHECK-LABEL: @shrink(
; CHECK-NEXT:    [[TMP1:%.*]] = sdiv i8 [[X:%.*]], 127
; CHECK-NEXT:    [[DIV:%.*]] = sext i8 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %conv = sext i8 %x to i32
  %div = sdiv i32 %conv, 127
  ret i32 %div
}

; Division in the smaller type can lead to more optimizations.

define i32 @zap(i8 %x) {
; CHECK-LABEL: @zap(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i8 [[X:%.*]], -128
; CHECK-NEXT:    [[DIV:%.*]] = zext i1 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %conv = sext i8 %x to i32
  %div = sdiv i32 %conv, -128
  ret i32 %div
}

; Splat constant divisors should get the same folds.

define <3 x i32> @shrink_vec(<3 x i8> %x) {
; CHECK-LABEL: @shrink_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = sdiv <3 x i8> [[X:%.*]], splat (i8 127)
; CHECK-NEXT:    [[DIV:%.*]] = sext <3 x i8> [[TMP1]] to <3 x i32>
; CHECK-NEXT:    ret <3 x i32> [[DIV]]
;
  %conv = sext <3 x i8> %x to <3 x i32>
  %div = sdiv <3 x i32> %conv, <i32 127, i32 127, i32 127>
  ret <3 x i32> %div
}

define <2 x i32> @zap_vec(<2 x i8> %x) {
; CHECK-LABEL: @zap_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> [[X:%.*]], splat (i8 -128)
; CHECK-NEXT:    [[DIV:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i32>
; CHECK-NEXT:    ret <2 x i32> [[DIV]]
;
  %conv = sext <2 x i8> %x to <2 x i32>
  %div = sdiv <2 x i32> %conv, <i32 -128, i32 -128>
  ret <2 x i32> %div
}

; But we can't do this if the signed constant won't fit in the original type.

define i32 @shrink_no(i8 %x) {
; CHECK-LABEL: @shrink_no(
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[CONV]], 128
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %conv = sext i8 %x to i32
  %div = sdiv i32 %conv, 128
  ret i32 %div
}

; When the divisor is known larger than the quotient,
; InstSimplify should kill it before InstCombine sees it.

define i32 @shrink_no2(i8 %x) {
; CHECK-LABEL: @shrink_no2(
; CHECK-NEXT:    ret i32 0
;
  %conv = sext i8 %x to i32
  %div = sdiv i32 %conv, -129
  ret i32 %div
}

define i32 @shrink_no3(i16 %x) {
; CHECK-LABEL: @shrink_no3(
; CHECK-NEXT:    ret i32 0
;
  %conv = sext i16 %x to i32
  %div = sdiv i32 %conv, 65535
  ret i32 %div
}

; This previously crashed when trying to simplify the zext/icmp this becomes.
define <2 x i8> @PR34841(<2 x i8> %x) {
; CHECK-LABEL: @PR34841(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %neg = and <2 x i8> %x, <i8 2, i8 2>
  %div = udiv <2 x i8> <i8 1, i8 1>, %neg
  ret <2 x i8> %div
}

; X / (X * Y) -> 1 / Y if the multiplication does not overflow

define i8 @div_factor_signed(i8 %x, i8 %y) {
; CHECK-LABEL: @div_factor_signed(
; CHECK-NEXT:    [[Y_FR:%.*]] = freeze i8 [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[Y_FR]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ult i8 [[TMP1]], 3
; CHECK-NEXT:    [[R:%.*]] = select i1 [[TMP2]], i8 [[Y_FR]], i8 0
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = mul nsw i8 %x, %y
  %r = sdiv i8 %x, %a
  ret i8 %r
}

; X / (Y * X) -> 1 / Y if the multiplication does not overflow

define <2 x i8> @div_factor_signed_vec(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @div_factor_signed_vec(
; CHECK-NEXT:    [[Y_FR:%.*]] = freeze <2 x i8> [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = add <2 x i8> [[Y_FR]], splat (i8 1)
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ult <2 x i8> [[TMP1]], splat (i8 3)
; CHECK-NEXT:    [[R:%.*]] = select <2 x i1> [[TMP2]], <2 x i8> [[Y_FR]], <2 x i8> zeroinitializer
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %a = mul nsw <2 x i8> %y, %x
  %r = sdiv <2 x i8> %x, %a
  ret <2 x i8> %r
}

; X / (Y * X) -> 1 / Y if the multiplication does not overflow

define i8 @div_factor_unsigned(i8 %x, i8 %y) {
; CHECK-LABEL: @div_factor_unsigned(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i8 [[Y:%.*]], 1
; CHECK-NEXT:    [[R:%.*]] = zext i1 [[TMP1]] to i8
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = mul nuw i8 %y, %x
  %r = udiv i8 %x, %a
  ret i8 %r
}

; X / (X * Y) -> 1 / Y if the multiplication does not overflow

define <2 x i8> @div_factor_unsigned_vec(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @div_factor_unsigned_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> [[Y:%.*]], splat (i8 1)
; CHECK-NEXT:    [[R:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %a = mul nuw <2 x i8> %x, %y
  %r = udiv <2 x i8> %x, %a
  ret <2 x i8> %r
}

define i8 @udiv_common_factor(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @udiv_common_factor(
; CHECK-NEXT:    [[C:%.*]] = udiv i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i8 [[C]]
;
  %a = mul nuw i8 %z, %x
  %b = mul nuw i8 %z, %y
  %c = udiv i8 %a, %b
  ret i8 %c
}

define <2 x i8> @udiv_common_factor_commute1_vec(<2 x i8> %x, <2 x i8> %y, <2 x i8> %z) {
; CHECK-LABEL: @udiv_common_factor_commute1_vec(
; CHECK-NEXT:    [[C:%.*]] = udiv <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i8> [[C]]
;
  %a = mul nuw <2 x i8> %x, %z
  %b = mul nuw <2 x i8> %z, %y
  %c = udiv <2 x i8> %a, %b
  ret <2 x i8> %c
}

define i8 @udiv_common_factor_commute2(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @udiv_common_factor_commute2(
; CHECK-NEXT:    [[C:%.*]] = udiv i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i8 [[C]]
;
  %a = mul nuw i8 %x, %z
  %b = mul nuw i8 %y, %z
  %c = udiv i8 %a, %b
  ret i8 %c
}

define i8 @udiv_common_factor_commute3(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @udiv_common_factor_commute3(
; CHECK-NEXT:    [[C:%.*]] = udiv i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i8 [[C]]
;
  %a = mul nuw i8 %z, %x
  %b = mul nuw i8 %y, %z
  %c = udiv i8 %a, %b
  ret i8 %c
}

; Negative test: both mul must be 'nuw'.

define i8 @udiv_common_factor_not_nuw(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @udiv_common_factor_not_nuw(
; CHECK-NEXT:    [[A:%.*]] = mul i8 [[Z:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[B:%.*]] = mul nuw i8 [[Z]], [[Y:%.*]]
; CHECK-NEXT:    [[C:%.*]] = udiv i8 [[A]], [[B]]
; CHECK-NEXT:    ret i8 [[C]]
;
  %a = mul i8 %z, %x
  %b = mul nuw i8 %z, %y
  %c = udiv i8 %a, %b
  ret i8 %c
}

; Negative test: both mul must be 'nuw'.

define <2 x i8> @udiv_common_factor_not_nuw_vec(<2 x i8> %x, <2 x i8> %y, <2 x i8> %z) {
; CHECK-LABEL: @udiv_common_factor_not_nuw_vec(
; CHECK-NEXT:    [[A:%.*]] = mul nuw <2 x i8> [[Z:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[B:%.*]] = mul <2 x i8> [[Z]], [[Y:%.*]]
; CHECK-NEXT:    [[C:%.*]] = udiv <2 x i8> [[A]], [[B]]
; CHECK-NEXT:    ret <2 x i8> [[C]]
;
  %a = mul nuw <2 x i8> %z, %x
  %b = mul <2 x i8> %z, %y
  %c = udiv <2 x i8> %a, %b
  ret <2 x i8> %c
}

define i32 @test_exact_nsw_exact(i32 %x) {
; CHECK-LABEL: @test_exact_nsw_exact(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sdiv exact i32 [[X:%.*]], -3
; CHECK-NEXT:    ret i32 [[DIV_NEG]]
;
  %div = sdiv exact i32 %x, 3
  %neg = sub nsw i32 0, %div
  ret i32 %neg
}

define <2 x i64> @test_exact_vec(<2 x i64> %x) {
; CHECK-LABEL: @test_exact_vec(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sdiv exact <2 x i64> [[X:%.*]], <i64 -3, i64 -4>
; CHECK-NEXT:    ret <2 x i64> [[DIV_NEG]]
;
  %div = sdiv exact <2 x i64> %x, <i64 3, i64 4>
  %neg = sub nsw <2 x i64> zeroinitializer, %div
  ret <2 x i64> %neg
}

; Constant is safe to negate.

define <2 x i8> @negate_sdiv_vec_splat(<2 x i8> %x) {
; CHECK-LABEL: @negate_sdiv_vec_splat(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sdiv <2 x i8> [[X:%.*]], splat (i8 -42)
; CHECK-NEXT:    ret <2 x i8> [[DIV_NEG]]
;
  %div = sdiv <2 x i8> %x, <i8 42, i8 42>
  %neg = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %neg
}

; Dividing by poison is UB.

define <2 x i8> @negate_sdiv_vec_poison_elt(<2 x i8> %x) {
; CHECK-LABEL: @negate_sdiv_vec_poison_elt(
; CHECK-NEXT:    ret <2 x i8> poison
;
  %div = sdiv <2 x i8> %x, <i8 poison, i8 42>
  %neg = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %neg
}

; Division by -1 may be UB (if numerator is the signed min val), but div-by-1 can be simplified.

define <2 x i8> @negate_sdiv_vec_splat_one(<2 x i8> %x) {
; CHECK-LABEL: @negate_sdiv_vec_splat_one(
; CHECK-NEXT:    [[NEG:%.*]] = sub <2 x i8> zeroinitializer, [[X:%.*]]
; CHECK-NEXT:    ret <2 x i8> [[NEG]]
;
  %div = sdiv <2 x i8> %x, <i8 1, i8 1>
  %neg = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %neg
}

; Can't negate signed-min constant, but can convert to a compare..

define <2 x i8> @negate_sdiv_vec_splat_signed_min(<2 x i8> %x) {
; CHECK-LABEL: @negate_sdiv_vec_splat_signed_min(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> [[X:%.*]], splat (i8 -128)
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sext <2 x i1> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[DIV_NEG]]
;
  %div = sdiv <2 x i8> %x, <i8 -128, i8 -128>
  %neg = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %neg
}

; Division by -1 may be UB for any element of a vector.

define <2 x i8> @negate_sdiv_vec_one_element(<2 x i8> %x) {
; CHECK-LABEL: @negate_sdiv_vec_one_element(
; CHECK-NEXT:    [[DIV:%.*]] = sdiv <2 x i8> [[X:%.*]], <i8 -1, i8 1>
; CHECK-NEXT:    [[NEG:%.*]] = sub <2 x i8> zeroinitializer, [[DIV]]
; CHECK-NEXT:    ret <2 x i8> [[NEG]]
;
  %div = sdiv <2 x i8> %x, <i8 -1, i8 1>
  %neg = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %neg
}

; Can't negate signed-min constant for any element of a vector.

define <2 x i8> @negate_sdiv_vec_signed_min_elt(<2 x i8> %x) {
; CHECK-LABEL: @negate_sdiv_vec_signed_min_elt(
; CHECK-NEXT:    [[DIV:%.*]] = sdiv <2 x i8> [[X:%.*]], <i8 -1, i8 -128>
; CHECK-NEXT:    [[NEG:%.*]] = sub <2 x i8> zeroinitializer, [[DIV]]
; CHECK-NEXT:    ret <2 x i8> [[NEG]]
;
  %div = sdiv <2 x i8> %x, <i8 -1, i8 -128>
  %neg = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %neg
}

; Division by -1 may be UB and can't negate signed-min.

define <2 x i8> @negate_sdiv_vec_signed_min_and_one_elt(<2 x i8> %x) {
; CHECK-LABEL: @negate_sdiv_vec_signed_min_and_one_elt(
; CHECK-NEXT:    [[DIV:%.*]] = sdiv <2 x i8> [[X:%.*]], <i8 1, i8 -128>
; CHECK-NEXT:    [[NEG:%.*]] = sub <2 x i8> zeroinitializer, [[DIV]]
; CHECK-NEXT:    ret <2 x i8> [[NEG]]
;
  %div = sdiv <2 x i8> %x, <i8 1, i8 -128>
  %neg = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %neg
}

define i32 @test_exact_nonsw_exact(i32 %x) {
; CHECK-LABEL: @test_exact_nonsw_exact(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sdiv exact i32 [[X:%.*]], -3
; CHECK-NEXT:    ret i32 [[DIV_NEG]]
;
  %div = sdiv exact i32 %x, 3
  %neg = sub i32 0, %div
  ret i32 %neg
}

define i32 @test_exact_nsw_noexact(i32 %x) {
; CHECK-LABEL: @test_exact_nsw_noexact(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sdiv i32 [[X:%.*]], -3
; CHECK-NEXT:    ret i32 [[DIV_NEG]]
;
  %div = sdiv i32 %x, 3
  %neg = sub nsw i32 0, %div
  ret i32 %neg
}

define i32 @test_exact_nonsw_noexact(i32 %x) {
; CHECK-LABEL: @test_exact_nonsw_noexact(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sdiv i32 [[X:%.*]], -3
; CHECK-NEXT:    ret i32 [[DIV_NEG]]
;
  %div = sdiv i32 %x, 3
  %neg = sub i32 0, %div
  ret i32 %neg
}

define i32 @test_exact_div_nonconst(i32 %x, i32 %y) {
; CHECK-LABEL: @test_exact_div_nonconst(
; CHECK-NEXT:    [[DIV:%.*]] = sdiv exact i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = sub nsw i32 0, [[DIV]]
; CHECK-NEXT:    ret i32 [[NEG]]
;
  %div = sdiv exact i32 %x, %y
  %neg = sub nsw i32 0, %div
  ret i32 %neg
}

define i32 @test_exact_div_one(i32 %x) {
; CHECK-LABEL: @test_exact_div_one(
; CHECK-NEXT:    [[NEG:%.*]] = sub nsw i32 0, [[X:%.*]]
; CHECK-NEXT:    ret i32 [[NEG]]
;
  %div = sdiv exact i32 %x, 1
  %neg = sub nsw i32 0, %div
  ret i32 %neg
}

define i8 @test_exact_div_minSigned(i8 %x) {
; CHECK-LABEL: @test_exact_div_minSigned(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i8 [[X:%.*]], -128
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sext i1 [[TMP1]] to i8
; CHECK-NEXT:    ret i8 [[DIV_NEG]]
;
  %div = sdiv exact i8 %x, -128
  %neg = sub nsw i8 0, %div
  ret i8 %neg
}

; X / INT_MIN --> X == INT_MIN

define i8 @sdiv_by_int_min(i8 %x) {
; CHECK-LABEL: @sdiv_by_int_min(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i8 [[X:%.*]], -128
; CHECK-NEXT:    [[D:%.*]] = zext i1 [[TMP1]] to i8
; CHECK-NEXT:    ret i8 [[D]]
;
  %d = sdiv i8 %x, -128
  ret i8 %d
}

define <2 x i8> @sdiv_by_int_min_vec_splat(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_by_int_min_vec_splat(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> [[X:%.*]], splat (i8 -128)
; CHECK-NEXT:    [[D:%.*]] = zext <2 x i1> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[D]]
;
  %d = sdiv <2 x i8> %x, <i8 -128, i8 -128>
  ret <2 x i8> %d
}

define <2 x i8> @sdiv_by_int_min_vec_splat_poison(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_by_int_min_vec_splat_poison(
; CHECK-NEXT:    ret <2 x i8> poison
;
  %d = sdiv <2 x i8> %x, <i8 -128, i8 poison>
  ret <2 x i8> %d
}

define <2 x i8> @sdiv_by_negconst_v2i8(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_by_negconst_v2i8(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sdiv <2 x i8> [[X:%.*]], splat (i8 108)
; CHECK-NEXT:    ret <2 x i8> [[DIV_NEG]]
;
  %div = sdiv <2 x i8> %x, <i8 -108, i8 -108>
  %sub = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %sub
}

define <vscale x 2 x i8> @sdiv_by_negconst_nxv2i8(<vscale x 2 x i8> %x) {
; CHECK-LABEL: @sdiv_by_negconst_nxv2i8(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sdiv <vscale x 2 x i8> [[X:%.*]], splat (i8 108)
; CHECK-NEXT:    ret <vscale x 2 x i8> [[DIV_NEG]]
;
  %div = sdiv <vscale x 2 x i8> %x, splat (i8 -108)
  %sub = sub <vscale x 2 x i8> zeroinitializer, %div
  ret <vscale x 2 x i8> %sub
}

define <2 x i8> @sdiv_by_minSigned_v2i8(<2 x i8> %x) {
; CHECK-LABEL: @sdiv_by_minSigned_v2i8(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <2 x i8> [[X:%.*]], splat (i8 -128)
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sext <2 x i1> [[TMP1]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[DIV_NEG]]
;
  %div = sdiv <2 x i8> %x, <i8 -128, i8 -128>
  %sub = sub <2 x i8> zeroinitializer, %div
  ret <2 x i8> %sub
}

define <vscale x 2 x i8> @sdiv_by_minSigned_nxv2i8(<vscale x 2 x i8> %x) {
; CHECK-LABEL: @sdiv_by_minSigned_nxv2i8(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq <vscale x 2 x i8> [[X:%.*]], splat (i8 -128)
; CHECK-NEXT:    [[DIV_NEG:%.*]] = sext <vscale x 2 x i1> [[TMP1]] to <vscale x 2 x i8>
; CHECK-NEXT:    ret <vscale x 2 x i8> [[DIV_NEG]]
;
  %div = sdiv <vscale x 2 x i8> %x, splat (i8 -128)
  %sub = sub <vscale x 2 x i8> zeroinitializer, %div
  ret <vscale x 2 x i8> %sub
}

define i32 @sdiv_constant_dividend_select_of_constants_divisor(i1 %b) {
; CHECK-LABEL: @sdiv_constant_dividend_select_of_constants_divisor(
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], i32 3, i32 -14
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 12, i32 -3
  %r = sdiv i32 42, %s
  ret i32 %r
}

define i32 @sdiv_constant_dividend_select_of_constants_divisor_use(i1 %b) {
; CHECK-LABEL: @sdiv_constant_dividend_select_of_constants_divisor_use(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], i32 12, i32 -3
; CHECK-NEXT:    call void @use(i32 [[S]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B]], i32 3, i32 -14
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 12, i32 -3
  call void @use(i32 %s)
  %r = sdiv i32 42, %s
  ret i32 %r
}

define i32 @sdiv_constant_dividend_select_of_constants_divisor_0_arm(i1 %b) {
; CHECK-LABEL: @sdiv_constant_dividend_select_of_constants_divisor_0_arm(
; CHECK-NEXT:    ret i32 3
;
  %s = select i1 %b, i32 12, i32 0
  %r = sdiv i32 42, %s
  ret i32 %r
}

; negative test - not safe to speculate div with variable divisor

define i32 @sdiv_constant_dividend_select_divisor1(i1 %b, i32 %x) {
; CHECK-LABEL: @sdiv_constant_dividend_select_divisor1(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], i32 [[X:%.*]], i32 -3
; CHECK-NEXT:    [[R:%.*]] = sdiv i32 42, [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 %x, i32 -3
  %r = sdiv i32 42, %s
  ret i32 %r
}

; negative test - not safe to speculate div with variable divisor

define i32 @sdiv_constant_dividend_select_divisor2(i1 %b, i32 %x) {
; CHECK-LABEL: @sdiv_constant_dividend_select_divisor2(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], i32 12, i32 [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = sdiv i32 42, [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 12, i32 %x
  %r = sdiv i32 42, %s
  ret i32 %r
}

define <2 x i8> @sdiv_constant_dividend_select_of_constants_divisor_vec(i1 %b) {
; CHECK-LABEL: @sdiv_constant_dividend_select_of_constants_divisor_vec(
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], <2 x i8> <i8 3, i8 8>, <2 x i8> splat (i8 -10)
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %s = select i1 %b, <2 x i8> <i8 12, i8 -5>, <2 x i8> <i8 -4, i8 4>
  %r = sdiv <2 x i8> <i8 42, i8 -42>, %s
  ret <2 x i8> %r
}

; Div-by-0 element is immediate UB, so select is simplified.

define <2 x i8> @sdiv_constant_dividend_select_of_constants_divisor_vec_ub1(i1 %b) {
; CHECK-LABEL: @sdiv_constant_dividend_select_of_constants_divisor_vec_ub1(
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], <2 x i8> <i8 poison, i8 8>, <2 x i8> splat (i8 -10)
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %s = select i1 %b, <2 x i8> <i8 0, i8 -5>, <2 x i8> <i8 -4, i8 4>
  %r = sdiv <2 x i8> <i8 42, i8 -42>, %s
  ret <2 x i8> %r
}

; SMIN / -1 element is poison.

define <2 x i8> @sdiv_constant_dividend_select_of_constants_divisor_vec_ub2(i1 %b) {
; CHECK-LABEL: @sdiv_constant_dividend_select_of_constants_divisor_vec_ub2(
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], <2 x i8> <i8 3, i8 25>, <2 x i8> <i8 -10, i8 poison>
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %s = select i1 %b, <2 x i8> <i8 12, i8 -5>, <2 x i8> <i8 -4, i8 -1>
  %r = sdiv <2 x i8> <i8 42, i8 -128>, %s
  ret <2 x i8> %r
}

; negative test - must have constant dividend

define i32 @sdiv_select_of_constants_divisor(i1 %b, i32 %x) {
; CHECK-LABEL: @sdiv_select_of_constants_divisor(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], i32 12, i32 -3
; CHECK-NEXT:    [[R:%.*]] = sdiv i32 [[X:%.*]], [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 12, i32 -3
  %r = sdiv i32 %x, %s
  ret i32 %r
}

define i32 @udiv_constant_dividend_select_of_constants_divisor(i1 %b) {
; CHECK-LABEL: @udiv_constant_dividend_select_of_constants_divisor(
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], i32 3, i32 0
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 12, i32 -3
  %r = udiv i32 42, %s
  ret i32 %r
}

define i32 @udiv_constant_dividend_select_of_constants_divisor_use(i1 %b) {
; CHECK-LABEL: @udiv_constant_dividend_select_of_constants_divisor_use(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], i32 12, i32 -3
; CHECK-NEXT:    call void @use(i32 [[S]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B]], i32 3, i32 0
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 12, i32 -3
  call void @use(i32 %s)
  %r = udiv i32 42, %s
  ret i32 %r
}

; Div-by-0 is immediate UB, so select is simplified.

define i32 @udiv_constant_dividend_select_of_constants_divisor_0_arm(i1 %b) {
; CHECK-LABEL: @udiv_constant_dividend_select_of_constants_divisor_0_arm(
; CHECK-NEXT:    ret i32 3
;
  %s = select i1 %b, i32 12, i32 0
  %r = udiv i32 42, %s
  ret i32 %r
}

; negative test - not safe to speculate div with variable divisor

define i32 @udiv_constant_dividend_select_divisor1(i1 %b, i32 %x) {
; CHECK-LABEL: @udiv_constant_dividend_select_divisor1(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], i32 [[X:%.*]], i32 -3
; CHECK-NEXT:    [[R:%.*]] = udiv i32 42, [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 %x, i32 -3
  %r = udiv i32 42, %s
  ret i32 %r
}

; negative test - not safe to speculate div with variable divisor

define i32 @udiv_constant_dividend_select_divisor2(i1 %b, i32 %x) {
; CHECK-LABEL: @udiv_constant_dividend_select_divisor2(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], i32 12, i32 [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = udiv i32 42, [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 12, i32 %x
  %r = udiv i32 42, %s
  ret i32 %r
}

define <2 x i8> @udiv_constant_dividend_select_of_constants_divisor_vec(i1 %b) {
; CHECK-LABEL: @udiv_constant_dividend_select_of_constants_divisor_vec(
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], <2 x i8> <i8 3, i8 0>, <2 x i8> <i8 0, i8 53>
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %s = select i1 %b, <2 x i8> <i8 12, i8 -5>, <2 x i8> <i8 -4, i8 4>
  %r = udiv <2 x i8> <i8 42, i8 -42>, %s
  ret <2 x i8> %r
}

; Div-by-0 element is immediate UB, so select is simplified.

define <2 x i8> @udiv_constant_dividend_select_of_constants_divisor_vec_ub1(i1 %b) {
; CHECK-LABEL: @udiv_constant_dividend_select_of_constants_divisor_vec_ub1(
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], <2 x i8> <i8 poison, i8 0>, <2 x i8> <i8 0, i8 53>
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %s = select i1 %b, <2 x i8> <i8 0, i8 -5>, <2 x i8> <i8 -4, i8 4>
  %r = udiv <2 x i8> <i8 42, i8 -42>, %s
  ret <2 x i8> %r
}

; There's no unsigned equivalent to "SMIN / -1", so this is just the usual constant folding.

define <2 x i8> @udiv_constant_dividend_select_of_constants_divisor_vec_ub2(i1 %b) {
; CHECK-LABEL: @udiv_constant_dividend_select_of_constants_divisor_vec_ub2(
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], <2 x i8> <i8 3, i8 0>, <2 x i8> zeroinitializer
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %s = select i1 %b, <2 x i8> <i8 12, i8 -5>, <2 x i8> <i8 -4, i8 -1>
  %r = udiv <2 x i8> <i8 42, i8 -128>, %s
  ret <2 x i8> %r
}

; negative test - must have constant dividend

define i32 @udiv_select_of_constants_divisor(i1 %b, i32 %x) {
; CHECK-LABEL: @udiv_select_of_constants_divisor(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], i32 12, i32 -3
; CHECK-NEXT:    [[R:%.*]] = udiv i32 [[X:%.*]], [[S]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = select i1 %b, i32 12, i32 -3
  %r = udiv i32 %x, %s
  ret i32 %r
}

; PR34063
; 1 / X !=/== -1

define i1 @sdiv_one_icmpeq_one(i32 %x) {
; CHECK-LABEL: @sdiv_one_icmpeq_one(
; CHECK-NEXT:    [[X_FR:%.*]] = freeze i32 [[X:%.*]]
; CHECK-NEXT:    [[B1:%.*]] = icmp eq i32 [[X_FR]], 1
; CHECK-NEXT:    ret i1 [[B1]]
;
  %A = sdiv i32 1, %x
  %B = icmp eq i32 %A, 1
  ret i1 %B
}

define i1 @sdiv_one_icmpeq_negone(i32 %x) {
; CHECK-LABEL: @sdiv_one_icmpeq_negone(
; CHECK-NEXT:    [[X_FR:%.*]] = freeze i32 [[X:%.*]]
; CHECK-NEXT:    [[B1:%.*]] = icmp eq i32 [[X_FR]], -1
; CHECK-NEXT:    ret i1 [[B1]]
;
  %A = sdiv i32 1, %x
  %B = icmp eq i32 %A, -1
  ret i1 %B
}

define i1 @udiv_one_icmpeq_one(i32 %x) {
; CHECK-LABEL: @udiv_one_icmpeq_one(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[X:%.*]], 1
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %A = udiv i32 1, %x
  %B = icmp eq i32 %A, 1
  ret i1 %B
}

define i1 @udiv_one_icmpne_one(i32 %x) {
; CHECK-LABEL: @udiv_one_icmpne_one(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[X:%.*]], 1
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %A = udiv i32 1, %x
  %B = icmp ne i32 %A, 1
  ret i1 %B
}

; ((X * Y) / Z) / X --> Y / Z

define i8 @udiv_udiv_mul_nuw(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @udiv_udiv_mul_nuw(
; CHECK-NEXT:    [[R:%.*]] = udiv i8 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %m = mul nuw i8 %x, %y
  %d = udiv i8 %m, %z
  %r = udiv i8 %d, %x
  ret i8 %r
}

; exact propagates and commute is ok

define i8 @udiv_udiv_mul_nuw_exact_exact(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @udiv_udiv_mul_nuw_exact_exact(
; CHECK-NEXT:    [[R:%.*]] = udiv exact i8 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %m = mul nuw i8 %y, %x
  %d = udiv exact i8 %m, %z
  %r = udiv exact i8 %d, %x
  ret i8 %r
}

; extra uses are ok

define i32 @udiv_udiv_mul_nuw_exact_use(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @udiv_udiv_mul_nuw_exact_use(
; CHECK-NEXT:    [[M:%.*]] = mul nuw i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    call void @use(i32 [[M]])
; CHECK-NEXT:    [[R:%.*]] = udiv i32 [[Y]], [[Z:%.*]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %m = mul nuw i32 %x, %y
  call void @use(i32 %m)
  %d = udiv exact i32 %m, %z
  %r = udiv i32 %d, %x
  ret i32 %r
}

; negative test - must have nuw

define i8 @udiv_udiv_mul_nsw(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @udiv_udiv_mul_nsw(
; CHECK-NEXT:    [[M:%.*]] = mul nsw i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[D:%.*]] = udiv i8 [[M]], [[Z:%.*]]
; CHECK-NEXT:    [[R:%.*]] = udiv i8 [[D]], [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %m = mul nsw i8 %x, %y
  %d = udiv i8 %m, %z
  %r = udiv i8 %d, %x
  ret i8 %r
}

; negative test - opcode mismatch

define i8 @udiv_sdiv_mul_nuw(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @udiv_sdiv_mul_nuw(
; CHECK-NEXT:    [[M:%.*]] = mul nuw i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[D:%.*]] = sdiv i8 [[M]], [[Z:%.*]]
; CHECK-NEXT:    [[R:%.*]] = udiv i8 [[D]], [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %m = mul nuw i8 %x, %y
  %d = sdiv i8 %m, %z
  %r = udiv i8 %d, %x
  ret i8 %r
}

; ((Y * X) / Z) / X --> Y / Z

define <2 x i8> @sdiv_sdiv_mul_nsw(<2 x i8> %x, <2 x i8> %y, <2 x i8> %z) {
; CHECK-LABEL: @sdiv_sdiv_mul_nsw(
; CHECK-NEXT:    [[R:%.*]] = sdiv <2 x i8> [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %m = mul nsw <2 x i8> %y, %x
  %d = sdiv <2 x i8> %m, %z
  %r = sdiv <2 x i8> %d, %x
  ret <2 x i8> %r
}

; (X * C0) / (X * C1) --> C0 / C1
define i8 @sdiv_mul_nsw_mul_nsw(i8 %x,i8 %y,i8 %z) {
; CHECK-LABEL: @sdiv_mul_nsw_mul_nsw(
; CHECK-NEXT:    [[ADD4:%.*]] = mul nsw i8 [[X:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[ADD5:%.*]] = mul nsw i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i8 [[ADD5]], [[ADD4]]
; CHECK-NEXT:    ret i8 [[DIV]]
;
  %add4 = mul nsw i8 %x, %z
  %add5 = mul nsw i8 %x, %y
  %div = sdiv i8 %add5, %add4
  ret i8 %div
}

define i8 @udiv_mul_nuw_mul_nuw(i8 %x,i8 %y,i8 %z) {
; CHECK-LABEL: @udiv_mul_nuw_mul_nuw(
; CHECK-NEXT:    [[DIV:%.*]] = udiv i8 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[DIV]]
;
  %add4 = mul nuw i8 %x, %z
  %add5 = mul nuw i8 %x, %y
  %div = udiv i8 %add5, %add4
  ret i8 %div
}

define i8 @sdiv_mul_nsw_constant_mul_nsw_constant(i8 %x) {
; CHECK-LABEL: @sdiv_mul_nsw_constant_mul_nsw_constant(
; CHECK-NEXT:    ret i8 2
;
  %add4 = mul nsw i8 %x, 5
  %add5 = mul nsw i8 %x, 10
  %div = sdiv i8 %add5, %add4
  ret i8 %div
}

define i4 @sdiv_mul_nsw_constant_mul_constant(i4 %a) {
; CHECK-LABEL: @sdiv_mul_nsw_constant_mul_constant(
; CHECK-NEXT:    [[ADD4:%.*]] = mul i4 [[A:%.*]], 3
; CHECK-NEXT:    [[ADD5:%.*]] = mul nsw i4 [[A]], 6
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i4 [[ADD5]], [[ADD4]]
; CHECK-NEXT:    ret i4 [[DIV]]
;
  %add4 = mul i4 %a, 3
  %add5 = mul nsw i4 %a, 6
  %div = sdiv i4 %add5, %add4
  ret i4 %div
}
define i4 @sdiv_mul_nsw_constant_mul_constant2(i4 %a) {
; CHECK-LABEL: @sdiv_mul_nsw_constant_mul_constant2(
; CHECK-NEXT:    [[ADD4:%.*]] = sub i4 0, [[A:%.*]]
; CHECK-NEXT:    [[ADD5:%.*]] = shl i4 [[A]], 3
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i4 [[ADD5]], [[ADD4]]
; CHECK-NEXT:    ret i4 [[DIV]]
;
  %add4 = mul i4 %a, 15
  %add5 = mul nsw i4 %a, 8
  %div = sdiv i4 %add5, %add4
  ret i4 %div
}

define i4 @sdiv_mul_nsw_constant_mul_constant3(i4 %a) {
; CHECK-LABEL: @sdiv_mul_nsw_constant_mul_constant3(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i4 [[A:%.*]], -8
; CHECK-NEXT:    [[DIV:%.*]] = select i1 [[TMP1]], i4 1, i4 -1
; CHECK-NEXT:    ret i4 [[DIV]]
;
  %add4 = mul i4 %a, 15
  %add5 = mul nsw i4 %a, 1
  %div = sdiv i4 %add5, %add4
  ret i4 %div
}

define i4 @sdiv_mul_nsw_mul(i4 %a) {
; CHECK-LABEL: @sdiv_mul_nsw_mul(
; CHECK-NEXT:    [[ADD4:%.*]] = sub i4 0, [[A:%.*]]
; CHECK-NEXT:    [[ADD5:%.*]] = shl i4 [[A]], 3
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i4 [[ADD5]], [[ADD4]]
; CHECK-NEXT:    ret i4 [[DIV]]
;
  %add4 = mul i4 %a, -1
  %add5 = mul nsw i4 %a, -8
  %div = sdiv i4 %add5, %add4
  ret i4 %div
}

define i4 @udiv_mul_nuw_constant_mul_constant(i4 %a) {
; CHECK-LABEL: @udiv_mul_nuw_constant_mul_constant(
; CHECK-NEXT:    ret i4 2
;
  %add4 = mul i4 %a, 3
  %add5 = mul nuw i4 %a, 6
  %div = udiv i4 %add5, %add4
  ret i4 %div
}

define i4 @udiv_mul_nuw_mul_negative(i4 %a) {
; CHECK-LABEL: @udiv_mul_nuw_mul_negative(
; CHECK-NEXT:    [[ADD4:%.*]] = mul i4 [[A:%.*]], -3
; CHECK-NEXT:    [[ADD5:%.*]] = shl nuw i4 [[A]], 2
; CHECK-NEXT:    [[DIV:%.*]] = udiv i4 [[ADD5]], [[ADD4]]
; CHECK-NEXT:    ret i4 [[DIV]]
;
  %add4 = mul i4 %a, 13
  %add5 = mul nuw i4 %a, 4
  %div = udiv i4 %add5, %add4
  ret i4 %div
}

define i4 @sdiv_mul_nsw_mul_nsw_allones(i4 %a) {
; CHECK-LABEL: @sdiv_mul_nsw_mul_nsw_allones(
; CHECK-NEXT:    [[ADD4:%.*]] = sub nsw i4 0, [[A:%.*]]
; CHECK-NEXT:    [[ADD5:%.*]] = shl i4 [[A]], 3
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i4 [[ADD5]], [[ADD4]]
; CHECK-NEXT:    ret i4 [[DIV]]
;
  %add4 = mul nsw i4 %a, -1
  %add5 = mul nsw i4 %a, -8
  %div = sdiv i4 %add5, %add4
  ret i4 %div
}

define i4 @sdiv_mul_nsw_mul_signmask(i4 %a, i4 %c2) {
; CHECK-LABEL: @sdiv_mul_nsw_mul_signmask(
; CHECK-NEXT:    [[ADD4:%.*]] = shl i4 [[A:%.*]], 3
; CHECK-NEXT:    [[ADD5:%.*]] = mul nsw i4 [[A]], [[C2:%.*]]
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i4 [[ADD5]], [[ADD4]]
; CHECK-NEXT:    ret i4 [[DIV]]
;
  %add4 = mul nsw i4 %a, -8
  %add5 = mul nsw i4 %a, %c2
  %div = sdiv i4 %add5, %add4
  ret i4 %div
}

define i32 @sdiv_sub1(i32 %arg) {
; CHECK-LABEL: @sdiv_sub1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[ARG:%.*]], -2147483648
; CHECK-NEXT:    [[DIV:%.*]] = select i1 [[TMP1]], i32 1, i32 -1
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %neg = sub i32 0, %arg
  %div = sdiv i32 %neg, %arg
  ret i32 %div
}

define i32 @sdiv_sub2(i32 %arg) {
; CHECK-LABEL: @sdiv_sub2(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[ARG:%.*]], -2147483648
; CHECK-NEXT:    [[DIV:%.*]] = select i1 [[TMP1]], i32 1, i32 -1
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %neg = sub i32 0, %arg
  %div = sdiv i32 %arg, %neg
  ret i32 %div
}

define i32 @sub_sdiv_multiuse(i32 %arg) {
; CHECK-LABEL: @sub_sdiv_multiuse(
; CHECK-NEXT:    [[NEG:%.*]] = sub i32 0, [[ARG:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[ARG]], -2147483648
; CHECK-NEXT:    [[DIV:%.*]] = select i1 [[TMP1]], i32 1, i32 -1
; CHECK-NEXT:    call void @use(i32 [[NEG]])
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %neg = sub i32 0, %arg
  %div = sdiv i32 %arg, %neg
  call void @use(i32 %neg)
  ret i32 %div
}

define i32 @sdiv_sub_sub(i32 %x ,i32 %y) {
; CHECK-LABEL: @sdiv_sub_sub(
; CHECK-NEXT:    [[S:%.*]] = sub i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[S]], -2147483648
; CHECK-NEXT:    [[D:%.*]] = select i1 [[TMP1]], i32 1, i32 -1
; CHECK-NEXT:    ret i32 [[D]]
;
  %s = sub i32 %x, %y
  %u = sub i32 %y, %x
  %d = sdiv i32 %s, %u
  ret i32 %d
}

define i32 @sdiv_mul_sub(i32 %x, i32 %y) {
; CHECK-LABEL: @sdiv_mul_sub(
; CHECK-NEXT:    [[M:%.*]] = mul i32 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[M]], -2147483648
; CHECK-NEXT:    [[R:%.*]] = select i1 [[TMP1]], i32 1, i32 -1
; CHECK-NEXT:    ret i32 [[R]]
;
  %m = mul i32 %y, %x
  %d = sub i32 0, %m
  %r = sdiv i32 %d, %m
  ret i32 %r
}

define i32 @sdiv_mul_sub_nsw(i32 %x, i32 %y) {
; CHECK-LABEL: @sdiv_mul_sub_nsw(
; CHECK-NEXT:    ret i32 -1
;
  %m = mul i32 %y, %x
  %n = sub nsw i32 0, %m
  %d = sdiv i32 %m, %n
  ret i32 %d
}

define i32 @sdiv_mul_nsw_sub_nsw(i32 %x, i32 %y) {
; CHECK-LABEL: @sdiv_mul_nsw_sub_nsw(
; CHECK-NEXT:    ret i32 -1
;
  %m = mul nsw i32 %y, %x
  %n = sub nsw i32 0, %m
  %d = sdiv i32 %m, %n
  ret i32 %d
}

; exact propagates

define i8 @sdiv_sdiv_mul_nsw_exact_exact(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @sdiv_sdiv_mul_nsw_exact_exact(
; CHECK-NEXT:    [[R:%.*]] = sdiv exact i8 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %m = mul nsw i8 %x, %y
  %d = sdiv exact i8 %m, %z
  %r = sdiv exact i8 %d, %x
  ret i8 %r
}

; extra uses are ok

define i32 @sdiv_sdiv_mul_nsw_exact_use(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @sdiv_sdiv_mul_nsw_exact_use(
; CHECK-NEXT:    [[M:%.*]] = mul nsw i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[D:%.*]] = sdiv i32 [[M]], [[Z:%.*]]
; CHECK-NEXT:    call void @use(i32 [[D]])
; CHECK-NEXT:    [[R:%.*]] = sdiv i32 [[Y]], [[Z]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %m = mul nsw i32 %x, %y
  %d = sdiv i32 %m, %z
  call void @use(i32 %d)
  %r = sdiv exact i32 %d, %x
  ret i32 %r
}

; negative test - must have nsw

define i8 @sdiv_sdiv_mul_nuw(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @sdiv_sdiv_mul_nuw(
; CHECK-NEXT:    [[M:%.*]] = mul nuw i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[D:%.*]] = sdiv i8 [[M]], [[Z:%.*]]
; CHECK-NEXT:    [[R:%.*]] = sdiv i8 [[D]], [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %m = mul nuw i8 %x, %y
  %d = sdiv i8 %m, %z
  %r = sdiv i8 %d, %x
  ret i8 %r
}

; negative test - opcode mismatch

define i8 @sdiv_udiv_mul_nsw(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @sdiv_udiv_mul_nsw(
; CHECK-NEXT:    [[M:%.*]] = mul nsw i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[D:%.*]] = udiv i8 [[M]], [[Z:%.*]]
; CHECK-NEXT:    [[R:%.*]] = sdiv i8 [[D]], [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %m = mul nsw i8 %x, %y
  %d = udiv i8 %m, %z
  %r = sdiv i8 %d, %x
  ret i8 %r
}

; ((X * C2) + C1) / C2 --> X + C1/C2

define i6 @sdiv_distribute_mul_nsw_add_nsw(i6 %x) {
; CHECK-LABEL: @sdiv_distribute_mul_nsw_add_nsw(
; CHECK-NEXT:    [[DIV:%.*]] = add nsw i6 [[X:%.*]], -5
; CHECK-NEXT:    ret i6 [[DIV]]
;
  %mul = mul nsw i6 %x, 3
  %add = add nsw i6 %mul, -15
  %div = sdiv i6 %add, 3
  ret i6 %div
}

; extra uses are ok

define i32 @sdiv_distribute_mul_nsw_add_nsw_uses(i32 %x) {
; CHECK-LABEL: @sdiv_distribute_mul_nsw_add_nsw_uses(
; CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[X:%.*]], 42
; CHECK-NEXT:    call void @use(i32 [[MUL]])
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[MUL]], 126
; CHECK-NEXT:    call void @use(i32 [[ADD]])
; CHECK-NEXT:    [[DIV:%.*]] = add nsw i32 [[X]], 3
; CHECK-NEXT:    ret i32 [[DIV]]
;
  %mul = mul nsw i32 %x, 42
  call void @use(i32 %mul)
  %add = add nsw i32 %mul, 126
  call void @use(i32 %add)
  %div = sdiv i32 %add, 42
  ret i32 %div
}

; vector splats work

define <2 x i6> @udiv_distribute_mul_nuw_add_nuw(<2 x i6> %x) {
; CHECK-LABEL: @udiv_distribute_mul_nuw_add_nuw(
; CHECK-NEXT:    [[DIV:%.*]] = add nuw <2 x i6> [[X:%.*]], splat (i6 5)
; CHECK-NEXT:    ret <2 x i6> [[DIV]]
;
  %mul = mul nuw <2 x i6> %x, <i6 3, i6 3>
  %add = add nuw <2 x i6> %mul, <i6 15, i6 15>
  %div = udiv <2 x i6> %add, <i6 3, i6 3>
  ret <2 x i6> %div
}

; negative test - constants must be evenly divisible

define i6 @sdiv_distribute_mul_nsw_add_nsw_not_multiple_offset(i6 %x) {
; CHECK-LABEL: @sdiv_distribute_mul_nsw_add_nsw_not_multiple_offset(
; CHECK-NEXT:    [[MUL:%.*]] = mul nsw i6 [[X:%.*]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i6 [[MUL]], -16
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i6 [[ADD]], 3
; CHECK-NEXT:    ret i6 [[DIV]]
;
  %mul = mul nsw i6 %x, 3
  %add = add nsw i6 %mul, -16
  %div = sdiv i6 %add, 3
  ret i6 %div
}

; constants do not have to be evenly divisible with unsigned division

define i6 @udiv_distribute_mul_nuw_add_nuw_not_multiple_offset(i6 %x) {
; CHECK-LABEL: @udiv_distribute_mul_nuw_add_nuw_not_multiple_offset(
; CHECK-NEXT:    [[DIV:%.*]] = add nuw i6 [[X:%.*]], 2
; CHECK-NEXT:    ret i6 [[DIV]]
;
  %mul = mul nuw i6 %x, 3
  %add = add nuw i6 %mul, 7
  %div = udiv i6 %add, 3
  ret i6 %div
}

; negative test - wrong no-wrap

define i6 @sdiv_distribute_mul_nuw_add_nsw(i6 %x) {
; CHECK-LABEL: @sdiv_distribute_mul_nuw_add_nsw(
; CHECK-NEXT:    [[MUL:%.*]] = mul nuw i6 [[X:%.*]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i6 [[MUL]], -15
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i6 [[ADD]], 3
; CHECK-NEXT:    ret i6 [[DIV]]
;
  %mul = mul nuw i6 %x, 3
  %add = add nsw i6 %mul, -15
  %div = sdiv i6 %add, 3
  ret i6 %div
}

; negative test - wrong no-wrap

define i6 @udiv_distribute_mul_nsw_add_nuw(i6 %x) {
; CHECK-LABEL: @udiv_distribute_mul_nsw_add_nuw(
; CHECK-NEXT:    [[MUL:%.*]] = mul nsw i6 [[X:%.*]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i6 [[MUL]], 9
; CHECK-NEXT:    [[DIV:%.*]] = udiv i6 [[ADD]], 3
; CHECK-NEXT:    ret i6 [[DIV]]
;
  %mul = mul nsw i6 %x, 3
  %add = add nuw i6 %mul, 9
  %div = udiv i6 %add, 3
  ret i6 %div
}

define i32 @fold_disjoint_or_over_sdiv(i32 %x) {
; CHECK-LABEL: @fold_disjoint_or_over_sdiv(
; CHECK-NEXT:    [[R:%.*]] = add nsw i32 [[X:%.*]], 9
; CHECK-NEXT:    ret i32 [[R]]
;
  %mul = mul nsw i32 %x, 9
  %or = or disjoint i32 %mul, 81
  %r = sdiv i32 %or, 9
  ret i32 %r
}

define i32 @fold_disjoint_or_over_udiv(i32 %x) {
; CHECK-LABEL: @fold_disjoint_or_over_udiv(
; CHECK-NEXT:    [[R:%.*]] = add nuw i32 [[X:%.*]], 9
; CHECK-NEXT:    ret i32 [[R]]
;
  %mul = mul nuw i32 %x, 9
  %or = or disjoint i32 %mul, 81
  %r = udiv i32 %or, 9
  ret i32 %r
}

define i8 @udiv_trunc_shl(i32 %x) {
; CHECK-LABEL: @udiv_trunc_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[X:%.*]] to i8
; CHECK-NEXT:    [[UDIV1:%.*]] = lshr i8 8, [[TMP1]]
; CHECK-NEXT:    ret i8 [[UDIV1]]
;
  %lshr = shl i32 1, %x
  %trunc = trunc i32 %lshr to i8
  %div = udiv i8 8, %trunc
  ret i8 %div
}

define i32 @zext_udiv_trunc_lshr(i32 %x) {
; CHECK-LABEL: @zext_udiv_trunc_lshr(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[X:%.*]] to i8
; CHECK-NEXT:    [[TMP2:%.*]] = sub i8 5, [[TMP1]]
; CHECK-NEXT:    [[UDIV1:%.*]] = lshr i8 8, [[TMP2]]
; CHECK-NEXT:    [[ZEXT:%.*]] = zext nneg i8 [[UDIV1]] to i32
; CHECK-NEXT:    ret i32 [[ZEXT]]
;
  %lshr = lshr i32 32, %x
  %trunc = trunc i32 %lshr to i8
  %div = udiv i8 8, %trunc
  %zext = zext i8 %div to i32
  ret i32 %zext
}

define i32 @udiv_and_shl(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: @udiv_and_shl(
; CHECK-NEXT:    [[DIV1:%.*]] = lshr i32 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    ret i32 [[DIV1]]
;
  %shl = shl i32 1, %a
  %and = and i32 %b, %shl
  %div = udiv i32 %c, %and
  ret i32 %div
}
