; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt %s -passes=instcombine -S | FileCheck %s

define i1 @test_switch_with_zext(i16 %a, i1 %b, i1 %c) {
; CHECK-LABEL: define i1 @test_switch_with_zext(
; CHECK-SAME: i16 [[A:%.*]], i1 [[B:%.*]], i1 [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i16 [[A]], label [[SW_DEFAULT:%.*]] [
; CHECK-NEXT:      i16 37, label [[SW_BB:%.*]]
; CHECK-NEXT:      i16 38, label [[SW_BB]]
; CHECK-NEXT:      i16 39, label [[SW_BB]]
; CHECK-NEXT:    ]
; CHECK:       sw.bb:
; CHECK-NEXT:    ret i1 [[B]]
; CHECK:       sw.default:
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.ext = zext i16 %a to i32
  switch i32 %a.ext, label %sw.default [
  i32 37, label %sw.bb
  i32 38, label %sw.bb
  i32 39, label %sw.bb
  ]

sw.bb:
  ret i1 %b
sw.default:
  ret i1 %c
}

define i1 @test_switch_with_sext(i16 %a, i1 %b, i1 %c) {
; CHECK-LABEL: define i1 @test_switch_with_sext(
; CHECK-SAME: i16 [[A:%.*]], i1 [[B:%.*]], i1 [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i16 [[A]], label [[SW_DEFAULT:%.*]] [
; CHECK-NEXT:      i16 37, label [[SW_BB:%.*]]
; CHECK-NEXT:      i16 38, label [[SW_BB]]
; CHECK-NEXT:      i16 39, label [[SW_BB]]
; CHECK-NEXT:    ]
; CHECK:       sw.bb:
; CHECK-NEXT:    ret i1 [[B]]
; CHECK:       sw.default:
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.ext = sext i16 %a to i32
  switch i32 %a.ext, label %sw.default [
  i32 37, label %sw.bb
  i32 38, label %sw.bb
  i32 39, label %sw.bb
  ]

sw.bb:
  ret i1 %b
sw.default:
  ret i1 %c
}

; Negative tests

define i1 @test_switch_with_zext_unreachable_case(i16 %a, i1 %b, i1 %c) {
; CHECK-LABEL: define i1 @test_switch_with_zext_unreachable_case(
; CHECK-SAME: i16 [[A:%.*]], i1 [[B:%.*]], i1 [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_EXT:%.*]] = zext i16 [[A]] to i32
; CHECK-NEXT:    switch i32 [[A_EXT]], label [[SW_DEFAULT:%.*]] [
; CHECK-NEXT:      i32 37, label [[SW_BB:%.*]]
; CHECK-NEXT:      i32 38, label [[SW_BB]]
; CHECK-NEXT:      i32 39, label [[SW_BB]]
; CHECK-NEXT:      i32 65537, label [[SW_BB]]
; CHECK-NEXT:    ]
; CHECK:       sw.bb:
; CHECK-NEXT:    ret i1 [[B]]
; CHECK:       sw.default:
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.ext = zext i16 %a to i32
  switch i32 %a.ext, label %sw.default [
  i32 37, label %sw.bb
  i32 38, label %sw.bb
  i32 39, label %sw.bb
  i32 65537, label %sw.bb
  ]

sw.bb:
  ret i1 %b
sw.default:
  ret i1 %c
}

define i1 @test_switch_with_sext_unreachable_case(i16 %a, i1 %b, i1 %c) {
; CHECK-LABEL: define i1 @test_switch_with_sext_unreachable_case(
; CHECK-SAME: i16 [[A:%.*]], i1 [[B:%.*]], i1 [[C:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_EXT:%.*]] = sext i16 [[A]] to i32
; CHECK-NEXT:    switch i32 [[A_EXT]], label [[SW_DEFAULT:%.*]] [
; CHECK-NEXT:      i32 37, label [[SW_BB:%.*]]
; CHECK-NEXT:      i32 38, label [[SW_BB]]
; CHECK-NEXT:      i32 39, label [[SW_BB]]
; CHECK-NEXT:      i32 -65537, label [[SW_BB]]
; CHECK-NEXT:    ]
; CHECK:       sw.bb:
; CHECK-NEXT:    ret i1 [[B]]
; CHECK:       sw.default:
; CHECK-NEXT:    ret i1 [[C]]
;
entry:
  %a.ext = sext i16 %a to i32
  switch i32 %a.ext, label %sw.default [
  i32 37, label %sw.bb
  i32 38, label %sw.bb
  i32 39, label %sw.bb
  i32 -65537, label %sw.bb
  ]

sw.bb:
  ret i1 %b
sw.default:
  ret i1 %c
}
