; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Pattern:
;   (or (and (add x, half_c1), c3), (and x, c2))
; IFF:
;   c1, c2, c3 is constant
;   c1 is pow2
;   c2 < c1
;   c3 == (c1 - 1) ^ c2
;   half_c1 == (lshr c1, 1)
;   (c1 >> 1) & c3 == (c1 >> 1)
;   x is known to be less than c1
; Could be transformed into:
;   (xor x, half_c1)
; The reason above transformation could be done is becase
; in (and (add x, half_c1), c3), half_c1 equals the top bit
; of the demanded mask indicated by (and ..., c3)

define i16 @or_and_add_and() {
; CHECK-LABEL: @or_and_add_and(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X:%.*]] = call i16 @dummy(), !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    [[OR:%.*]] = xor i16 [[X]], 32
; CHECK-NEXT:    ret i16 [[OR]]
;
entry:
  %x = call i16 @dummy(), !range !0
  %add = add i16 32, %x
  %and1 = and i16 %add, 48
  %and2 = and i16 %x, 15
  %or = or i16 %and1, %and2
  ret i16 %or
}

declare i16 @dummy()

!0 = !{i16 0, i16 64}
