; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+d --target-abi=ilp32d < %s \
; RUN:   | FileCheck %s

;; This file contains specific tests for the ilp32d ABI.

;; Check pass floating-point arguments whith FPRs.

define i32 @callee_float_in_fpr(i32 %a, float %b, double %c) nounwind {
; CHECK-LABEL: callee_float_in_fpr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ftintrz.w.s $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a1, $fa0
; CHECK-NEXT:    ftintrz.w.d $fa0, $fa1
; CHECK-NEXT:    movfr2gr.s $a2, $fa0
; CHECK-NEXT:    add.w $a0, $a0, $a1
; CHECK-NEXT:    add.w $a0, $a0, $a2
; CHECK-NEXT:    ret
  %b_fptosi = fptosi float %b to i32
  %c_fptosi = fptosi double %c to i32
  %1 = add i32 %a, %b_fptosi
  %2 = add i32 %1, %c_fptosi
  ret i32 %2
}

define i32 @caller_float_in_fpr() nounwind {
; CHECK-LABEL: caller_float_in_fpr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.w $sp, $sp, -16
; CHECK-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; CHECK-NEXT:    movgr2fr.w $fa1, $zero
; CHECK-NEXT:    movgr2frh.w $fa1, $zero
; CHECK-NEXT:    movgr2fr.w $fa0, $zero
; CHECK-NEXT:    ori $a0, $zero, 1
; CHECK-NEXT:    bl callee_float_in_fpr
; CHECK-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; CHECK-NEXT:    addi.w $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 @callee_float_in_fpr(i32 1, float 0.0, double 0.0)
  ret i32 %1
}

;; Check that the GPR is used once the FPRs are exhausted.

;; Must keep define on a single line due to an update_llc_test_checks.py limitation.
define i32 @callee_double_in_gpr_exhausted_fprs(double %a, double %b, double %c, double %d, double %e, double %f, double %g, double %h, double %i) nounwind {
; CHECK-LABEL: callee_double_in_gpr_exhausted_fprs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movgr2fr.w $fa0, $a0
; CHECK-NEXT:    movgr2frh.w $fa0, $a1
; CHECK-NEXT:    ftintrz.w.d $fa1, $fa7
; CHECK-NEXT:    movfr2gr.s $a0, $fa1
; CHECK-NEXT:    ftintrz.w.d $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a1, $fa0
; CHECK-NEXT:    add.w $a0, $a0, $a1
; CHECK-NEXT:    ret
  %h_fptosi = fptosi double %h to i32
  %i_fptosi = fptosi double %i to i32
  %1 = add i32 %h_fptosi, %i_fptosi
  ret i32 %1
}

define i32 @caller_double_in_gpr_exhausted_fprs() nounwind {
; CHECK-LABEL: caller_double_in_gpr_exhausted_fprs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.w $sp, $sp, -16
; CHECK-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_0)
; CHECK-NEXT:    fld.d $fa1, $a0, %pc_lo12(.LCPI3_0)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_1)
; CHECK-NEXT:    fld.d $fa2, $a0, %pc_lo12(.LCPI3_1)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_2)
; CHECK-NEXT:    fld.d $fa3, $a0, %pc_lo12(.LCPI3_2)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_3)
; CHECK-NEXT:    fld.d $fa4, $a0, %pc_lo12(.LCPI3_3)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_4)
; CHECK-NEXT:    fld.d $fa5, $a0, %pc_lo12(.LCPI3_4)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_5)
; CHECK-NEXT:    fld.d $fa6, $a0, %pc_lo12(.LCPI3_5)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI3_6)
; CHECK-NEXT:    fld.d $fa7, $a0, %pc_lo12(.LCPI3_6)
; CHECK-NEXT:    addi.w $a0, $zero, 1
; CHECK-NEXT:    movgr2fr.w $fa0, $a0
; CHECK-NEXT:    ffint.s.w $fa0, $fa0
; CHECK-NEXT:    fcvt.d.s $fa0, $fa0
; CHECK-NEXT:    lu12i.w $a1, 262688
; CHECK-NEXT:    move $a0, $zero
; CHECK-NEXT:    bl callee_double_in_gpr_exhausted_fprs
; CHECK-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; CHECK-NEXT:    addi.w $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call i32 @callee_double_in_gpr_exhausted_fprs(
      double 1.0, double 2.0, double 3.0, double 4.0, double 5.0, double 6.0,
      double 7.0, double 8.0, double 9.0)
  ret i32 %1
}

;; Check that the stack is used once the FPRs and GPRs are both exhausted.

;; Must keep define on a single line due to an update_llc_test_checks.py limitation.
define i32 @callee_double_on_stack_exhausted_fprs_gprs(double %a, double %b, double %c, double %d, double %e, double %f, double %g, double %h, double %i, double %j, double %k, double %l, double %m, double %n) nounwind {
; CHECK-LABEL: callee_double_on_stack_exhausted_fprs_gprs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fld.d $fa0, $sp, 0
; CHECK-NEXT:    fld.d $fa1, $sp, 8
; CHECK-NEXT:    ftintrz.w.d $fa0, $fa0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    ftintrz.w.d $fa0, $fa1
; CHECK-NEXT:    movfr2gr.s $a1, $fa0
; CHECK-NEXT:    add.w $a0, $a0, $a1
; CHECK-NEXT:    ret
  %m_fptosi = fptosi double %m to i32
  %n_fptosi = fptosi double %n to i32
  %1 = add i32 %m_fptosi, %n_fptosi
  ret i32 %1
}

define i32 @caller_double_on_stack_exhausted_fprs_gprs() nounwind {
; CHECK-LABEL: caller_double_on_stack_exhausted_fprs_gprs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.w $sp, $sp, -32
; CHECK-NEXT:    st.w $ra, $sp, 28 # 4-byte Folded Spill
; CHECK-NEXT:    lu12i.w $a0, 262816
; CHECK-NEXT:    st.w $a0, $sp, 4
; CHECK-NEXT:    st.w $zero, $sp, 0
; CHECK-NEXT:    lu12i.w $a0, 262848
; CHECK-NEXT:    st.w $a0, $sp, 12
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI5_0)
; CHECK-NEXT:    fld.d $fa1, $a0, %pc_lo12(.LCPI5_0)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI5_1)
; CHECK-NEXT:    fld.d $fa2, $a0, %pc_lo12(.LCPI5_1)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI5_2)
; CHECK-NEXT:    fld.d $fa3, $a0, %pc_lo12(.LCPI5_2)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI5_3)
; CHECK-NEXT:    fld.d $fa4, $a0, %pc_lo12(.LCPI5_3)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI5_4)
; CHECK-NEXT:    fld.d $fa5, $a0, %pc_lo12(.LCPI5_4)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI5_5)
; CHECK-NEXT:    fld.d $fa6, $a0, %pc_lo12(.LCPI5_5)
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI5_6)
; CHECK-NEXT:    fld.d $fa7, $a0, %pc_lo12(.LCPI5_6)
; CHECK-NEXT:    addi.w $a0, $zero, 1
; CHECK-NEXT:    movgr2fr.w $fa0, $a0
; CHECK-NEXT:    ffint.s.w $fa0, $fa0
; CHECK-NEXT:    fcvt.d.s $fa0, $fa0
; CHECK-NEXT:    lu12i.w $a1, 262688
; CHECK-NEXT:    lu12i.w $a3, 262720
; CHECK-NEXT:    lu12i.w $a5, 262752
; CHECK-NEXT:    lu12i.w $a7, 262784
; CHECK-NEXT:    st.w $zero, $sp, 8
; CHECK-NEXT:    move $a0, $zero
; CHECK-NEXT:    move $a2, $zero
; CHECK-NEXT:    move $a4, $zero
; CHECK-NEXT:    move $a6, $zero
; CHECK-NEXT:    bl callee_double_on_stack_exhausted_fprs_gprs
; CHECK-NEXT:    ld.w $ra, $sp, 28 # 4-byte Folded Reload
; CHECK-NEXT:    addi.w $sp, $sp, 32
; CHECK-NEXT:    ret
  %1 = call i32 @callee_double_on_stack_exhausted_fprs_gprs(
      double 1.0, double 2.0, double 3.0, double 4.0, double 5.0, double 6.0,
      double 7.0, double 8.0, double 9.0, double 10.0, double 11.0, double 12.0,
      double 13.0, double 14.0)
  ret i32 %1
}

;; Check returning doubles.

define double @callee_double_ret() nounwind {
; CHECK-LABEL: callee_double_ret:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.w $a0, $zero, 1
; CHECK-NEXT:    movgr2fr.w $fa0, $a0
; CHECK-NEXT:    ffint.s.w $fa0, $fa0
; CHECK-NEXT:    fcvt.d.s $fa0, $fa0
; CHECK-NEXT:    ret
  ret double 1.0
}

define i64 @caller_double_ret() nounwind {
; CHECK-LABEL: caller_double_ret:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.w $sp, $sp, -16
; CHECK-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; CHECK-NEXT:    bl callee_double_ret
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    movfrh2gr.s $a1, $fa0
; CHECK-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; CHECK-NEXT:    addi.w $sp, $sp, 16
; CHECK-NEXT:    ret
  %1 = call double @callee_double_ret()
  %2 = bitcast double %1 to i64
  ret i64 %2
}
