# 0.0.29

**Version:** 0.0.29
**Published:** 2025-01-18T21:35:34Z

## Release Notes

### 📦 **Rust Coreutils 0.0.29 Release:**

We are excited to announce the release of **Rust Coreutils 0.0.29**!
---

### Highlights:
- **Improved Compatibility**:
  - Passing GNU tests increased to **506** (+30 compared to 0.0.28).
  - Failing tests reduced to **67** (-27 compared to 0.0.28).
- **Contributions**: This release was made possible by the dedication of **32 contributors**, including **18 newcomers**.
- Compared with 0.0.28, several commands now achieve 100% compatibility with GNU tests, including `df`, `dircolors`, `chmod`, `chroot`, `comm`, `seq`, `split`, `uniq`, and more.
- **Performance Boost**: Optimizations in tools like `du`, `echo`, and `seq`.

---

### GNU Test Suite Compatibility:
Here’s how version 0.0.29 compares to the previous release:

| Result        | 0.0.28 | 0.0.29 | Change 0.0.28 to 0.0.29 | % Total 0.0.28 | % Total 0.0.29 | % Change 0.0.28 to 0.0.29 |
|---------------|--------|--------|-------------------------|----------------|----------------|--------------------------|
| Pass          | 476    | 506    | +30                    | 77.65%         | 82.38%         | +4.73%                   |
| Skip          | 43     | 41     | -2                     | 7.01%          | 6.68%          | -0.33%                   |
| Fail          | 94     | 67     | -27                    | 15.34%         | 10.92%         | -4.42%                   |
| Error         | 0      | 0      | 0                      | 0.00%          | 0.00%          | 0.00%                    |

---

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

---

### Call to Action:
Support our work by sponsoring us on GitHub! Your contributions directly help maintain our infrastructure and enable faster development. [Sponsor us here](https://github.com/sponsors/uutils).

For more details and to download the latest release, visit our website: [https://uutils.github.io](https://uutils.github.io).

## What's Changed

### basenc
* basenc: ignore Interrupted errors by @andrewliebenow in https://github.com/uutils/coreutils/pull/6778
* basenc: ignore case with "--base16 --decode" by @cakebaker in https://github.com/uutils/coreutils/pull/6963
* build-gnu.sh: adapt `basenc` message to clap changes by @cakebaker in https://github.com/uutils/coreutils/pull/6966

### base32/base64
* handle two corner cases by @sylvestre in https://github.com/uutils/coreutils/pull/6906

### checksum
* prepare further behavior fix with a rework by @RenjiSann in https://github.com/uutils/coreutils/pull/6822
* Further rework by @RenjiSann in https://github.com/uutils/coreutils/pull/6868
* cksum: even more fixes by @RenjiSann in https://github.com/uutils/coreutils/pull/6929
* fuzzing: add a new fuzzer for cksum by @sylvestre in https://github.com/uutils/coreutils/pull/6585
* fix error message when the flags length and an algorithm different from blake2b are present by @Felle33 in https://github.com/uutils/coreutils/pull/7071
* the --tag is meaningless with --check by @Felle33 in https://github.com/uutils/coreutils/pull/7079
* remove some unnecessary type info by @cakebaker in https://github.com/uutils/coreutils/pull/7080

### chmod
* Remove duplicate declarations + start to plug it to chmod too by @sylvestre in https://github.com/uutils/coreutils/pull/7017
* add uucore's `perms` feature to `Cargo.toml` by @cakebaker in https://github.com/uutils/coreutils/pull/7037
* add support for the deref and links options by @sylvestre in https://github.com/uutils/coreutils/pull/7025
* remove test tests/chmod/symlinks from the list by @sylvestre in https://github.com/uutils/coreutils/pull/7125

### chroot
* fix parsing of --userspec argument by @jfinkels in https://github.com/uutils/coreutils/pull/7043
* remove `-G` short option by @cakebaker in https://github.com/uutils/coreutils/pull/7051
* fix many issues with chroot by @jfinkels in https://github.com/uutils/coreutils/pull/7057
* handle the error when invalid user by @sylvestre in https://github.com/uutils/coreutils/pull/7015
* make group option self overwriting by @AnirbanHalder654322 in https://github.com/uutils/coreutils/pull/7123
* tests/chroot/chroot-credentials has been fixed by @sylvestre in https://github.com/uutils/coreutils/pull/7124

### comm
* generate an error if the input is a directory by @sylvestre in https://github.com/uutils/coreutils/pull/6853
* adapt GNU error messages by @cakebaker in https://github.com/uutils/coreutils/pull/6998
* don't use files for test by @sylvestre in https://github.com/uutils/coreutils/pull/7140
* implement the ordering check by @sylvestre in https://github.com/uutils/coreutils/pull/7144

### cp
* remove some `sleep()` calls in tests by @cakebaker in https://github.com/uutils/coreutils/pull/6890
* use the function from uucore by @sylvestre in https://github.com/uutils/coreutils/pull/7003
* when copying a read only file, make sure that the xattrs can be set properly by @sylvestre in https://github.com/uutils/coreutils/pull/7009
* copy attributes after making subdir by @rm-dr in https://github.com/uutils/coreutils/pull/6884
* make --backup and --no-clobber are mutually exclusive by @sylvestre in https://github.com/uutils/coreutils/pull/7082
* implement copying from streams by @DaringCuteSeal in https://github.com/uutils/coreutils/pull/7061

### csplit
* fix bug when --suppress-matched flag is active and positive/negative offset is present by @Felle33 in https://github.com/uutils/coreutils/pull/7088
* support reading from pipe by @fuad1502 in https://github.com/uutils/coreutils/pull/6951
* simplify test by @cakebaker in https://github.com/uutils/coreutils/pull/7106
* add support for `-q` by @cakebaker in https://github.com/uutils/coreutils/pull/7000
* allow offset without sign in pattern by @cakebaker in https://github.com/uutils/coreutils/pull/7006

### cut
* Fix cut when lines don't end with specified delim by @andreistan26 in https://github.com/uutils/coreutils/pull/5844
* adjust to our messages as they are better by @sylvestre in https://github.com/uutils/coreutils/pull/6921
* some test refactorings by @cakebaker in https://github.com/uutils/coreutils/pull/6970
* fix overriding of `-d=` by @cakebaker in https://github.com/uutils/coreutils/pull/6984
* don't merge adjacent ranges by @cakebaker in https://github.com/uutils/coreutils/pull/6990
* fix handling of newline as delimiter by @cakebaker in https://github.com/uutils/coreutils/pull/6996

### date
* display %Z alphabetic time zone abbreviation by @jfinkels in https://github.com/uutils/coreutils/pull/7134

### dd
* error if iflag=directory and input is stdin by @jfinkels in https://github.com/uutils/coreutils/pull/7122

### df
* fix display of special characters by @jfinkels in https://github.com/uutils/coreutils/pull/7151
* error on over-mounted device by @jfinkels in https://github.com/uutils/coreutils/pull/7116
* df test now passes by @sylvestre in https://github.com/uutils/coreutils/pull/7130

### dircolors
* fix empty COLORTERM matching with ?* pattern by @sylvestre in https://github.com/uutils/coreutils/pull/7089
* move `use` declaration to top by @cakebaker in https://github.com/uutils/coreutils/pull/7143
* dircolors is fixed by @sylvestre in https://github.com/uutils/coreutils/pull/7141

### du
* Reuse metadata from DirEntry where possible by @jesseschalken in https://github.com/uutils/coreutils/pull/6839
* fix the display with --inodes by @sylvestre in https://github.com/uutils/coreutils/pull/6878
* deduplicate the input by @sylvestre in https://github.com/uutils/coreutils/pull/6885
* Reuse existing metadata instead of calling path.is_dir() again by @jesseschalken in https://github.com/uutils/coreutils/pull/6840

### echo
* remove code made obsolete by MSRV 1.79 by @cakebaker in https://github.com/uutils/coreutils/pull/6989
* handle double hyphens by @cakebaker in https://github.com/uutils/coreutils/pull/6997
* add support for `POSIXLY_CORRECT` by @cakebaker in https://github.com/uutils/coreutils/pull/7059

### env
* add missing `cfg` attributes to tests by @cakebaker in https://github.com/uutils/coreutils/pull/6896
* better handling of the errors by @sylvestre in https://github.com/uutils/coreutils/pull/7090
* fix only long options are allowed to contain '=' by @jovielarue in https://github.com/uutils/coreutils/pull/7008

### fmt
* generate an error if the input is a directory by @sylvestre in https://github.com/uutils/coreutils/pull/6854

### head
* fix subtraction underflow with --bytes=-N by @jfinkels in https://github.com/uutils/coreutils/pull/7036
* make head fail when writing to /dev/full by @DaringCuteSeal in https://github.com/uutils/coreutils/pull/7068

### install
* create destination file with safer modes before copy by @nerdroychan in https://github.com/uutils/coreutils/pull/6595
* Revert "create destination file with safer modes before copy" by @sylvestre in https://github.com/uutils/coreutils/pull/6922
* implement copying from streams by @DaringCuteSeal in https://github.com/uutils/coreutils/pull/6965

### kill
* add `-n` hidden option for compatibility with bash by @samueltardieu in https://github.com/uutils/coreutils/pull/7069
* make `-s` conflict with `-l` and `-t` by @samueltardieu in https://github.com/uutils/coreutils/pull/7070

### ls
* when a file has capabilities (setcap), change the color by @sylvestre in https://github.com/uutils/coreutils/pull/6987
* finish the plug of mtime by @sylvestre in https://github.com/uutils/coreutils/pull/7016
* add better support for non-UTF-8 bytes by @jtracey in https://github.com/uutils/coreutils/pull/7020

### mkfifo
* better handle the mode + umask by @sylvestre in https://github.com/uutils/coreutils/pull/6971
* add missing "mode" feature for uucore dep by @jfinkels in https://github.com/uutils/coreutils/pull/7075

### more
* reduce memory usage a bit by @tertsdiepraam in https://github.com/uutils/coreutils/pull/6399

### mv
* fix the output of an error message by @sylvestre in https://github.com/uutils/coreutils/pull/6861
* remove `sleep` in tests by @cakebaker in https://github.com/uutils/coreutils/pull/6880
* show "same file" error for `mv d/f d` by @cakebaker in https://github.com/uutils/coreutils/pull/5788
* Revert "show 'same file' error for `mv d/f d`" by @sylvestre in https://github.com/uutils/coreutils/pull/6905
* fix invalid numbered backup path by @hamflx in https://github.com/uutils/coreutils/pull/6119
* don't panic if apply_xattrs fails by @alexs-sh in https://github.com/uutils/coreutils/pull/6936
* improve move-to-self error handling by @sgvictorino in https://github.com/uutils/coreutils/pull/6995

### numfmt
* use `succeeds()`/`fails()` instead of `run()` in tests by @cakebaker in https://github.com/uutils/coreutils/pull/7135
* adapt GNU `numfmt` error message by @cakebaker in https://github.com/uutils/coreutils/pull/7086

### printf
* remove allow(dead_code) directive by @jfinkels in https://github.com/uutils/coreutils/pull/7110

### rm
* fix r4_gnu_test by @AnirbanHalder654322 in https://github.com/uutils/coreutils/pull/6621
* remove outdated comment by @cakebaker in https://github.com/uutils/coreutils/pull/7022
* remove open call from uu-rm by @elde-n in https://github.com/uutils/coreutils/pull/7010

### seq
* add overflow checks when parsing exponents by @steinwand6 in https://github.com/uutils/coreutils/pull/6858
* handle scientific notation with uppercase 'E' by @artP2 in https://github.com/uutils/coreutils/pull/6928
* reduce memory allocation during prefix search by @alexs-sh in https://github.com/uutils/coreutils/pull/6949
* handle 0e... scientific notation without padding by @aimerlief in https://github.com/uutils/coreutils/pull/6934
* use `stdout_only()` to remove `no_stderr()` by @cakebaker in https://github.com/uutils/coreutils/pull/6937
* improve error handling for invalid -f values by @jfinkels in https://github.com/uutils/coreutils/pull/7032
* re-enable GNU test file precision.sh by @jfinkels in https://github.com/uutils/coreutils/pull/7095
* add floating point support by @alexs-sh in https://github.com/uutils/coreutils/pull/6959
* add a lower bound for exponents by @alexs-sh in https://github.com/uutils/coreutils/pull/7145
* fixed tests/seq/seq-precision by @sylvestre in https://github.com/uutils/coreutils/pull/7147

### sort
* Rework merge batching logic by @karlmcdowall in https://github.com/uutils/coreutils/pull/6957

### split
* fix bug with large arguments to -C by @jfinkels in https://github.com/uutils/coreutils/pull/7128

### stat
* Improve "stat" compatibility by @sylvestre in https://github.com/uutils/coreutils/pull/6933
* fix precision when rendering mtime (%Y) by @jfinkels in https://github.com/uutils/coreutils/pull/7115

### tail
* fix issue #6543 (--pid when reading from stdin) by @just-an-engineer in https://github.com/uutils/coreutils/pull/6582

### tr
* Add ambiguous octal escape warning by @OshinoShinobu-Chan in https://github.com/uutils/coreutils/pull/6886
* generate an error if the input is a directory by @sylvestre in https://github.com/uutils/coreutils/pull/6855
* generate an error for real if the input is a directory by @sylvestre in https://github.com/uutils/coreutils/pull/6907

### tsort
* split edge data on any whitespace chars by @jfinkels in https://github.com/uutils/coreutils/pull/7078
* print nodes and cycles as they are visited by @jfinkels in https://github.com/uutils/coreutils/pull/7093

### uniq
* fix multibyte input by @sylvestre in https://github.com/uutils/coreutils/pull/7046

### wc
* fix escaping by @jtracey in https://github.com/uutils/coreutils/pull/6993

### uucore
* Make EscapedChar and friends pub by @LegNeato in https://github.com/uutils/coreutils/pull/6903
* Make `Spec` public by @LegNeato in https://github.com/uutils/coreutils/pull/6946
* uucore/buf_copy: bug fixes for compatibility with uutils core utilities by @DaringCuteSeal in https://github.com/uutils/coreutils/pull/6983
* uucore: add common splice-write functionality by @DaringCuteSeal in https://github.com/uutils/coreutils/pull/6964
* uucore: correctly truncate response if getgroups shrinks by @santtu in https://github.com/uutils/coreutils/pull/6978
* uucore: add alacritty to the list of terminals that support colors by @sylvestre in https://github.com/uutils/coreutils/pull/6923
* uucore/buf-copy: delete redundant functions by @DaringCuteSeal in https://github.com/uutils/coreutils/pull/7060
* quoting_style: Add support for non-UTF-8 bytes by @jtracey in https://github.com/uutils/coreutils/pull/6882
* uucore:format:fix floating-point representation by @alexs-sh in https://github.com/uutils/coreutils/pull/7034
* Remove crash! macro by @saulvaldelvira in https://github.com/uutils/coreutils/pull/7084
* uucore: remove mention of crash in docs by @jfinkels in https://github.com/uutils/coreutils/pull/7109


### Build & CI
* GNUmakefile: remove `sleep` from `UNIX_PROGS` to avoid warning by @cakebaker in https://github.com/uutils/coreutils/pull/6960
* publish: by default, put it as draft by @sylvestre in https://github.com/uutils/coreutils/pull/6860
* Bump MSRV to `1.77` by @cakebaker in https://github.com/uutils/coreutils/pull/6870
* Improve gnu build script by @sylvestre in https://github.com/uutils/coreutils/pull/7136
* GnuComment: zizmor: ignore[dangerous-triggers] by @dcampbell24 in https://github.com/uutils/coreutils/pull/6974
* Android CICD: use posix style test by @jtracey in https://github.com/uutils/coreutils/pull/6982
* GNU: try to remove the fail-2eperm.sh workaround by @sylvestre in https://github.com/uutils/coreutils/pull/7013
* ci: install `libselinux1-dev` by @cakebaker in https://github.com/uutils/coreutils/pull/7132
* Put DEFAULT_BRANCH into an env variable. by @dcampbell24 in https://github.com/uutils/coreutils/pull/6973
* Set persist-credentials: false by @dcampbell24 in https://github.com/uutils/coreutils/pull/6975
* Use the env variable STYLE_FAIL_ON_FAULT. by @dcampbell24 in https://github.com/uutils/coreutils/pull/6976
* GNU: Improve the SKIP reporting by @sylvestre in https://github.com/uutils/coreutils/pull/6988
* GnuTests: also display CURRENT_RUN_SKIP for debug purposes by @sylvestre in https://github.com/uutils/coreutils/pull/6992
* CI: test all features individually by @sylvestre in https://github.com/uutils/coreutils/pull/7038
* CI: disable the windows job for indiv tests by @sylvestre in https://github.com/uutils/coreutils/pull/7047
* deny.toml: remove entries from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/7118
* Refresh cargo.lock and update deny configuration by @sylvestre in https://github.com/uutils/coreutils/pull/7120
* Prepare release 0.0.29 by @sylvestre in https://github.com/uutils/coreutils/pull/7121

### Code quality
* Fix new clippy warnings by @sylvestre in https://github.com/uutils/coreutils/pull/6898
* Use `div_ceil()` from `std` by @cakebaker in https://github.com/uutils/coreutils/pull/6877
* uudoc,chcon: fix `needless_lifetimes` warnings by @cakebaker in https://github.com/uutils/coreutils/pull/6899
* uucore/perms: use ORs instead of `match` (fix todo) by @cakebaker in https://github.com/uutils/coreutils/pull/6891
* clippy: fix clippy warnings by @sylvestre in https://github.com/uutils/coreutils/pull/6910
* Fix clippy warnings by @RenjiSann in https://github.com/uutils/coreutils/pull/6932
* Improve the GNU compat doc by @sylvestre in https://github.com/uutils/coreutils/pull/7012
* clippy: fix errors introduced with Rust `1.84` by @cakebaker in https://github.com/uutils/coreutils/pull/7111

### Documentation
* doc: remove fixed tests from `why-error.md` by @cakebaker in https://github.com/uutils/coreutils/pull/7101
* doc: improve why-error doc  by @sylvestre in https://github.com/uutils/coreutils/pull/7091
* document two more failures by @sylvestre in https://github.com/uutils/coreutils/pull/7041
* Fix: broken doc links by @jovielarue in https://github.com/uutils/coreutils/pull/7024

## Dependencies
* Bump `crossterm` from `0.27.0` to `0.28.1` by @cakebaker in https://github.com/uutils/coreutils/pull/6874
* Bump `thiserror` from `1.0.69` to `2.0.3` by @cakebaker in https://github.com/uutils/coreutils/pull/6888
* Bump `cpp` and `cpp_build` from `0.5.9` to `0.5.10` by @cakebaker in https://github.com/uutils/coreutils/pull/6887
* fuzz: bump `bigdecimal` from `0.4.3` to `0.4.7` by @cakebaker in https://github.com/uutils/coreutils/pull/7148
* Bump `chrono-tz` to `0.10.0` by @cakebaker in https://github.com/uutils/coreutils/pull/7146
* Bump `itertools` from `0.13.0` to `0.14.0` by @cakebaker in https://github.com/uutils/coreutils/pull/7045
* Bump `tempfile` from `3.14.0` to `3.15.0` by @cakebaker in https://github.com/uutils/coreutils/pull/7062
* Bump `unicode-width`, adapt test and fixtures by @cakebaker in https://github.com/uutils/coreutils/pull/6904
* Bump `clap` to `4.5.23` & fix failing `seq` tests by @cakebaker in https://github.com/uutils/coreutils/pull/6955
* Bump `zip` from `1.1.4` to `2.2.2` by @cakebaker in https://github.com/uutils/coreutils/pull/6873
* Cargo.lock: downgrade `log` from `0.4.24` to `0.4.22` by @cakebaker in https://github.com/uutils/coreutils/pull/7131
* fix(deps): update rust crate libc to v0.2.164 by @renovate in https://github.com/uutils/coreutils/pull/6847
* chore(deps): update rust crate serde to v1.0.215 by @renovate in https://github.com/uutils/coreutils/pull/6862
* chore(deps): update davidanson/markdownlint-cli2-action action to v18 by @renovate in https://github.com/uutils/coreutils/pull/6864
* fix(deps): update rust crate libfuzzer-sys to v0.4.8 by @renovate in https://github.com/uutils/coreutils/pull/6863
* fix(deps): update rust crate tempfile to v3.14.0 by @renovate in https://github.com/uutils/coreutils/pull/6866
* chore(deps): update rust crate thiserror to v1.0.69 by @renovate in https://github.com/uutils/coreutils/pull/6843
* chore(deps): update rust crate bstr to v1.11.0 by @renovate in https://github.com/uutils/coreutils/pull/6865
* chore(deps): update rust crate clap_mangen to v0.2.24 by @renovate in https://github.com/uutils/coreutils/pull/6358
* fix(deps): update rust crate proc-macro2 to v1.0.91 by @renovate in https://github.com/uutils/coreutils/pull/6879
* fix(deps): update rust crate proc-macro2 to v1.0.92 by @renovate in https://github.com/uutils/coreutils/pull/6881
* chore(deps): update rust crate fts-sys to v0.2.13 by @renovate in https://github.com/uutils/coreutils/pull/6883
* fix(deps): update rust crate libc to v0.2.165 by @renovate in https://github.com/uutils/coreutils/pull/6889
* fix(deps): update rust crate libc to v0.2.166 by @renovate in https://github.com/uutils/coreutils/pull/6894
* chore(deps): update rust crate blake3 to v1.5.5 by @renovate in https://github.com/uutils/coreutils/pull/6895
* chore(deps): update dawidd6/action-download-artifact action to v7 by @renovate in https://github.com/uutils/coreutils/pull/6900
* fix(deps): update rust crate libc to v0.2.167 by @renovate in https://github.com/uutils/coreutils/pull/6901
* chore(deps): update rust crate terminal_size to v0.4.1 by @renovate in https://github.com/uutils/coreutils/pull/6902
* chore(deps): update rust crate time to v0.3.37 by @renovate in https://github.com/uutils/coreutils/pull/6908
* chore(deps): update rust crate thiserror to v2.0.4 by @renovate in https://github.com/uutils/coreutils/pull/6909
* chore(deps): update rust crate self_cell to v1.1.0 by @renovate in https://github.com/uutils/coreutils/pull/6927
* chore(deps): update rust crate thiserror to v2.0.5 by @renovate in https://github.com/uutils/coreutils/pull/6939
* chore(deps): update rust crate thiserror to v2.0.6 by @renovate in https://github.com/uutils/coreutils/pull/6940
* chore(deps): update rust crate bigdecimal to v0.4.7 by @renovate in https://github.com/uutils/coreutils/pull/6941
* fix(deps): update rust crate libc to v0.2.168 by @renovate in https://github.com/uutils/coreutils/pull/6943
* chore(deps): update rust crate chrono to v0.4.39 by @renovate in https://github.com/uutils/coreutils/pull/6942
* chore(deps): update rust crate serde to v1.0.216 by @renovate in https://github.com/uutils/coreutils/pull/6948
* chore(deps): update rust crate bstr to v1.11.1 by @renovate in https://github.com/uutils/coreutils/pull/6950
* fix(deps): update rust crate lazy_static to v1.5.0 by @renovate in https://github.com/uutils/coreutils/pull/6952
* chore(deps): update mozilla-actions/sccache-action action to v0.0.7 by @renovate in https://github.com/uutils/coreutils/pull/6953
* chore(deps): update rust crate thiserror to v2.0.7 by @renovate in https://github.com/uutils/coreutils/pull/6958
* chore(deps): update rust crate clap_complete to v4.5.38 by @renovate in https://github.com/uutils/coreutils/pull/6361
* fix(deps): update rust crate clap_complete to v4.5.39 by @renovate in https://github.com/uutils/coreutils/pull/6961
* chore(deps): update rust crate clap_complete to v4.5.40 by @renovate in https://github.com/uutils/coreutils/pull/6967
* chore(deps): update rust crate thiserror to v2.0.8 by @renovate in https://github.com/uutils/coreutils/pull/6969
* fix(deps): update rust crate libc to v0.2.169 by @renovate in https://github.com/uutils/coreutils/pull/6977
* chore(deps): update rust crate thiserror to v2.0.9 by @renovate in https://github.com/uutils/coreutils/pull/6986
* chore(deps): update rust crate platform-info to v2.0.5 by @renovate in https://github.com/uutils/coreutils/pull/6991
* chore(deps): update vmactions/freebsd-vm action to v1.1.6 by @renovate in https://github.com/uutils/coreutils/pull/6994
* fix(deps): update rust crate quote to v1.0.38 by @renovate in https://github.com/uutils/coreutils/pull/6999
* chore(deps): update rust crate serde to v1.0.217 by @renovate in https://github.com/uutils/coreutils/pull/7007
* chore(deps): update rust crate glob to v0.3.2 by @renovate in https://github.com/uutils/coreutils/pull/7018
* chore(deps): update vmactions/freebsd-vm action to v1.1.7 by @renovate in https://github.com/uutils/coreutils/pull/7014
* chore(deps): update davidanson/markdownlint-cli2-action action to v19 by @renovate in https://github.com/uutils/coreutils/pull/7019
* chore(deps): update rust crate rstest to 0.24.0 by @renovate in https://github.com/uutils/coreutils/pull/7049
* chore(deps): update rust crate bstr to v1.11.3 by @renovate in https://github.com/uutils/coreutils/pull/7054
* chore(deps): update rust crate xattr to v1.4.0 by @renovate in https://github.com/uutils/coreutils/pull/7081
* chore(deps): update rust crate phf to v0.11.3 by @renovate in https://github.com/uutils/coreutils/pull/7085
* chore(deps): update rust crate phf_codegen to v0.11.3 by @renovate in https://github.com/uutils/coreutils/pull/7083
* chore(deps): update rust crate clap to v4.5.24 by @renovate in https://github.com/uutils/coreutils/pull/7099
* chore(deps): update rust crate clap_complete to v4.5.41 by @renovate in https://github.com/uutils/coreutils/pull/7100
* chore(deps): update rust crate clap_mangen to v0.2.25 by @renovate in https://github.com/uutils/coreutils/pull/7102
* chore(deps): update rust crate thiserror to v2.0.10 by @renovate in https://github.com/uutils/coreutils/pull/7104
* chore(deps): update vmactions/freebsd-vm action to v1.1.8 by @renovate in https://github.com/uutils/coreutils/pull/7105
* chore(deps): update rust crate clap to v4.5.26 by @renovate in https://github.com/uutils/coreutils/pull/7107
* chore(deps): update rust crate clap_complete to v4.5.42 by @renovate in https://github.com/uutils/coreutils/pull/7108
* chore(deps): update rust crate clap_mangen to v0.2.26 by @renovate in https://github.com/uutils/coreutils/pull/7112
* fix(deps): update rust crate proc-macro2 to v1.0.93 by @renovate in https://github.com/uutils/coreutils/pull/7117
* chore(deps): update rust crate thiserror to v2.0.11 by @renovate in https://github.com/uutils/coreutils/pull/7114
* chore(deps): update rust crate notify to v8 by @renovate in https://github.com/uutils/coreutils/pull/7113
* fix(deps): update rust crate data-encoding-macro to v0.1.16 by @renovate in https://github.com/uutils/coreutils/pull/7137
* chore(deps): update rust crate chrono-tz to v0.10.1 by @renovate in https://github.com/uutils/coreutils/pull/7150
* fix(deps): crates import compatible uucore by @Banyc in https://github.com/uutils/coreutils/pull/6869
## New Contributors
* @Banyc made their first contribution in https://github.com/uutils/coreutils/pull/6869
* @jesseschalken made their first contribution in https://github.com/uutils/coreutils/pull/6839
* @steinwand6 made their first contribution in https://github.com/uutils/coreutils/pull/6858
* @LegNeato made their first contribution in https://github.com/uutils/coreutils/pull/6903
* @hamflx made their first contribution in https://github.com/uutils/coreutils/pull/6119
* @andreistan26 made their first contribution in https://github.com/uutils/coreutils/pull/5844
* @nerdroychan made their first contribution in https://github.com/uutils/coreutils/pull/6595
* @artP2 made their first contribution in https://github.com/uutils/coreutils/pull/6928
* @aimerlief made their first contribution in https://github.com/uutils/coreutils/pull/6934
* @alexs-sh made their first contribution in https://github.com/uutils/coreutils/pull/6936
* @santtu made their first contribution in https://github.com/uutils/coreutils/pull/6978
* @karlmcdowall made their first contribution in https://github.com/uutils/coreutils/pull/6957
* @elde-n made their first contribution in https://github.com/uutils/coreutils/pull/7010
* @jovielarue made their first contribution in https://github.com/uutils/coreutils/pull/7008
* @Felle33 made their first contribution in https://github.com/uutils/coreutils/pull/7071
* @rm-dr made their first contribution in https://github.com/uutils/coreutils/pull/6884
* @saulvaldelvira made their first contribution in https://github.com/uutils/coreutils/pull/7084
* @fuad1502 made their first contribution in https://github.com/uutils/coreutils/pull/6951

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.28...0.0.29
