import { OneOf } from '../utility';
type SerializedTLogEntry = {
    logIndex: string;
    logId: {
        keyId: string;
    };
    kindVersion: {
        kind: string;
        version: string;
    } | undefined;
    integratedTime: string;
    inclusionPromise: {
        signedEntryTimestamp: string;
    };
    inclusionProof: {
        logIndex: string;
        rootHash: string;
        treeSize: string;
        hashes: string[];
        checkpoint: {
            envelope: string;
        };
    } | undefined;
    canonicalizedBody: string;
};
type SerializedTimestampVerificationData = {
    rfc3161Timestamps: {
        signedTimestamp: string;
    }[];
};
type SerializedMessageSignature = {
    messageDigest: {
        algorithm: string;
        digest: string;
    } | undefined;
    signature: string;
};
type SerializedDSSEEnvelope = {
    payload: string;
    payloadType: string;
    signatures: {
        sig: string;
        keyid: string;
    }[];
};
export type SerializedBundle = {
    mediaType: string;
    verificationMaterial: (OneOf<{
        x509CertificateChain: {
            certificates: {
                rawBytes: string;
            }[];
        };
        publicKey: {
            hint: string;
        };
    }> | undefined) & {
        tlogEntries: SerializedTLogEntry[];
        timestampVerificationData: SerializedTimestampVerificationData | undefined;
    };
} & OneOf<{
    dsseEnvelope: SerializedDSSEEnvelope;
    messageSignature: SerializedMessageSignature;
}>;
interface SerializedSignature {
    sig: string;
    keyid: string;
}
export type SerializedEnvelope = {
    payload: string;
    payloadType: string;
    signatures: SerializedSignature[];
};
export {};
