/*
 *	lib.h - SAM-FS user library function prototypes.
 *
 *	Definitions for SAM-FS user library function prototypes.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef	_SAM_LIB_H
#define	_SAM_LIB_H

#ifdef sun
#pragma ident "$Revision$"
#endif

#include "sam/types.h"


/*
 * Macros.
 */
#define	STR_FROM_ERRNO_BUF_SIZE 	80
#define	STR_FROM_FSIZE_BUF_SIZE 	12
#define	STR_FROM_INTERVAL_BUF_SIZE 	18
#define	STR_FROM_TIME_BUF_SIZE 		18
#define	STR_FROM_VOLID_BUF_SIZE 	40

/*
 * Macros for WORM retention period calculations
 */
#define	MINS_IN_YEAR 		(365*24*60)
#define	MINS_IN_LYEAR 		(366*24*60)
#define	MINS_IN_DAY  		(24*60)
#define	MINS_IN_HOUR 		(60)

/*
 * SAM file system request functions
 */

#ifdef	_SAM_RESOURCE_H
extern	int	sam_rdrsf(char *, int, sam_resource_file_t *);
#endif

/*
 * SAM command utility functions
 */

extern	char	*device_to_nm(int);
extern	int	nm_to_device(char *);
extern	int	media_to_device(char *);
extern	int 	sam_syscall(int cmd, void *args, int arg_size);


/*
 * Generally useful command utility functions
 */

pid_t 	FindProc(char *name, char *arg);
char	*GetParentName(void);
char	*GetProcName(pid_t pid, char *buf, int buf_size);
int 	sam_lockout(char *name, char *dir, char *prefix, int *siglist);
void	*MapFileAttach(char *fileName, uint_t magic, int mode);
void 	MakeDir(char *dname);
int 	MapFileDetach(void *mf_a);

int 	percent_used(uint capacity, uint space);
int 	llpercent_used(u_longlong_t capacity, u_longlong_t space);
void 	ll2oct(u_longlong_t value, char *dest, int width);
void 	ll2str(u_longlong_t value, char *dest, int width);
u_longlong_t llfrom_oct(int digs, char *where);
u_longlong_t llfrom_str(int digs, char *where);

extern char *time_string(time_t, time_t, char *);
extern char *TimeString(time_t time, char *str, int size);

time_t StrToTime(char *str);

extern int  StrToMinutes(char *args, long *expiration);
extern void MinToStr(time_t chgtime, long num_mins, char *gtime, char *str);
extern int  DateToMinutes(char *args, long *mins);

char	*getuser(uid_t);	/* get user name for uid */
char	*getgroup(gid_t);	/* get group name for gid */

#ifndef	MAIN
extern char *program_name;
#endif

#ifndef	SAM_LIB_GNU		/* Do not define these for GNU code	*/
extern	void	error		(int, int, char *, ...);
extern	char	*stpcpy		(char *, char *);
#endif

extern	int	SAM_fd;		/* File descriptor for .ioctl file	*/

int sam_syscall(int number, void *arg, int size);
char  *sam_mediatoa(int mt);
extern int   sam_atomedia(char *name);
extern void  sam_syslog(int priority, const char *fmt, ...);
extern char *StrFromErrno(int errno_arg, char *buf, int buf_size);
extern char *StrFromFsize(uint64_t size, int prec, char *buf, int buf_size);
extern char *StrFromInterval(int interval, char *buf, int buf_size);
extern int   StrToFsize(char *string, uint64_t *size);
extern int   StrToInterval(char *string, int *interval);

#if defined(_AML_CATALOG_H)
extern int  StrToVolId(char *arg, struct VolId *vid);
extern char *StrFromVolId(struct VolId *vid, char *buf, int buf_size);
#endif /* defined(_AML_CATALOG_H) */

#if defined(_SAM_FS_DIRENT_H)
int sam_getdent(struct sam_dirent ** dirent);
int sam_opendir(char *dir_name);
#endif /* defined(_SAM_FS_DIRENT_H) */

#if defined(_SAMFS_MOUNT_H)
char	*DskToRdsk(char *dsk, char *rdsk);
int	GetFsInfo(char *name, struct sam_fs_info *fi);
int	GetFsInfoDefs(char *name, struct sam_fs_info *fi);
int	GetFsInfoByEq(int eq, struct sam_fs_info *fi);
int	GetFsInfoByPartEq(int eq, struct sam_fs_info *fi);
int	GetFsMount(char *fs_name, struct sam_mount_info *mp);
int	GetFsMountDefs(char *fs_name, struct sam_mount_info *mp);
char	*GetFsMountName(int eq);
int 	GetFsParts(char *name, int maxpts, struct sam_fs_part *pts);
int 	GetFsStatus(struct sam_fs_status **fs);
int 	OpenInodesFile(char *mountPoint);
char	*SetFsParam(char *fsname, char *param, char *value);
char	*SetFsConfig(char *fsname, char *param);
int 	SetFsPartSt(char *fsname, char *eqnum, int32_t state);

char	*StrFromFsStatus(struct sam_fs_info *fi);
#endif /* defined(_SAMFS_MOUNT_H) */

#if defined(_AML_DEVICE_H)
int read_mcf(char *dummy, dev_ent_t **devlist, int *high_eq);
void WriteMcfbin(int DeviceNumof, dev_ent_t *DeviceTable);
#endif /* defined(_AML_DEVICE_H) */

#endif /* _SAM_LIB_H */
