# $Revision$

#    SAM-QFS_notice_begin
#
#      Solaris 2.x Sun Storage & Archiving Management File System
#
#               Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
#
#               U.S. Government Rights - Commercial software. Government users are
#       subject to the Sun Microsystems, Inc. standard license agreement and applicable
#       provisions of the FAR and its supplements.
#
#       Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
#       are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
#       and other countries.
#
#    SAM-QFS_notice_end
#
#
#       LGPL NOTICE
#
#       This library is free software; you can redistribute it and/or
#       modify it under the terms of the GNU Lesser General Public
#       License as published by the Free Software Foundation; either
#       version 2.1 of the License, or (at your option) any later version.
#
#       This library is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#       Lesser General Public License for more details.
#
#       You should have received a copy of the GNU Lesser General Public
#       License along with this library; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#	common.mk - common definitions
#
#	common.mk should be the first inclusion in all Makefiles.

# Default number of parallel jobs allowed
NJOBS = 4

.PHONY:	all

# Default target
all:

ifndef	DEPTH
$(error "DEPTH variable is undefined")
endif

-include $(DEPTH)/mk/include/CONFIG.mk
include $(DEPTH)/mk/include/defaults.mk

SAMQFS_VERSION := 4.6
GUI_VERSION := 3.0

SHELL := /bin/sh
OS := $(shell uname -s)
HOSTNAME := $(shell hostname)

#
#     Unset LD_LIBRARY_PATH.
#
LD_LIBRARY_PATH =

#
#	Include OS, Revision, and architecture dependent definitions
#	for SunOS and Linux.
#
ifeq ($(OS), SunOS)
	include $(DEPTH)/mk/include/sun.mk
else
ifeq ($(OS), Linux)
	include $(DEPTH)/mk/include/linux.mk
else
$(error "Don't know anything about OS $(OS)")
endif
endif

WHOAMI = $(shell $(CMDWHOAMI))

# Installation directories.
BASEDIR := /
DESTDIR := $(BASEDIR)/etc/fs/samfs
USRDEST := $(BASEDIR)/opt/SUNWsamfs/bin
ADMDEST := $(BASEDIR)/opt/SUNWsamfs/sbin
INCDEST := $(BASEDIR)/opt/SUNWsamfs/include
DOCDEST := $(BASEDIR)/opt/SUNWsamfs/doc
EXADEST := $(BASEDIR)/opt/SUNWsamfs/examples
MANDEST := $(BASEDIR)/opt/SUNWsamfs/man
LIBDEST := $(BASEDIR)/opt/SUNWsamfs/lib
RPCDEST := $(BASEDIR)opt/SUNWsamfs/client
TOOLDEST := $(BASEDIR)/opt/SUNWsamfs/tools
JREDEST := $(BASEDIR)/opt/SUNWsamfs/jre
STKDEST := $(BASEDIR)/opt/SUNWsamfs/stk
FSDEST  := $(BASEDIR)/kernel/fs/$(64DIR)
SYSDEST  := $(BASEDIR)/kernel/sys/$(64DIR)
DRVDEST := $(BASEDIR)/kernel/drv/$(64DIR)
JLIBDEST := $(BASEDIR)/opt/SUNWsamfs/lib/java
ECTDEST := $(BASEDIR)/etc/opt/SUNWsamfs
VARDEST := $(BASEDIR)/var/opt/SUNWsamfs


OWNER := $(WHOAMI)
GROUP := sam
SYSMODE := 755
USERMODE := 755
DATAMODE := 644

SYSINST := -m $(SYSMODE) -g $(GROUP) -o $(OWNER)
USERINST := -m $(USERMODE) -g $(GROUP) -o $(OWNER)
DATAINST := -m $(DATAMODE) -g $(GROUP) -o $(OWNER)
MSGINST := -m 444 -g $(GROUP) -o $(OWNER)

#
# Default VPATH
#
VPATH = .

#
#	Destination for generated output
#
OBJ_BASE := obj
ifneq	($(DEBUG), yes)
	OBJ_DIR := $(OBJ_BASE)/$(OS_ARCH)
else
	OBJ_DIR := $(OBJ_BASE)/$(OS_ARCH)_DEBUG
endif

#
# Set additional debug options if needed
#
# "DEBUG = yes | no" may be specified globally
#
# "DEBUG_OFF = yes" may be specified in a make file to
# suppress debug mode for that make file only.
#
ifeq ($(DEBUG), yes)
	ifneq ($(DEBUG_OFF), yes)
		DEBUGCDEFS += -DDEBUG
	endif
endif

DEPCFLAGS += $(DEBUGCDEFS)

#
# Build with SAM_TRACE enabled
#
DEPCFLAGS += -DSAM_TRACE

#
# make depend output file
#
DEPFILE = $(OBJ_DIR)/.depend

#
# CFLAGS defines when using threads
#
THRCOMP = -D_REENTRANT

#
# Default sam-qfs include files
#
INCLUDE = $(DEPTH)/include
#INCLUDE = /opt/SUNWsamfs/include

#
# Final default CFLAGS settings
#
CFLAGS = $(DEPCFLAGS) $(DEBUGCFLAGS) $(PLATFLAGS) $(CERRWARN)
LDFLAGS = $(PLATFLAGS)
ifeq ($(SPARCV9), yes)
LIBSO = $(LIBSO_OPT)/opt/SUNWsamfs/lib/sparcv9 $(LIBSO_OPT)/opt/SUNWsamfs/lib
else
ifeq ($(AMD64), yes)
LIBSO = $(LIBSO_OPT)/opt/SUNWsamfs/lib/amd64 $(LIBSO_OPT)/opt/SUNWsamfs/lib
else
LIBSO = $(LIBSO_OPT)/opt/SUNWsamfs/lib
endif
endif

#
# default lint options
#
LNOPTS = -u -x -Dlint -Nlevel=2
