/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.PropertyManager;
import com.sun.xml.stream.writers.XMLEventWriterImpl;
import com.sun.xml.stream.writers.XMLStreamWriterImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class ZephyrWriterFactory
extends XMLOutputFactory {
    private PropertyManager fPropertyManager = new PropertyManager(2);

    public boolean isPropertySupported(String string) {
        if (string == null) {
            return false;
        }
        return this.fPropertyManager.containsProperty(string);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Property not supported");
        }
        if (this.fPropertyManager.containsProperty(string)) {
            return this.fPropertyManager.getProperty(string);
        }
        throw new IllegalArgumentException("Property not supported");
    }

    public void setProperty(String string, Object object) throws IllegalArgumentException {
        if (string == null || object == null || !this.fPropertyManager.containsProperty(string)) {
            throw new IllegalArgumentException("Property " + string + "is not supported");
        }
        this.fPropertyManager.setProperty(string, object);
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(outputStream));
    }

    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(writer));
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(result));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return new XMLStreamWriterImpl(outputStream, new PropertyManager(this.fPropertyManager));
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return new XMLStreamWriterImpl(writer, new PropertyManager(this.fPropertyManager));
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            if (streamResult.getWriter() != null) {
                return new XMLStreamWriterImpl(streamResult.getWriter(), new PropertyManager(this.fPropertyManager));
            }
            if (streamResult.getOutputStream() != null) {
                return new XMLStreamWriterImpl(streamResult.getOutputStream(), new PropertyManager(this.fPropertyManager));
            }
            if (streamResult.getSystemId() != null) {
                try {
                    FileWriter fileWriter = new FileWriter(new File(streamResult.getSystemId()));
                    return new XMLStreamWriterImpl(fileWriter, new PropertyManager(this.fPropertyManager));
                }
                catch (IOException iOException) {
                    throw new XMLStreamException(iOException);
                }
            }
        } else if (result instanceof Result) {
            try {
                FileWriter fileWriter = new FileWriter(new File(result.getSystemId()));
                return new XMLStreamWriterImpl(fileWriter, new PropertyManager(this.fPropertyManager));
            }
            catch (IOException iOException) {
                throw new XMLStreamException(iOException);
            }
        }
        throw new UnsupportedOperationException();
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(outputStream, string));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) throws XMLStreamException {
        try {
            return new XMLStreamWriterImpl(outputStream, string, new PropertyManager(this.fPropertyManager));
        }
        catch (Exception exception) {
            throw new XMLStreamException(exception);
        }
    }
}

