/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.bugtracking.commons;

import java.awt.Component;
import java.awt.GridBagConstraints;

/**
 *
 * @author Tomas Stupka
 */
public class NoContentPanel extends javax.swing.JPanel {
    private Component progressComponent;

    /** Creates new form NoContentPanel2 */
    public NoContentPanel() {
        initComponents();
    }

    public void setText(String text) {
        label.setText(text);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel2 = new javax.swing.JPanel();
        label = new javax.swing.JLabel();

        setBackground(javax.swing.UIManager.getDefaults().getColor("EditorPane.background"));
        setLayout(new java.awt.GridBagLayout());

        jPanel2.setBackground(javax.swing.UIManager.getDefaults().getColor("EditorPane.background"));
        jPanel2.setLayout(new java.awt.GridBagLayout());

        label.setText(org.openide.util.NbBundle.getMessage(NoContentPanel.class, "NoContentPanel.label.text")); // NOI18N
        jPanel2.add(label, new java.awt.GridBagConstraints());

        add(jPanel2, new java.awt.GridBagConstraints());
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel label;
    // End of variables declaration//GEN-END:variables

    public void setProgressComponent(Component component) {
        if(progressComponent != null) jPanel2.remove(progressComponent);
        if(component != null) {
            this.progressComponent = component;
            GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
            jPanel2.add(component, gridBagConstraints);
        } 
    }

}
