/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.dtoa;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.mozilla.javascript.dtoa.Decimal;
import org.mozilla.javascript.dtoa.DoubleFormatter;

public class DecimalFormatter {
    private static final double MAX_FIXED = 1.0E21;

    public static String toExponential(double v, int fractionDigits) {
        BigDecimal bd;
        assert (Double.isFinite(v));
        if (fractionDigits < 0) {
            return DoubleFormatter.toDecimal(v).toString(Decimal.Mode.TO_EXPONENTIAL);
        }
        boolean negative = Math.signum(v) < 0.0;
        double val = v;
        if (negative) {
            val = Math.abs(v);
        }
        int exponent = (bd = new BigDecimal(val, new MathContext(fractionDigits + 1, RoundingMode.HALF_UP))).scale() >= 0 ? bd.precision() - bd.scale() - 1 : bd.precision() + -bd.scale() - 1;
        return DecimalFormatter.toExponentialString(bd, exponent, fractionDigits, negative);
    }

    public static String toFixed(double v, int fractionDigits) {
        assert (Double.isFinite(v));
        assert (fractionDigits >= 0);
        boolean negative = Math.signum(v) < 0.0;
        double val = v;
        if (negative) {
            val = Math.abs(v);
        }
        if (val >= 1.0E21) {
            return DoubleFormatter.toString(v);
        }
        BigDecimal bd = new BigDecimal(val, MathContext.UNLIMITED);
        if (bd.scale() > fractionDigits) {
            bd = bd.setScale(fractionDigits, RoundingMode.HALF_UP);
        }
        return DecimalFormatter.toFixedString(bd, fractionDigits, negative);
    }

    public static String toPrecision(double v, int precision) {
        int exponent;
        int fractionDigits;
        assert (Double.isFinite(v));
        assert (precision >= 1);
        boolean negative = Math.signum(v) < 0.0;
        double val = negative ? -v : v;
        BigDecimal bd = new BigDecimal(val, new MathContext(precision, RoundingMode.HALF_UP));
        int scale = bd.scale();
        int numDigits = bd.precision();
        if (scale >= 0) {
            fractionDigits = scale >= numDigits ? precision : precision - (numDigits - scale);
            exponent = numDigits - scale - 1;
        } else {
            fractionDigits = 0;
            exponent = numDigits + -scale - 1;
        }
        if (exponent < -6 || exponent >= precision) {
            return DecimalFormatter.toExponentialString(bd, exponent, precision - 1, negative);
        }
        return DecimalFormatter.toFixedString(bd, fractionDigits, negative);
    }

    private static String toFixedString(BigDecimal d, int fractionDigits, boolean negative) {
        int scale = d.scale();
        assert (scale >= 0);
        String digits = d.unscaledValue().toString();
        int numDigits = digits.length();
        if (scale == 0 && fractionDigits == 0) {
            if (negative) {
                return "-" + digits;
            }
            return digits;
        }
        StringBuilder b = new StringBuilder(numDigits * 2 + 3);
        if (negative) {
            b.append('-');
        }
        if (scale >= numDigits) {
            b.append("0.");
            DecimalFormatter.fillZeroes(b, scale - numDigits);
            b.append(digits);
        } else {
            b.append(digits.substring(0, numDigits - scale));
            b.append('.');
            b.append(digits.substring(numDigits - scale));
        }
        DecimalFormatter.fillZeroes(b, fractionDigits - scale);
        return b.toString();
    }

    private static String toExponentialString(BigDecimal d, int exponent, int fractionDigits, boolean negative) {
        String digits = d.unscaledValue().toString();
        int numDigits = digits.length();
        StringBuilder b = new StringBuilder(numDigits + fractionDigits + 7);
        if (negative) {
            b.append('-');
        }
        b.append(digits.charAt(0));
        if (numDigits > 1 || fractionDigits >= 1) {
            b.append('.');
            b.append(digits.substring(1));
            DecimalFormatter.fillZeroes(b, fractionDigits - (numDigits - 1));
        }
        b.append('e');
        if (exponent >= 0) {
            b.append('+');
        }
        b.append(exponent);
        return b.toString();
    }

    private static void fillZeroes(StringBuilder b, int count) {
        for (int i = 0; i < count; ++i) {
            b.append('0');
        }
    }
}

