#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arch-hs
version:              0.4.0.0
visibility:           public
id:                   arch-hs-0.4.0.0-7jPciAvGnIQFsXy86GIQPT
key:                  arch-hs-0.4.0.0-7jPciAvGnIQFsXy86GIQPT
license:              MIT
copyright:            2020 berberman
maintainer:           berberman <1793913507@qq.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  c3d184267e636ec21ec6aac215891f51
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Community
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.OptionReader Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Data.Aeson.Ext Distribution.ArchHs.Internal.NamePresetLoader

import-dirs:          /usr/lib/ghc-8.10.2/site-local/arch-hs-0.4.0.0
library-dirs:         /usr/lib/ghc-8.10.2/site-local/arch-hs-0.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/arch-hs-0.4.0.0
hs-libraries:         HSarch-hs-0.4.0.0-7jPciAvGnIQFsXy86GIQPT
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-8.10.2/site-local/arch-hs-0.4.0.0/include
depends:
    Cabal-3.2.0.0 aeson-1.5.4.1-1IeGMr9U117LwJYrLRVKTY
    algebraic-graphs-0.5-J9kmaMMLs4xJT2tgDWPQlr base-4.14.1.0
    bytestring-0.10.10.0 colourista-0.1.0.0-DnavSMQsXRALUonxX0ENCx
    conduit-1.3.4-4jvOBOzxV1hIVvrhitNicH
    conduit-extra-1.3.5-HfFATvBEagDKm7nPa1b9L3 containers-0.6.2.1
    deepseq-1.4.4.0 directory-1.3.6.0 filepath-1.4.2.1
    hackage-db-2.1.0-B89vQHjAY8OEi7kF5WYuQE
    megaparsec-8.0.0-Jjb3znaodfG7zsLnmDi1na
    microlens-0.4.11.2-9caS3Frz8K54yIHXMtlddL
    microlens-th-0.4.3.6-M0D4zBEXIjEa75KR5Tb4o
    neat-interpolation-0.5.1.2-E4C6NlcGhmx9i21kdnSpew
    optparse-applicative-0.16.1.0-JDPEASK1GJS1Nsq2qjjZCq
    polysemy-1.4.0.0-GYG87NTLhhfFG7WnzgjWLH
    req-3.8.0-18YsiBYyFn7j6N5N7tOot
    split-0.2.3.4-15npQ2h4TqNDaGU8Z2EdgB
    tar-conduit-0.3.2-LvFwx29aDdeGvk8cnTGLy7 template-haskell-2.16.0.0
    text-1.2.3.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

