/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.systemd;

import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.systemd.Libsystemd;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;

public class SystemdPlugin
extends Plugin
implements ClusterPlugin {
    private static final Logger logger = LogManager.getLogger(SystemdPlugin.class);
    private final boolean enabled;
    Scheduler.Cancellable extender;

    final boolean isEnabled() {
        return this.enabled;
    }

    public SystemdPlugin() {
        this(true, Build.CURRENT.type(), System.getenv("ES_SD_NOTIFY"));
    }

    SystemdPlugin(boolean assertIsPackageDistribution, Build.Type buildType, String esSDNotify) {
        boolean isPackageDistribution;
        boolean bl = isPackageDistribution = buildType == Build.Type.DEB || buildType == Build.Type.RPM;
        if (assertIsPackageDistribution) assert (isPackageDistribution) : buildType;
        if (!isPackageDistribution) {
            logger.debug("disabling sd_notify as the build type [{}] is not a package distribution", (Object)buildType);
            this.enabled = false;
            return;
        }
        logger.trace("ES_SD_NOTIFY is set to [{}]", (Object)esSDNotify);
        if (esSDNotify == null) {
            this.enabled = false;
            return;
        }
        if (!Boolean.TRUE.toString().equals(esSDNotify) && !Boolean.FALSE.toString().equals(esSDNotify)) {
            throw new RuntimeException("ES_SD_NOTIFY set to unexpected value [" + esSDNotify + "]");
        }
        this.enabled = Boolean.TRUE.toString().equals(esSDNotify);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver) {
        if (this.enabled) {
            this.extender = threadPool.scheduleWithFixedDelay(() -> {
                int rc = this.sd_notify(0, "EXTEND_TIMEOUT_USEC=30000000");
                if (rc < 0) {
                    logger.warn("extending startup timeout via sd_notify failed with [{}]", (Object)rc);
                }
            }, TimeValue.timeValueSeconds((long)15L), "same");
        }
        return Collections.emptyList();
    }

    int sd_notify(int unset_environment, String state) {
        int rc = Libsystemd.sd_notify(unset_environment, state);
        logger.trace("sd_notify({}, {}) returned [{}]", (Object)unset_environment, (Object)state, (Object)rc);
        return rc;
    }

    public void onNodeStarted() {
        if (!this.enabled) {
            return;
        }
        int rc = this.sd_notify(0, "READY=1");
        if (rc < 0) {
            throw new RuntimeException("sd_notify returned error [" + rc + "]");
        }
        assert (this.extender != null);
        boolean cancelled = this.extender.cancel();
        assert (cancelled);
    }

    public void close() {
        if (!this.enabled) {
            return;
        }
        int rc = this.sd_notify(0, "STOPPING=1");
        if (rc < 0) {
            logger.warn("sd_notify returned error [{}]", (Object)rc);
        }
    }
}

