/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class UpdateMessage
extends ObjectMessage {
    public static final String TAG = "update";
    private final Player destination;

    private UpdateMessage(Player destination) {
        super(TAG);
        this.destination = destination;
    }

    public UpdateMessage(Player destination, FreeColGameObject fcgo) {
        this(destination);
        this.appendChild(fcgo);
    }

    public UpdateMessage(Player destination, List<FreeColGameObject> fcgos) {
        this(destination);
        this.appendChildren(fcgos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this((Player)null);
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        ArrayList fcos = new ArrayList();
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                fcos.add(xr.readFreeColObject(game));
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChildren(fcos);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.UPDATE;
    }

    @Override
    public boolean merge(Message message) {
        if (message instanceof UpdateMessage) {
            UpdateMessage other = (UpdateMessage)message;
            this.appendChildren(other.getChildren());
            return true;
        }
        return false;
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        FreeColXMLWriter.WriteScope ws = null;
        if (this.destination != null) {
            ws = xw.replaceScope(FreeColXMLWriter.WriteScope.toClient(this.destination));
        }
        super.toXML(xw);
        if (this.destination != null) {
            xw.replaceScope(ws);
        }
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        if (freeColClient.isInGame()) {
            this.igc(freeColClient).updateHandler(this.getChildren());
            this.clientGeneric(freeColClient);
        } else {
            this.pgc(freeColClient).updateHandler(this.getChildren());
        }
    }
}

