/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.richtooltip;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.gephi.ui.components.richtooltip.JRichTooltipPanel;

public class RichTooltip {
    protected String title;
    protected Image mainImage;
    protected List<String> descriptionSections;
    protected Image footerImage;
    protected List<String> footerSections;
    private Popup tipWindow;
    private boolean tipShowing = false;

    public RichTooltip() {
    }

    public RichTooltip(String title, String descriptionSection) {
        this.setTitle(title);
        this.addDescriptionSection(descriptionSection);
    }

    public void showTooltip(JComponent component) {
        if (component == null || !component.isShowing()) {
            return;
        }
        this.showTooltip(component, component.getLocationOnScreen());
    }

    public void showTooltip(JComponent component, Point screenLocation) {
        if (component == null || !component.isShowing()) {
            return;
        }
        Point location = new Point();
        GraphicsConfiguration gc = component.getGraphicsConfiguration();
        Rectangle sBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        sBounds.x += screenInsets.left;
        sBounds.y += screenInsets.top;
        sBounds.width -= screenInsets.left + screenInsets.right;
        sBounds.height -= screenInsets.top + screenInsets.bottom;
        this.hideTooltip();
        JRichTooltipPanel tip = new JRichTooltipPanel(this);
        Dimension size = tip.getPreferredSize();
        location.x = screenLocation.x + 10;
        location.y = screenLocation.y - 10;
        if (location.y + size.height > sBounds.y + sBounds.height) {
            location.y = screenLocation.y - size.height;
        }
        if (location.x < sBounds.x) {
            location.x = sBounds.x;
        } else if (location.x - sBounds.x + size.width > sBounds.width) {
            location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.tipWindow = popupFactory.getPopup(component, tip, location.x, location.y);
        this.tipWindow.show();
        this.tipShowing = true;
    }

    public void hideTooltip() {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
        }
    }

    public void addDescriptionSection(String section) {
        if (this.descriptionSections == null) {
            this.descriptionSections = new LinkedList<String>();
        }
        this.descriptionSections.add(section);
    }

    public void addFooterSection(String section) {
        if (this.footerSections == null) {
            this.footerSections = new LinkedList<String>();
        }
        this.footerSections.add(section);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Image getMainImage() {
        return this.mainImage;
    }

    public void setMainImage(Image image) {
        this.mainImage = image;
    }

    public List<String> getDescriptionSections() {
        if (this.descriptionSections == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.descriptionSections);
    }

    public Image getFooterImage() {
        return this.footerImage;
    }

    public void setFooterImage(Image image) {
        this.footerImage = image;
    }

    public List<String> getFooterSections() {
        if (this.footerSections == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.footerSections);
    }
}

