#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 jose
version:              0.8.4
visibility:           public
id:                   jose-0.8.4-GOwlbo2kWHdHSRXBwrp375
key:                  jose-0.8.4-GOwlbo2kWHdHSRXBwrp375
license:              Apache-2.0
copyright:            Copyright (C) 2013-2018  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    Javascript Object Signing and Encryption and JSON Web Token library

description:

    An implementation of the Javascript Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519) formats.

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) are supported (Ed25519 only).

    JWK Thumbprint (RFC 7638) is supported (requires /aeson/ >= 0.10).

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  62d8f775fb0ed3cf48d49a4746a0bcf0
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.Orphans

import-dirs:          /usr/lib/ghc-8.10.5/site-local/jose-0.8.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/jose-0.8.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/jose-0.8.4
hs-libraries:         HSjose-0.8.4-GOwlbo2kWHdHSRXBwrp375
depends:
    QuickCheck-2.14.2-LYkEXWaccd95SoKseYSYTk
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs
    attoparsec-0.14.1-IwUGXYiDhQIB5nUHrI5Wg8 base-4.14.2.0
    base64-bytestring-1.2.0.1-Gn2QlQL7quxDmGBEoLUsKs
    bytestring-0.10.12.0 concise-0.1.0.1-Hm4EYnbIaJp4QlhEPHZHvx
    containers-0.6.4.1 cryptonite-0.29-DOJpzHmGf631cPBYwOScHA
    lens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC
    memory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S
    monad-time-0.3.1.0-35smlGNocUd6H7P1jwmOgV mtl-2.2.2
    network-uri-2.6.4.1-FvgDgWAahTMJnOZjiFXR50
    quickcheck-instances-0.3.25.2-d55WE7pIQIDZ5tlUZLXeH
    safe-0.3.19-DlKvqLTtraZKItu5PR3KBM template-haskell-2.16.0.0
    text-1.2.4.1 time-1.9.3
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    x509-1.7.5-HMu4C5aPvqAHy7ZwXFzct

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

