#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 unicode-data
version:              0.1.0.1
visibility:           public
id:                   unicode-data-0.1.0.1-KW2JuJAmImzG9LJ8aVb71a
key:                  unicode-data-0.1.0.1-KW2JuJAmImzG9LJ8aVb71a
license:              Apache-2.0
copyright:            2020 Composewell Technologies and Contributors
maintainer:           streamly@composewell.com
author:               Composewell Technologies and Contributors
stability:            Experimental
homepage:             http://github.com/composewell/unicode-data
synopsis:             Access Unicode character database
description:
    @unicode-data@ provides Haskell APIs to efficiently access the unicode
    character database. Performance is the primary goal in the design of
    this package.

    The Haskell data structures are generated programmatically from the
    unicode character database (UCD) files.  The latest unicode version
    supported by this library is 13.0.0.

category:             Data,Text,Unicode
abi:                  4f8bb6021756b91ea206931126fd8dde
exposed:              True
exposed-modules:
    Unicode.Char Unicode.Char.Case Unicode.Char.General
    Unicode.Char.Normalization Unicode.Internal.Bits
    Unicode.Internal.Char.DerivedCoreProperties
    Unicode.Internal.Char.PropList
    Unicode.Internal.Char.UnicodeData.CombiningClass
    Unicode.Internal.Char.UnicodeData.Compositions
    Unicode.Internal.Char.UnicodeData.Decomposable
    Unicode.Internal.Char.UnicodeData.DecomposableK
    Unicode.Internal.Char.UnicodeData.Decompositions
    Unicode.Internal.Char.UnicodeData.DecompositionsK
    Unicode.Internal.Char.UnicodeData.DecompositionsK2
    Unicode.Internal.Division

import-dirs:          /usr/lib/ghc-8.10.5/site-local/unicode-data-0.1.0.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/unicode-data-0.1.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/unicode-data-0.1.0.1
hs-libraries:         HSunicode-data-0.1.0.1-KW2JuJAmImzG9LJ8aVb71a
depends:              base-4.14.2.0
haddock-interfaces:
    /usr/share/doc/haskell-unicode-data/html/unicode-data.haddock

haddock-html:         /usr/share/doc/haskell-unicode-data/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

