/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;
import org.openstreetmap.josm.gui.mappaint.BooleanStyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ColorStyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.PropertyStyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.StyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public interface StyleSetting {
    public Object getValue();

    default public StyleSettingGui getStyleSettingGui() {
        throw new UnsupportedOperationException(this.getClass() + " not supported");
    }

    public static class ColorStyleSetting
    extends PropertyStyleSetting<Color> {
        ColorStyleSetting(StyleSource parentStyle, String label, AbstractToStringProperty<Color> property) {
            super(parentStyle, label, Color.class, property);
        }

        @Override
        public StyleSettingGui getStyleSettingGui() {
            return new ColorStyleSettingGui(this);
        }
    }

    public static class BooleanStyleSetting
    extends PropertyStyleSetting<Boolean> {
        BooleanStyleSetting(StyleSource parentStyle, String label, AbstractToStringProperty<Boolean> property) {
            super(parentStyle, label, Boolean.class, property);
        }

        @Override
        public StyleSettingGui getStyleSettingGui() {
            return new BooleanStyleSettingGui(this);
        }
    }

    public static class PropertyStyleSetting<T>
    extends LabeledStyleSetting
    implements StyleSetting {
        private final Class<T> type;
        private final AbstractToStringProperty<T> property;

        PropertyStyleSetting(StyleSource parentStyle, String label, Class<T> type, AbstractToStringProperty<T> property) {
            super(parentStyle, label);
            this.type = type;
            this.property = property;
        }

        public String getKey() {
            return this.property.getKey();
        }

        public T getValue() {
            return this.property.get();
        }

        public void setValue(T value) {
            this.property.put(value);
        }

        public void setStringValue(String value) {
            this.setValue(Cascade.convertTo(value, this.type));
        }

        @Override
        public StyleSettingGui getStyleSettingGui() {
            return new PropertyStyleSettingGui(this);
        }
    }

    public static class StyleSettingGroup
    extends LabeledStyleSetting {
        public final String key;
        public final Icon icon;

        StyleSettingGroup(StyleSource parentStyle, String label, String key, Icon icon) {
            super(parentStyle, label);
            this.key = Objects.requireNonNull(key);
            this.icon = icon;
        }

        public static StyleSettingGroup create(Cascade c, StyleSource parentStyle, String key) {
            String label = c.get("label", null, String.class);
            if (label == null) {
                Logging.warn("property 'label' required for StyleSettingGroup");
                return null;
            }
            Icon icon = Optional.ofNullable(c.get("icon", null, String.class)).map(s -> ImageProvider.get(s, ImageProvider.ImageSizes.MENU)).orElse(null);
            return new StyleSettingGroup(parentStyle, label, key, icon);
        }
    }

    public static abstract class LabeledStyleSetting
    implements Comparable<LabeledStyleSetting> {
        public final StyleSource parentStyle;
        public final String label;

        LabeledStyleSetting(StyleSource parentStyle, String label) {
            this.parentStyle = Objects.requireNonNull(parentStyle);
            this.label = Objects.requireNonNull(label);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.parentStyle);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LabeledStyleSetting other = (LabeledStyleSetting)obj;
            return Objects.equals(this.label, other.label) && Objects.equals(this.parentStyle, other.parentStyle);
        }

        @Override
        public int compareTo(LabeledStyleSetting o) {
            return this.label.compareTo(o.label);
        }
    }
}

