/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.commons.jci.problems.CompilationProblem;

public final class BuilderResultUtils {
    private static final String DEFAULT_SEPARATOR = " ";

    private BuilderResultUtils() {
    }

    public static String getProblemMessage(Object object, String summary) {
        return BuilderResultUtils.getProblemMessage(object, summary, DEFAULT_SEPARATOR);
    }

    public static String getProblemMessage(Object object, String summary, String separator) {
        if (object instanceof CompilationProblem[]) {
            return BuilderResultUtils.fillSummary((CompilationProblem[])object, summary, separator);
        }
        return summary;
    }

    public static StringBuilder appendProblems(Object object, StringBuilder builder) {
        if (object instanceof CompilationProblem[]) {
            CompilationProblem[] problem;
            for (CompilationProblem aProblem : problem = (CompilationProblem[])object) {
                builder.append("\t").append(aProblem).append("\n");
            }
        } else if (object != null) {
            builder.append(object);
        }
        return builder;
    }

    private static String fillSummary(CompilationProblem[] problem, String summary, String separator) {
        StringBuilder builder = new StringBuilder(summary).append(DEFAULT_SEPARATOR).append(problem[0].getMessage());
        for (int i = 1; i < problem.length; ++i) {
            builder.append(separator).append(problem[i].getMessage());
        }
        return builder.toString();
    }
}

