/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.settings.FileAccessPermission;
import org.jboss.aesh.history.InMemoryHistory;
import org.jboss.aesh.util.LoggerUtil;

public class FileHistory
extends InMemoryHistory {
    private final File historyFile;
    private final FileAccessPermission historyFilePermission;
    private final boolean logging;
    private static final Logger LOGGER = LoggerUtil.getLogger(FileHistory.class.getName());

    public FileHistory(File file, int maxSize, boolean logging) throws IOException {
        this(file, maxSize, null, logging);
    }

    public FileHistory(File file, int maxSize, FileAccessPermission historyFilePermission, boolean logging) throws IOException {
        super(maxSize);
        this.logging = logging;
        this.historyFile = file;
        this.historyFilePermission = historyFilePermission;
        this.readFile();
    }

    private void readFile() throws IOException {
        if (this.historyFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.historyFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.push(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private void writeFile() throws IOException {
        this.historyFile.delete();
        try (FileWriter fw = new FileWriter(this.historyFile);){
            for (int i = 0; i < this.size(); ++i) {
                fw.write(this.get(i) + Config.getLineSeparator());
            }
        }
        if (this.historyFilePermission != null) {
            this.historyFile.setReadable(false, false);
            this.historyFile.setReadable(this.historyFilePermission.isReadable(), this.historyFilePermission.isReadableOwnerOnly());
            this.historyFile.setWritable(false, false);
            this.historyFile.setWritable(this.historyFilePermission.isWritable(), this.historyFilePermission.isWritableOwnerOnly());
            this.historyFile.setExecutable(false, false);
            this.historyFile.setExecutable(this.historyFilePermission.isExecutable(), this.historyFilePermission.isExecutableOwnerOnly());
        }
    }

    @Override
    public void stop() {
        block2: {
            try {
                this.writeFile();
            }
            catch (IOException e) {
                if (!this.logging) break block2;
                LOGGER.log(Level.WARNING, "Failed when trying to write history file", e);
            }
        }
    }
}

