/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.diff.DiffOperation;

final class Diff {
    DiffOperation operation;
    JsonPointer path;
    JsonPointer arrayPath;
    int firstArrayIndex;
    int secondArrayIndex;
    final JsonNode value;
    JsonPointer fromPath;
    Diff pairedDiff;
    boolean firstOfPair;

    Diff(DiffOperation operation, JsonPointer path, JsonNode value) {
        this.operation = operation;
        this.path = path;
        this.value = value;
    }

    Diff(DiffOperation operation, JsonPointer arrayPath, int firstArrayIndex, int secondArrayIndex, JsonNode value) {
        this.operation = operation;
        this.arrayPath = arrayPath;
        this.firstArrayIndex = firstArrayIndex;
        this.secondArrayIndex = secondArrayIndex;
        this.value = value;
    }

    JsonNode asJsonPatch() {
        JsonPointer ptr = this.arrayPath != null ? this.getSecondArrayPath() : this.path;
        ObjectNode patch = this.operation.newOp(ptr);
        if (this.operation == DiffOperation.REMOVE) {
            return patch;
        }
        if (this.operation == DiffOperation.MOVE || this.operation == DiffOperation.COPY) {
            patch.put("from", this.fromPath.toString());
        } else {
            patch.put("value", this.value);
        }
        return patch;
    }

    JsonPointer getFirstArrayPath() {
        return this.arrayPath.append(this.firstArrayIndex);
    }

    JsonPointer getSecondArrayPath() {
        if (this.secondArrayIndex != -1) {
            return this.arrayPath.append(this.secondArrayIndex);
        }
        return this.arrayPath.append("-");
    }

    public String toString() {
        return this.asJsonPatch().toString();
    }
}

