/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.credential;

import java.io.IOException;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.credential.dto.WebAuthnCredentialData;
import org.keycloak.models.credential.dto.WebAuthnSecretData;
import org.keycloak.util.JsonSerialization;

public class WebAuthnCredentialModel
extends CredentialModel {
    public static final String TYPE = "webauthn";
    private final WebAuthnCredentialData credentialData;
    private final WebAuthnSecretData secretData;

    private WebAuthnCredentialModel(WebAuthnCredentialData credentialData, WebAuthnSecretData secretData) {
        this.credentialData = credentialData;
        this.secretData = secretData;
    }

    public static WebAuthnCredentialModel create(String userLabel, String aaguid, String credentialId, String attestationStatement, String credentialPublicKey, long counter) {
        WebAuthnCredentialData credentialData = new WebAuthnCredentialData(aaguid, credentialId, counter, attestationStatement, credentialPublicKey);
        WebAuthnSecretData secretData = new WebAuthnSecretData();
        WebAuthnCredentialModel credentialModel = new WebAuthnCredentialModel(credentialData, secretData);
        credentialModel.fillCredentialModelFields();
        credentialModel.setUserLabel(userLabel);
        return credentialModel;
    }

    public static WebAuthnCredentialModel createFromCredentialModel(CredentialModel credentialModel) {
        try {
            WebAuthnCredentialData credentialData = (WebAuthnCredentialData)JsonSerialization.readValue((String)credentialModel.getCredentialData(), WebAuthnCredentialData.class);
            WebAuthnSecretData secretData = (WebAuthnSecretData)JsonSerialization.readValue((String)credentialModel.getSecretData(), WebAuthnSecretData.class);
            WebAuthnCredentialModel webAuthnCredentialModel = new WebAuthnCredentialModel(credentialData, secretData);
            webAuthnCredentialModel.setUserLabel(credentialModel.getUserLabel());
            webAuthnCredentialModel.setCreatedDate(credentialModel.getCreatedDate());
            webAuthnCredentialModel.setType(TYPE);
            webAuthnCredentialModel.setId(credentialModel.getId());
            webAuthnCredentialModel.setSecretData(credentialModel.getSecretData());
            webAuthnCredentialModel.setCredentialData(credentialModel.getCredentialData());
            return webAuthnCredentialModel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateCounter(long counter) {
        this.credentialData.setCounter(counter);
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString((Object)this.credentialData));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WebAuthnCredentialData getWebAuthnCredentialData() {
        return this.credentialData;
    }

    public WebAuthnSecretData getWebAuthnSecretData() {
        return this.secretData;
    }

    private void fillCredentialModelFields() {
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString((Object)this.credentialData));
            this.setSecretData(JsonSerialization.writeValueAsString((Object)this.secretData));
            this.setType(TYPE);
            this.setCreatedDate(Time.currentTimeMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "WebAuthnCredentialModel { " + this.credentialData + ", " + this.secretData + " }";
    }
}

