/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye.deployment;

import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.microprofile.config.smallrye.ServiceNames;

public class SubsystemDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<Config> CONFIG = AttachmentKey.create(Config.class);
    public static final AttachmentKey<ConfigProviderResolver> CONFIG_PROVIDER_RESOLVER = AttachmentKey.create(ConfigProviderResolver.class);

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        builder.forClassLoader((ClassLoader)module.getClassLoader()).addDefaultSources().addDiscoveredSources().addDiscoveredConverters();
        this.addConfigSourcesFromServices((ConfigBuilder)builder, phaseContext.getServiceRegistry(), (ClassLoader)module.getClassLoader());
        Config config = builder.build();
        deploymentUnit.putAttachment(CONFIG, (Object)config);
        ConfigProviderResolver configProviderResolver = (ConfigProviderResolver)deploymentUnit.getAttachment(CONFIG_PROVIDER_RESOLVER);
        configProviderResolver.registerConfig(config, (ClassLoader)module.getClassLoader());
    }

    private void addConfigSourcesFromServices(ConfigBuilder builder, ServiceRegistry serviceRegistry, ClassLoader classloader) {
        List serviceNames = serviceRegistry.getServiceNames();
        for (ServiceName serviceName : serviceNames) {
            ServiceController service;
            if (ServiceNames.CONFIG_SOURCE.isParentOf(serviceName)) {
                service = serviceRegistry.getService(serviceName);
                ConfigSource configSource = (ConfigSource)ConfigSource.class.cast(service.getValue());
                builder.withSources(new ConfigSource[]{configSource});
                continue;
            }
            if (!ServiceNames.CONFIG_SOURCE_PROVIDER.isParentOf(serviceName)) continue;
            service = serviceRegistry.getService(serviceName);
            ConfigSourceProvider configSourceProvider = (ConfigSourceProvider)ConfigSourceProvider.class.cast(service.getValue());
            for (ConfigSource configSource : configSourceProvider.getConfigSources(classloader)) {
                builder.withSources(new ConfigSource[]{configSource});
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
        Config config = (Config)context.getAttachment(CONFIG);
        ConfigProviderResolver configProviderResolver = (ConfigProviderResolver)context.getAttachment(CONFIG_PROVIDER_RESOLVER);
        configProviderResolver.releaseConfig(config);
    }
}

