/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class AuthenticatedClientSessionStore {
    private final ConcurrentHashMap<String, UUID> authenticatedClientSessionIds;

    public AuthenticatedClientSessionStore() {
        this.authenticatedClientSessionIds = new ConcurrentHashMap();
    }

    private AuthenticatedClientSessionStore(ConcurrentHashMap<String, UUID> authenticatedClientSessionIds) {
        this.authenticatedClientSessionIds = authenticatedClientSessionIds;
    }

    public void clear() {
        this.authenticatedClientSessionIds.clear();
    }

    public boolean containsKey(String key) {
        return this.authenticatedClientSessionIds.containsKey(key);
    }

    public void forEach(BiConsumer<? super String, ? super UUID> action) {
        this.authenticatedClientSessionIds.forEach(action);
    }

    public UUID get(String key) {
        return this.authenticatedClientSessionIds.get(key);
    }

    public Set<String> keySet() {
        return this.authenticatedClientSessionIds.keySet();
    }

    public UUID put(String key, UUID value) {
        return this.authenticatedClientSessionIds.put(key, value);
    }

    public UUID remove(String clientUUID) {
        return this.authenticatedClientSessionIds.remove(clientUUID);
    }

    public int size() {
        return this.authenticatedClientSessionIds.size();
    }

    public String toString() {
        return this.authenticatedClientSessionIds.toString();
    }

    public static class ExternalizerImpl
    implements Externalizer<AuthenticatedClientSessionStore> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, AuthenticatedClientSessionStore obj) throws IOException {
            output.writeByte(1);
            KeycloakMarshallUtil.writeMap(obj.authenticatedClientSessionIds, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.UUID_EXT, output);
        }

        public AuthenticatedClientSessionStore readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public AuthenticatedClientSessionStore readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            AuthenticatedClientSessionStore res = new AuthenticatedClientSessionStore((ConcurrentHashMap)KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.UUID_EXT, ConcurrentHashMap::new));
            return res;
        }
    }
}

