/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.drools;

import java.util.concurrent.TimeUnit;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

class DroolsPolicy {
    private static final int SESSION_POOL_SIZE = 10;
    private final KieContainer kc;
    private final KieScanner kcs;
    private final String sessionName;

    DroolsPolicy(KieServices ks, Policy associatedPolicy) {
        String groupId = (String)associatedPolicy.getConfig().get("mavenArtifactGroupId");
        String artifactId = (String)associatedPolicy.getConfig().get("mavenArtifactId");
        String version = (String)associatedPolicy.getConfig().get("mavenArtifactVersion");
        String scannerPeriod = (String)associatedPolicy.getConfig().get("scannerPeriod");
        String scannerPeriodUnit = (String)associatedPolicy.getConfig().get("scannerPeriodUnit");
        this.sessionName = (String)associatedPolicy.getConfig().get("sessionName");
        this.kc = ks.newKieContainer(ks.newReleaseId(groupId, artifactId, version));
        this.kcs = ks.newKieScanner(this.kc);
        this.kcs.start(this.toMillis(scannerPeriod, scannerPeriodUnit));
        KieSession session = this.kc.newKieSession(this.sessionName);
        if (session == null) {
            throw new RuntimeException("Could not obtain session with name [" + this.sessionName + "].");
        }
        session.dispose();
    }

    void evaluate(Evaluation evaluation) {
        KieSession session = this.kc.newKieSession(this.sessionName);
        session.insert((Object)evaluation);
        session.fireAllRules();
        session.dispose();
    }

    void dispose() {
        this.kcs.stop();
    }

    private long toMillis(String scannerPeriod, String scannerPeriodUnit) {
        switch (scannerPeriodUnit) {
            case "Seconds": {
                return TimeUnit.SECONDS.toMillis(Integer.valueOf(scannerPeriod).intValue());
            }
            case "Minutes": {
                return TimeUnit.MINUTES.toMillis(Integer.valueOf(scannerPeriod).intValue());
            }
            case "Hours": {
                return TimeUnit.HOURS.toMillis(Integer.valueOf(scannerPeriod).intValue());
            }
            case "Days": {
                return TimeUnit.DAYS.toMillis(Integer.valueOf(scannerPeriod).intValue());
            }
        }
        throw new RuntimeException("Invalid time period [" + scannerPeriodUnit + "].");
    }
}

