/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.RealmModel;

public class AuthenticatorUtil {
    public static List<AuthenticationExecutionModel> getEnabledExecutionsRecursively(RealmModel realm, String flowId) {
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        AuthenticatorUtil.recurseExecutions(realm, flowId, executions);
        return executions;
    }

    public static void recurseExecutions(RealmModel realm, String flowId, List<AuthenticationExecutionModel> executions) {
        List authenticationExecutions = realm.getAuthenticationExecutions(flowId);
        if (authenticationExecutions == null) {
            return;
        }
        for (AuthenticationExecutionModel model : authenticationExecutions) {
            executions.add(model);
            if (!model.isAuthenticatorFlow() || !model.isEnabled()) continue;
            AuthenticatorUtil.recurseExecutions(realm, model.getFlowId(), executions);
        }
    }

    public static AuthenticationExecutionModel findExecutionByAuthenticator(RealmModel realm, String flowId, String authProviderId) {
        for (AuthenticationExecutionModel model : realm.getAuthenticationExecutions(flowId)) {
            AuthenticationExecutionModel recurse;
            if (model.isAuthenticatorFlow() && (recurse = AuthenticatorUtil.findExecutionByAuthenticator(realm, model.getFlowId(), authProviderId)) != null) {
                return recurse;
            }
            if (!model.getAuthenticator().equals(authProviderId)) continue;
            return model;
        }
        return null;
    }

    public static boolean isEnabled(RealmModel realm, String flowId, String authProviderId) {
        AuthenticationExecutionModel execution = AuthenticatorUtil.findExecutionByAuthenticator(realm, flowId, authProviderId);
        if (execution == null) {
            return false;
        }
        return execution.isEnabled();
    }

    public static boolean isRequired(RealmModel realm, String flowId, String authProviderId) {
        AuthenticationExecutionModel execution = AuthenticatorUtil.findExecutionByAuthenticator(realm, flowId, authProviderId);
        if (execution == null) {
            return false;
        }
        return execution.isRequired();
    }
}

