/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.challenge;

import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.authenticators.challenge.BasicAuthAuthenticator;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;

public class BasicAuthOTPAuthenticator
extends BasicAuthAuthenticator
implements Authenticator,
CredentialValidator<OTPCredentialProvider> {
    @Override
    protected boolean onAuthenticate(AuthenticationFlowContext context, String[] challenge) {
        String otp;
        String username = challenge[0];
        String password = challenge[1];
        OTPPolicy otpPolicy = context.getRealm().getOTPPolicy();
        int otpLength = otpPolicy.getDigits();
        if (password.length() < otpLength) {
            return false;
        }
        return this.checkUsernameAndPassword(context, username, password = password.substring(0, password.length() - otpLength)) && this.checkOtp(context, otp = challenge[1].substring(password.length(), challenge[1].length()));
    }

    private boolean checkOtp(AuthenticationFlowContext context, String otp) {
        OTPCredentialModel preferredCredential = (OTPCredentialModel)this.getCredentialProvider(context.getSession()).getDefaultCredential(context.getSession(), context.getRealm(), context.getUser());
        boolean valid = this.getCredentialProvider(context.getSession()).isValid(context.getRealm(), context.getUser(), (CredentialInput)new UserCredentialModel(preferredCredential.getId(), this.getCredentialProvider(context.getSession()).getType(), otp));
        if (!valid) {
            context.getEvent().user(context.getUser()).error("invalid_user_credentials");
            if (context.getExecution().isRequired()) {
                Response challengeResponse = this.challenge(context, "invalidTotpMessage");
                context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challengeResponse);
            } else {
                context.attempted();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return this.getCredentialProvider(session).isConfiguredFor(realm, user);
    }

    public OTPCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (OTPCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
    }
}

