/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.ErrorResponseException;

public class AuthorizeClientUtil {
    private static final Logger logger = Logger.getLogger(AuthorizeClientUtil.class);

    public static ClientAuthResult authorizeClient(KeycloakSession session, EventBuilder event) {
        AuthenticationProcessor processor = AuthorizeClientUtil.getAuthenticationProcessor(session, event);
        Response response = processor.authenticateClient();
        if (response != null) {
            throw new WebApplicationException(response);
        }
        ClientModel client = processor.getClient();
        if (client == null) {
            throw new ErrorResponseException("invalid_client", "Client authentication ended, but client is null", Response.Status.BAD_REQUEST);
        }
        String protocol = client.getProtocol();
        if (protocol == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)client.getClientId());
            protocol = "openid-connect";
        }
        if (!protocol.equals("openid-connect")) {
            event.error("invalid_client");
            throw new ErrorResponseException("invalid_client", "Wrong client protocol.", Response.Status.BAD_REQUEST);
        }
        session.getContext().setClient(client);
        return new ClientAuthResult(client, processor.getClientAuthAttributes());
    }

    public static AuthenticationProcessor getAuthenticationProcessor(KeycloakSession session, EventBuilder event) {
        RealmModel realm = session.getContext().getRealm();
        AuthenticationFlowModel clientAuthFlow = realm.getClientAuthenticationFlow();
        String flowId = clientAuthFlow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setFlowId(flowId).setConnection(session.getContext().getConnection()).setEventBuilder(event).setRealm(realm).setSession(session).setUriInfo((UriInfo)session.getContext().getUri()).setRequest((HttpRequest)session.getContext().getContextObject(HttpRequest.class));
        return processor;
    }

    public static ClientAuthenticatorFactory findClientAuthenticatorForOIDCAuthMethod(KeycloakSession session, String oidcAuthMethod) {
        List providerFactories = session.getKeycloakSessionFactory().getProviderFactories(ClientAuthenticator.class);
        for (ProviderFactory factory : providerFactories) {
            ClientAuthenticatorFactory clientAuthFactory = (ClientAuthenticatorFactory)factory;
            if (!clientAuthFactory.getProtocolAuthenticatorMethods("openid-connect").contains(oidcAuthMethod)) continue;
            return clientAuthFactory;
        }
        return null;
    }

    public static class ClientAuthResult {
        private final ClientModel client;
        private final Map<String, String> clientAuthAttributes;

        private ClientAuthResult(ClientModel client, Map<String, String> clientAuthAttributes) {
            this.client = client;
            this.clientAuthAttributes = clientAuthAttributes;
        }

        public ClientModel getClient() {
            return this.client;
        }

        public Map<String, String> getClientAuthAttributes() {
            return this.clientAuthAttributes;
        }
    }
}

