/*
 * This file is part of the libopencm3 project.
 *
 * Copyright (C) 2015 Felix Held <felix-libopencm3@felixheld.de>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LIBOPENCM3_PERIPH_H
#define LIBOPENCM3_PERIPH_H

/* --- Peripheral Identifiers ---------------------------------------------- */
#define PERIPH_SUPC		0
#define PERIPH_RSTC		1
#define PERIPH_RTC		2
#define PERIPH_RTT		3
#define PERIPH_WDG		4
#define PERIPH_PMC		5
#define PERIPH_EEFC		6
#define PERIPH_UART0		8
#define PERIPH_UART1		9
#define PERIPH_PIOA		11
#define PERIPH_PIOB		12
#define PERIPH_PIOC		13
#define PERIPH_USART0		14
#define PERIPH_USART1		15
#define PERIPH_TWI0		19
#define PERIPH_TWI1		20
#define PERIPH_SPI		21
#define PERIPH_TC0		23
#define PERIPH_TC1		24
#define PERIPH_TC2		25
#define PERIPH_TC3		26
#define PERIPH_TC4		27
#define PERIPH_TC5		28
#define PERIPH_ADC		29
#define PERIPH_DACC		30
#define PERIPH_PWM		31


#endif
