/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XTextListener;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.logging.XLogger;
import com.sun.star.logging.XLoggerPool;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.InvalidQueryException;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.DatabaseObjectWizard;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.db.SQLQueryComposer;
import com.sun.star.wizards.report.Dataimport;
import com.sun.star.wizards.report.GroupFieldHandler;
import com.sun.star.wizards.report.IReportDocument;
import com.sun.star.wizards.report.ReportFinalizer;
import com.sun.star.wizards.report.ReportLayouter;
import com.sun.star.wizards.report.ReportTextImplementation;
import com.sun.star.wizards.ui.CommandFieldSelection;
import com.sun.star.wizards.ui.SortingComponent;
import com.sun.star.wizards.ui.TitlesComponent;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.XFieldSelectionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class ReportWizard
extends DatabaseObjectWizard
implements XTextListener {
    private SortingComponent CurSortingComponent;
    private TitlesComponent CurTitlesComponent;
    private CommandFieldSelection CurDBCommandFieldSelection;
    private GroupFieldHandler CurGroupFieldHandler;
    private ReportLayouter CurReportLayouter;
    private ReportFinalizer CurReportFinalizer;
    private int nReportMode = 1;
    private String m_sReportName = PropertyNames.EMPTY_STRING;
    protected static final String SOREPORTFORMNAME = "ReportSource";
    private static final int SOMAINPAGE = 1;
    private static final int SOTITLEPAGE = 2;
    protected static final int SOGROUPPAGE = 3;
    private static final int SOSORTPAGE = 4;
    protected static final int SOTEMPLATEPAGE = 5;
    protected static final int SOSTOREPAGE = 6;
    private IReportDocument m_reportDocument;
    private static String sMsgWizardName;
    private static String slblFields;
    private static String slblSelFields;
    private static String sShowBinaryFields;
    private String[] WizardHeaderText = new String[6];
    private static String slblColumnTitles;
    private static String slblColumnNames;
    private static String slblTables;
    protected static boolean bCloseDocument;
    private boolean bHasEscapeProcessing = true;
    private static XLogger m_xLogger;

    public ReportWizard(XMultiServiceFactory i_serviceFactory, PropertyValue[] i_wizardContext) {
        super(i_serviceFactory, 34320, i_wizardContext);
        super.addResourceHandler();
        if (this.getReportResources(false)) {
            Helper.setUnoPropertyValues(this.xDialogModel, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_MOVEABLE, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_TITLE, PropertyNames.PROPERTY_WIDTH}, new Object[]{210, Boolean.TRUE, "DialogReport", 102, 41, 1, (short)0, sMsgWizardName, 310});
            this.drawNaviBar();
            this.setRightPaneHeaders(this.WizardHeaderText);
        }
    }

    @Override
    protected void enterStep(int nOldStep, int nNewStep) {
        if (nOldStep >= 5 && nNewStep < 5) {
            this.m_reportDocument.removeTextTableAndTextSection();
        }
        switch (nNewStep) {
            case 1: {
                this.CurDBCommandFieldSelection.setModified(false);
                break;
            }
            case 2: {
                String[] aFieldNames = this.m_reportDocument.getRecordParser().getFieldNames();
                Map<String, String> aFieldTitleSet = this.m_reportDocument.getRecordParser().getFieldTitleSet();
                this.CurTitlesComponent.initialize(aFieldNames, aFieldTitleSet);
                break;
            }
            case 3: {
                this.CurGroupFieldHandler.initialize();
                break;
            }
            case 4: {
                String[] aFieldNames2 = this.m_reportDocument.getRecordParser().getFieldNames();
                String[][] aSortFieldNames = this.m_reportDocument.getRecordParser().getSortFieldNames();
                this.CurSortingComponent.initialize(aFieldNames2, aSortFieldNames);
                int nLength = this.m_reportDocument.getRecordParser().GroupFieldNames.length;
                this.CurSortingComponent.setReadOnlyUntil(nLength);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.CurReportFinalizer.initialize(this.m_reportDocument.getRecordParser());
                break;
            }
        }
    }

    @Override
    protected void leaveStep(int nOldStep, int nNewStep) {
        switch (nOldStep) {
            case 1: {
                String[] aSelectedFieldNames = this.CurDBCommandFieldSelection.getSelectedFieldNames();
                String aTableName = this.CurDBCommandFieldSelection.getSelectedCommandName();
                int nType = this.CurDBCommandFieldSelection.getSelectedCommandType();
                this.m_reportDocument.initializeFieldColumns(nType, aTableName, aSelectedFieldNames);
                if (!this.CurDBCommandFieldSelection.isModified()) break;
                this.m_reportDocument.clearDocument();
                this.m_reportDocument.getRecordParser().setGroupFieldNames(new String[0]);
                this.CurGroupFieldHandler.removeGroupFieldNames();
                break;
            }
            case 2: {
                String[] sFieldTitles = this.CurTitlesComponent.getFieldTitles();
                this.m_reportDocument.setFieldTitles(sFieldTitles);
                break;
            }
            case 3: {
                this.CurGroupFieldHandler.getGroupFieldNames(this.m_reportDocument.getRecordParser());
                String[] aGroupFieldNames = this.m_reportDocument.getRecordParser().GroupFieldNames;
                this.m_reportDocument.setGrouping(aGroupFieldNames);
                break;
            }
            case 4: {
                String[][] aSortFieldNames = this.CurSortingComponent.getSortFieldNames();
                this.m_reportDocument.setSorting(aSortFieldNames);
                super.enablefromStep(5, true);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
        if (nOldStep < 5 && super.getNewStep() >= 5) {
            this.m_reportDocument.getRecordParser().createRecordFieldNames();
            this.CurReportLayouter.initialize(this.m_reportDocument.getContentPath());
        }
    }

    private void dialogFinish() {
        this.xComponent.dispose();
        if (bCloseDocument) {
            this.m_reportDocument.dispose();
            return;
        }
        if (this.nReportMode == 2 || this.nReportMode == 3) {
            this.m_reportDocument.addReportToDBView();
            boolean bOpenInDesign = this.nReportMode == 2;
            this.m_reportDocument.createAndOpenReportDocument(this.m_sReportName, true, bOpenInDesign);
        } else {
            this.m_reportDocument.importReportData(this);
            this.m_reportDocument.createAndOpenReportDocument(this.m_sReportName, false, false);
        }
    }

    private boolean executeQuery() {
        boolean bQueryCreated = false;
        RecordParser recordParser = this.m_reportDocument.getRecordParser();
        SQLQueryComposer sqlQueryComposer = recordParser.getSQLQueryComposer();
        if (this.CurDBCommandFieldSelection.getSelectedCommandType() == 0) {
            if (this.m_reportDocument instanceof ReportTextImplementation) {
                bQueryCreated = sqlQueryComposer.setQueryCommand(this.xWindow, false, false);
                this.m_reportDocument.setCommandType(2);
                String sQuery = sqlQueryComposer.getQuery();
                this.m_reportDocument.setCommand(sQuery);
            } else {
                bQueryCreated = true;
            }
        } else {
            try {
                String sQueryName = this.CurDBCommandFieldSelection.getSelectedCommandName();
                DBMetaData.CommandObject oCommand = recordParser.getQueryByName(sQueryName);
                this.bHasEscapeProcessing = recordParser.hasEscapeProcessing(oCommand.getPropertySet());
                String sCommand = (String)oCommand.getPropertySet().getPropertyValue(PropertyNames.COMMAND);
                if (this.bHasEscapeProcessing) {
                    if (this.m_reportDocument instanceof ReportTextImplementation) {
                        sqlQueryComposer.m_xQueryAnalyzer.setQuery(sCommand);
                        sqlQueryComposer.prependSortingCriteria();
                        this.m_reportDocument.setCommandType(2);
                        this.m_reportDocument.setCommand(sqlQueryComposer.getQuery());
                    }
                } else {
                    this.m_reportDocument.setCommandType(2);
                    this.m_reportDocument.setCommand(sCommand);
                }
                bQueryCreated = true;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (!bQueryCreated) {
            super.vetoableChange(null);
        }
        return bQueryCreated;
    }

    private void buildSteps() {
        this.CurDBCommandFieldSelection = new CommandFieldSelection(this, this.m_reportDocument.getRecordParser(), 100, slblFields, slblSelFields, slblTables, true, 34330);
        this.CurDBCommandFieldSelection.addFieldSelectionListener(new FieldSelectionListener());
        if (!this.isReportBuilderInstalled()) {
            this.insertLabel("lblBinaryFields", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{16, sShowBinaryFields, 95, 162, 1, 210});
        }
        this.CurTitlesComponent = new TitlesComponent(this, 2, 97, 37, 210, 7, slblColumnNames, slblColumnTitles, 34381);
        this.CurTitlesComponent.addTextListener(this);
        this.CurGroupFieldHandler = new GroupFieldHandler(this.m_reportDocument, this);
        this.CurSortingComponent = new SortingComponent(this, 4, 95, 30, 210, 34348);
        this.CurReportLayouter = new ReportLayouter(this.xMSF, this.m_reportDocument, this, this.isReportBuilderInstalled());
        this.CurReportFinalizer = new ReportFinalizer(this.m_reportDocument, this);
        bCloseDocument = true;
        this.enableNavigationButtons(false, false, false);
    }

    @Override
    public boolean finishWizard() {
        int ncurStep = this.getCurrentStep();
        if ((this.switchToStep(ncurStep, 6) || ncurStep == 6) && this.executeQuery() && this.CurReportFinalizer.finish()) {
            this.nReportMode = this.CurReportFinalizer.getReportOpenMode();
            this.m_sReportName = this.CurReportFinalizer.getStoreName();
            this.xDialog.endExecute();
            return true;
        }
        return false;
    }

    @Override
    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    private void insertQueryRelatedSteps() {
        this.setRMItemLabels(this.m_oResource);
        this.addRoadmap();
        int i = 0;
        i = this.insertRoadmapItem(0, true, this.m_oResource.getResText("RID_QUERY_80"), 1);
        i = this.insertRoadmapItem(i, false, this.m_oResource.getResText("RID_REPORT_68"), 2);
        i = this.insertRoadmapItem(i, false, this.m_oResource.getResText("RID_REPORT_11"), 3);
        i = this.insertRoadmapItem(i, false, this.m_oResource.getResText("RID_REPORT_12"), 4);
        i = this.insertRoadmapItem(i, false, this.m_oResource.getResText("RID_REPORT_13"), 5);
        i = this.insertRoadmapItem(i, false, this.m_oResource.getResText("RID_REPORT_14"), 6);
        this.setRoadmapInteractive(true);
        this.setRoadmapComplete(true);
        this.setCurrentRoadmapItemID((short)1);
    }

    private boolean isReportBuilderInstalled() {
        XContentEnumerationAccess a = (XContentEnumerationAccess)UnoRuntime.queryInterface(XContentEnumerationAccess.class, (Object)this.xMSF);
        XEnumeration e = a.createContentEnumeration("org.libreoffice.report.pentaho.SOReportJobFactory");
        if (e == null) {
            return false;
        }
        return e.hasMoreElements();
    }

    private static void initializeLogger(XMultiServiceFactory _xMSF) {
        XComponentContext xContext = Helper.getComponentContext(_xMSF);
        Object aLoggerPool = xContext.getValueByName("/singletons/com.sun.star.logging.LoggerPool");
        if (aLoggerPool == null) {
            System.out.println("Can't get singleton from logging");
        }
        XLoggerPool xLoggerPool = (XLoggerPool)UnoRuntime.queryInterface(XLoggerPool.class, (Object)aLoggerPool);
        m_xLogger = xLoggerPool.getNamedLogger("com.sun.star.wizards.ReportBuilder");
    }

    public static XLogger getLogger() {
        return m_xLogger;
    }

    public void startReportWizard() {
        ReportWizard.initializeLogger(this.xMSF);
        ReportWizard.getLogger().log(1000, "Start Report Wizard");
        if (this.isReportBuilderInstalled()) {
            Class<?> a = null;
            try {
                a = Class.forName("com.sun.star.wizards.reportbuilder.ReportBuilderImplementation");
            }
            catch (ClassNotFoundException e) {
                System.err.println("ReportBuilderImplementation is unavailable");
            }
            if (a != null) {
                try {
                    Method aMethod = a.getMethod("create", XMultiServiceFactory.class);
                    this.m_reportDocument = (IReportDocument)aMethod.invoke(a, this.xMSF);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            if (this.m_reportDocument == null) {
                this.m_reportDocument = new ReportTextImplementation(this.xMSF);
            }
            this.m_reportDocument.initialize(this.m_docUI, this.m_oResource);
            if (this.m_reportDocument.getRecordParser().getConnection(this.m_wizardContext)) {
                this.buildSteps();
                if (!this.isReportBuilderInstalled()) {
                    this.CurReportLayouter.drawConstants();
                }
                this.m_reportDocument.checkInvariants();
                this.CurDBCommandFieldSelection.preselectCommand(this.m_wizardContext, false);
                this.createWindowPeer(this.m_reportDocument.getWizardParent());
                this.m_reportDocument.getRecordParser().setWindowPeer(this.xControl.getPeer());
                this.insertQueryRelatedSteps();
                short RetValue = this.executeDialog(this.m_reportDocument.getFrame().getComponentWindow().getPosSize());
                if (RetValue == 0) {
                    this.dialogFinish();
                }
            }
            this.m_reportDocument.getRecordParser().dispose();
        }
        catch (IOException e) {
            String sMessage = e.getMessage();
            if (sMessage.equals("default.otr")) {
                sMessage = this.m_oResource.getResText("RID_REPORT_92");
            }
            SystemDialog.showMessageBox(this.xMSF, "ErrorBox", 0x400000, sMessage);
        }
        catch (Exception jexception) {
            jexception.printStackTrace(System.err);
        }
    }

    public void importReportData(XMultiServiceFactory xMSF, Dataimport CurDataimport) {
        boolean bDocisStored = false;
        try {
            boolean bexecute = false;
            bexecute = !this.bHasEscapeProcessing ? this.m_reportDocument.getRecordParser().executeCommand(1) : this.m_reportDocument.getRecordParser().executeCommand(2);
            if (bexecute) {
                bexecute = this.m_reportDocument.getRecordParser().getFields(this.m_reportDocument.getRecordParser().getFieldNames(), false);
            }
            if (bexecute) {
                this.m_reportDocument.insertDatabaseDatatoReportDocument(xMSF);
            }
            if (this.CurReportFinalizer.getReportOpenMode() == 1) {
                bDocisStored = this.m_reportDocument.getRecordParser().storeDatabaseDocumentToTempPath(this.m_reportDocument.getComponent(), this.CurReportFinalizer.getStoreName());
            }
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        CurDataimport.xComponent.dispose();
        if (bDocisStored) {
            this.m_reportDocument.getRecordParser().addReportDocument(this.m_reportDocument.getComponent(), false);
        }
        this.m_reportDocument.getRecordParser().dispose();
    }

    private boolean getReportResources(boolean bgetProgressResourcesOnly) {
        sMsgWizardName = this.m_oResource.getResText("RID_REPORT_0");
        if (!bgetProgressResourcesOnly) {
            sShowBinaryFields = this.m_oResource.getResText("RID_REPORT_60");
            slblTables = this.m_oResource.getResText("RID_FORM_6");
            slblFields = this.m_oResource.getResText("RID_FORM_12");
            slblSelFields = this.m_oResource.getResText("RID_REPORT_9");
            this.WizardHeaderText[0] = this.m_oResource.getResText("RID_REPORT_28");
            this.WizardHeaderText[1] = this.m_oResource.getResText("RID_REPORT_69");
            this.WizardHeaderText[2] = this.m_oResource.getResText("RID_REPORT_29");
            this.WizardHeaderText[3] = this.m_oResource.getResText("RID_REPORT_30");
            this.WizardHeaderText[4] = this.m_oResource.getResText("RID_REPORT_31");
            this.WizardHeaderText[5] = this.m_oResource.getResText("RID_REPORT_32");
        }
        slblColumnTitles = this.m_oResource.getResText("RID_REPORT_70");
        slblColumnNames = this.m_oResource.getResText("RID_REPORT_71");
        return true;
    }

    public static String getBlindTextNote(Object _aDocument, Resource _oResource) {
        String sBlindTextNote = PropertyNames.EMPTY_STRING;
        if (_aDocument instanceof ReportTextImplementation) {
            sBlindTextNote = _oResource.getResText("RID_REPORT_75");
            sBlindTextNote = JavaTools.replaceSubString(sBlindTextNote, String.valueOf('\r'), "<BR>");
        }
        return sBlindTextNote;
    }

    private void enableRoadmapItems(boolean _bEnabled) {
        try {
            Object oRoadmapItem = null;
            int CurStep = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP));
            boolean bEnabled = false;
            for (int i = 0; i < this.getRMItemCount(); ++i) {
                oRoadmapItem = this.xIndexContRoadmap.getByIndex(i);
                int CurItemID = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(oRoadmapItem, "ID"));
                bEnabled = CurItemID > CurStep ? _bEnabled : true;
                Helper.setUnoPropertyValue(oRoadmapItem, PropertyNames.PROPERTY_ENABLED, bEnabled);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void enableWizardSteps(String[] NewItems) {
        boolean bEnabled = NewItems.length > 0;
        this.setControlProperty("btnWizardNext", PropertyNames.PROPERTY_ENABLED, bEnabled);
        this.setControlProperty("btnWizardFinish", PropertyNames.PROPERTY_ENABLED, bEnabled);
        this.enableRoadmapItems(bEnabled);
    }

    public void textChanged(TextEvent xTextEvent) {
        try {
            Object oModel = UnoDialog.getModel(xTextEvent.Source);
            String sContent = (String)Helper.getUnoPropertyValue(oModel, "Text");
            String fieldname = this.CurTitlesComponent.getFieldNameByTitleControl(oModel);
            this.m_reportDocument.liveupdate_changeUserFieldContent(fieldname, sContent);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    @Override
    public void disposing(EventObject EventObject2) {
    }

    private void toggleSortingPage() {
        boolean bdoenable;
        int nlCommandType = this.CurDBCommandFieldSelection.getSelectedCommandType();
        boolean bl = bdoenable = nlCommandType == 0;
        if (!bdoenable) {
            String sQueryName = this.CurDBCommandFieldSelection.getSelectedCommandName();
            DBMetaData.CommandObject oCommand = this.m_reportDocument.getRecordParser().getQueryByName(sQueryName);
            bdoenable = this.m_reportDocument.getRecordParser().hasEscapeProcessing(oCommand.getPropertySet());
        }
        super.setStepEnabled(4, bdoenable);
    }

    private class FieldSelectionListener
    implements XFieldSelectionListener {
        private int m_nID;

        private FieldSelectionListener() {
        }

        @Override
        public void setID(String sIncSuffix) {
            this.m_nID = 1;
            if (sIncSuffix != null && !sIncSuffix.equals(PropertyNames.EMPTY_STRING) && !sIncSuffix.equals("_")) {
                String sID = JavaTools.ArrayoutofString(sIncSuffix, "_")[1];
                this.m_nID = Integer.parseInt(sID);
            }
        }

        @Override
        public void shiftFromLeftToRight(String[] SelItems, String[] NewItems) {
            if (this.m_nID == 1) {
                ReportWizard.this.CurDBCommandFieldSelection.setModified(true);
                ReportWizard.this.enableWizardSteps(NewItems);
                ReportWizard.this.toggleSortingPage();
            }
        }

        @Override
        public void shiftFromRightToLeft(String[] SelItems, String[] NewItems) {
            if (this.m_nID == 1) {
                ReportWizard.this.enableWizardSteps(NewItems);
                ReportWizard.this.CurDBCommandFieldSelection.setModified(true);
            }
        }

        @Override
        public void moveItemDown(String item) {
        }

        @Override
        public void moveItemUp(String item) {
        }
    }
}

