# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.threaded_image_algorithm import ThreadedImageAlgorithm


class ImageDifference(ThreadedImageAlgorithm):
    """
    ImageDifference - Compares images for regression tests.
    
    Superclass: ThreadedImageAlgorithm
    
    ImageDifference takes two rgb unsigned char images and compares
    them. It allows the images to be slightly different.  If allow_shift
    is on, then each pixel can be shifted by two pixels. Threshold is the
    allowable error for each pixel.
    
    This is a symmetric filter and the difference computed is symmetric.
    The resulting value is the maximum error of the two directions A->B
    and B->A
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImageDifference, obj, update, **traits)
    
    allow_shift = tvtk_base.true_bool_trait(desc=\
        """
        Specify whether the comparison will allow a shift of two pixels
        between the images.  If set, then the minimum difference between
        input images will be used to determine the difference. Otherwise,
        the difference is computed directly between pixels of identical
        row/column values.
        """
    )

    def _allow_shift_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAllowShift,
                        self.allow_shift_)

    averaging = tvtk_base.true_bool_trait(desc=\
        """
        Specify whether the comparison will include comparison of
        averaged 3x3 data between the images. For graphics renderings you
        normally would leave this on. For imaging operations it should be
        off.
        """
    )

    def _averaging_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAveraging,
                        self.averaging_)

    average_threshold_factor = traits.Float(0.65, enter_set=True, auto_set=False, desc=\
        """
        When doing Averaging, adjust the threshold for the average by
        this factor. Defaults to 0.5 requiring a better match
        """
    )

    def _average_threshold_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAverageThresholdFactor,
                        self.average_threshold_factor)

    threshold = traits.Int(105, enter_set=True, auto_set=False, desc=\
        """
        Specify a threshold tolerance for pixel differences.
        """
    )

    def _threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetThreshold,
                        self.threshold)

    def _get_error(self):
        return self._vtk_obj.GetError()
    error = traits.Property(_get_error, desc=\
        """
        Return the total error in comparing the two images.
        """
    )

    def get_error(self, *args):
        """
        V.get_error() -> float
        C++: double GetError()
        V.get_error([float, ...])
        C++: void GetError(double *e)
        Return the total error in comparing the two images.
        """
        ret = self._wrap_call(self._vtk_obj.GetError, *args)
        return ret

    def _get_image(self):
        return wrap_vtk(self._vtk_obj.GetImage())
    image = traits.Property(_get_image, desc=\
        """
        Specify the Image to compare the input to.
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_thresholded_error(self):
        return self._vtk_obj.GetThresholdedError()
    thresholded_error = traits.Property(_get_thresholded_error, desc=\
        """
        Return the total thresholded error in comparing the two images.
        The thresholded error is the error for a given pixel minus the
        threshold and clamped at a minimum of zero.
        """
    )

    def get_thresholded_error(self, *args):
        """
        V.get_thresholded_error() -> float
        C++: double GetThresholdedError()
        V.get_thresholded_error([float, ...])
        C++: void GetThresholdedError(double *e)
        Return the total thresholded error in comparing the two images.
        The thresholded error is the error for a given pixel minus the
        threshold and clamped at a minimum of zero.
        """
        ret = self._wrap_call(self._vtk_obj.GetThresholdedError, *args)
        return ret

    def set_image_connection(self, *args):
        """
        V.set_image_connection(AlgorithmOutput)
        C++: void SetImageConnection(AlgorithmOutput *output)
        Specify the Image to compare the input to.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetImageConnection, *my_args)
        return ret

    def set_image_data(self, *args):
        """
        V.set_image_data(DataObject)
        C++: void SetImageData(DataObject *image)
        Specify the Image to compare the input to.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetImageData, *my_args)
        return ret

    _updateable_traits_ = \
    (('allow_shift', 'GetAllowShift'), ('averaging', 'GetAveraging'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('split_mode',
    'GetSplitMode'), ('average_threshold_factor',
    'GetAverageThresholdFactor'), ('threshold', 'GetThreshold'),
    ('desired_bytes_per_piece', 'GetDesiredBytesPerPiece'), ('enable_smp',
    'GetEnableSMP'), ('global_default_enable_smp',
    'GetGlobalDefaultEnableSMP'), ('minimum_piece_size',
    'GetMinimumPieceSize'), ('number_of_threads', 'GetNumberOfThreads'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'allow_shift', 'averaging', 'debug',
    'global_warning_display', 'release_data_flag', 'split_mode',
    'average_threshold_factor', 'desired_bytes_per_piece', 'enable_smp',
    'global_default_enable_smp', 'minimum_piece_size',
    'number_of_threads', 'progress_text', 'threshold'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImageDifference, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImageDifference properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['allow_shift', 'averaging'], ['split_mode'],
            ['average_threshold_factor', 'desired_bytes_per_piece', 'enable_smp',
            'global_default_enable_smp', 'minimum_piece_size',
            'number_of_threads', 'threshold']),
            title='Edit ImageDifference properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImageDifference properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

