/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.plaf.xerto.XertoUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class SlidingFrameBorder
implements Border,
UIResource {
    public static final int SHADOW_SIZE = 10;
    protected Color _highlight;
    protected Color _lightHighlight;
    protected Color _shadow;
    protected Color _darkShadow;
    protected Insets _insets;
    private static double LOG10 = Math.log(10.0);

    public SlidingFrameBorder(Color color, Color color2, Color color3, Color color4, Insets insets) {
        this._highlight = color;
        this._lightHighlight = color2;
        this._shadow = color3;
        this._darkShadow = color4;
        this._insets = insets;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this._insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this._insets.top >= 10) {
            graphics.setColor(XertoUtils.getFrameBorderColor());
            graphics.drawRect(n, n2 + this._insets.top - 1, n3, n4 - this._insets.top + 1);
            graphics.setColor(this._highlight);
            graphics.drawLine(n, n2 + this._insets.top - 5, n + n3, n2 + this._insets.top - 5);
            graphics.setColor(this._lightHighlight);
            graphics.drawLine(n, n2 + this._insets.top - 4, n + n3, n2 + this._insets.top - 4);
            graphics.setColor(this._highlight);
            graphics.drawLine(n, n2 + this._insets.top - 3, n + n3, n2 + this._insets.top - 3);
            graphics.drawLine(n, n2 + this._insets.top - 2, n + n3, n2 + this._insets.top - 2);
            SlidingFrameBorder.paintGradient(graphics, new Rectangle(n, n2, n3, this._insets.top - 5), true, 40, false);
        }
        if (this._insets.left >= 10) {
            graphics.setColor(XertoUtils.getFrameBorderColor());
            graphics.drawRect(n + this._insets.left - 1, n2, n3 - this._insets.left, n4);
            graphics.setColor(this._highlight);
            graphics.drawLine(n + this._insets.left - 5, n2, n + this._insets.left - 5, n2 + n4);
            graphics.setColor(this._lightHighlight);
            graphics.drawLine(n + this._insets.left - 4, n2, n + this._insets.left - 4, n2 + n4);
            graphics.setColor(this._highlight);
            graphics.drawLine(n + this._insets.left - 3, n2, n + this._insets.left - 3, n2 + n4);
            graphics.drawLine(n + this._insets.left - 2, n2, n + this._insets.left - 2, n2 + n4);
            SlidingFrameBorder.paintGradient(graphics, new Rectangle(n, n2, this._insets.left - 5, n4), false, 40, false);
        }
        if (this._insets.bottom >= 10) {
            graphics.setColor(XertoUtils.getFrameBorderColor());
            graphics.drawRect(n, n2, n3, n4 - this._insets.bottom);
            graphics.setColor(this._highlight);
            graphics.drawLine(n, n2 + n4 - this._insets.bottom + 1, n + n3, n2 + n4 - this._insets.bottom + 1);
            graphics.drawLine(n, n2 + n4 - this._insets.bottom + 2, n + n3, n2 + n4 - this._insets.bottom + 2);
            graphics.setColor(this._shadow);
            graphics.drawLine(n, n2 + n4 - this._insets.bottom + 3, n + n3, n2 + n4 - this._insets.bottom + 3);
            graphics.setColor(this._darkShadow);
            graphics.drawLine(n, n2 + n4 - this._insets.bottom + 4, n + n3, n2 + n4 - this._insets.bottom + 4);
            SlidingFrameBorder.paintGradient(graphics, new Rectangle(n, n2 + n4 - this._insets.bottom + 4, n3, this._insets.bottom - 5), true, 100, true);
        }
        if (this._insets.right >= 10) {
            graphics.setColor(XertoUtils.getFrameBorderColor());
            graphics.drawRect(n, n2, n3 - this._insets.right, n4);
            graphics.setColor(this._highlight);
            graphics.drawLine(n + n3 - this._insets.right + 1, n2, n + n3 - this._insets.right + 1, n2 + n4);
            graphics.drawLine(n + n3 - this._insets.right + 2, n2, n + n3 - this._insets.right + 2, n2 + n4);
            graphics.setColor(this._shadow);
            graphics.drawLine(n + n3 - this._insets.right + 3, n2, n + n3 - this._insets.right + 3, n2 + n4);
            graphics.setColor(this._darkShadow);
            graphics.drawLine(n + n3 - this._insets.right + 4, n2, n + n3 - this._insets.right + 4, n2 + n4);
            SlidingFrameBorder.paintGradient(graphics, new Rectangle(n + n3 - this._insets.right + 4, n2, this._insets.right - 5, n4), false, 100, true);
        }
    }

    public static void paintGradient(Graphics graphics, Rectangle rectangle, boolean bl, int n, boolean bl2) {
        if (bl) {
            for (int i = 1; i < rectangle.height; ++i) {
                int n2 = (int)((1.0 - Math.log(i) / LOG10) * (double)n);
                graphics.setColor(new Color(0, 0, 0, n2));
                if (bl2) {
                    graphics.drawLine(rectangle.x, rectangle.y + i, rectangle.x + rectangle.width, rectangle.y + i);
                    continue;
                }
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - i, rectangle.x + rectangle.width, rectangle.y + rectangle.height - i);
            }
        } else {
            for (int i = 1; i < rectangle.width; ++i) {
                int n3 = (int)((1.0 - Math.log(i) / LOG10) * (double)n);
                graphics.setColor(new Color(0, 0, 0, n3));
                if (bl2) {
                    graphics.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + rectangle.height);
                    continue;
                }
                graphics.drawLine(rectangle.x + rectangle.width - i, rectangle.y, rectangle.x + rectangle.width - i, rectangle.y + rectangle.height);
            }
        }
    }
}

