"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["node_modules_css-loader_dist_runtime_getUrl_js-src_BoardSelector_vue-data_image_svg_xml_3c_21-daea39"],{74227:(t,e,n)=>{n.d(e,{A:()=>i});var o=n(71354),a=n.n(o),l=n(76314),r=n.n(l)()(a());r.push([t.id,"\n#modal-inner[data-v-5e94966b] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n}\nul[data-v-5e94966b] {\n\tmin-height: 100px;\n}\nli[data-v-5e94966b] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-5e94966b]:hover, li[data-v-5e94966b]:focus {\n\tbackground-color: var(--color-background-dark);\n}\nli.selected[data-v-5e94966b] {\n\tborder: 1px solid var(--color-primary-element);\n}\n.board-bullet[data-v-5e94966b] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nli > span[data-v-5e94966b],\n.avatar[data-v-5e94966b] {\n\tvertical-align: middle;\n}\n\n","",{version:3,sources:["webpack://./src/BoardSelector.vue"],names:[],mappings:";AAmHA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;;CAEA,sBAAA;AAEA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2019 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<template>\n\t<NcModal @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h1>{{ t('deck', 'Select the board to link to a project') }}</h1>\n\t\t\t<input v-model=\"filter\" type=\"text\" :placeholder=\"t('deck', 'Search by board title')\">\n\t\t\t<ul v-if=\"!loading\">\n\t\t\t\t<li v-for=\"board in availableBoards\"\n\t\t\t\t\t:key=\"board.id\"\n\t\t\t\t\t:class=\"{'selected': (selectedBoard === board.id) }\"\n\t\t\t\t\t@click=\"selectedBoard=board.id\">\n\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + board.color }\" class=\"board-bullet\" />\n\t\t\t\t\t<span>{{ board.title }}</span>\n\t\t\t\t</li>\n\t\t\t</ul>\n\t\t\t<button v-if=\"!loading\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ t('deck', 'Select board') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\nimport { generateUrl } from '@nextcloud/router'\n\nexport default {\n\tname: 'BoardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tfilter: '',\n\t\t\tboards: [],\n\t\t\tselectedBoard: null,\n\t\t\tloading: true,\n\t\t\tcurrentBoard: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tavailableBoards() {\n\t\t\treturn this.boards.filter((board) => (\n\t\t\t\t'' + board.id !== '' + this.currentBoard\n\t\t\t\t&& board.title.match(this.filter)\n\t\t\t))\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t\tconst hash = window.location.hash.match(/\\/boards\\/([0-9]+)/)\n\t\tthis.currentBoard = hash.length > 0 ? hash[1] : null\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedBoard)\n\t\t},\n\t},\n\n}\n<\/script>\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\tli.selected {\n\t\tborder: 1px solid var(--color-primary-element);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tli > span,\n\t.avatar {\n\t\tvertical-align: middle;\n\n\t}\n\n</style>\n"],sourceRoot:""}]);const i=r},4417:t=>{t.exports=function(t,e){return e||(e={}),t?(t=String(t.__esModule?t.default:t),/^['"].*['"]$/.test(t)&&(t=t.slice(1,-1)),e.hash&&(t+=e.hash),/["'() \t\n]|(%20)/.test(t)||e.needQuotes?'"'.concat(t.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):t):t}},34203:(t,e,n)=>{n.r(e),n.d(e,{default:()=>C});var o=n(76333),a=n(70715),l=n(63814);const r={name:"BoardSelector",components:{NcModal:o.FH},data:()=>({filter:"",boards:[],selectedBoard:null,loading:!0,currentBoard:null}),computed:{availableBoards(){return this.boards.filter((t=>""+t.id!=""+this.currentBoard&&t.title.match(this.filter)))}},beforeMount(){this.fetchBoards();const t=window.location.hash.match(/\/boards\/([0-9]+)/);this.currentBoard=t.length>0?t[1]:null},methods:{fetchBoards(){a.Ay.get((0,l.Jv)("/apps/deck/boards")).then((t=>{this.boards=t.data,this.loading=!1}))},close(){this.$root.$emit("close")},select(){this.$root.$emit("select",this.selectedBoard)}}};var i=n(85072),d=n.n(i),s=n(97825),c=n.n(s),A=n(77659),h=n.n(A),p=n(55056),u=n.n(p),g=n(10540),b=n.n(g),m=n(41113),v=n.n(m),N=n(74227),x={};x.styleTagTransform=v(),x.setAttributes=u(),x.insert=h().bind(null,"head"),x.domAPI=c(),x.insertStyleElement=b();d()(N.A,x);N.A&&N.A.locals&&N.A.locals;const C=(0,n(14486).A)(r,(function(){var t=this,e=t._self._c;return e("NcModal",{on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h1",[t._v(t._s(t.t("deck","Select the board to link to a project")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.filter,expression:"filter"}],attrs:{type:"text",placeholder:t.t("deck","Search by board title")},domProps:{value:t.filter},on:{input:function(e){e.target.composing||(t.filter=e.target.value)}}}),t._v(" "),t.loading?t._e():e("ul",t._l(t.availableBoards,(function(n){return e("li",{key:n.id,class:{selected:t.selectedBoard===n.id},on:{click:function(e){t.selectedBoard=n.id}}},[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.color}}),t._v(" "),e("span",[t._v(t._s(n.title))])])})),0),t._v(" "),t.loading?t._e():e("button",{staticClass:"primary",on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.t("deck","Select board"))+"\n\t\t")])])])}),[],!1,null,"5e94966b",null).exports},27518:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M15.4%2016.6L10.8%2012l4.6-4.6L14%206l-6%206%206%206%201.4-1.4z%27/%3e%3c/svg%3e"},27514:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M18.4%207.4L17%206l-6%206%206%206%201.4-1.4-4.6-4.6%204.6-4.6m-6%200L11%206l-6%206%206%206%201.4-1.4L7.8%2012l4.6-4.6z%27/%3e%3c/svg%3e"},79722:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M5.6%207.4L7%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6m6%200L13%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6z%27/%3e%3c/svg%3e"},86886:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M8.6%2016.6l4.6-4.6-4.6-4.6L10%206l6%206-6%206-1.4-1.4z%27/%3e%3c/svg%3e"},76333:(t,e,n)=>{n.d(e,{AO:()=>X.N,Az:()=>i.N,B6:()=>A.N,Bx:()=>I.N,EQ:()=>gt.N,FH:()=>rt.A,K1:()=>et.N,Ki:()=>d.A,Ko:()=>o.A,Qz:()=>E.N,R1:()=>D.N,c:()=>U.A,i$:()=>Y.N,lT:()=>K.N,ne:()=>lt.A,v:()=>bt.N,x1:()=>T.A,yI:()=>J.A,z:()=>h.A});n(18911);var o=n(89257),a=n(92090),l=n(30567),r=n(1790),i=n(7225),d=n(73267),s=n(17452),c=n(93806),A=n(26325),h=n(80114),p=n(32831),u=n(98060),g=n(59224),b=n(47611),m=n(10363),v=n(97313),N=n(17465),x=n(20377),C=n(54656),f=n(80329),w=n(62720),k=n(24777),B=n(24302),_=n(94851),y=n(66687),S=n(2318),L=n(85948),M=n(12146),P=n(46503),I=n(26455),D=n(36562),E=n(32421),T=n(18740),X=n(12620),$=n(63657),z=n(85641),F=n(46747),G=n(21558),H=n(74900),j=n(57201),K=n(87638),Q=n(81212),U=n(31126),Y=n(76358),R=n(74358),W=n(68296),q=n(7834),J=n(34196),O=n(78298),V=n(57758),Z=n(9508),tt=n(26517),et=n(96338),nt=n(63407),ot=n(59500),at=n(64990),lt=n(84237),rt=n(27180),it=n(80910),dt=n(66154),st=n(17622),ct=n(79742),At=n(14825),ht=n(51681),pt=n(69126),ut=n(4570),gt=(n(40708),n(18230),n(70715),n(21777),n(40699)),bt=n(60666),mt=(n(61338),n(94632)),vt=n(63447),Nt=n(63527),xt=n(89775),Ct=n(65217),ft=n(42740),wt=n(35702),kt=n(76057),Bt=n(87136),_t=n(23610),yt=(n(23020),n(53429),n(94205),n(9050),n(684),n(42892)),St=n(65842),Lt=(n(18300),n(75105),n(92471),n(16406),n(33884));o.A,a.N,l.A,r.A,i.N,d.A,s.A,c.A,h.A,p.A,u.A,A.N,g.N,b.A,m.A,v.N,N.N,x.A,C.N,f.A,w.A,k.N,B.N,_.N,y.A,S.N,L.A,M.N,P.A,pt.N,I.N,D.N,E.N,T.A,X.N,$.N,z.N,F.N,G.N,H.N,j.N,K.N,Q.A,U.A,Y.N,R.N,W.A,q.N,J.A,O.A,V.A,Z.N,tt.N,et.N,nt.A,ot.N,at.N,lt.A,ht.N,rt.A,it.A,dt.N,st.N,ct.N,At.N,pt.a,ut.N,mt.N,gt.N,vt.N,Nt.N,xt.N,Ct.N,ft.A,bt.N,wt.N,kt.N,Bt.N,_t.A,Symbol.toStringTag,yt.u,St.u,Lt.yw,Symbol.toStringTag}}]);
//# sourceMappingURL=deck-node_modules_css-loader_dist_runtime_getUrl_js-src_BoardSelector_vue-data_image_svg_xml_3c_21-daea39.js.map?v=a7a695336a2e30c60083