/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.debugging.OWLDebugger;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class AbstractOWLDebugger
implements OWLDebugger {
    @Nonnull
    protected final OWLOntologyManager owlOntologyManager;
    @Nonnull
    private OWLOntology ontology;

    protected AbstractOWLDebugger(@Nonnull OWLOntologyManager owlOntologyManager, @Nonnull OWLOntology ontology) {
        this.owlOntologyManager = OWLAPIPreconditions.checkNotNull(owlOntologyManager, "owlOntologyManager cannot be null");
        this.ontology = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        this.mergeImportsClosure();
    }

    private void mergeImportsClosure() {
        OWLOntology originalOntology = this.ontology;
        try {
            this.ontology = this.owlOntologyManager.createOntology(OWLOntologyDocumentSourceBase.getNextDocumentIRI("http://debugger.semanticweb.org/ontolog"));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException(e);
        }
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(originalOntology)) {
            for (OWLAxiom oWLAxiom : ont.getLogicalAxioms()) {
                assert (oWLAxiom != null);
                changes.add(new AddAxiom(this.ontology, oWLAxiom));
            }
        }
        this.owlOntologyManager.applyChanges(changes);
    }

    @Nonnull
    protected abstract OWLClassExpression getCurrentClass() throws OWLException;

    @Override
    public OWLOntology getOWLOntology() {
        return this.ontology;
    }

    @Override
    @Nonnull
    public Set<Set<OWLAxiom>> getAllSOSForInconsistentClass(OWLClassExpression cls) throws OWLException {
        Set<OWLAxiom> firstMups = this.getSOSForInconsistentClass(cls);
        if (firstMups.isEmpty()) {
            return CollectionFactory.emptySet();
        }
        HashSet<Set<OWLAxiom>> allMups = new HashSet<Set<OWLAxiom>>();
        allMups.add(firstMups);
        HashSet<Set<OWLAxiom>> satPaths = new HashSet<Set<OWLAxiom>>();
        HashSet<OWLAxiom> currentPathContents = new HashSet<OWLAxiom>();
        this.constructHittingSetTree(firstMups, allMups, satPaths, currentPathContents);
        return allMups;
    }

    public void constructHittingSetTree(@Nonnull Set<OWLAxiom> mups, @Nonnull Set<Set<OWLAxiom>> allMups, @Nonnull Set<Set<OWLAxiom>> satPaths, @Nonnull Set<OWLAxiom> currentPathContents) throws OWLException {
        for (OWLAxiom axiom : mups) {
            assert (axiom != null);
            this.owlOntologyManager.applyChange(new RemoveAxiom(this.ontology, axiom));
            currentPathContents.add(axiom);
            boolean earlyTermination = false;
            for (Set<OWLAxiom> satPath : satPaths) {
                if (!satPath.containsAll(currentPathContents)) continue;
                earlyTermination = true;
                break;
            }
            if (!earlyTermination) {
                Set<OWLAxiom> newMUPS = this.getSOSForInconsistentClass(this.getCurrentClass());
                if (!newMUPS.isEmpty()) {
                    if (!allMups.contains(newMUPS)) {
                        allMups.add(newMUPS);
                        this.constructHittingSetTree(newMUPS, allMups, satPaths, currentPathContents);
                    }
                } else {
                    satPaths.add(new HashSet<OWLAxiom>(currentPathContents));
                }
            }
            currentPathContents.remove(axiom);
            this.owlOntologyManager.applyChange(new AddAxiom(this.ontology, axiom));
        }
    }
}

