/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import java.awt.Frame;
import java.util.List;
import javax.annotation.Nonnull;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.core.ui.wizard.WizardPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.deprecation.DeprecationProfile;
import org.protege.editor.owl.model.util.OboUtilities;
import org.protege.editor.owl.ui.deprecation.AlternateEntitiesPage;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizardState;
import org.protege.editor.owl.ui.deprecation.DeprecationCodePage;
import org.protege.editor.owl.ui.deprecation.DeprecationProfilePage;
import org.protege.editor.owl.ui.deprecation.DeprecationReasonPage;
import org.protege.editor.owl.ui.deprecation.DeprecationReplacementEntityPage;
import org.protege.editor.owl.ui.deprecation.DeprecationSummaryPage;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class DeprecateEntityWizard
extends Wizard {
    private final DeprecateEntityWizardState wizardState = new DeprecateEntityWizardState();

    public DeprecateEntityWizard(@Nonnull Frame owner, @Nonnull OWLEditorKit editorKit, @Nonnull OWLEntity entityToDeprecate, @Nonnull List<DeprecationProfile> depreactionProfiles) {
        super(owner);
        this.setTitle(DeprecateEntityWizard.generateTitle(editorKit, entityToDeprecate));
        this.registerWizardPanel("DeprecationProfilePage", (WizardPanel)new DeprecationProfilePage(editorKit, this.wizardState, depreactionProfiles));
        this.registerWizardPanel("DeprecationReason", (WizardPanel)new DeprecationReasonPage(editorKit, this.wizardState, entityToDeprecate));
        this.registerWizardPanel("DeprecationCodePage", (WizardPanel)new DeprecationCodePage(editorKit, this.wizardState));
        this.registerWizardPanel("DeprecationReplacementEntityPage", (WizardPanel)new DeprecationReplacementEntityPage(editorKit, this.wizardState));
        this.registerWizardPanel("AlternateEntitiesPage", (WizardPanel)new AlternateEntitiesPage(editorKit, this.wizardState));
        this.registerWizardPanel("DeprecationSummaryPage", (WizardPanel)new DeprecationSummaryPage(editorKit, entityToDeprecate, this.wizardState));
        this.setCurrentPanel("DeprecationProfilePage");
    }

    private static String generateTitle(OWLEditorKit editorKit, OWLEntity entityToDeprecate) {
        String title = "Deprecate " + editorKit.getModelManager().getRendering((OWLObject)entityToDeprecate);
        title = title + OboUtilities.getOboIdFromIri(entityToDeprecate.getIRI()).map(oboId -> " (" + oboId + ")").orElse("");
        return title;
    }

    public DeprecateEntityWizardState getWizardState() {
        return this.wizardState;
    }
}

