/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.io.File;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.JPLException;
import org.jpl7.JRef;
import org.jpl7.Term;
import org.jpl7.Version;
import org.jpl7.fli.Prolog;

public class JPL {
    protected static final boolean DEBUG = false;
    public static final Term JFALSE = new Compound("@", new Term[]{new Atom("false")});
    public static final Term JTRUE = new Compound("@", new Term[]{new Atom("true")});
    public static final Term JNULL = new Compound("@", new Term[]{new Atom("null")});
    public static final Term JVOID = new Compound("@", new Term[]{new Atom("void")});
    protected static boolean modeDontTellMe = true;
    protected static final Atom LIST_NIL_MODERN = new Atom("[]", "reserved_symbol");
    protected static final Atom LIST_NIL_TRADITIONAL = new Atom("[]", "text");
    public static Atom LIST_NIL = LIST_NIL_MODERN;
    protected static final String LIST_PAIR_MODERN = "[|]";
    protected static final String LIST_PAIR_TRADITIONAL = ".";
    public static String LIST_PAIR = "[|]";
    public static boolean LIST_TOSTRING_TEXTUAL = true;
    private static String nativeLibraryName = "jpl";
    private static String nativeLibraryDir = null;
    private static String nativeLibraryPath = null;
    private static final Version version_ = new Version();

    public static String setNativeLibraryName(String string) {
        if (string == null) {
            throw new NullPointerException("newName cannot be null");
        }
        String string2 = nativeLibraryName;
        nativeLibraryName = string;
        return string2;
    }

    public static String setNativeLibraryDir(String string) {
        String string2 = nativeLibraryDir;
        nativeLibraryDir = string;
        return string2;
    }

    public static String setNativeLibraryPath(String string) {
        String string2 = nativeLibraryPath;
        nativeLibraryPath = string;
        return string2;
    }

    public static void loadNativeLibrary() {
        if (nativeLibraryPath != null) {
            System.load(new File(nativeLibraryPath).getAbsolutePath());
        } else if (nativeLibraryDir != null) {
            System.load(new File(nativeLibraryDir, System.mapLibraryName(nativeLibraryName)).getAbsolutePath());
        } else {
            System.loadLibrary(nativeLibraryName);
        }
    }

    public static String jarPath() {
        try {
            return Class.forName("org.jpl7.JPL").getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return "";
        }
    }

    public static void setDTMMode(boolean bl) {
        modeDontTellMe = bl;
    }

    public static void setTraditional() {
        if (JPL.getSyntax().equals("modern")) {
            if (JPL.getActualInitArgs() == null) {
                LIST_NIL = LIST_NIL_TRADITIONAL;
                LIST_PAIR = LIST_PAIR_TRADITIONAL;
                JPL.setDefaultInitArgs(JPL.argsEnsureSyntax(JPL.getDefaultInitArgs()));
            } else {
                throw new JPLException("cannot switch to traditional syntax after Prolog is initialised");
            }
        }
    }

    public static void setTraditionalAnyway() {
        LIST_NIL = LIST_NIL_TRADITIONAL;
        LIST_PAIR = LIST_PAIR_TRADITIONAL;
    }

    public static String getSyntax() {
        if (LIST_PAIR.equals(LIST_PAIR_MODERN)) {
            return "modern";
        }
        if (LIST_PAIR.equals(LIST_PAIR_TRADITIONAL)) {
            return "traditional";
        }
        throw new JPLException("syntax is neither traditional nor modern");
    }

    public static String[] getDefaultInitArgs() {
        return Prolog.get_default_init_args();
    }

    public static void setDefaultInitArgs(String[] stringArray) {
        Prolog.set_default_init_args(JPL.argsEnsureSyntax(stringArray));
    }

    private static String[] argsEnsureSyntax(String[] stringArray) {
        String[] stringArray2;
        int n;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("--traditional")) continue;
            ++n2;
        }
        String[] stringArray3 = new String[stringArray.length - n2];
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("--traditional")) continue;
            stringArray3[n3++] = stringArray[n];
        }
        if (JPL.getSyntax().equals("modern")) {
            stringArray2 = stringArray3;
        } else {
            stringArray2 = new String[stringArray3.length + 1];
            stringArray2[0] = stringArray3[0];
            stringArray2[1] = "--traditional";
            n3 = 2;
            for (n = 1; n < stringArray3.length; ++n) {
                stringArray2[n3++] = stringArray3[n];
            }
        }
        return stringArray2;
    }

    public static String[] getActualInitArgs() {
        return Prolog.get_actual_init_args();
    }

    public static boolean init(String[] stringArray) {
        return Prolog.set_default_init_args(stringArray) && JPL.init();
    }

    public static boolean init() {
        return Prolog.initialise();
    }

    protected static boolean isSimpleName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c < 'a' || c > 'z') {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static Term newJRef(Object object) {
        if (object == null) {
            return JNULL;
        }
        return new JRef(object);
    }

    protected static String quotedName(String string) {
        return JPL.isSimpleName(string) ? string : "'" + string + "'";
    }

    @Deprecated
    public static void halt() {
        Prolog.halt(0);
    }

    public static Version version() {
        return version_;
    }

    public static String version_string() {
        return JPL.version_.major + LIST_PAIR_TRADITIONAL + JPL.version_.minor + LIST_PAIR_TRADITIONAL + JPL.version_.patch + "-" + JPL.version_.status;
    }

    public static void main(String[] stringArray) {
        System.out.println(JPL.version_string());
    }
}

