// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from AT91SAM9G10.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,at91sam9g10

// Atmel AT91SAM9G10 device: ARM926EJ Embedded Microprocessor Unit, 266MHz, LCD, USB, 217 Pins (refer to http://www.atmel.com/devices/SAM9G10.aspx for more)
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "AT91SAM9G10"
)

// Interrupt numbers.
const (
	// Advanced Interrupt Controller
	IRQ_FIQ = 0

	// Debug Unit
	IRQ_DBGU = 1

	// Parallel Input/Output Controller A
	IRQ_PIOA = 2

	// Parallel Input/Output Controller B
	IRQ_PIOB = 3

	// Parallel Input/Output Controller C
	IRQ_PIOC = 4

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 6

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 7

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 8

	// MultiMedia Card Interface
	IRQ_MCI = 9

	// USB Device Port
	IRQ_UDP = 10

	// Two-wire Interface
	IRQ_TWI = 11

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 12

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 13

	// Synchronous Serial Controller 0
	IRQ_SSC0 = 14

	// Synchronous Serial Controller 1
	IRQ_SSC1 = 15

	// Synchronous Serial Controller 2
	IRQ_SSC2 = 16

	// Timer Counter 0
	IRQ_TC0 = 17

	// Timer Counter 0
	IRQ_TC1 = 18

	// Timer Counter 0
	IRQ_TC2 = 19

	// USB Host Port
	IRQ_UHP = 20

	// LCD Controller
	IRQ_LCDC = 21

	// Advanced Interrupt Controller
	IRQ_IRQ0 = 29

	// Advanced Interrupt Controller
	IRQ_IRQ1 = 30

	// Advanced Interrupt Controller
	IRQ_IRQ2 = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export FIQ_IRQHandler
func interruptFIQ() {
	callHandlers(IRQ_FIQ)
}

//export DBGU_IRQHandler
func interruptDBGU() {
	callHandlers(IRQ_DBGU)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export PIOC_IRQHandler
func interruptPIOC() {
	callHandlers(IRQ_PIOC)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export MCI_IRQHandler
func interruptMCI() {
	callHandlers(IRQ_MCI)
}

//export UDP_IRQHandler
func interruptUDP() {
	callHandlers(IRQ_UDP)
}

//export TWI_IRQHandler
func interruptTWI() {
	callHandlers(IRQ_TWI)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SSC0_IRQHandler
func interruptSSC0() {
	callHandlers(IRQ_SSC0)
}

//export SSC1_IRQHandler
func interruptSSC1() {
	callHandlers(IRQ_SSC1)
}

//export SSC2_IRQHandler
func interruptSSC2() {
	callHandlers(IRQ_SSC2)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export UHP_IRQHandler
func interruptUHP() {
	callHandlers(IRQ_UHP)
}

//export LCDC_IRQHandler
func interruptLCDC() {
	callHandlers(IRQ_LCDC)
}

//export IRQ0_IRQHandler
func interruptIRQ0() {
	callHandlers(IRQ_IRQ0)
}

//export IRQ1_IRQHandler
func interruptIRQ1() {
	callHandlers(IRQ_IRQ1)
}

//export IRQ2_IRQHandler
func interruptIRQ2() {
	callHandlers(IRQ_IRQ2)
}

// Peripherals.
var (
	// USB Host Port
	UHP = (*UHP_Type)(unsafe.Pointer(uintptr(0x500000)))

	// LCD Controller
	LCDC = (*LCDC_Type)(unsafe.Pointer(uintptr(0x600000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0xfffa0000)))

	// USB Device Port
	UDP = (*UDP_Type)(unsafe.Pointer(uintptr(0xfffa4000)))

	// MultiMedia Card Interface
	MCI = (*MCI_Type)(unsafe.Pointer(uintptr(0xfffa8000)))

	// Two-wire Interface
	TWI = (*TWI_Type)(unsafe.Pointer(uintptr(0xfffac000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffb0000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffb4000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0xfffb8000)))

	// Synchronous Serial Controller 0
	SSC0 = (*SSC_Type)(unsafe.Pointer(uintptr(0xfffbc000)))

	// Synchronous Serial Controller 1
	SSC1 = (*SSC_Type)(unsafe.Pointer(uintptr(0xfffc0000)))

	// Synchronous Serial Controller 2
	SSC2 = (*SSC_Type)(unsafe.Pointer(uintptr(0xfffc4000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0xfffc8000)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0xfffcc000)))

	// SDRAM Controller
	SDRAMC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffea00)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffec00)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffee00)))

	// Advanced Interrupt Controller
	AIC = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))

	// Debug Unit
	DBGU = (*DBGU_Type)(unsafe.Pointer(uintptr(0xfffff200)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd00)))

	// Shutdown Controller
	SHDWC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd10)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd20)))

	// Periodic Interval Timer
	PIT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd40)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd50)))
)

// USB Host Port
type UHP_Type struct {
}

// LCD Controller
type LCDC_Type struct {
	DMABADDR1    volatile.Register32 // 0x0
	DMABADDR2    volatile.Register32 // 0x4
	DMAFRMPT1    volatile.Register32 // 0x8
	DMAFRMPT2    volatile.Register32 // 0xC
	DMAFRMADD1   volatile.Register32 // 0x10
	DMAFRMADD2   volatile.Register32 // 0x14
	DMAFRMCFG    volatile.Register32 // 0x18
	DMACON       volatile.Register32 // 0x1C
	_            [2016]byte
	LCDCON1      volatile.Register32 // 0x800
	LCDCON2      volatile.Register32 // 0x804
	LCDTIM1      volatile.Register32 // 0x808
	LCDTIM2      volatile.Register32 // 0x80C
	LCDFRMCFG    volatile.Register32 // 0x810
	LCDFIFO      volatile.Register32 // 0x814
	LCDMVAL      volatile.Register32 // 0x818
	DP1_2        volatile.Register32 // 0x81C
	DP4_7        volatile.Register32 // 0x820
	DP3_5        volatile.Register32 // 0x824
	DP2_3        volatile.Register32 // 0x828
	DP5_7        volatile.Register32 // 0x82C
	DP3_4        volatile.Register32 // 0x830
	DP4_5        volatile.Register32 // 0x834
	DP6_7        volatile.Register32 // 0x838
	PWRCON       volatile.Register32 // 0x83C
	CONTRAST_CTR volatile.Register32 // 0x840
	CONTRAST_VAL volatile.Register32 // 0x844
	LCD_IER      volatile.Register32 // 0x848
	LCD_IDR      volatile.Register32 // 0x84C
	LCD_IMR      volatile.Register32 // 0x850
	LCD_ISR      volatile.Register32 // 0x854
	LCD_ICR      volatile.Register32 // 0x858
	_            [136]byte
	LCD_WPCR     volatile.Register32 // 0x8E4
	LCD_WPSR     volatile.Register32 // 0x8E8
	_            [788]byte
	LUTENTRY     [256]volatile.Register32 // 0xC00
}

// LCDC.DMABADDR1: DMA Base Address Register 1
func (o *LCDC_Type) SetDMABADDR1_BADDR_U(value uint32) {
	volatile.StoreUint32(&o.DMABADDR1.Reg, volatile.LoadUint32(&o.DMABADDR1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetDMABADDR1_BADDR_U() uint32 {
	return (volatile.LoadUint32(&o.DMABADDR1.Reg) & 0xfffffffc) >> 2
}

// LCDC.DMABADDR2: DMA Base Address Register 2
func (o *LCDC_Type) SetDMABADDR2(value uint32) {
	volatile.StoreUint32(&o.DMABADDR2.Reg, value)
}
func (o *LCDC_Type) GetDMABADDR2() uint32 {
	return volatile.LoadUint32(&o.DMABADDR2.Reg)
}

// LCDC.DMAFRMPT1: DMA Frame Pointer Register 1
func (o *LCDC_Type) SetDMAFRMPT1_FRMPT_U(value uint32) {
	volatile.StoreUint32(&o.DMAFRMPT1.Reg, volatile.LoadUint32(&o.DMAFRMPT1.Reg)&^(0x7fffff)|value)
}
func (o *LCDC_Type) GetDMAFRMPT1_FRMPT_U() uint32 {
	return volatile.LoadUint32(&o.DMAFRMPT1.Reg) & 0x7fffff
}

// LCDC.DMAFRMPT2: DMA Frame Pointer Register 2
func (o *LCDC_Type) SetDMAFRMPT2_FRMPT_L(value uint32) {
	volatile.StoreUint32(&o.DMAFRMPT2.Reg, volatile.LoadUint32(&o.DMAFRMPT2.Reg)&^(0x7fffff)|value)
}
func (o *LCDC_Type) GetDMAFRMPT2_FRMPT_L() uint32 {
	return volatile.LoadUint32(&o.DMAFRMPT2.Reg) & 0x7fffff
}

// LCDC.DMAFRMADD1: DMA Frame Address Register 1
func (o *LCDC_Type) SetDMAFRMADD1(value uint32) {
	volatile.StoreUint32(&o.DMAFRMADD1.Reg, value)
}
func (o *LCDC_Type) GetDMAFRMADD1() uint32 {
	return volatile.LoadUint32(&o.DMAFRMADD1.Reg)
}

// LCDC.DMAFRMADD2: DMA Frame Address Register 2
func (o *LCDC_Type) SetDMAFRMADD2(value uint32) {
	volatile.StoreUint32(&o.DMAFRMADD2.Reg, value)
}
func (o *LCDC_Type) GetDMAFRMADD2() uint32 {
	return volatile.LoadUint32(&o.DMAFRMADD2.Reg)
}

// LCDC.DMAFRMCFG: DMA Frame Configuration Register
func (o *LCDC_Type) SetDMAFRMCFG_FRMSIZE(value uint32) {
	volatile.StoreUint32(&o.DMAFRMCFG.Reg, volatile.LoadUint32(&o.DMAFRMCFG.Reg)&^(0x7fffff)|value)
}
func (o *LCDC_Type) GetDMAFRMCFG_FRMSIZE() uint32 {
	return volatile.LoadUint32(&o.DMAFRMCFG.Reg) & 0x7fffff
}
func (o *LCDC_Type) SetDMAFRMCFG_BRSTLN(value uint32) {
	volatile.StoreUint32(&o.DMAFRMCFG.Reg, volatile.LoadUint32(&o.DMAFRMCFG.Reg)&^(0x7f000000)|value<<24)
}
func (o *LCDC_Type) GetDMAFRMCFG_BRSTLN() uint32 {
	return (volatile.LoadUint32(&o.DMAFRMCFG.Reg) & 0x7f000000) >> 24
}

// LCDC.DMACON: DMA Control Register
func (o *LCDC_Type) SetDMACON_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMACON.Reg, volatile.LoadUint32(&o.DMACON.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetDMACON_DMAEN() uint32 {
	return volatile.LoadUint32(&o.DMACON.Reg) & 0x1
}
func (o *LCDC_Type) SetDMACON_DMARST(value uint32) {
	volatile.StoreUint32(&o.DMACON.Reg, volatile.LoadUint32(&o.DMACON.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetDMACON_DMARST() uint32 {
	return (volatile.LoadUint32(&o.DMACON.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetDMACON_DMABUSY(value uint32) {
	volatile.StoreUint32(&o.DMACON.Reg, volatile.LoadUint32(&o.DMACON.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetDMACON_DMABUSY() uint32 {
	return (volatile.LoadUint32(&o.DMACON.Reg) & 0x4) >> 2
}

// LCDC.LCDCON1: LCD Control Register 1
func (o *LCDC_Type) SetLCDCON1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.LCDCON1.Reg, volatile.LoadUint32(&o.LCDCON1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDCON1_BYPASS() uint32 {
	return volatile.LoadUint32(&o.LCDCON1.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDCON1_CLKVAL(value uint32) {
	volatile.StoreUint32(&o.LCDCON1.Reg, volatile.LoadUint32(&o.LCDCON1.Reg)&^(0x1ff000)|value<<12)
}
func (o *LCDC_Type) GetLCDCON1_CLKVAL() uint32 {
	return (volatile.LoadUint32(&o.LCDCON1.Reg) & 0x1ff000) >> 12
}
func (o *LCDC_Type) SetLCDCON1_LINECNT(value uint32) {
	volatile.StoreUint32(&o.LCDCON1.Reg, volatile.LoadUint32(&o.LCDCON1.Reg)&^(0xffe00000)|value<<21)
}
func (o *LCDC_Type) GetLCDCON1_LINECNT() uint32 {
	return (volatile.LoadUint32(&o.LCDCON1.Reg) & 0xffe00000) >> 21
}

// LCDC.LCDCON2: LCD Control Register 2
func (o *LCDC_Type) SetLCDCON2_DISTYPE(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x3)|value)
}
func (o *LCDC_Type) GetLCDCON2_DISTYPE() uint32 {
	return volatile.LoadUint32(&o.LCDCON2.Reg) & 0x3
}
func (o *LCDC_Type) SetLCDCON2_SCANMOD(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDCON2_SCANMOD() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDCON2_IFWIDTH(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x18)|value<<3)
}
func (o *LCDC_Type) GetLCDCON2_IFWIDTH() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x18) >> 3
}
func (o *LCDC_Type) SetLCDCON2_PIXELSIZE(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0xe0)|value<<5)
}
func (o *LCDC_Type) GetLCDCON2_PIXELSIZE() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0xe0) >> 5
}
func (o *LCDC_Type) SetLCDCON2_INVVD(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDCON2_INVVD() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDCON2_INVFRAME(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDCON2_INVFRAME() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDCON2_INVLINE(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDCON2_INVLINE() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDCON2_INVCLK(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDCON2_INVCLK() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetLCDCON2_INVDVAL(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDCON2_INVDVAL() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDCON2_CLKMOD(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x8000)|value<<15)
}
func (o *LCDC_Type) GetLCDCON2_CLKMOD() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x8000) >> 15
}
func (o *LCDC_Type) SetLCDCON2_MEMOR(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0xc0000000)|value<<30)
}
func (o *LCDC_Type) GetLCDCON2_MEMOR() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0xc0000000) >> 30
}

// LCDC.LCDTIM1: LCD Timing Register 1
func (o *LCDC_Type) SetLCDTIM1_VFP(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetLCDTIM1_VFP() uint32 {
	return volatile.LoadUint32(&o.LCDTIM1.Reg) & 0xff
}
func (o *LCDC_Type) SetLCDTIM1_VBP(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetLCDTIM1_VBP() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM1.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetLCDTIM1_VPW(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0x3f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDTIM1_VPW() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM1.Reg) & 0x3f0000) >> 16
}
func (o *LCDC_Type) SetLCDTIM1_VHDLY(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0xf000000)|value<<24)
}
func (o *LCDC_Type) GetLCDTIM1_VHDLY() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM1.Reg) & 0xf000000) >> 24
}
func (o *LCDC_Type) SetLCDTIM1_STUCKTO1(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0x80000000)|value<<31)
}
func (o *LCDC_Type) GetLCDTIM1_STUCKTO1() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM1.Reg) & 0x80000000) >> 31
}

// LCDC.LCDTIM2: LCD Timing Register 2
func (o *LCDC_Type) SetLCDTIM2_HBP(value uint32) {
	volatile.StoreUint32(&o.LCDTIM2.Reg, volatile.LoadUint32(&o.LCDTIM2.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetLCDTIM2_HBP() uint32 {
	return volatile.LoadUint32(&o.LCDTIM2.Reg) & 0xff
}
func (o *LCDC_Type) SetLCDTIM2_HPW(value uint32) {
	volatile.StoreUint32(&o.LCDTIM2.Reg, volatile.LoadUint32(&o.LCDTIM2.Reg)&^(0x3f00)|value<<8)
}
func (o *LCDC_Type) GetLCDTIM2_HPW() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM2.Reg) & 0x3f00) >> 8
}
func (o *LCDC_Type) SetLCDTIM2_HFP(value uint32) {
	volatile.StoreUint32(&o.LCDTIM2.Reg, volatile.LoadUint32(&o.LCDTIM2.Reg)&^(0xffe00000)|value<<21)
}
func (o *LCDC_Type) GetLCDTIM2_HFP() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM2.Reg) & 0xffe00000) >> 21
}

// LCDC.LCDFRMCFG: LCD Frame Configuration Register
func (o *LCDC_Type) SetLCDFRMCFG_LINEVAL(value uint32) {
	volatile.StoreUint32(&o.LCDFRMCFG.Reg, volatile.LoadUint32(&o.LCDFRMCFG.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetLCDFRMCFG_LINEVAL() uint32 {
	return volatile.LoadUint32(&o.LCDFRMCFG.Reg) & 0x7ff
}
func (o *LCDC_Type) SetLCDFRMCFG_HOZVAL(value uint32) {
	volatile.StoreUint32(&o.LCDFRMCFG.Reg, volatile.LoadUint32(&o.LCDFRMCFG.Reg)&^(0xffe00000)|value<<21)
}
func (o *LCDC_Type) GetLCDFRMCFG_HOZVAL() uint32 {
	return (volatile.LoadUint32(&o.LCDFRMCFG.Reg) & 0xffe00000) >> 21
}

// LCDC.LCDFIFO: LCD FIFO Register
func (o *LCDC_Type) SetLCDFIFO_FIFOTH(value uint32) {
	volatile.StoreUint32(&o.LCDFIFO.Reg, volatile.LoadUint32(&o.LCDFIFO.Reg)&^(0xffff)|value)
}
func (o *LCDC_Type) GetLCDFIFO_FIFOTH() uint32 {
	return volatile.LoadUint32(&o.LCDFIFO.Reg) & 0xffff
}

// LCDC.LCDMVAL: LCDMOD Toggle Rate Value Register
func (o *LCDC_Type) SetLCDMVAL_MVAL(value uint32) {
	volatile.StoreUint32(&o.LCDMVAL.Reg, volatile.LoadUint32(&o.LCDMVAL.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetLCDMVAL_MVAL() uint32 {
	return volatile.LoadUint32(&o.LCDMVAL.Reg) & 0xff
}
func (o *LCDC_Type) SetLCDMVAL_MMODE(value uint32) {
	volatile.StoreUint32(&o.LCDMVAL.Reg, volatile.LoadUint32(&o.LCDMVAL.Reg)&^(0x80000000)|value<<31)
}
func (o *LCDC_Type) GetLCDMVAL_MMODE() uint32 {
	return (volatile.LoadUint32(&o.LCDMVAL.Reg) & 0x80000000) >> 31
}

// LCDC.DP1_2: Dithering Pattern DP1_2
func (o *LCDC_Type) SetDP1_2(value uint32) {
	volatile.StoreUint32(&o.DP1_2.Reg, volatile.LoadUint32(&o.DP1_2.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetDP1_2() uint32 {
	return volatile.LoadUint32(&o.DP1_2.Reg) & 0xff
}

// LCDC.DP4_7: Dithering Pattern DP4_7
func (o *LCDC_Type) SetDP4_7(value uint32) {
	volatile.StoreUint32(&o.DP4_7.Reg, volatile.LoadUint32(&o.DP4_7.Reg)&^(0xfffffff)|value)
}
func (o *LCDC_Type) GetDP4_7() uint32 {
	return volatile.LoadUint32(&o.DP4_7.Reg) & 0xfffffff
}

// LCDC.DP3_5: Dithering Pattern DP3_5
func (o *LCDC_Type) SetDP3_5(value uint32) {
	volatile.StoreUint32(&o.DP3_5.Reg, volatile.LoadUint32(&o.DP3_5.Reg)&^(0xfffff)|value)
}
func (o *LCDC_Type) GetDP3_5() uint32 {
	return volatile.LoadUint32(&o.DP3_5.Reg) & 0xfffff
}

// LCDC.DP2_3: Dithering Pattern DP2_3
func (o *LCDC_Type) SetDP2_3(value uint32) {
	volatile.StoreUint32(&o.DP2_3.Reg, volatile.LoadUint32(&o.DP2_3.Reg)&^(0xfff)|value)
}
func (o *LCDC_Type) GetDP2_3() uint32 {
	return volatile.LoadUint32(&o.DP2_3.Reg) & 0xfff
}

// LCDC.DP5_7: Dithering Pattern DP5_7
func (o *LCDC_Type) SetDP5_7(value uint32) {
	volatile.StoreUint32(&o.DP5_7.Reg, volatile.LoadUint32(&o.DP5_7.Reg)&^(0xfffffff)|value)
}
func (o *LCDC_Type) GetDP5_7() uint32 {
	return volatile.LoadUint32(&o.DP5_7.Reg) & 0xfffffff
}

// LCDC.DP3_4: Dithering Pattern DP3_4
func (o *LCDC_Type) SetDP3_4(value uint32) {
	volatile.StoreUint32(&o.DP3_4.Reg, volatile.LoadUint32(&o.DP3_4.Reg)&^(0xffff)|value)
}
func (o *LCDC_Type) GetDP3_4() uint32 {
	return volatile.LoadUint32(&o.DP3_4.Reg) & 0xffff
}

// LCDC.DP4_5: Dithering Pattern DP4_5
func (o *LCDC_Type) SetDP4_5(value uint32) {
	volatile.StoreUint32(&o.DP4_5.Reg, volatile.LoadUint32(&o.DP4_5.Reg)&^(0xfffff)|value)
}
func (o *LCDC_Type) GetDP4_5() uint32 {
	return volatile.LoadUint32(&o.DP4_5.Reg) & 0xfffff
}

// LCDC.DP6_7: Dithering Pattern DP6_7
func (o *LCDC_Type) SetDP6_7(value uint32) {
	volatile.StoreUint32(&o.DP6_7.Reg, volatile.LoadUint32(&o.DP6_7.Reg)&^(0xfffffff)|value)
}
func (o *LCDC_Type) GetDP6_7() uint32 {
	return volatile.LoadUint32(&o.DP6_7.Reg) & 0xfffffff
}

// LCDC.PWRCON: Power Control Register
func (o *LCDC_Type) SetPWRCON_LCD_PWR(value uint32) {
	volatile.StoreUint32(&o.PWRCON.Reg, volatile.LoadUint32(&o.PWRCON.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetPWRCON_LCD_PWR() uint32 {
	return volatile.LoadUint32(&o.PWRCON.Reg) & 0x1
}
func (o *LCDC_Type) SetPWRCON_GUARD_TIME(value uint32) {
	volatile.StoreUint32(&o.PWRCON.Reg, volatile.LoadUint32(&o.PWRCON.Reg)&^(0xfe)|value<<1)
}
func (o *LCDC_Type) GetPWRCON_GUARD_TIME() uint32 {
	return (volatile.LoadUint32(&o.PWRCON.Reg) & 0xfe) >> 1
}
func (o *LCDC_Type) SetPWRCON_LCD_BUSY(value uint32) {
	volatile.StoreUint32(&o.PWRCON.Reg, volatile.LoadUint32(&o.PWRCON.Reg)&^(0x80000000)|value<<31)
}
func (o *LCDC_Type) GetPWRCON_LCD_BUSY() uint32 {
	return (volatile.LoadUint32(&o.PWRCON.Reg) & 0x80000000) >> 31
}

// LCDC.CONTRAST_CTR: Contrast Control Register
func (o *LCDC_Type) SetCONTRAST_CTR_PS(value uint32) {
	volatile.StoreUint32(&o.CONTRAST_CTR.Reg, volatile.LoadUint32(&o.CONTRAST_CTR.Reg)&^(0x3)|value)
}
func (o *LCDC_Type) GetCONTRAST_CTR_PS() uint32 {
	return volatile.LoadUint32(&o.CONTRAST_CTR.Reg) & 0x3
}
func (o *LCDC_Type) SetCONTRAST_CTR_POL(value uint32) {
	volatile.StoreUint32(&o.CONTRAST_CTR.Reg, volatile.LoadUint32(&o.CONTRAST_CTR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetCONTRAST_CTR_POL() uint32 {
	return (volatile.LoadUint32(&o.CONTRAST_CTR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetCONTRAST_CTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CONTRAST_CTR.Reg, volatile.LoadUint32(&o.CONTRAST_CTR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetCONTRAST_CTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CONTRAST_CTR.Reg) & 0x8) >> 3
}

// LCDC.LCD_IER: LCD Interrupt Enable Register
func (o *LCDC_Type) SetLCD_IER_LNIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_IER_LNIE() uint32 {
	return volatile.LoadUint32(&o.LCD_IER.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_IER_LSTLNIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_IER_LSTLNIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_IER_EOFIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_IER_EOFIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_IER_UFLWIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_IER_UFLWIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_IER_OWRIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_IER_OWRIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_IER_MERIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_IER_MERIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x40) >> 6
}

// LCDC.LCD_IDR: LCD Interrupt Disable Register
func (o *LCDC_Type) SetLCD_IDR_LNID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_IDR_LNID() uint32 {
	return volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_IDR_LSTLNID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_IDR_LSTLNID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_IDR_EOFID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_IDR_EOFID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_IDR_UFLWID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_IDR_UFLWID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_IDR_OWRID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_IDR_OWRID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_IDR_MERID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_IDR_MERID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x40) >> 6
}

// LCDC.LCD_IMR: LCD Interrupt Mask Register
func (o *LCDC_Type) SetLCD_IMR_LNIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_IMR_LNIM() uint32 {
	return volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_IMR_LSTLNIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_IMR_LSTLNIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_IMR_EOFIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_IMR_EOFIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_IMR_UFLWIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_IMR_UFLWIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_IMR_OWRIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_IMR_OWRIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_IMR_MERIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_IMR_MERIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x40) >> 6
}

// LCDC.LCD_ISR: LCD Interrupt Status Register
func (o *LCDC_Type) SetLCD_ISR_LNIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_ISR_LNIS() uint32 {
	return volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_ISR_LSTLNIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_ISR_LSTLNIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_ISR_EOFIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_ISR_EOFIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_ISR_UFLWIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_ISR_UFLWIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_ISR_OWRIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_ISR_OWRIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_ISR_MERIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_ISR_MERIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x40) >> 6
}

// LCDC.LCD_ICR: LCD Interrupt Clear Register
func (o *LCDC_Type) SetLCD_ICR_LNIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_ICR_LNIC() uint32 {
	return volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_ICR_LSTLNIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_ICR_LSTLNIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_ICR_EOFIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_ICR_EOFIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_ICR_UFLWIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_ICR_UFLWIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_ICR_OWRIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_ICR_OWRIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_ICR_MERIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_ICR_MERIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x40) >> 6
}

// LCDC.LCD_WPSR: Write Protection Status Register
func (o *LCDC_Type) SetLCD_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.LCD_WPSR.Reg, volatile.LoadUint32(&o.LCD_WPSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.LCD_WPSR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.LCD_WPSR.Reg, volatile.LoadUint32(&o.LCD_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *LCDC_Type) GetLCD_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.LCD_WPSR.Reg) & 0xffff00) >> 8
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [8]byte
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [8]byte
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [8]byte
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, value)
}
func (o *TC_Type) GetCV0() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg)
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, value)
}
func (o *TC_Type) GetRA0() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg)
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, value)
}
func (o *TC_Type) GetRB0() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg)
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, value)
}
func (o *TC_Type) GetRC0() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg)
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, value)
}
func (o *TC_Type) GetCV1() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg)
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, value)
}
func (o *TC_Type) GetRA1() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg)
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, value)
}
func (o *TC_Type) GetRB1() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg)
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, value)
}
func (o *TC_Type) GetRC1() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg)
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, value)
}
func (o *TC_Type) GetCV2() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg)
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, value)
}
func (o *TC_Type) GetRA2() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg)
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, value)
}
func (o *TC_Type) GetRB2() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg)
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, value)
}
func (o *TC_Type) GetRC2() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg)
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}

// USB Device Port
type UDP_Type struct {
	FRM_NUM  volatile.Register32 // 0x0
	GLB_STAT volatile.Register32 // 0x4
	FADDR    volatile.Register32 // 0x8
	_        [4]byte
	IER      volatile.Register32 // 0x10
	IDR      volatile.Register32 // 0x14
	IMR      volatile.Register32 // 0x18
	ISR      volatile.Register32 // 0x1C
	ICR      volatile.Register32 // 0x20
	_        [4]byte
	RST_EP   volatile.Register32    // 0x28
	CSR      [6]volatile.Register32 // 0x2C
	_        [8]byte
	FDR      [6]volatile.Register32 // 0x4C
	_        [16]byte
	TXVC     volatile.Register32 // 0x74
}

// UDP.FRM_NUM: Frame Number Register
func (o *UDP_Type) SetFRM_NUM(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x7ff)|value)
}
func (o *UDP_Type) GetFRM_NUM() uint32 {
	return volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x7ff
}
func (o *UDP_Type) SetFRM_NUM_FRM_ERR(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x10000)|value<<16)
}
func (o *UDP_Type) GetFRM_NUM_FRM_ERR() uint32 {
	return (volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x10000) >> 16
}
func (o *UDP_Type) SetFRM_NUM_FRM_OK(value uint32) {
	volatile.StoreUint32(&o.FRM_NUM.Reg, volatile.LoadUint32(&o.FRM_NUM.Reg)&^(0x20000)|value<<17)
}
func (o *UDP_Type) GetFRM_NUM_FRM_OK() uint32 {
	return (volatile.LoadUint32(&o.FRM_NUM.Reg) & 0x20000) >> 17
}

// UDP.GLB_STAT: Global State Register
func (o *UDP_Type) SetGLB_STAT_FADDEN(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetGLB_STAT_FADDEN() uint32 {
	return volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x1
}
func (o *UDP_Type) SetGLB_STAT_CONFG(value uint32) {
	volatile.StoreUint32(&o.GLB_STAT.Reg, volatile.LoadUint32(&o.GLB_STAT.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetGLB_STAT_CONFG() uint32 {
	return (volatile.LoadUint32(&o.GLB_STAT.Reg) & 0x2) >> 1
}

// UDP.FADDR: Function Address Register
func (o *UDP_Type) SetFADDR_FADD(value uint32) {
	volatile.StoreUint32(&o.FADDR.Reg, volatile.LoadUint32(&o.FADDR.Reg)&^(0x7f)|value)
}
func (o *UDP_Type) GetFADDR_FADD() uint32 {
	return volatile.LoadUint32(&o.FADDR.Reg) & 0x7f
}
func (o *UDP_Type) SetFADDR_FEN(value uint32) {
	volatile.StoreUint32(&o.FADDR.Reg, volatile.LoadUint32(&o.FADDR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetFADDR_FEN() uint32 {
	return (volatile.LoadUint32(&o.FADDR.Reg) & 0x100) >> 8
}

// UDP.IER: Interrupt Enable Register
func (o *UDP_Type) SetIER_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIER_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UDP_Type) SetIER_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIER_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIER_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIER_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIER_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIER_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIER_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIER_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIER_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIER_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIER_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIER_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIER_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIER_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIER_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIER_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIER_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIER_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}

// UDP.IDR: Interrupt Disable Register
func (o *UDP_Type) SetIDR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIDR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UDP_Type) SetIDR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIDR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIDR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIDR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIDR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIDR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIDR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIDR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIDR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIDR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIDR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIDR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIDR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIDR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIDR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIDR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIDR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIDR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}

// UDP.IMR: Interrupt Mask Register
func (o *UDP_Type) SetIMR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetIMR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UDP_Type) SetIMR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetIMR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetIMR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetIMR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetIMR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetIMR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetIMR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetIMR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetIMR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetIMR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetIMR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetIMR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetIMR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetIMR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetIMR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetIMR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetIMR_BIT12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetIMR_BIT12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetIMR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetIMR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}

// UDP.ISR: Interrupt Status Register
func (o *UDP_Type) SetISR_EP0INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetISR_EP0INT() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *UDP_Type) SetISR_EP1INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetISR_EP1INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetISR_EP2INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetISR_EP2INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetISR_EP3INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetISR_EP3INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetISR_EP4INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetISR_EP4INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetISR_EP5INT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetISR_EP5INT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetISR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetISR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetISR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetISR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetISR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetISR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetISR_ENDBUSRES(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetISR_ENDBUSRES() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetISR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetISR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}

// UDP.ICR: Interrupt Clear Register
func (o *UDP_Type) SetICR_RXSUSP(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetICR_RXSUSP() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *UDP_Type) SetICR_RXRSM(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *UDP_Type) GetICR_RXRSM() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *UDP_Type) SetICR_SOFINT(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetICR_SOFINT() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetICR_ENDBUSRES(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *UDP_Type) GetICR_ENDBUSRES() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *UDP_Type) SetICR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *UDP_Type) GetICR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}

// UDP.RST_EP: Reset Endpoint Register
func (o *UDP_Type) SetRST_EP_EP0(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetRST_EP_EP0() uint32 {
	return volatile.LoadUint32(&o.RST_EP.Reg) & 0x1
}
func (o *UDP_Type) SetRST_EP_EP1(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetRST_EP_EP1() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetRST_EP_EP2(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetRST_EP_EP2() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetRST_EP_EP3(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetRST_EP_EP3() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetRST_EP_EP4(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetRST_EP_EP4() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetRST_EP_EP5(value uint32) {
	volatile.StoreUint32(&o.RST_EP.Reg, volatile.LoadUint32(&o.RST_EP.Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetRST_EP_EP5() uint32 {
	return (volatile.LoadUint32(&o.RST_EP.Reg) & 0x20) >> 5
}

// UDP.CSR: Endpoint Control and Status Register (ept_num = 0)
func (o *UDP_Type) SetCSR_TXCOMP(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *UDP_Type) GetCSR_TXCOMP(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *UDP_Type) SetCSR_RX_DATA_BK0(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *UDP_Type) GetCSR_RX_DATA_BK0(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *UDP_Type) SetCSR_RXSETUP(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *UDP_Type) GetCSR_RXSETUP(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *UDP_Type) SetCSR_STALLSENTISOERROR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *UDP_Type) GetCSR_STALLSENTISOERROR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *UDP_Type) SetCSR_TXPKTRDY(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *UDP_Type) GetCSR_TXPKTRDY(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x10) >> 4
}
func (o *UDP_Type) SetCSR_FORCESTALL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *UDP_Type) GetCSR_FORCESTALL(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x20) >> 5
}
func (o *UDP_Type) SetCSR_RX_DATA_BK1(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *UDP_Type) GetCSR_RX_DATA_BK1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x40) >> 6
}
func (o *UDP_Type) SetCSR_DIR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *UDP_Type) GetCSR_DIR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x80) >> 7
}
func (o *UDP_Type) SetCSR_EPTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x700)|value<<8)
}
func (o *UDP_Type) GetCSR_EPTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x700) >> 8
}
func (o *UDP_Type) SetCSR_DTGLE(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *UDP_Type) GetCSR_DTGLE(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x800) >> 11
}
func (o *UDP_Type) SetCSR_EPEDS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *UDP_Type) GetCSR_EPEDS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8000) >> 15
}
func (o *UDP_Type) SetCSR_RXBYTECNT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x7ff0000)|value<<16)
}
func (o *UDP_Type) GetCSR_RXBYTECNT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x7ff0000) >> 16
}

// UDP.FDR: Endpoint FIFO Data Register (ept_num = 0)
func (o *UDP_Type) SetFDR_FIFO_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.FDR[idx].Reg, volatile.LoadUint32(&o.FDR[idx].Reg)&^(0xff)|value)
}
func (o *UDP_Type) GetFDR_FIFO_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.FDR[idx].Reg) & 0xff
}

// UDP.TXVC: Transceiver Control Register
func (o *UDP_Type) SetTXVC_TXVDIS(value uint32) {
	volatile.StoreUint32(&o.TXVC.Reg, volatile.LoadUint32(&o.TXVC.Reg)&^(0x100)|value<<8)
}
func (o *UDP_Type) GetTXVC_TXVDIS() uint32 {
	return (volatile.LoadUint32(&o.TXVC.Reg) & 0x100) >> 8
}

// MultiMedia Card Interface
type MCI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	DTOR volatile.Register32 // 0x8
	SDCR volatile.Register32 // 0xC
	ARGR volatile.Register32 // 0x10
	CMDR volatile.Register32 // 0x14
	BLKR volatile.Register32 // 0x18
	_    [4]byte
	RSPR [4]volatile.Register32 // 0x20
	RDR  volatile.Register32    // 0x30
	TDR  volatile.Register32    // 0x34
	_    [8]byte
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [176]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// MCI.CR: Control Register
func (o *MCI_Type) SetCR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *MCI_Type) GetCR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *MCI_Type) SetCR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *MCI_Type) GetCR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *MCI_Type) SetCR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *MCI_Type) GetCR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *MCI_Type) SetCR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *MCI_Type) GetCR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *MCI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *MCI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// MCI.MR: Mode Register
func (o *MCI_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *MCI_Type) GetMR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *MCI_Type) SetMR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *MCI_Type) GetMR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *MCI_Type) SetMR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800)|value<<11)
}
func (o *MCI_Type) GetMR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800) >> 11
}
func (o *MCI_Type) SetMR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *MCI_Type) GetMR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *MCI_Type) SetMR_PDCFBYTE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *MCI_Type) GetMR_PDCFBYTE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *MCI_Type) SetMR_PDCPADV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *MCI_Type) GetMR_PDCPADV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}
func (o *MCI_Type) SetMR_PDCMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *MCI_Type) GetMR_PDCMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}
func (o *MCI_Type) SetMR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCI_Type) GetMR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xffff0000) >> 16
}

// MCI.DTOR: Data Timeout Register
func (o *MCI_Type) SetDTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0xf)|value)
}
func (o *MCI_Type) GetDTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.DTOR.Reg) & 0xf
}
func (o *MCI_Type) SetDTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0x70)|value<<4)
}
func (o *MCI_Type) GetDTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.DTOR.Reg) & 0x70) >> 4
}

// MCI.SDCR: SD/SDIO Card Register
func (o *MCI_Type) SetSDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *MCI_Type) GetSDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *MCI_Type) SetSDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x80)|value<<7)
}
func (o *MCI_Type) GetSDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0x80) >> 7
}

// MCI.ARGR: Argument Register
func (o *MCI_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *MCI_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// MCI.CMDR: Command Register
func (o *MCI_Type) SetCMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *MCI_Type) GetCMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *MCI_Type) SetCMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *MCI_Type) GetCMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0xc0) >> 6
}
func (o *MCI_Type) SetCMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x700)|value<<8)
}
func (o *MCI_Type) GetCMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x700) >> 8
}
func (o *MCI_Type) SetCMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *MCI_Type) GetCMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *MCI_Type) SetCMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *MCI_Type) GetCMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *MCI_Type) SetCMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *MCI_Type) GetCMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x30000) >> 16
}
func (o *MCI_Type) SetCMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *MCI_Type) GetCMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40000) >> 18
}
func (o *MCI_Type) SetCMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *MCI_Type) GetCMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x380000) >> 19
}
func (o *MCI_Type) SetCMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *MCI_Type) GetCMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x3000000) >> 24
}

// MCI.BLKR: Block Register
func (o *MCI_Type) SetBLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff)|value)
}
func (o *MCI_Type) GetBLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.BLKR.Reg) & 0xffff
}
func (o *MCI_Type) SetBLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCI_Type) GetBLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.BLKR.Reg) & 0xffff0000) >> 16
}

// MCI.RSPR: Response Register
func (o *MCI_Type) SetRSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.RSPR[idx].Reg, value)
}
func (o *MCI_Type) GetRSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.RSPR[idx].Reg)
}

// MCI.RDR: Receive Data Register
func (o *MCI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *MCI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// MCI.TDR: Transmit Data Register
func (o *MCI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *MCI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// MCI.SR: Status Register
func (o *MCI_Type) SetSR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *MCI_Type) GetSR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *MCI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *MCI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *MCI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *MCI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *MCI_Type) SetSR_BLKE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *MCI_Type) GetSR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *MCI_Type) SetSR_DTIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *MCI_Type) GetSR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *MCI_Type) SetSR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *MCI_Type) GetSR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *MCI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *MCI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *MCI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *MCI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *MCI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *MCI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *MCI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *MCI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *MCI_Type) SetSR_RINDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *MCI_Type) GetSR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *MCI_Type) SetSR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *MCI_Type) GetSR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *MCI_Type) SetSR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *MCI_Type) GetSR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *MCI_Type) SetSR_RENDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *MCI_Type) GetSR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *MCI_Type) SetSR_RTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *MCI_Type) GetSR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *MCI_Type) SetSR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *MCI_Type) GetSR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *MCI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *MCI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *MCI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *MCI_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCI_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// MCI.IER: Interrupt Enable Register
func (o *MCI_Type) SetIER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *MCI_Type) GetIER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *MCI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *MCI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *MCI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *MCI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *MCI_Type) SetIER_BLKE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *MCI_Type) GetIER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *MCI_Type) SetIER_DTIP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *MCI_Type) GetIER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *MCI_Type) SetIER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *MCI_Type) GetIER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *MCI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *MCI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *MCI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *MCI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *MCI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *MCI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *MCI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *MCI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *MCI_Type) SetIER_RINDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *MCI_Type) GetIER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *MCI_Type) SetIER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *MCI_Type) GetIER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *MCI_Type) SetIER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *MCI_Type) GetIER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *MCI_Type) SetIER_RENDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *MCI_Type) GetIER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *MCI_Type) SetIER_RTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *MCI_Type) GetIER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *MCI_Type) SetIER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *MCI_Type) GetIER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *MCI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *MCI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *MCI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *MCI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *MCI_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *MCI_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// MCI.IDR: Interrupt Disable Register
func (o *MCI_Type) SetIDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *MCI_Type) GetIDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *MCI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *MCI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *MCI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *MCI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *MCI_Type) SetIDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *MCI_Type) GetIDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *MCI_Type) SetIDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *MCI_Type) GetIDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *MCI_Type) SetIDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *MCI_Type) GetIDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *MCI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *MCI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *MCI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *MCI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *MCI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *MCI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *MCI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *MCI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *MCI_Type) SetIDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *MCI_Type) GetIDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *MCI_Type) SetIDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *MCI_Type) GetIDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *MCI_Type) SetIDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *MCI_Type) GetIDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *MCI_Type) SetIDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *MCI_Type) GetIDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *MCI_Type) SetIDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *MCI_Type) GetIDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *MCI_Type) SetIDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *MCI_Type) GetIDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *MCI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *MCI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *MCI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *MCI_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCI_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// MCI.IMR: Interrupt Mask Register
func (o *MCI_Type) SetIMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *MCI_Type) GetIMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *MCI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *MCI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *MCI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *MCI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *MCI_Type) SetIMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *MCI_Type) GetIMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *MCI_Type) SetIMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *MCI_Type) GetIMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *MCI_Type) SetIMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *MCI_Type) GetIMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *MCI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *MCI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *MCI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *MCI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *MCI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *MCI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *MCI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *MCI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *MCI_Type) SetIMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *MCI_Type) GetIMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *MCI_Type) SetIMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *MCI_Type) GetIMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *MCI_Type) SetIMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *MCI_Type) GetIMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *MCI_Type) SetIMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *MCI_Type) GetIMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *MCI_Type) SetIMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *MCI_Type) GetIMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *MCI_Type) SetIMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *MCI_Type) GetIMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *MCI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *MCI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *MCI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *MCI_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCI_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// MCI.RPR: Receive Pointer Register
func (o *MCI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *MCI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// MCI.RCR: Receive Counter Register
func (o *MCI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *MCI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// MCI.TPR: Transmit Pointer Register
func (o *MCI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *MCI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// MCI.TCR: Transmit Counter Register
func (o *MCI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *MCI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// MCI.RNPR: Receive Next Pointer Register
func (o *MCI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *MCI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// MCI.RNCR: Receive Next Counter Register
func (o *MCI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *MCI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// MCI.TNPR: Transmit Next Pointer Register
func (o *MCI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *MCI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// MCI.TNCR: Transmit Next Counter Register
func (o *MCI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *MCI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// MCI.PTCR: Transfer Control Register
func (o *MCI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *MCI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *MCI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *MCI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *MCI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *MCI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *MCI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *MCI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// MCI.PTSR: Transfer Status Register
func (o *MCI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *MCI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *MCI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *MCI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Two-wire Interface
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [172]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetMR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMR_MAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMR_MAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetMR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetMR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCSR_RR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCSR_RR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// USART.RHR: Receiver Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmitter Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0x7ff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0x7ff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.MAN: Manchester Encoder Decoder Register
func (o *USART_Type) SetMAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xf
}
func (o *USART_Type) SetMAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetMAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetMAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetMAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetMAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetMAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetMAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetMAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetMAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMAN_ONE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}

// USART.RPR: Receive Pointer Register
func (o *USART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *USART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// USART.RCR: Receive Counter Register
func (o *USART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// USART.TPR: Transmit Pointer Register
func (o *USART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *USART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// USART.TCR: Transmit Counter Register
func (o *USART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// USART.RNPR: Receive Next Pointer Register
func (o *USART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *USART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// USART.RNCR: Receive Next Counter Register
func (o *USART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// USART.TNPR: Transmit Next Pointer Register
func (o *USART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *USART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// USART.TNCR: Transmit Next Counter Register
func (o *USART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// USART.PTCR: Transfer Control Register
func (o *USART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *USART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// USART.PTSR: Transfer Status Register
func (o *USART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *USART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Synchronous Serial Controller 0
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [176]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.RPR: Receive Pointer Register
func (o *SSC_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *SSC_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// SSC.RCR: Receive Counter Register
func (o *SSC_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// SSC.TPR: Transmit Pointer Register
func (o *SSC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *SSC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// SSC.TCR: Transmit Counter Register
func (o *SSC_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// SSC.RNPR: Receive Next Pointer Register
func (o *SSC_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *SSC_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// SSC.RNCR: Receive Next Counter Register
func (o *SSC_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// SSC.TNPR: Transmit Next Pointer Register
func (o *SSC_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *SSC_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// SSC.TNCR: Transmit Next Counter Register
func (o *SSC_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// SSC.PTCR: Transfer Control Register
func (o *SSC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *SSC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// SSC.PTSR: Transfer Status Register
func (o *SSC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *SSC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [192]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.RPR: Receive Pointer Register
func (o *SPI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *SPI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// SPI.RCR: Receive Counter Register
func (o *SPI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// SPI.TPR: Transmit Pointer Register
func (o *SPI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *SPI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// SPI.TCR: Transmit Counter Register
func (o *SPI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// SPI.RNPR: Receive Next Pointer Register
func (o *SPI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *SPI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// SPI.RNCR: Receive Next Counter Register
func (o *SPI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// SPI.TNPR: Transmit Next Pointer Register
func (o *SPI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *SPI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// SPI.TNCR: Transmit Next Counter Register
func (o *SPI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// SPI.PTCR: Transfer Control Register
func (o *SPI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *SPI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// SPI.PTSR: Transfer Status Register
func (o *SPI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *SPI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// SDRAM Controller
type EBI_Type struct {
	MR  volatile.Register32 // 0x0
	TR  volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
	_   [4]byte
	LPR volatile.Register32 // 0x10
	IER volatile.Register32 // 0x14
	IDR volatile.Register32 // 0x18
	IMR volatile.Register32 // 0x1C
	ISR volatile.Register32 // 0x20
	MDR volatile.Register32 // 0x24
}

// EBI.MR: SDRAMC Mode Register
func (o *EBI_Type) SetMR_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetMR_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x7
}

// EBI.TR: SDRAMC Refresh Timer Register
func (o *EBI_Type) SetTR_COUNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xfff)|value)
}
func (o *EBI_Type) GetTR_COUNT() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xfff
}

// EBI.CR: SDRAMC Configuration Register
func (o *EBI_Type) SetCR_NC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3)|value)
}
func (o *EBI_Type) GetCR_NC() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3
}
func (o *EBI_Type) SetCR_NR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc)|value<<2)
}
func (o *EBI_Type) GetCR_NR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc) >> 2
}
func (o *EBI_Type) SetCR_NB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetCR_NB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *EBI_Type) SetCR_CAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *EBI_Type) GetCR_CAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *EBI_Type) SetCR_DBW(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *EBI_Type) GetCR_DBW() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *EBI_Type) SetCR_TWR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *EBI_Type) GetCR_TWR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *EBI_Type) SetCR_TRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000)|value<<12)
}
func (o *EBI_Type) GetCR_TRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000) >> 12
}
func (o *EBI_Type) SetCR_TRP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetCR_TRP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetCR_TRCD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00000)|value<<20)
}
func (o *EBI_Type) GetCR_TRCD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00000) >> 20
}
func (o *EBI_Type) SetCR_TRAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *EBI_Type) GetCR_TRAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *EBI_Type) SetCR_TXSR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *EBI_Type) GetCR_TXSR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0000000) >> 28
}

// EBI.LPR: SDRAMC Low Power Register
func (o *EBI_Type) SetLPR_LPCB(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x3)|value)
}
func (o *EBI_Type) GetLPR_LPCB() uint32 {
	return volatile.LoadUint32(&o.LPR.Reg) & 0x3
}
func (o *EBI_Type) SetLPR_PASR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x70)|value<<4)
}
func (o *EBI_Type) GetLPR_PASR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x70) >> 4
}
func (o *EBI_Type) SetLPR_TCSR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x300)|value<<8)
}
func (o *EBI_Type) GetLPR_TCSR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x300) >> 8
}
func (o *EBI_Type) SetLPR_DS(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0xc00)|value<<10)
}
func (o *EBI_Type) GetLPR_DS() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0xc00) >> 10
}
func (o *EBI_Type) SetLPR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x3000)|value<<12)
}
func (o *EBI_Type) GetLPR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x3000) >> 12
}

// EBI.IER: SDRAMC Interrupt Enable Register
func (o *EBI_Type) SetIER_RES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIER_RES() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// EBI.IDR: SDRAMC Interrupt Disable Register
func (o *EBI_Type) SetIDR_RES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIDR_RES() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// EBI.IMR: SDRAMC Interrupt Mask Register
func (o *EBI_Type) SetIMR_RES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetIMR_RES() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// EBI.ISR: SDRAMC Interrupt Status Register
func (o *EBI_Type) SetISR_RES(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetISR_RES() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// EBI.MDR: SDRAMC Memory Device Register
func (o *EBI_Type) SetMDR_MD(value uint32) {
	volatile.StoreUint32(&o.MDR.Reg, volatile.LoadUint32(&o.MDR.Reg)&^(0x3)|value)
}
func (o *EBI_Type) GetMDR_MD() uint32 {
	return volatile.LoadUint32(&o.MDR.Reg) & 0x3
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG volatile.Register32    // 0x0
	MATRIX_SCFG [5]volatile.Register32 // 0x4
	_           [12]byte
	MATRIX_TCR  volatile.Register32 // 0x24
	_           [8]byte
	EBI_CSA     volatile.Register32 // 0x30
	USB_PUCR    volatile.Register32 // 0x34
}

// MATRIX.MATRIX_MCFG: Master Configuration Register
func (o *MATRIX_Type) SetMATRIX_MCFG_RCB0(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MCFG.Reg, volatile.LoadUint32(&o.MATRIX_MCFG.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_MCFG_RCB0() uint32 {
	return volatile.LoadUint32(&o.MATRIX_MCFG.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_MCFG_RCB1(value uint32) {
	volatile.StoreUint32(&o.MATRIX_MCFG.Reg, volatile.LoadUint32(&o.MATRIX_MCFG.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMATRIX_MCFG_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_MCFG.Reg) & 0x2) >> 1
}

// MATRIX.MATRIX_SCFG: Slave Configuration Register
func (o *MATRIX_Type) SetMATRIX_SCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0xff)|value)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0xff
}
func (o *MATRIX_Type) SetMATRIX_SCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_SCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x1c0000)|value<<18)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x1c0000) >> 18
}

// MATRIX.MATRIX_TCR: MATRIX TCM Configuration Register
func (o *MATRIX_Type) SetMATRIX_TCR_ITCM_SIZE(value uint32) {
	volatile.StoreUint32(&o.MATRIX_TCR.Reg, volatile.LoadUint32(&o.MATRIX_TCR.Reg)&^(0xf)|value)
}
func (o *MATRIX_Type) GetMATRIX_TCR_ITCM_SIZE() uint32 {
	return volatile.LoadUint32(&o.MATRIX_TCR.Reg) & 0xf
}
func (o *MATRIX_Type) SetMATRIX_TCR_DTCM_SIZE(value uint32) {
	volatile.StoreUint32(&o.MATRIX_TCR.Reg, volatile.LoadUint32(&o.MATRIX_TCR.Reg)&^(0xf0)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_TCR_DTCM_SIZE() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_TCR.Reg) & 0xf0) >> 4
}

// MATRIX.EBI_CSA: EBI Chip Select Assignment Register
func (o *MATRIX_Type) SetEBI_CSA_EBI_CS1A(value uint32) {
	volatile.StoreUint32(&o.EBI_CSA.Reg, volatile.LoadUint32(&o.EBI_CSA.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetEBI_CSA_EBI_CS1A() uint32 {
	return (volatile.LoadUint32(&o.EBI_CSA.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetEBI_CSA_EBI_CS3A(value uint32) {
	volatile.StoreUint32(&o.EBI_CSA.Reg, volatile.LoadUint32(&o.EBI_CSA.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetEBI_CSA_EBI_CS3A() uint32 {
	return (volatile.LoadUint32(&o.EBI_CSA.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetEBI_CSA_EBI_CS4A(value uint32) {
	volatile.StoreUint32(&o.EBI_CSA.Reg, volatile.LoadUint32(&o.EBI_CSA.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetEBI_CSA_EBI_CS4A() uint32 {
	return (volatile.LoadUint32(&o.EBI_CSA.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetEBI_CSA_EBI_CS5A(value uint32) {
	volatile.StoreUint32(&o.EBI_CSA.Reg, volatile.LoadUint32(&o.EBI_CSA.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetEBI_CSA_EBI_CS5A() uint32 {
	return (volatile.LoadUint32(&o.EBI_CSA.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetEBI_CSA_EBI_DBPUC(value uint32) {
	volatile.StoreUint32(&o.EBI_CSA.Reg, volatile.LoadUint32(&o.EBI_CSA.Reg)&^(0x100)|value<<8)
}
func (o *MATRIX_Type) GetEBI_CSA_EBI_DBPUC() uint32 {
	return (volatile.LoadUint32(&o.EBI_CSA.Reg) & 0x100) >> 8
}

// MATRIX.USB_PUCR: USB Pad Pull-up Control Register
func (o *MATRIX_Type) SetUSB_PUCR_UDP_PUP_ON(value uint32) {
	volatile.StoreUint32(&o.USB_PUCR.Reg, volatile.LoadUint32(&o.USB_PUCR.Reg)&^(0x40000000)|value<<30)
}
func (o *MATRIX_Type) GetUSB_PUCR_UDP_PUP_ON() uint32 {
	return (volatile.LoadUint32(&o.USB_PUCR.Reg) & 0x40000000) >> 30
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SMR   [32]volatile.Register32 // 0x0
	SVR   [32]volatile.Register32 // 0x80
	IVR   volatile.Register32     // 0x100
	FVR   volatile.Register32     // 0x104
	ISR   volatile.Register32     // 0x108
	IPR   volatile.Register32     // 0x10C
	IMR   volatile.Register32     // 0x110
	CISR  volatile.Register32     // 0x114
	_     [8]byte
	IECR  volatile.Register32 // 0x120
	IDCR  volatile.Register32 // 0x124
	ICCR  volatile.Register32 // 0x128
	ISCR  volatile.Register32 // 0x12C
	EOICR volatile.Register32 // 0x130
	SPU   volatile.Register32 // 0x134
	DCR   volatile.Register32 // 0x138
	_     [4]byte
	FFER  volatile.Register32 // 0x140
	FFDR  volatile.Register32 // 0x144
	FFSR  volatile.Register32 // 0x148
}

// AIC.SMR: Source Mode Register
func (o *AIC_Type) SetSMR_PRIOR(idx int, value uint32) {
	volatile.StoreUint32(&o.SMR[idx].Reg, volatile.LoadUint32(&o.SMR[idx].Reg)&^(0x7)|value)
}
func (o *AIC_Type) GetSMR_PRIOR(idx int) uint32 {
	return volatile.LoadUint32(&o.SMR[idx].Reg) & 0x7
}
func (o *AIC_Type) SetSMR_SRCTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SMR[idx].Reg, volatile.LoadUint32(&o.SMR[idx].Reg)&^(0x60)|value<<5)
}
func (o *AIC_Type) GetSMR_SRCTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SMR[idx].Reg) & 0x60) >> 5
}

// AIC.SVR: Source Vector Register
func (o *AIC_Type) SetSVR(idx int, value uint32) {
	volatile.StoreUint32(&o.SVR[idx].Reg, value)
}
func (o *AIC_Type) GetSVR(idx int) uint32 {
	return volatile.LoadUint32(&o.SVR[idx].Reg)
}

// AIC.IVR: Interrupt Vector Register
func (o *AIC_Type) SetIVR(value uint32) {
	volatile.StoreUint32(&o.IVR.Reg, value)
}
func (o *AIC_Type) GetIVR() uint32 {
	return volatile.LoadUint32(&o.IVR.Reg)
}

// AIC.FVR: FIQ Interrupt Vector Register
func (o *AIC_Type) SetFVR(value uint32) {
	volatile.StoreUint32(&o.FVR.Reg, value)
}
func (o *AIC_Type) GetFVR() uint32 {
	return volatile.LoadUint32(&o.FVR.Reg)
}

// AIC.ISR: Interrupt Status Register
func (o *AIC_Type) SetISR_IRQID(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1f)|value)
}
func (o *AIC_Type) GetISR_IRQID() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1f
}

// AIC.IPR: Interrupt Pending Register
func (o *AIC_Type) SetIPR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIPR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IPR.Reg) & 0x1
}
func (o *AIC_Type) SetIPR_SYS(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIPR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIPR_PID2(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIPR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIPR_PID3(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIPR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIPR_PID4(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIPR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIPR_PID5(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIPR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIPR_PID6(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIPR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIPR_PID7(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIPR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIPR_PID8(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIPR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIPR_PID9(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIPR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIPR_PID10(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIPR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIPR_PID11(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIPR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIPR_PID12(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIPR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIPR_PID13(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIPR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIPR_PID14(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIPR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIPR_PID15(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIPR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIPR_PID16(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIPR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIPR_PID17(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIPR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIPR_PID18(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIPR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIPR_PID19(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIPR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIPR_PID20(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIPR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIPR_PID21(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIPR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIPR_PID22(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIPR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIPR_PID23(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIPR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIPR_PID24(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIPR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIPR_PID25(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIPR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIPR_PID26(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIPR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIPR_PID27(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIPR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIPR_PID28(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIPR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIPR_PID29(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIPR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIPR_PID30(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIPR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIPR_PID31(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIPR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80000000) >> 31
}

// AIC.IMR: Interrupt Mask Register
func (o *AIC_Type) SetIMR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIMR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AIC_Type) SetIMR_SYS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIMR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIMR_PID2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIMR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIMR_PID3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIMR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIMR_PID4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIMR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIMR_PID5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIMR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIMR_PID6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIMR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIMR_PID7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIMR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIMR_PID8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIMR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIMR_PID9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIMR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIMR_PID10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIMR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIMR_PID11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIMR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIMR_PID12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIMR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIMR_PID13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIMR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIMR_PID14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIMR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIMR_PID15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIMR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIMR_PID16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIMR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIMR_PID17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIMR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIMR_PID18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIMR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIMR_PID19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIMR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIMR_PID20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIMR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIMR_PID21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIMR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIMR_PID22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIMR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIMR_PID23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIMR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIMR_PID24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIMR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIMR_PID25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIMR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIMR_PID26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIMR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIMR_PID27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIMR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIMR_PID28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIMR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIMR_PID29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIMR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIMR_PID30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIMR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIMR_PID31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIMR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// AIC.CISR: Core Interrupt Status Register
func (o *AIC_Type) SetCISR_NFIQ(value uint32) {
	volatile.StoreUint32(&o.CISR.Reg, volatile.LoadUint32(&o.CISR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetCISR_NFIQ() uint32 {
	return volatile.LoadUint32(&o.CISR.Reg) & 0x1
}
func (o *AIC_Type) SetCISR_NIRQ(value uint32) {
	volatile.StoreUint32(&o.CISR.Reg, volatile.LoadUint32(&o.CISR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetCISR_NIRQ() uint32 {
	return (volatile.LoadUint32(&o.CISR.Reg) & 0x2) >> 1
}

// AIC.IECR: Interrupt Enable Command Register
func (o *AIC_Type) SetIECR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIECR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IECR.Reg) & 0x1
}
func (o *AIC_Type) SetIECR_SYS(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIECR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIECR_PID2(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIECR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIECR_PID3(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIECR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIECR_PID4(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIECR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIECR_PID5(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIECR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIECR_PID6(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIECR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIECR_PID7(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIECR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIECR_PID8(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIECR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIECR_PID9(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIECR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIECR_PID10(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIECR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIECR_PID11(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIECR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIECR_PID12(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIECR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIECR_PID13(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIECR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIECR_PID14(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIECR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIECR_PID15(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIECR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIECR_PID16(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIECR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIECR_PID17(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIECR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIECR_PID18(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIECR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIECR_PID19(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIECR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIECR_PID20(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIECR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIECR_PID21(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIECR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIECR_PID22(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIECR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIECR_PID23(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIECR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIECR_PID24(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIECR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIECR_PID25(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIECR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIECR_PID26(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIECR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIECR_PID27(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIECR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIECR_PID28(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIECR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIECR_PID29(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIECR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIECR_PID30(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIECR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIECR_PID31(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIECR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80000000) >> 31
}

// AIC.IDCR: Interrupt Disable Command Register
func (o *AIC_Type) SetIDCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIDCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IDCR.Reg) & 0x1
}
func (o *AIC_Type) SetIDCR_SYS(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIDCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIDCR_PID2(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIDCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIDCR_PID3(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIDCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIDCR_PID4(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIDCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIDCR_PID5(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIDCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIDCR_PID6(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIDCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIDCR_PID7(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIDCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIDCR_PID8(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIDCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIDCR_PID9(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIDCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIDCR_PID10(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIDCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIDCR_PID11(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIDCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIDCR_PID12(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIDCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIDCR_PID13(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIDCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIDCR_PID14(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIDCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIDCR_PID15(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIDCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIDCR_PID16(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIDCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIDCR_PID17(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIDCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIDCR_PID18(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIDCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIDCR_PID19(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIDCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIDCR_PID20(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIDCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIDCR_PID21(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIDCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIDCR_PID22(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIDCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIDCR_PID23(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIDCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIDCR_PID24(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIDCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIDCR_PID25(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIDCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIDCR_PID26(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIDCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIDCR_PID27(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIDCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIDCR_PID28(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIDCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIDCR_PID29(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIDCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIDCR_PID30(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIDCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIDCR_PID31(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIDCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80000000) >> 31
}

// AIC.ICCR: Interrupt Clear Command Register
func (o *AIC_Type) SetICCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetICCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.ICCR.Reg) & 0x1
}
func (o *AIC_Type) SetICCR_SYS(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetICCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetICCR_PID2(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetICCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetICCR_PID3(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetICCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetICCR_PID4(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetICCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetICCR_PID5(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetICCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetICCR_PID6(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetICCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetICCR_PID7(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetICCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetICCR_PID8(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetICCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetICCR_PID9(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetICCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetICCR_PID10(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetICCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetICCR_PID11(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetICCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetICCR_PID12(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetICCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetICCR_PID13(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetICCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetICCR_PID14(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetICCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetICCR_PID15(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetICCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetICCR_PID16(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetICCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetICCR_PID17(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetICCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetICCR_PID18(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetICCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetICCR_PID19(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetICCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetICCR_PID20(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetICCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetICCR_PID21(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetICCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetICCR_PID22(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetICCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetICCR_PID23(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetICCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetICCR_PID24(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetICCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetICCR_PID25(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetICCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetICCR_PID26(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetICCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetICCR_PID27(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetICCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetICCR_PID28(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetICCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetICCR_PID29(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetICCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetICCR_PID30(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetICCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetICCR_PID31(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetICCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80000000) >> 31
}

// AIC.ISCR: Interrupt Set Command Register
func (o *AIC_Type) SetISCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetISCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.ISCR.Reg) & 0x1
}
func (o *AIC_Type) SetISCR_SYS(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetISCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetISCR_PID2(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetISCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetISCR_PID3(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetISCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetISCR_PID4(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetISCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetISCR_PID5(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetISCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetISCR_PID6(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetISCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetISCR_PID7(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetISCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetISCR_PID8(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetISCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetISCR_PID9(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetISCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetISCR_PID10(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetISCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetISCR_PID11(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetISCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetISCR_PID12(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetISCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetISCR_PID13(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetISCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetISCR_PID14(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetISCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetISCR_PID15(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetISCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetISCR_PID16(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetISCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetISCR_PID17(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetISCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetISCR_PID18(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetISCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetISCR_PID19(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetISCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetISCR_PID20(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetISCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetISCR_PID21(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetISCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetISCR_PID22(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetISCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetISCR_PID23(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetISCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetISCR_PID24(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetISCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetISCR_PID25(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetISCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetISCR_PID26(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetISCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetISCR_PID27(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetISCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetISCR_PID28(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetISCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetISCR_PID29(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetISCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetISCR_PID30(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetISCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetISCR_PID31(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetISCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000000) >> 31
}

// AIC.SPU: Spurious Interrupt Vector Register
func (o *AIC_Type) SetSPU(value uint32) {
	volatile.StoreUint32(&o.SPU.Reg, value)
}
func (o *AIC_Type) GetSPU() uint32 {
	return volatile.LoadUint32(&o.SPU.Reg)
}

// AIC.DCR: Debug Control Register
func (o *AIC_Type) SetDCR_PROT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetDCR_PROT() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}
func (o *AIC_Type) SetDCR_GMSK(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetDCR_GMSK() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x2) >> 1
}

// AIC.FFER: Fast Forcing Enable Register
func (o *AIC_Type) SetFFER_SYS(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFER_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFER_PID2(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFER_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFER_PID3(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFER_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFER_PID4(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFER_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFER_PID5(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFER_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFER_PID6(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFER_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFER_PID7(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFER_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFER_PID8(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFER_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFER_PID9(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFER_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFER_PID10(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFER_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFER_PID11(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFER_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFER_PID12(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFER_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFER_PID13(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFER_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFER_PID14(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFER_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFER_PID15(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFER_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFER_PID16(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFER_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFER_PID17(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFER_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFER_PID18(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFER_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFER_PID19(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFER_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFER_PID20(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFER_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFER_PID21(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFER_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFER_PID22(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFER_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFER_PID23(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFER_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFER_PID24(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFER_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFER_PID25(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFER_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFER_PID26(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFER_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFER_PID27(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFER_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFER_PID28(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFER_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFER_PID29(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFER_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFER_PID30(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFER_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFER_PID31(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFER_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80000000) >> 31
}

// AIC.FFDR: Fast Forcing Disable Register
func (o *AIC_Type) SetFFDR_SYS(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFDR_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFDR_PID2(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFDR_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFDR_PID3(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFDR_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFDR_PID4(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFDR_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFDR_PID5(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFDR_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFDR_PID6(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFDR_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFDR_PID7(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFDR_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFDR_PID8(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFDR_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFDR_PID9(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFDR_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFDR_PID10(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFDR_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFDR_PID11(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFDR_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFDR_PID12(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFDR_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFDR_PID13(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFDR_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFDR_PID14(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFDR_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFDR_PID15(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFDR_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFDR_PID16(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFDR_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFDR_PID17(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFDR_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFDR_PID18(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFDR_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFDR_PID19(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFDR_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFDR_PID20(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFDR_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFDR_PID21(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFDR_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFDR_PID22(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFDR_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFDR_PID23(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFDR_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFDR_PID24(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFDR_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFDR_PID25(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFDR_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFDR_PID26(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFDR_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFDR_PID27(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFDR_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFDR_PID28(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFDR_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFDR_PID29(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFDR_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFDR_PID30(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFDR_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFDR_PID31(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFDR_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80000000) >> 31
}

// AIC.FFSR: Fast Forcing Status Register
func (o *AIC_Type) SetFFSR_SYS(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFSR_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFSR_PID2(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFSR_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFSR_PID3(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFSR_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFSR_PID4(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFSR_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFSR_PID5(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFSR_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFSR_PID6(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFSR_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFSR_PID7(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFSR_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFSR_PID8(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFSR_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFSR_PID9(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFSR_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFSR_PID10(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFSR_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFSR_PID11(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFSR_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFSR_PID12(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFSR_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFSR_PID13(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFSR_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFSR_PID14(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFSR_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFSR_PID15(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFSR_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFSR_PID16(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFSR_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFSR_PID17(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFSR_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFSR_PID18(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFSR_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFSR_PID19(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFSR_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFSR_PID20(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFSR_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFSR_PID21(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFSR_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFSR_PID22(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFSR_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFSR_PID23(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFSR_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFSR_PID24(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFSR_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFSR_PID25(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFSR_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFSR_PID26(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFSR_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFSR_PID27(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFSR_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFSR_PID28(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFSR_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFSR_PID29(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFSR_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFSR_PID30(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFSR_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFSR_PID31(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFSR_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80000000) >> 31
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
	_    [180]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// DBGU.CR: Control Register
func (o *DBGU_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGU_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGU_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DBGU_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// DBGU.MR: Mode Register
func (o *DBGU_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *DBGU_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *DBGU_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *DBGU_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// DBGU.IER: Interrupt Enable Register
func (o *DBGU_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DBGU_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *DBGU_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *DBGU_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *DBGU_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *DBGU_Type) SetIER_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIER_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIER_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIER_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// DBGU.IDR: Interrupt Disable Register
func (o *DBGU_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DBGU_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *DBGU_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *DBGU_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *DBGU_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *DBGU_Type) SetIDR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIDR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIDR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIDR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// DBGU.IMR: Interrupt Mask Register
func (o *DBGU_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DBGU_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *DBGU_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *DBGU_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *DBGU_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *DBGU_Type) SetIMR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIMR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIMR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIMR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// DBGU.SR: Status Register
func (o *DBGU_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *DBGU_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *DBGU_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *DBGU_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *DBGU_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *DBGU_Type) SetSR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetSR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetSR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetSR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// DBGU.RHR: Receive Holding Register
func (o *DBGU_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *DBGU_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// DBGU.THR: Transmit Holding Register
func (o *DBGU_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *DBGU_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// DBGU.BRGR: Baud Rate Generator Register
func (o *DBGU_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// DBGU.CIDR: Chip ID Register
func (o *DBGU_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *DBGU_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *DBGU_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *DBGU_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *DBGU_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *DBGU_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *DBGU_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *DBGU_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *DBGU_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *DBGU_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *DBGU_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *DBGU_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *DBGU_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *DBGU_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *DBGU_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// DBGU.EXID: Chip ID Extension Register
func (o *DBGU_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *DBGU_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// DBGU.FNR: Force NTRST Register
func (o *DBGU_Type) SetFNR_FNTRST(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetFNR_FNTRST() uint32 {
	return volatile.LoadUint32(&o.FNR.Reg) & 0x1
}

// DBGU.RPR: Receive Pointer Register
func (o *DBGU_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *DBGU_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// DBGU.RCR: Receive Counter Register
func (o *DBGU_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// DBGU.TPR: Transmit Pointer Register
func (o *DBGU_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *DBGU_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// DBGU.TCR: Transmit Counter Register
func (o *DBGU_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// DBGU.RNPR: Receive Next Pointer Register
func (o *DBGU_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *DBGU_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// DBGU.RNCR: Receive Next Counter Register
func (o *DBGU_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// DBGU.TNPR: Transmit Next Pointer Register
func (o *DBGU_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *DBGU_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// DBGU.TNCR: Transmit Next Counter Register
func (o *DBGU_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// DBGU.PTCR: Transfer Control Register
func (o *DBGU_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *DBGU_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *DBGU_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *DBGU_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// DBGU.PTSR: Transfer Status Register
func (o *DBGU_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *DBGU_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *DBGU_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER  volatile.Register32 // 0x0
	PDR  volatile.Register32 // 0x4
	PSR  volatile.Register32 // 0x8
	_    [4]byte
	OER  volatile.Register32 // 0x10
	ODR  volatile.Register32 // 0x14
	OSR  volatile.Register32 // 0x18
	_    [4]byte
	IFER volatile.Register32 // 0x20
	IFDR volatile.Register32 // 0x24
	IFSR volatile.Register32 // 0x28
	_    [4]byte
	SODR volatile.Register32 // 0x30
	CODR volatile.Register32 // 0x34
	ODSR volatile.Register32 // 0x38
	PDSR volatile.Register32 // 0x3C
	IER  volatile.Register32 // 0x40
	IDR  volatile.Register32 // 0x44
	IMR  volatile.Register32 // 0x48
	ISR  volatile.Register32 // 0x4C
	MDER volatile.Register32 // 0x50
	MDDR volatile.Register32 // 0x54
	MDSR volatile.Register32 // 0x58
	_    [4]byte
	PUDR volatile.Register32 // 0x60
	PUER volatile.Register32 // 0x64
	PUSR volatile.Register32 // 0x68
	_    [4]byte
	ASR  volatile.Register32 // 0x70
	BSR  volatile.Register32 // 0x74
	ABSR volatile.Register32 // 0x78
	_    [36]byte
	OWER volatile.Register32 // 0xA0
	OWDR volatile.Register32 // 0xA4
	OWSR volatile.Register32 // 0xA8
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000000) >> 31
}

// PIO.SODR: Set Output Data Register
func (o *PIO_Type) SetSODR_P0(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSODR_P0() uint32 {
	return volatile.LoadUint32(&o.SODR.Reg) & 0x1
}
func (o *PIO_Type) SetSODR_P1(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSODR_P1() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSODR_P2(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSODR_P2() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSODR_P3(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSODR_P3() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSODR_P4(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSODR_P4() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSODR_P5(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSODR_P5() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSODR_P6(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSODR_P6() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSODR_P7(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSODR_P7() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSODR_P8(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSODR_P8() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSODR_P9(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSODR_P9() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSODR_P10(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSODR_P10() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSODR_P11(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSODR_P11() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSODR_P12(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSODR_P12() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSODR_P13(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSODR_P13() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSODR_P14(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSODR_P14() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSODR_P15(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSODR_P15() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSODR_P16(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSODR_P16() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSODR_P17(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSODR_P17() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSODR_P18(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSODR_P18() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSODR_P19(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSODR_P19() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSODR_P20(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSODR_P20() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSODR_P21(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSODR_P21() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSODR_P22(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSODR_P22() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSODR_P23(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSODR_P23() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSODR_P24(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSODR_P24() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSODR_P25(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSODR_P25() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSODR_P26(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSODR_P26() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSODR_P27(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSODR_P27() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSODR_P28(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSODR_P28() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSODR_P29(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSODR_P29() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSODR_P30(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSODR_P30() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSODR_P31(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSODR_P31() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000000) >> 31
}

// PIO.CODR: Clear Output Data Register
func (o *PIO_Type) SetCODR_P0(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetCODR_P0() uint32 {
	return volatile.LoadUint32(&o.CODR.Reg) & 0x1
}
func (o *PIO_Type) SetCODR_P1(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetCODR_P1() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetCODR_P2(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetCODR_P2() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetCODR_P3(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetCODR_P3() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetCODR_P4(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetCODR_P4() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetCODR_P5(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetCODR_P5() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetCODR_P6(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetCODR_P6() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetCODR_P7(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetCODR_P7() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetCODR_P8(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetCODR_P8() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetCODR_P9(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetCODR_P9() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetCODR_P10(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetCODR_P10() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetCODR_P11(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetCODR_P11() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetCODR_P12(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetCODR_P12() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetCODR_P13(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetCODR_P13() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetCODR_P14(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetCODR_P14() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetCODR_P15(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetCODR_P15() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetCODR_P16(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetCODR_P16() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetCODR_P17(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetCODR_P17() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetCODR_P18(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetCODR_P18() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetCODR_P19(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetCODR_P19() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetCODR_P20(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetCODR_P20() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetCODR_P21(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetCODR_P21() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetCODR_P22(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetCODR_P22() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetCODR_P23(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetCODR_P23() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetCODR_P24(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetCODR_P24() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetCODR_P25(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetCODR_P25() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetCODR_P26(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetCODR_P26() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetCODR_P27(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetCODR_P27() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetCODR_P28(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetCODR_P28() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetCODR_P29(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetCODR_P29() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetCODR_P30(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetCODR_P30() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetCODR_P31(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetCODR_P31() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000000) >> 31
}

// PIO.ODSR: Output Data Status Register
func (o *PIO_Type) SetODSR_P0(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODSR_P0() uint32 {
	return volatile.LoadUint32(&o.ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetODSR_P1(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODSR_P2(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODSR_P3(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODSR_P4(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODSR_P5(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODSR_P6(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODSR_P7(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODSR_P8(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODSR_P9(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODSR_P10(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODSR_P11(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODSR_P12(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODSR_P13(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODSR_P14(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODSR_P15(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODSR_P16(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODSR_P17(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODSR_P18(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODSR_P19(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODSR_P20(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODSR_P21(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODSR_P22(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODSR_P23(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODSR_P24(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODSR_P25(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODSR_P26(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODSR_P27(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODSR_P28(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODSR_P29(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODSR_P30(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODSR_P31(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PDSR: Pin Data Status Register
func (o *PIO_Type) SetPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000000) >> 31
}

// PIO.IER: Interrupt Enable Register
func (o *PIO_Type) SetIER_P0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIER_P0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PIO_Type) SetIER_P1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIER_P1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIER_P2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIER_P2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIER_P3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIER_P3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIER_P4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIER_P4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIER_P5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIER_P5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIER_P6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIER_P6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIER_P7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIER_P7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIER_P8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIER_P8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIER_P9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIER_P9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIER_P10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIER_P10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIER_P11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIER_P11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIER_P12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIER_P12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIER_P13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIER_P13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIER_P14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIER_P14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIER_P15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIER_P15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIER_P16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIER_P16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIER_P17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIER_P17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIER_P18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIER_P18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIER_P19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIER_P19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIER_P20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIER_P20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIER_P21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIER_P21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIER_P22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIER_P22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIER_P23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIER_P23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIER_P24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIER_P24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIER_P25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIER_P25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIER_P26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIER_P26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIER_P27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIER_P27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIER_P28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIER_P28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIER_P29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIER_P29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIER_P30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIER_P30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIER_P31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIER_P31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// PIO.IDR: Interrupt Disable Register
func (o *PIO_Type) SetIDR_P0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIDR_P0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PIO_Type) SetIDR_P1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIDR_P2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIDR_P3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIDR_P4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIDR_P5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIDR_P6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIDR_P7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIDR_P8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIDR_P9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIDR_P10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIDR_P11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIDR_P12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIDR_P13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIDR_P14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIDR_P15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIDR_P16(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIDR_P17(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIDR_P18(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIDR_P19(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIDR_P20(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIDR_P21(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIDR_P22(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIDR_P23(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIDR_P24(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIDR_P25(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIDR_P26(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIDR_P27(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIDR_P28(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIDR_P29(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIDR_P30(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIDR_P31(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// PIO.IMR: Interrupt Mask Register
func (o *PIO_Type) SetIMR_P0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIMR_P0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PIO_Type) SetIMR_P1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIMR_P1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIMR_P2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIMR_P2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIMR_P3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIMR_P3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIMR_P4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIMR_P4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIMR_P5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIMR_P5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIMR_P6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIMR_P6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIMR_P7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIMR_P7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIMR_P8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIMR_P8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIMR_P9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIMR_P9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIMR_P10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIMR_P10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIMR_P11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIMR_P11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIMR_P12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIMR_P12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIMR_P13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIMR_P13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIMR_P14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIMR_P14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIMR_P15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIMR_P15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIMR_P16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIMR_P16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIMR_P17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIMR_P17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIMR_P18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIMR_P18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIMR_P19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIMR_P19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIMR_P20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIMR_P20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIMR_P21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIMR_P21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIMR_P22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIMR_P22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIMR_P23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIMR_P23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIMR_P24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIMR_P24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIMR_P25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIMR_P25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIMR_P26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIMR_P26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIMR_P27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIMR_P27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIMR_P28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIMR_P28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIMR_P29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIMR_P29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIMR_P30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIMR_P30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIMR_P31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIMR_P31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// PIO.ISR: Interrupt Status Register
func (o *PIO_Type) SetISR_P0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetISR_P0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PIO_Type) SetISR_P1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetISR_P1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetISR_P2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetISR_P2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetISR_P3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetISR_P3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetISR_P4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetISR_P4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetISR_P5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetISR_P5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetISR_P6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetISR_P6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetISR_P7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetISR_P7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetISR_P8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetISR_P8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetISR_P9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetISR_P9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetISR_P10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetISR_P10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetISR_P11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetISR_P11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetISR_P12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetISR_P12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetISR_P13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetISR_P13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetISR_P14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetISR_P14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetISR_P15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetISR_P15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetISR_P16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetISR_P16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetISR_P17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetISR_P17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetISR_P18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetISR_P18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetISR_P19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetISR_P19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetISR_P20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetISR_P20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetISR_P21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetISR_P21() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetISR_P22(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetISR_P22() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetISR_P23(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetISR_P23() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetISR_P24(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetISR_P24() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetISR_P25(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetISR_P25() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetISR_P26(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetISR_P26() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetISR_P27(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetISR_P27() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetISR_P28(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetISR_P28() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetISR_P29(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetISR_P29() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetISR_P30(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetISR_P30() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetISR_P31(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetISR_P31() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// PIO.MDER: Multi-driver Enable Register
func (o *PIO_Type) SetMDER_P0(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDER_P0() uint32 {
	return volatile.LoadUint32(&o.MDER.Reg) & 0x1
}
func (o *PIO_Type) SetMDER_P1(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDER_P1() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDER_P2(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDER_P2() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDER_P3(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDER_P3() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDER_P4(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDER_P4() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDER_P5(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDER_P5() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDER_P6(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDER_P6() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDER_P7(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDER_P7() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDER_P8(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDER_P8() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDER_P9(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDER_P9() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDER_P10(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDER_P10() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDER_P11(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDER_P11() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDER_P12(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDER_P12() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDER_P13(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDER_P13() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDER_P14(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDER_P14() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDER_P15(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDER_P15() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDER_P16(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDER_P16() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDER_P17(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDER_P17() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDER_P18(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDER_P18() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDER_P19(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDER_P19() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDER_P20(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDER_P20() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDER_P21(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDER_P21() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDER_P22(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDER_P22() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDER_P23(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDER_P23() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDER_P24(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDER_P24() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDER_P25(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDER_P25() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDER_P26(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDER_P26() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDER_P27(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDER_P27() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDER_P28(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDER_P28() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDER_P29(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDER_P29() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDER_P30(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDER_P30() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDER_P31(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDER_P31() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000000) >> 31
}

// PIO.MDDR: Multi-driver Disable Register
func (o *PIO_Type) SetMDDR_P0(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDDR_P0() uint32 {
	return volatile.LoadUint32(&o.MDDR.Reg) & 0x1
}
func (o *PIO_Type) SetMDDR_P1(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDDR_P2(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDDR_P3(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDDR_P4(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDDR_P5(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDDR_P6(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDDR_P7(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDDR_P8(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDDR_P9(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDDR_P10(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDDR_P11(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDDR_P12(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDDR_P13(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDDR_P14(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDDR_P15(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDDR_P16(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDDR_P17(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDDR_P18(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDDR_P19(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDDR_P20(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDDR_P21(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDDR_P22(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDDR_P23(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDDR_P24(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDDR_P25(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDDR_P26(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDDR_P27(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDDR_P28(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDDR_P29(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDDR_P30(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDDR_P31(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000000) >> 31
}

// PIO.MDSR: Multi-driver Status Register
func (o *PIO_Type) SetMDSR_P0(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDSR_P0() uint32 {
	return volatile.LoadUint32(&o.MDSR.Reg) & 0x1
}
func (o *PIO_Type) SetMDSR_P1(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDSR_P2(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDSR_P3(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDSR_P4(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDSR_P5(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDSR_P6(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDSR_P7(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDSR_P8(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDSR_P9(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDSR_P10(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDSR_P11(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDSR_P12(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDSR_P13(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDSR_P14(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDSR_P15(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDSR_P16(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDSR_P17(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDSR_P18(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDSR_P19(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDSR_P20(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDSR_P21(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDSR_P22(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDSR_P23(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDSR_P24(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDSR_P25(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDSR_P26(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDSR_P27(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDSR_P28(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDSR_P29(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDSR_P30(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDSR_P31(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000000) >> 31
}

// PIO.PUDR: Pull-up Disable Register
func (o *PIO_Type) SetPUDR_P0(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUDR_P0() uint32 {
	return volatile.LoadUint32(&o.PUDR.Reg) & 0x1
}
func (o *PIO_Type) SetPUDR_P1(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUDR_P2(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUDR_P3(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUDR_P4(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUDR_P5(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUDR_P6(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUDR_P7(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUDR_P8(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUDR_P9(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUDR_P10(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUDR_P11(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUDR_P12(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUDR_P13(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUDR_P14(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUDR_P15(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUDR_P16(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUDR_P17(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUDR_P18(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUDR_P19(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUDR_P20(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUDR_P21(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUDR_P22(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUDR_P23(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUDR_P24(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUDR_P25(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUDR_P26(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUDR_P27(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUDR_P28(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUDR_P29(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUDR_P30(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUDR_P31(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000000) >> 31
}

// PIO.PUER: Pull-up Enable Register
func (o *PIO_Type) SetPUER_P0(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUER_P0() uint32 {
	return volatile.LoadUint32(&o.PUER.Reg) & 0x1
}
func (o *PIO_Type) SetPUER_P1(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUER_P1() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUER_P2(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUER_P2() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUER_P3(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUER_P3() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUER_P4(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUER_P4() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUER_P5(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUER_P5() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUER_P6(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUER_P6() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUER_P7(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUER_P7() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUER_P8(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUER_P8() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUER_P9(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUER_P9() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUER_P10(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUER_P10() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUER_P11(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUER_P11() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUER_P12(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUER_P12() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUER_P13(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUER_P13() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUER_P14(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUER_P14() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUER_P15(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUER_P15() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUER_P16(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUER_P16() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUER_P17(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUER_P17() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUER_P18(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUER_P18() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUER_P19(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUER_P19() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUER_P20(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUER_P20() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUER_P21(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUER_P21() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUER_P22(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUER_P22() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUER_P23(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUER_P23() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUER_P24(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUER_P24() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUER_P25(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUER_P25() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUER_P26(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUER_P26() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUER_P27(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUER_P27() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUER_P28(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUER_P28() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUER_P29(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUER_P29() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUER_P30(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUER_P30() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUER_P31(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUER_P31() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000000) >> 31
}

// PIO.PUSR: Pad Pull-up Status Register
func (o *PIO_Type) SetPUSR_P0(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUSR_P0() uint32 {
	return volatile.LoadUint32(&o.PUSR.Reg) & 0x1
}
func (o *PIO_Type) SetPUSR_P1(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUSR_P2(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUSR_P3(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUSR_P4(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUSR_P5(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUSR_P6(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUSR_P7(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUSR_P8(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUSR_P9(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUSR_P10(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUSR_P11(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUSR_P12(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUSR_P13(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUSR_P14(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUSR_P15(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUSR_P16(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUSR_P17(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUSR_P18(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUSR_P19(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUSR_P20(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUSR_P21(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUSR_P22(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUSR_P23(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUSR_P24(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUSR_P25(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUSR_P26(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUSR_P27(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUSR_P28(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUSR_P29(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUSR_P30(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUSR_P31(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000000) >> 31
}

// PIO.ASR: Peripheral A Select Register
func (o *PIO_Type) SetASR_P0(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetASR_P0() uint32 {
	return volatile.LoadUint32(&o.ASR.Reg) & 0x1
}
func (o *PIO_Type) SetASR_P1(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetASR_P1() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetASR_P2(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetASR_P2() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetASR_P3(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetASR_P3() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetASR_P4(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetASR_P4() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetASR_P5(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetASR_P5() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetASR_P6(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetASR_P6() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetASR_P7(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetASR_P7() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetASR_P8(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetASR_P8() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetASR_P9(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetASR_P9() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetASR_P10(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetASR_P10() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetASR_P11(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetASR_P11() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetASR_P12(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetASR_P12() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetASR_P13(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetASR_P13() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetASR_P14(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetASR_P14() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetASR_P15(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetASR_P15() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetASR_P16(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetASR_P16() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetASR_P17(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetASR_P17() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetASR_P18(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetASR_P18() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetASR_P19(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetASR_P19() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetASR_P20(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetASR_P20() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetASR_P21(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetASR_P21() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetASR_P22(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetASR_P22() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetASR_P23(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetASR_P23() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetASR_P24(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetASR_P24() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetASR_P25(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetASR_P25() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetASR_P26(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetASR_P26() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetASR_P27(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetASR_P27() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetASR_P28(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetASR_P28() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetASR_P29(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetASR_P29() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetASR_P30(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetASR_P30() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetASR_P31(value uint32) {
	volatile.StoreUint32(&o.ASR.Reg, volatile.LoadUint32(&o.ASR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetASR_P31() uint32 {
	return (volatile.LoadUint32(&o.ASR.Reg) & 0x80000000) >> 31
}

// PIO.BSR: Peripheral B Select Register
func (o *PIO_Type) SetBSR_P0(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetBSR_P0() uint32 {
	return volatile.LoadUint32(&o.BSR.Reg) & 0x1
}
func (o *PIO_Type) SetBSR_P1(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetBSR_P1() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetBSR_P2(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetBSR_P2() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetBSR_P3(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetBSR_P3() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetBSR_P4(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetBSR_P4() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetBSR_P5(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetBSR_P5() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetBSR_P6(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetBSR_P6() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetBSR_P7(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetBSR_P7() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetBSR_P8(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetBSR_P8() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetBSR_P9(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetBSR_P9() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetBSR_P10(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetBSR_P10() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetBSR_P11(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetBSR_P11() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetBSR_P12(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetBSR_P12() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetBSR_P13(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetBSR_P13() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetBSR_P14(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetBSR_P14() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetBSR_P15(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetBSR_P15() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetBSR_P16(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetBSR_P16() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetBSR_P17(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetBSR_P17() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetBSR_P18(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetBSR_P18() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetBSR_P19(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetBSR_P19() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetBSR_P20(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetBSR_P20() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetBSR_P21(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetBSR_P21() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetBSR_P22(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetBSR_P22() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetBSR_P23(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetBSR_P23() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetBSR_P24(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetBSR_P24() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetBSR_P25(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetBSR_P25() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetBSR_P26(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetBSR_P26() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetBSR_P27(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetBSR_P27() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetBSR_P28(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetBSR_P28() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetBSR_P29(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetBSR_P29() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetBSR_P30(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetBSR_P30() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetBSR_P31(value uint32) {
	volatile.StoreUint32(&o.BSR.Reg, volatile.LoadUint32(&o.BSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetBSR_P31() uint32 {
	return (volatile.LoadUint32(&o.BSR.Reg) & 0x80000000) >> 31
}

// PIO.ABSR: AB Status Register
func (o *PIO_Type) SetABSR_P0(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetABSR_P0() uint32 {
	return volatile.LoadUint32(&o.ABSR.Reg) & 0x1
}
func (o *PIO_Type) SetABSR_P1(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetABSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetABSR_P2(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetABSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetABSR_P3(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetABSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetABSR_P4(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetABSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetABSR_P5(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetABSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetABSR_P6(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetABSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetABSR_P7(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetABSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetABSR_P8(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetABSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetABSR_P9(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetABSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetABSR_P10(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetABSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetABSR_P11(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetABSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetABSR_P12(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetABSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetABSR_P13(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetABSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetABSR_P14(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetABSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetABSR_P15(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetABSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetABSR_P16(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetABSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetABSR_P17(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetABSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetABSR_P18(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetABSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetABSR_P19(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetABSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetABSR_P20(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetABSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetABSR_P21(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetABSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetABSR_P22(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetABSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetABSR_P23(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetABSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetABSR_P24(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetABSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetABSR_P25(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetABSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetABSR_P26(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetABSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetABSR_P27(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetABSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetABSR_P28(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetABSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetABSR_P29(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetABSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetABSR_P30(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetABSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetABSR_P31(value uint32) {
	volatile.StoreUint32(&o.ABSR.Reg, volatile.LoadUint32(&o.ABSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetABSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ABSR.Reg) & 0x80000000) >> 31
}

// PIO.OWER: Output Write Enable
func (o *PIO_Type) SetOWER_P0(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWER_P0() uint32 {
	return volatile.LoadUint32(&o.OWER.Reg) & 0x1
}
func (o *PIO_Type) SetOWER_P1(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWER_P1() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWER_P2(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWER_P2() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWER_P3(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWER_P3() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWER_P4(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWER_P4() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWER_P5(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWER_P5() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWER_P6(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWER_P6() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWER_P7(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWER_P7() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWER_P8(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWER_P8() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWER_P9(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWER_P9() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWER_P10(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWER_P10() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWER_P11(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWER_P11() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWER_P12(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWER_P12() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWER_P13(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWER_P13() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWER_P14(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWER_P14() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWER_P15(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWER_P15() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWER_P16(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWER_P16() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWER_P17(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWER_P17() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWER_P18(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWER_P18() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWER_P19(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWER_P19() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWER_P20(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWER_P20() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWER_P21(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWER_P21() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWER_P22(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWER_P22() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWER_P23(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWER_P23() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWER_P24(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWER_P24() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWER_P25(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWER_P25() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWER_P26(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWER_P26() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWER_P27(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWER_P27() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWER_P28(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWER_P28() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWER_P29(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWER_P29() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWER_P30(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWER_P30() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWER_P31(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWER_P31() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000000) >> 31
}

// PIO.OWDR: Output Write Disable
func (o *PIO_Type) SetOWDR_P0(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWDR_P0() uint32 {
	return volatile.LoadUint32(&o.OWDR.Reg) & 0x1
}
func (o *PIO_Type) SetOWDR_P1(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWDR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWDR_P2(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWDR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWDR_P3(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWDR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWDR_P4(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWDR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWDR_P5(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWDR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWDR_P6(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWDR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWDR_P7(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWDR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWDR_P8(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWDR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWDR_P9(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWDR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWDR_P10(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWDR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWDR_P11(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWDR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWDR_P12(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWDR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWDR_P13(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWDR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWDR_P14(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWDR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWDR_P15(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWDR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWDR_P16(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWDR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWDR_P17(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWDR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWDR_P18(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWDR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWDR_P19(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWDR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWDR_P20(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWDR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWDR_P21(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWDR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWDR_P22(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWDR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWDR_P23(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWDR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWDR_P24(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWDR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWDR_P25(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWDR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWDR_P26(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWDR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWDR_P27(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWDR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWDR_P28(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWDR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWDR_P29(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWDR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWDR_P30(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWDR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWDR_P31(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWDR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000000) >> 31
}

// PIO.OWSR: Output Write Status Register
func (o *PIO_Type) SetOWSR_P0(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWSR_P0() uint32 {
	return volatile.LoadUint32(&o.OWSR.Reg) & 0x1
}
func (o *PIO_Type) SetOWSR_P1(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWSR_P2(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWSR_P3(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWSR_P4(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWSR_P5(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWSR_P6(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWSR_P7(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWSR_P8(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWSR_P9(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWSR_P10(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWSR_P11(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWSR_P12(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWSR_P13(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWSR_P14(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWSR_P15(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWSR_P16(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWSR_P17(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWSR_P18(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWSR_P19(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWSR_P20(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWSR_P21(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWSR_P22(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWSR_P23(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWSR_P24(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWSR_P25(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWSR_P26(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWSR_P27(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWSR_P28(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWSR_P29(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWSR_P30(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWSR_P31(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000000) >> 31
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER    volatile.Register32 // 0x0
	PMC_SCDR    volatile.Register32 // 0x4
	PMC_SCSR    volatile.Register32 // 0x8
	_           [4]byte
	PMC_PCER    volatile.Register32 // 0x10
	PMC_PCDR    volatile.Register32 // 0x14
	PMC_PCSR    volatile.Register32 // 0x18
	_           [4]byte
	CKGR_MOR    volatile.Register32 // 0x20
	CKGR_MCFR   volatile.Register32 // 0x24
	CKGR_PLLAR  volatile.Register32 // 0x28
	CKGR_PLLBR  volatile.Register32 // 0x2C
	PMC_MCKR    volatile.Register32 // 0x30
	_           [12]byte
	PMC_PCK     [8]volatile.Register32 // 0x40
	PMC_IER     volatile.Register32    // 0x60
	PMC_IDR     volatile.Register32    // 0x64
	PMC_SR      volatile.Register32    // 0x68
	PMC_IMR     volatile.Register32    // 0x6C
	_           [16]byte
	PMC_PLLICPR volatile.Register32 // 0x80
}

// PMC.PMC_SCER: System Clock Enable Register
func (o *PMC_Type) SetPMC_SCER_UHP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_SCER_UHP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_SCER_UDP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SCER_UDP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SCER_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCER_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCER_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCER_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCER_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCER_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SCER_PCK3(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SCER_PCK3() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SCER_HCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SCER_HCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SCER_HCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SCER_HCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x20000) >> 17
}

// PMC.PMC_SCDR: System Clock Disable Register
func (o *PMC_Type) SetPMC_SCDR_PCK(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SCDR_PCK() uint32 {
	return volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SCDR_UHP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_SCDR_UHP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_SCDR_UDP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SCDR_UDP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SCDR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCDR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCDR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCDR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCDR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCDR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SCDR_PCK3(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SCDR_PCK3() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SCDR_HCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SCDR_HCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SCDR_HCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SCDR_HCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x20000) >> 17
}

// PMC.PMC_SCSR: System Clock Status Register
func (o *PMC_Type) SetPMC_SCSR_PCK(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SCSR_PCK() uint32 {
	return volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SCSR_UHP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_SCSR_UHP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_SCSR_UDP(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SCSR_UDP() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SCSR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCSR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCSR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCSR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCSR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCSR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SCSR_PCK3(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SCSR_PCK3() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_SCSR_HCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SCSR_HCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SCSR_HCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SCSR_HCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x20000) >> 17
}

// PMC.PMC_PCER: Peripheral Clock Enable Register
func (o *PMC_Type) SetPMC_PCER_PID2(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCER_PID2() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCER_PID3(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCER_PID3() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCER_PID4(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_PCER_PID4() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_PCER_PID5(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCER_PID5() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCER_PID6(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_PCER_PID6() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_PCER_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCER_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCER_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCER_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCER_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCER_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCER_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCER_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCER_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCER_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCER_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCER_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCER_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCER_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCER_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCER_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCER_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCER_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCER_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCER_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCER_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCER_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCER_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCER_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCER_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCER_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCER_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCER_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCER_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCER_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCER_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCER_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCER_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCER_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCER_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCER_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCER_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCER_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCER_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCER_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCER_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCER_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCER_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCER_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCER_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCER_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCER_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCER_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCER_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER.Reg, volatile.LoadUint32(&o.PMC_PCER.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCER_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCDR: Peripheral Clock Disable Register
func (o *PMC_Type) SetPMC_PCDR_PID2(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCDR_PID2() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCDR_PID3(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCDR_PID3() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCDR_PID4(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_PCDR_PID4() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_PCDR_PID5(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCDR_PID5() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCDR_PID6(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_PCDR_PID6() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_PCDR_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCDR_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCDR_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCDR_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCDR_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCDR_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCDR_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCDR_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCDR_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCDR_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCDR_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCDR_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCDR_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCDR_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCDR_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCDR_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCDR_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCDR_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCDR_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCDR_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCDR_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCDR_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCDR_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCDR_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCDR_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCDR_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCDR_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCDR_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCDR_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCDR_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCDR_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCDR_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCDR_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCDR_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCDR_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCDR_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCDR_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCDR_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCDR_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCDR_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCDR_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCDR_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCDR_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCDR_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCDR_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCDR_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCDR_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCDR_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCDR_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR.Reg, volatile.LoadUint32(&o.PMC_PCDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCDR_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCSR: Peripheral Clock Status Register
func (o *PMC_Type) SetPMC_PCSR_PID2(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_PCSR_PID2() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_PCSR_PID3(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_PCSR_PID3() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_PCSR_PID4(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_PCSR_PID4() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_PCSR_PID5(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_PCSR_PID5() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_PCSR_PID6(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_PCSR_PID6() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_PCSR_PID7(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_PCSR_PID7() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_PCSR_PID8(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_PCSR_PID8() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_PCSR_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCSR_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCSR_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCSR_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCSR_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCSR_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCSR_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCSR_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCSR_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCSR_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCSR_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCSR_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCSR_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCSR_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCSR_PID16(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PCSR_PID16() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_PCSR_PID17(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_PCSR_PID17() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_PCSR_PID18(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_PCSR_PID18() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_PCSR_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCSR_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCSR_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCSR_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCSR_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCSR_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCSR_PID22(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPMC_PCSR_PID22() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPMC_PCSR_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCSR_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCSR_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCSR_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCSR_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCSR_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCSR_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCSR_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCSR_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCSR_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCSR_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCSR_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCSR_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCSR_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCSR_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCSR_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCSR_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR.Reg, volatile.LoadUint32(&o.PMC_PCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCSR_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR.Reg) & 0x80000000) >> 31
}

// PMC.CKGR_MOR: Main Oscillator Register
func (o *PMC_Type) SetCKGR_MOR_MOSCEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCEN() uint32 {
	return volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1
}
func (o *PMC_Type) SetCKGR_MOR_OSCBYPASS(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetCKGR_MOR_OSCBYPASS() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetCKGR_MOR_OSCOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff00)|value<<8)
}
func (o *PMC_Type) GetCKGR_MOR_OSCOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff00) >> 8
}

// PMC.CKGR_MCFR: Main Clock Frequency Register
func (o *PMC_Type) SetCKGR_MCFR_MAINF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0xffff)|value)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINF() uint32 {
	return volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0xffff
}
func (o *PMC_Type) SetCKGR_MCFR_MAINRDY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINRDY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x10000) >> 16
}

// PMC.CKGR_PLLAR: PLL A Register
func (o *PMC_Type) SetCKGR_PLLAR_DIVA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLAR_DIVA() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLAR_PLLACOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLAR_PLLACOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLAR_OUTA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xc000)|value<<14)
}
func (o *PMC_Type) GetCKGR_PLLAR_OUTA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xc000) >> 14
}
func (o *PMC_Type) SetCKGR_PLLAR_MULA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLAR_MULA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLAR_STUCKTO1(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetCKGR_PLLAR_STUCKTO1() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x20000000) >> 29
}

// PMC.CKGR_PLLBR: PLL B Register
func (o *PMC_Type) SetCKGR_PLLBR_DIVB(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLBR.Reg, volatile.LoadUint32(&o.CKGR_PLLBR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLBR_DIVB() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLBR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLBR_PLLBCOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLBR.Reg, volatile.LoadUint32(&o.CKGR_PLLBR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLBR_PLLBCOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLBR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLBR_OUTB(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLBR.Reg, volatile.LoadUint32(&o.CKGR_PLLBR.Reg)&^(0xc000)|value<<14)
}
func (o *PMC_Type) GetCKGR_PLLBR_OUTB() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLBR.Reg) & 0xc000) >> 14
}
func (o *PMC_Type) SetCKGR_PLLBR_MULB(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLBR.Reg, volatile.LoadUint32(&o.CKGR_PLLBR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLBR_MULB() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLBR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLBR_USBDIV(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLBR.Reg, volatile.LoadUint32(&o.CKGR_PLLBR.Reg)&^(0x30000000)|value<<28)
}
func (o *PMC_Type) GetCKGR_PLLBR_USBDIV() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLBR.Reg) & 0x30000000) >> 28
}

// PMC.PMC_MCKR: Master Clock Register
func (o *PMC_Type) SetPMC_MCKR_CSS(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetPMC_MCKR_CSS() uint32 {
	return volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x3
}
func (o *PMC_Type) SetPMC_MCKR_PRES(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x1c)|value<<2)
}
func (o *PMC_Type) GetPMC_MCKR_PRES() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x1c) >> 2
}
func (o *PMC_Type) SetPMC_MCKR_MDIV(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x300)|value<<8)
}
func (o *PMC_Type) GetPMC_MCKR_MDIV() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x300) >> 8
}

// PMC.PMC_PCK: Programmable Clock 0 Register
func (o *PMC_Type) SetPMC_PCK_CSS(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetPMC_PCK_CSS(idx int) uint32 {
	return volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x3
}
func (o *PMC_Type) SetPMC_PCK_PRES(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x1c)|value<<2)
}
func (o *PMC_Type) GetPMC_PCK_PRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x1c) >> 2
}

// PMC.PMC_IER: Interrupt Enable Register
func (o *PMC_Type) SetPMC_IER_MOSCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IER_MOSCS() uint32 {
	return volatile.LoadUint32(&o.PMC_IER.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IER_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IER_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IER_LOCKB(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_IER_LOCKB() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_IER_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IER_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IER_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IER_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IER_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IER_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x800) >> 11
}

// PMC.PMC_IDR: Interrupt Disable Register
func (o *PMC_Type) SetPMC_IDR_MOSCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IDR_MOSCS() uint32 {
	return volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IDR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IDR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IDR_LOCKB(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_IDR_LOCKB() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_IDR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IDR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x800) >> 11
}

// PMC.PMC_SR: Status Register
func (o *PMC_Type) SetPMC_SR_MOSCS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SR_MOSCS() uint32 {
	return volatile.LoadUint32(&o.PMC_SR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SR_LOCKB(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_SR_LOCKB() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_SR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x800) >> 11
}

// PMC.PMC_IMR: Interrupt Mask Register
func (o *PMC_Type) SetPMC_IMR_MOSCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IMR_MOSCS() uint32 {
	return volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IMR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IMR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IMR_LOCKB(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_IMR_LOCKB() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_IMR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IMR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x800) >> 11
}

// PMC.PMC_PLLICPR: Charge Pump Current Register
func (o *PMC_Type) SetPMC_PLLICPR_ICPPLLA(value uint32) {
	volatile.StoreUint32(&o.PMC_PLLICPR.Reg, volatile.LoadUint32(&o.PMC_PLLICPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_PLLICPR_ICPPLLA() uint32 {
	return volatile.LoadUint32(&o.PMC_PLLICPR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_PLLICPR_ICPPLLB(value uint32) {
	volatile.StoreUint32(&o.PMC_PLLICPR.Reg, volatile.LoadUint32(&o.PMC_PLLICPR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_PLLICPR_ICPPLLB() uint32 {
	return (volatile.LoadUint32(&o.PMC_PLLICPR.Reg) & 0x10000) >> 16
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// SYSC.CR: Control Register
func (o *SYSC_Type) SetCR_PROCRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetCR_PROCRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SYSC_Type) SetCR_PERRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetCR_PERRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetCR_EXTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetCR_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSC_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// SYSC.SR: Status Register
func (o *SYSC_Type) SetSR_URSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSR_URSTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SYSC_Type) SetSR_RSTTYP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x700)|value<<8)
}
func (o *SYSC_Type) GetSR_RSTTYP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x700) >> 8
}
func (o *SYSC_Type) SetSR_NRSTL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSC_Type) GetSR_NRSTL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SYSC_Type) SetSR_SRCMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSC_Type) GetSR_SRCMP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SYSC.MR: Mode Register
func (o *SYSC_Type) SetMR_URSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetMR_URSTEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SYSC_Type) SetMR_URSTIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetMR_URSTIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SYSC_Type) SetMR_ERSTL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *SYSC_Type) GetMR_ERSTL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *SYSC_Type) SetMR_KEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSC_Type) GetMR_KEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// Constants for UHP: USB Host Port
const ()

// Constants for LCDC: LCD Controller
const (
	// DMABADDR1: DMA Base Address Register 1
	// Position of BADDR_U field.
	LCDC_DMABADDR1_BADDR_U_Pos = 0x2
	// Bit mask of BADDR_U field.
	LCDC_DMABADDR1_BADDR_U_Msk = 0xfffffffc

	// DMABADDR2: DMA Base Address Register 2
	// Position of BADDR_L field.
	LCDC_DMABADDR2_BADDR_L_Pos = 0x0
	// Bit mask of BADDR_L field.
	LCDC_DMABADDR2_BADDR_L_Msk = 0xffffffff

	// DMAFRMPT1: DMA Frame Pointer Register 1
	// Position of FRMPT_U field.
	LCDC_DMAFRMPT1_FRMPT_U_Pos = 0x0
	// Bit mask of FRMPT_U field.
	LCDC_DMAFRMPT1_FRMPT_U_Msk = 0x7fffff

	// DMAFRMPT2: DMA Frame Pointer Register 2
	// Position of FRMPT_L field.
	LCDC_DMAFRMPT2_FRMPT_L_Pos = 0x0
	// Bit mask of FRMPT_L field.
	LCDC_DMAFRMPT2_FRMPT_L_Msk = 0x7fffff

	// DMAFRMADD1: DMA Frame Address Register 1
	// Position of FRMADD_U field.
	LCDC_DMAFRMADD1_FRMADD_U_Pos = 0x0
	// Bit mask of FRMADD_U field.
	LCDC_DMAFRMADD1_FRMADD_U_Msk = 0xffffffff

	// DMAFRMADD2: DMA Frame Address Register 2
	// Position of FRMADD_L field.
	LCDC_DMAFRMADD2_FRMADD_L_Pos = 0x0
	// Bit mask of FRMADD_L field.
	LCDC_DMAFRMADD2_FRMADD_L_Msk = 0xffffffff

	// DMAFRMCFG: DMA Frame Configuration Register
	// Position of FRMSIZE field.
	LCDC_DMAFRMCFG_FRMSIZE_Pos = 0x0
	// Bit mask of FRMSIZE field.
	LCDC_DMAFRMCFG_FRMSIZE_Msk = 0x7fffff
	// Position of BRSTLN field.
	LCDC_DMAFRMCFG_BRSTLN_Pos = 0x18
	// Bit mask of BRSTLN field.
	LCDC_DMAFRMCFG_BRSTLN_Msk = 0x7f000000

	// DMACON: DMA Control Register
	// Position of DMAEN field.
	LCDC_DMACON_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	LCDC_DMACON_DMAEN_Msk = 0x1
	// Bit DMAEN.
	LCDC_DMACON_DMAEN = 0x1
	// Position of DMARST field.
	LCDC_DMACON_DMARST_Pos = 0x1
	// Bit mask of DMARST field.
	LCDC_DMACON_DMARST_Msk = 0x2
	// Bit DMARST.
	LCDC_DMACON_DMARST = 0x2
	// Position of DMABUSY field.
	LCDC_DMACON_DMABUSY_Pos = 0x2
	// Bit mask of DMABUSY field.
	LCDC_DMACON_DMABUSY_Msk = 0x4
	// Bit DMABUSY.
	LCDC_DMACON_DMABUSY = 0x4

	// LCDCON1: LCD Control Register 1
	// Position of BYPASS field.
	LCDC_LCDCON1_BYPASS_Pos = 0x0
	// Bit mask of BYPASS field.
	LCDC_LCDCON1_BYPASS_Msk = 0x1
	// Bit BYPASS.
	LCDC_LCDCON1_BYPASS = 0x1
	// Position of CLKVAL field.
	LCDC_LCDCON1_CLKVAL_Pos = 0xc
	// Bit mask of CLKVAL field.
	LCDC_LCDCON1_CLKVAL_Msk = 0x1ff000
	// Position of LINECNT field.
	LCDC_LCDCON1_LINECNT_Pos = 0x15
	// Bit mask of LINECNT field.
	LCDC_LCDCON1_LINECNT_Msk = 0xffe00000

	// LCDCON2: LCD Control Register 2
	// Position of DISTYPE field.
	LCDC_LCDCON2_DISTYPE_Pos = 0x0
	// Bit mask of DISTYPE field.
	LCDC_LCDCON2_DISTYPE_Msk = 0x3
	// Position of SCANMOD field.
	LCDC_LCDCON2_SCANMOD_Pos = 0x2
	// Bit mask of SCANMOD field.
	LCDC_LCDCON2_SCANMOD_Msk = 0x4
	// Bit SCANMOD.
	LCDC_LCDCON2_SCANMOD = 0x4
	// Position of IFWIDTH field.
	LCDC_LCDCON2_IFWIDTH_Pos = 0x3
	// Bit mask of IFWIDTH field.
	LCDC_LCDCON2_IFWIDTH_Msk = 0x18
	// Position of PIXELSIZE field.
	LCDC_LCDCON2_PIXELSIZE_Pos = 0x5
	// Bit mask of PIXELSIZE field.
	LCDC_LCDCON2_PIXELSIZE_Msk = 0xe0
	// Position of INVVD field.
	LCDC_LCDCON2_INVVD_Pos = 0x8
	// Bit mask of INVVD field.
	LCDC_LCDCON2_INVVD_Msk = 0x100
	// Bit INVVD.
	LCDC_LCDCON2_INVVD = 0x100
	// Position of INVFRAME field.
	LCDC_LCDCON2_INVFRAME_Pos = 0x9
	// Bit mask of INVFRAME field.
	LCDC_LCDCON2_INVFRAME_Msk = 0x200
	// Bit INVFRAME.
	LCDC_LCDCON2_INVFRAME = 0x200
	// Position of INVLINE field.
	LCDC_LCDCON2_INVLINE_Pos = 0xa
	// Bit mask of INVLINE field.
	LCDC_LCDCON2_INVLINE_Msk = 0x400
	// Bit INVLINE.
	LCDC_LCDCON2_INVLINE = 0x400
	// Position of INVCLK field.
	LCDC_LCDCON2_INVCLK_Pos = 0xb
	// Bit mask of INVCLK field.
	LCDC_LCDCON2_INVCLK_Msk = 0x800
	// Bit INVCLK.
	LCDC_LCDCON2_INVCLK = 0x800
	// Position of INVDVAL field.
	LCDC_LCDCON2_INVDVAL_Pos = 0xc
	// Bit mask of INVDVAL field.
	LCDC_LCDCON2_INVDVAL_Msk = 0x1000
	// Bit INVDVAL.
	LCDC_LCDCON2_INVDVAL = 0x1000
	// Position of CLKMOD field.
	LCDC_LCDCON2_CLKMOD_Pos = 0xf
	// Bit mask of CLKMOD field.
	LCDC_LCDCON2_CLKMOD_Msk = 0x8000
	// Bit CLKMOD.
	LCDC_LCDCON2_CLKMOD = 0x8000
	// Position of MEMOR field.
	LCDC_LCDCON2_MEMOR_Pos = 0x1e
	// Bit mask of MEMOR field.
	LCDC_LCDCON2_MEMOR_Msk = 0xc0000000

	// LCDTIM1: LCD Timing Register 1
	// Position of VFP field.
	LCDC_LCDTIM1_VFP_Pos = 0x0
	// Bit mask of VFP field.
	LCDC_LCDTIM1_VFP_Msk = 0xff
	// Position of VBP field.
	LCDC_LCDTIM1_VBP_Pos = 0x8
	// Bit mask of VBP field.
	LCDC_LCDTIM1_VBP_Msk = 0xff00
	// Position of VPW field.
	LCDC_LCDTIM1_VPW_Pos = 0x10
	// Bit mask of VPW field.
	LCDC_LCDTIM1_VPW_Msk = 0x3f0000
	// Position of VHDLY field.
	LCDC_LCDTIM1_VHDLY_Pos = 0x18
	// Bit mask of VHDLY field.
	LCDC_LCDTIM1_VHDLY_Msk = 0xf000000
	// Position of STUCKTO1 field.
	LCDC_LCDTIM1_STUCKTO1_Pos = 0x1f
	// Bit mask of STUCKTO1 field.
	LCDC_LCDTIM1_STUCKTO1_Msk = 0x80000000
	// Bit STUCKTO1.
	LCDC_LCDTIM1_STUCKTO1 = 0x80000000

	// LCDTIM2: LCD Timing Register 2
	// Position of HBP field.
	LCDC_LCDTIM2_HBP_Pos = 0x0
	// Bit mask of HBP field.
	LCDC_LCDTIM2_HBP_Msk = 0xff
	// Position of HPW field.
	LCDC_LCDTIM2_HPW_Pos = 0x8
	// Bit mask of HPW field.
	LCDC_LCDTIM2_HPW_Msk = 0x3f00
	// Position of HFP field.
	LCDC_LCDTIM2_HFP_Pos = 0x15
	// Bit mask of HFP field.
	LCDC_LCDTIM2_HFP_Msk = 0xffe00000

	// LCDFRMCFG: LCD Frame Configuration Register
	// Position of LINEVAL field.
	LCDC_LCDFRMCFG_LINEVAL_Pos = 0x0
	// Bit mask of LINEVAL field.
	LCDC_LCDFRMCFG_LINEVAL_Msk = 0x7ff
	// Position of HOZVAL field.
	LCDC_LCDFRMCFG_HOZVAL_Pos = 0x15
	// Bit mask of HOZVAL field.
	LCDC_LCDFRMCFG_HOZVAL_Msk = 0xffe00000

	// LCDFIFO: LCD FIFO Register
	// Position of FIFOTH field.
	LCDC_LCDFIFO_FIFOTH_Pos = 0x0
	// Bit mask of FIFOTH field.
	LCDC_LCDFIFO_FIFOTH_Msk = 0xffff

	// LCDMVAL: LCDMOD Toggle Rate Value Register
	// Position of MVAL field.
	LCDC_LCDMVAL_MVAL_Pos = 0x0
	// Bit mask of MVAL field.
	LCDC_LCDMVAL_MVAL_Msk = 0xff
	// Position of MMODE field.
	LCDC_LCDMVAL_MMODE_Pos = 0x1f
	// Bit mask of MMODE field.
	LCDC_LCDMVAL_MMODE_Msk = 0x80000000
	// Bit MMODE.
	LCDC_LCDMVAL_MMODE = 0x80000000

	// DP1_2: Dithering Pattern DP1_2
	// Position of DP1_2 field.
	LCDC_DP1_2_DP1_2_Pos = 0x0
	// Bit mask of DP1_2 field.
	LCDC_DP1_2_DP1_2_Msk = 0xff

	// DP4_7: Dithering Pattern DP4_7
	// Position of DP4_7 field.
	LCDC_DP4_7_DP4_7_Pos = 0x0
	// Bit mask of DP4_7 field.
	LCDC_DP4_7_DP4_7_Msk = 0xfffffff

	// DP3_5: Dithering Pattern DP3_5
	// Position of DP3_5 field.
	LCDC_DP3_5_DP3_5_Pos = 0x0
	// Bit mask of DP3_5 field.
	LCDC_DP3_5_DP3_5_Msk = 0xfffff

	// DP2_3: Dithering Pattern DP2_3
	// Position of DP2_3 field.
	LCDC_DP2_3_DP2_3_Pos = 0x0
	// Bit mask of DP2_3 field.
	LCDC_DP2_3_DP2_3_Msk = 0xfff

	// DP5_7: Dithering Pattern DP5_7
	// Position of DP5_7 field.
	LCDC_DP5_7_DP5_7_Pos = 0x0
	// Bit mask of DP5_7 field.
	LCDC_DP5_7_DP5_7_Msk = 0xfffffff

	// DP3_4: Dithering Pattern DP3_4
	// Position of DP3_4 field.
	LCDC_DP3_4_DP3_4_Pos = 0x0
	// Bit mask of DP3_4 field.
	LCDC_DP3_4_DP3_4_Msk = 0xffff

	// DP4_5: Dithering Pattern DP4_5
	// Position of DP4_5 field.
	LCDC_DP4_5_DP4_5_Pos = 0x0
	// Bit mask of DP4_5 field.
	LCDC_DP4_5_DP4_5_Msk = 0xfffff

	// DP6_7: Dithering Pattern DP6_7
	// Position of DP6_7 field.
	LCDC_DP6_7_DP6_7_Pos = 0x0
	// Bit mask of DP6_7 field.
	LCDC_DP6_7_DP6_7_Msk = 0xfffffff

	// PWRCON: Power Control Register
	// Position of LCD_PWR field.
	LCDC_PWRCON_LCD_PWR_Pos = 0x0
	// Bit mask of LCD_PWR field.
	LCDC_PWRCON_LCD_PWR_Msk = 0x1
	// Bit LCD_PWR.
	LCDC_PWRCON_LCD_PWR = 0x1
	// Position of GUARD_TIME field.
	LCDC_PWRCON_GUARD_TIME_Pos = 0x1
	// Bit mask of GUARD_TIME field.
	LCDC_PWRCON_GUARD_TIME_Msk = 0xfe
	// Position of LCD_BUSY field.
	LCDC_PWRCON_LCD_BUSY_Pos = 0x1f
	// Bit mask of LCD_BUSY field.
	LCDC_PWRCON_LCD_BUSY_Msk = 0x80000000
	// Bit LCD_BUSY.
	LCDC_PWRCON_LCD_BUSY = 0x80000000

	// CONTRAST_CTR: Contrast Control Register
	// Position of PS field.
	LCDC_CONTRAST_CTR_PS_Pos = 0x0
	// Bit mask of PS field.
	LCDC_CONTRAST_CTR_PS_Msk = 0x3
	// Position of POL field.
	LCDC_CONTRAST_CTR_POL_Pos = 0x2
	// Bit mask of POL field.
	LCDC_CONTRAST_CTR_POL_Msk = 0x4
	// Bit POL.
	LCDC_CONTRAST_CTR_POL = 0x4
	// Position of ENA field.
	LCDC_CONTRAST_CTR_ENA_Pos = 0x3
	// Bit mask of ENA field.
	LCDC_CONTRAST_CTR_ENA_Msk = 0x8
	// Bit ENA.
	LCDC_CONTRAST_CTR_ENA = 0x8

	// LCD_IER: LCD Interrupt Enable Register
	// Position of LNIE field.
	LCDC_LCD_IER_LNIE_Pos = 0x0
	// Bit mask of LNIE field.
	LCDC_LCD_IER_LNIE_Msk = 0x1
	// Bit LNIE.
	LCDC_LCD_IER_LNIE = 0x1
	// Position of LSTLNIE field.
	LCDC_LCD_IER_LSTLNIE_Pos = 0x1
	// Bit mask of LSTLNIE field.
	LCDC_LCD_IER_LSTLNIE_Msk = 0x2
	// Bit LSTLNIE.
	LCDC_LCD_IER_LSTLNIE = 0x2
	// Position of EOFIE field.
	LCDC_LCD_IER_EOFIE_Pos = 0x2
	// Bit mask of EOFIE field.
	LCDC_LCD_IER_EOFIE_Msk = 0x4
	// Bit EOFIE.
	LCDC_LCD_IER_EOFIE = 0x4
	// Position of UFLWIE field.
	LCDC_LCD_IER_UFLWIE_Pos = 0x4
	// Bit mask of UFLWIE field.
	LCDC_LCD_IER_UFLWIE_Msk = 0x10
	// Bit UFLWIE.
	LCDC_LCD_IER_UFLWIE = 0x10
	// Position of OWRIE field.
	LCDC_LCD_IER_OWRIE_Pos = 0x5
	// Bit mask of OWRIE field.
	LCDC_LCD_IER_OWRIE_Msk = 0x20
	// Bit OWRIE.
	LCDC_LCD_IER_OWRIE = 0x20
	// Position of MERIE field.
	LCDC_LCD_IER_MERIE_Pos = 0x6
	// Bit mask of MERIE field.
	LCDC_LCD_IER_MERIE_Msk = 0x40
	// Bit MERIE.
	LCDC_LCD_IER_MERIE = 0x40

	// LCD_IDR: LCD Interrupt Disable Register
	// Position of LNID field.
	LCDC_LCD_IDR_LNID_Pos = 0x0
	// Bit mask of LNID field.
	LCDC_LCD_IDR_LNID_Msk = 0x1
	// Bit LNID.
	LCDC_LCD_IDR_LNID = 0x1
	// Position of LSTLNID field.
	LCDC_LCD_IDR_LSTLNID_Pos = 0x1
	// Bit mask of LSTLNID field.
	LCDC_LCD_IDR_LSTLNID_Msk = 0x2
	// Bit LSTLNID.
	LCDC_LCD_IDR_LSTLNID = 0x2
	// Position of EOFID field.
	LCDC_LCD_IDR_EOFID_Pos = 0x2
	// Bit mask of EOFID field.
	LCDC_LCD_IDR_EOFID_Msk = 0x4
	// Bit EOFID.
	LCDC_LCD_IDR_EOFID = 0x4
	// Position of UFLWID field.
	LCDC_LCD_IDR_UFLWID_Pos = 0x4
	// Bit mask of UFLWID field.
	LCDC_LCD_IDR_UFLWID_Msk = 0x10
	// Bit UFLWID.
	LCDC_LCD_IDR_UFLWID = 0x10
	// Position of OWRID field.
	LCDC_LCD_IDR_OWRID_Pos = 0x5
	// Bit mask of OWRID field.
	LCDC_LCD_IDR_OWRID_Msk = 0x20
	// Bit OWRID.
	LCDC_LCD_IDR_OWRID = 0x20
	// Position of MERID field.
	LCDC_LCD_IDR_MERID_Pos = 0x6
	// Bit mask of MERID field.
	LCDC_LCD_IDR_MERID_Msk = 0x40
	// Bit MERID.
	LCDC_LCD_IDR_MERID = 0x40

	// LCD_IMR: LCD Interrupt Mask Register
	// Position of LNIM field.
	LCDC_LCD_IMR_LNIM_Pos = 0x0
	// Bit mask of LNIM field.
	LCDC_LCD_IMR_LNIM_Msk = 0x1
	// Bit LNIM.
	LCDC_LCD_IMR_LNIM = 0x1
	// Position of LSTLNIM field.
	LCDC_LCD_IMR_LSTLNIM_Pos = 0x1
	// Bit mask of LSTLNIM field.
	LCDC_LCD_IMR_LSTLNIM_Msk = 0x2
	// Bit LSTLNIM.
	LCDC_LCD_IMR_LSTLNIM = 0x2
	// Position of EOFIM field.
	LCDC_LCD_IMR_EOFIM_Pos = 0x2
	// Bit mask of EOFIM field.
	LCDC_LCD_IMR_EOFIM_Msk = 0x4
	// Bit EOFIM.
	LCDC_LCD_IMR_EOFIM = 0x4
	// Position of UFLWIM field.
	LCDC_LCD_IMR_UFLWIM_Pos = 0x4
	// Bit mask of UFLWIM field.
	LCDC_LCD_IMR_UFLWIM_Msk = 0x10
	// Bit UFLWIM.
	LCDC_LCD_IMR_UFLWIM = 0x10
	// Position of OWRIM field.
	LCDC_LCD_IMR_OWRIM_Pos = 0x5
	// Bit mask of OWRIM field.
	LCDC_LCD_IMR_OWRIM_Msk = 0x20
	// Bit OWRIM.
	LCDC_LCD_IMR_OWRIM = 0x20
	// Position of MERIM field.
	LCDC_LCD_IMR_MERIM_Pos = 0x6
	// Bit mask of MERIM field.
	LCDC_LCD_IMR_MERIM_Msk = 0x40
	// Bit MERIM.
	LCDC_LCD_IMR_MERIM = 0x40

	// LCD_ISR: LCD Interrupt Status Register
	// Position of LNIS field.
	LCDC_LCD_ISR_LNIS_Pos = 0x0
	// Bit mask of LNIS field.
	LCDC_LCD_ISR_LNIS_Msk = 0x1
	// Bit LNIS.
	LCDC_LCD_ISR_LNIS = 0x1
	// Position of LSTLNIS field.
	LCDC_LCD_ISR_LSTLNIS_Pos = 0x1
	// Bit mask of LSTLNIS field.
	LCDC_LCD_ISR_LSTLNIS_Msk = 0x2
	// Bit LSTLNIS.
	LCDC_LCD_ISR_LSTLNIS = 0x2
	// Position of EOFIS field.
	LCDC_LCD_ISR_EOFIS_Pos = 0x2
	// Bit mask of EOFIS field.
	LCDC_LCD_ISR_EOFIS_Msk = 0x4
	// Bit EOFIS.
	LCDC_LCD_ISR_EOFIS = 0x4
	// Position of UFLWIS field.
	LCDC_LCD_ISR_UFLWIS_Pos = 0x4
	// Bit mask of UFLWIS field.
	LCDC_LCD_ISR_UFLWIS_Msk = 0x10
	// Bit UFLWIS.
	LCDC_LCD_ISR_UFLWIS = 0x10
	// Position of OWRIS field.
	LCDC_LCD_ISR_OWRIS_Pos = 0x5
	// Bit mask of OWRIS field.
	LCDC_LCD_ISR_OWRIS_Msk = 0x20
	// Bit OWRIS.
	LCDC_LCD_ISR_OWRIS = 0x20
	// Position of MERIS field.
	LCDC_LCD_ISR_MERIS_Pos = 0x6
	// Bit mask of MERIS field.
	LCDC_LCD_ISR_MERIS_Msk = 0x40
	// Bit MERIS.
	LCDC_LCD_ISR_MERIS = 0x40

	// LCD_ICR: LCD Interrupt Clear Register
	// Position of LNIC field.
	LCDC_LCD_ICR_LNIC_Pos = 0x0
	// Bit mask of LNIC field.
	LCDC_LCD_ICR_LNIC_Msk = 0x1
	// Bit LNIC.
	LCDC_LCD_ICR_LNIC = 0x1
	// Position of LSTLNIC field.
	LCDC_LCD_ICR_LSTLNIC_Pos = 0x1
	// Bit mask of LSTLNIC field.
	LCDC_LCD_ICR_LSTLNIC_Msk = 0x2
	// Bit LSTLNIC.
	LCDC_LCD_ICR_LSTLNIC = 0x2
	// Position of EOFIC field.
	LCDC_LCD_ICR_EOFIC_Pos = 0x2
	// Bit mask of EOFIC field.
	LCDC_LCD_ICR_EOFIC_Msk = 0x4
	// Bit EOFIC.
	LCDC_LCD_ICR_EOFIC = 0x4
	// Position of UFLWIC field.
	LCDC_LCD_ICR_UFLWIC_Pos = 0x4
	// Bit mask of UFLWIC field.
	LCDC_LCD_ICR_UFLWIC_Msk = 0x10
	// Bit UFLWIC.
	LCDC_LCD_ICR_UFLWIC = 0x10
	// Position of OWRIC field.
	LCDC_LCD_ICR_OWRIC_Pos = 0x5
	// Bit mask of OWRIC field.
	LCDC_LCD_ICR_OWRIC_Msk = 0x20
	// Bit OWRIC.
	LCDC_LCD_ICR_OWRIC = 0x20
	// Position of MERIC field.
	LCDC_LCD_ICR_MERIC_Pos = 0x6
	// Bit mask of MERIC field.
	LCDC_LCD_ICR_MERIC_Msk = 0x40
	// Bit MERIC.
	LCDC_LCD_ICR_MERIC = 0x40

	// LCD_WPSR: Write Protection Status Register
	// Position of WPVS field.
	LCDC_LCD_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	LCDC_LCD_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	LCDC_LCD_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	LCDC_LCD_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	LCDC_LCD_WPSR_WPVSRC_Msk = 0xffff00
)

// Constants for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVE_EQ_1: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffffffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffffffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffffffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffffffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVE_EQ_1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffffffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffffffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffffffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffffffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR1_CPAS = 0x4
	// Position of CPBS field.
	TC_SR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR1_CPBS = 0x8
	// Position of CPCS field.
	TC_SR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR1_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR1_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR1_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR1_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR1_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR1_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR1_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR1_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR1_MTIOB = 0x40000

	// IER1: Interrupt Enable Register (channel = 1)
	// Position of COVFS field.
	TC_IER1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER1_CPAS = 0x4
	// Position of CPBS field.
	TC_IER1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER1_CPBS = 0x8
	// Position of CPCS field.
	TC_IER1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER1_ETRGS = 0x80

	// IDR1: Interrupt Disable Register (channel = 1)
	// Position of COVFS field.
	TC_IDR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR1_ETRGS = 0x80

	// IMR1: Interrupt Mask Register (channel = 1)
	// Position of COVFS field.
	TC_IMR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR1_ETRGS = 0x80

	// CCR2: Channel Control Register (channel = 2)
	// Position of CLKEN field.
	TC_CCR2_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR2_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR2_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR2_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR2_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR2_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR2_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR2_SWTRG = 0x4

	// CMR2: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR2_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR2_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR2_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR2_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR2_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR2_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR2_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR2_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR2_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR2_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR2_LDRA_Msk = 0x30000
	// None
	TC_CMR2_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR2_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR2_LDRB_Msk = 0xc0000
	// None
	TC_CMR2_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRB_EDGE = 0x3

	// CMR2_WAVE_EQ_1: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR2_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR2_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR2_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR2_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR2_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR2_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR2_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR2_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR2_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR2_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR2_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR2_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR2_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR2_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// CV2: Counter Value (channel = 2)
	// Position of CV field.
	TC_CV2_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV2_CV_Msk = 0xffffffff

	// RA2: Register A (channel = 2)
	// Position of RA field.
	TC_RA2_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA2_RA_Msk = 0xffffffff

	// RB2: Register B (channel = 2)
	// Position of RB field.
	TC_RB2_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB2_RB_Msk = 0xffffffff

	// RC2: Register C (channel = 2)
	// Position of RC field.
	TC_RC2_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC2_RC_Msk = 0xffffffff

	// SR2: Status Register (channel = 2)
	// Position of COVFS field.
	TC_SR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR2_CPAS = 0x4
	// Position of CPBS field.
	TC_SR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR2_CPBS = 0x8
	// Position of CPCS field.
	TC_SR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR2_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR2_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR2_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR2_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR2_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR2_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR2_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR2_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR2_MTIOB = 0x40000

	// IER2: Interrupt Enable Register (channel = 2)
	// Position of COVFS field.
	TC_IER2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER2_CPAS = 0x4
	// Position of CPBS field.
	TC_IER2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER2_CPBS = 0x8
	// Position of CPCS field.
	TC_IER2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER2_ETRGS = 0x80

	// IDR2: Interrupt Disable Register (channel = 2)
	// Position of COVFS field.
	TC_IDR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR2_ETRGS = 0x80

	// IMR2: Interrupt Mask Register (channel = 2)
	// Position of COVFS field.
	TC_IMR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR2_ETRGS = 0x80

	// BCR: Block Control Register
	// Position of SYNC field.
	TC_BCR_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	TC_BCR_SYNC_Msk = 0x1
	// Bit SYNC.
	TC_BCR_SYNC = 0x1

	// BMR: Block Mode Register
	// Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Pos = 0x0
	// Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk = 0x3
	// Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK0 = 0x0
	// Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA1 = 0x2
	// Signal connected to XC0: TIOA2
	TC_BMR_TC0XC0S_TIOA2 = 0x3
	// Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Pos = 0x2
	// Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk = 0xc
	// Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK1 = 0x0
	// Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA0 = 0x2
	// Signal connected to XC1: TIOA2
	TC_BMR_TC1XC1S_TIOA2 = 0x3
	// Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Pos = 0x4
	// Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk = 0x30
	// Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TCLK2 = 0x0
	// Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA1 = 0x2
	// Signal connected to XC2: TIOA2
	TC_BMR_TC2XC2S_TIOA2 = 0x3
)

// Constants for UDP: USB Device Port
const (
	// FRM_NUM: Frame Number Register
	// Position of FRM_NUM field.
	UDP_FRM_NUM_FRM_NUM_Pos = 0x0
	// Bit mask of FRM_NUM field.
	UDP_FRM_NUM_FRM_NUM_Msk = 0x7ff
	// Position of FRM_ERR field.
	UDP_FRM_NUM_FRM_ERR_Pos = 0x10
	// Bit mask of FRM_ERR field.
	UDP_FRM_NUM_FRM_ERR_Msk = 0x10000
	// Bit FRM_ERR.
	UDP_FRM_NUM_FRM_ERR = 0x10000
	// Position of FRM_OK field.
	UDP_FRM_NUM_FRM_OK_Pos = 0x11
	// Bit mask of FRM_OK field.
	UDP_FRM_NUM_FRM_OK_Msk = 0x20000
	// Bit FRM_OK.
	UDP_FRM_NUM_FRM_OK = 0x20000

	// GLB_STAT: Global State Register
	// Position of FADDEN field.
	UDP_GLB_STAT_FADDEN_Pos = 0x0
	// Bit mask of FADDEN field.
	UDP_GLB_STAT_FADDEN_Msk = 0x1
	// Bit FADDEN.
	UDP_GLB_STAT_FADDEN = 0x1
	// Position of CONFG field.
	UDP_GLB_STAT_CONFG_Pos = 0x1
	// Bit mask of CONFG field.
	UDP_GLB_STAT_CONFG_Msk = 0x2
	// Bit CONFG.
	UDP_GLB_STAT_CONFG = 0x2

	// FADDR: Function Address Register
	// Position of FADD field.
	UDP_FADDR_FADD_Pos = 0x0
	// Bit mask of FADD field.
	UDP_FADDR_FADD_Msk = 0x7f
	// Position of FEN field.
	UDP_FADDR_FEN_Pos = 0x8
	// Bit mask of FEN field.
	UDP_FADDR_FEN_Msk = 0x100
	// Bit FEN.
	UDP_FADDR_FEN = 0x100

	// IER: Interrupt Enable Register
	// Position of EP0INT field.
	UDP_IER_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IER_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IER_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IER_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IER_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IER_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IER_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IER_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IER_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IER_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IER_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IER_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IER_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IER_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IER_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IER_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IER_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IER_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IER_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IER_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IER_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IER_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IER_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IER_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_IER_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IER_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IER_SOFINT = 0x800
	// Position of WAKEUP field.
	UDP_IER_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IER_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IER_WAKEUP = 0x2000

	// IDR: Interrupt Disable Register
	// Position of EP0INT field.
	UDP_IDR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IDR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IDR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IDR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IDR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IDR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IDR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IDR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IDR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IDR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IDR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IDR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IDR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IDR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IDR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IDR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IDR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IDR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IDR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IDR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IDR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IDR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IDR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IDR_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_IDR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IDR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IDR_SOFINT = 0x800
	// Position of WAKEUP field.
	UDP_IDR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IDR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IDR_WAKEUP = 0x2000

	// IMR: Interrupt Mask Register
	// Position of EP0INT field.
	UDP_IMR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IMR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IMR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IMR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IMR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IMR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IMR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IMR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IMR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IMR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IMR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IMR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IMR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IMR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IMR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IMR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IMR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IMR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IMR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IMR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IMR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IMR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IMR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IMR_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_IMR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IMR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IMR_SOFINT = 0x800
	// Position of BIT12 field.
	UDP_IMR_BIT12_Pos = 0xc
	// Bit mask of BIT12 field.
	UDP_IMR_BIT12_Msk = 0x1000
	// Bit BIT12.
	UDP_IMR_BIT12 = 0x1000
	// Position of WAKEUP field.
	UDP_IMR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IMR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IMR_WAKEUP = 0x2000

	// ISR: Interrupt Status Register
	// Position of EP0INT field.
	UDP_ISR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_ISR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_ISR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_ISR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_ISR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_ISR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_ISR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_ISR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_ISR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_ISR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_ISR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_ISR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_ISR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_ISR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_ISR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_ISR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_ISR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_ISR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_ISR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_ISR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_ISR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_ISR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_ISR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_ISR_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_ISR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_ISR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_ISR_SOFINT = 0x800
	// Position of ENDBUSRES field.
	UDP_ISR_ENDBUSRES_Pos = 0xc
	// Bit mask of ENDBUSRES field.
	UDP_ISR_ENDBUSRES_Msk = 0x1000
	// Bit ENDBUSRES.
	UDP_ISR_ENDBUSRES = 0x1000
	// Position of WAKEUP field.
	UDP_ISR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_ISR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_ISR_WAKEUP = 0x2000

	// ICR: Interrupt Clear Register
	// Position of RXSUSP field.
	UDP_ICR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_ICR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_ICR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_ICR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_ICR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_ICR_RXRSM = 0x200
	// Position of SOFINT field.
	UDP_ICR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_ICR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_ICR_SOFINT = 0x800
	// Position of ENDBUSRES field.
	UDP_ICR_ENDBUSRES_Pos = 0xc
	// Bit mask of ENDBUSRES field.
	UDP_ICR_ENDBUSRES_Msk = 0x1000
	// Bit ENDBUSRES.
	UDP_ICR_ENDBUSRES = 0x1000
	// Position of WAKEUP field.
	UDP_ICR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_ICR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_ICR_WAKEUP = 0x2000

	// RST_EP: Reset Endpoint Register
	// Position of EP0 field.
	UDP_RST_EP_EP0_Pos = 0x0
	// Bit mask of EP0 field.
	UDP_RST_EP_EP0_Msk = 0x1
	// Bit EP0.
	UDP_RST_EP_EP0 = 0x1
	// Position of EP1 field.
	UDP_RST_EP_EP1_Pos = 0x1
	// Bit mask of EP1 field.
	UDP_RST_EP_EP1_Msk = 0x2
	// Bit EP1.
	UDP_RST_EP_EP1 = 0x2
	// Position of EP2 field.
	UDP_RST_EP_EP2_Pos = 0x2
	// Bit mask of EP2 field.
	UDP_RST_EP_EP2_Msk = 0x4
	// Bit EP2.
	UDP_RST_EP_EP2 = 0x4
	// Position of EP3 field.
	UDP_RST_EP_EP3_Pos = 0x3
	// Bit mask of EP3 field.
	UDP_RST_EP_EP3_Msk = 0x8
	// Bit EP3.
	UDP_RST_EP_EP3 = 0x8
	// Position of EP4 field.
	UDP_RST_EP_EP4_Pos = 0x4
	// Bit mask of EP4 field.
	UDP_RST_EP_EP4_Msk = 0x10
	// Bit EP4.
	UDP_RST_EP_EP4 = 0x10
	// Position of EP5 field.
	UDP_RST_EP_EP5_Pos = 0x5
	// Bit mask of EP5 field.
	UDP_RST_EP_EP5_Msk = 0x20
	// Bit EP5.
	UDP_RST_EP_EP5 = 0x20

	// CSR: Endpoint Control and Status Register (ept_num = 0)
	// Position of TXCOMP field.
	UDP_CSR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	UDP_CSR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	UDP_CSR_TXCOMP = 0x1
	// Position of RX_DATA_BK0 field.
	UDP_CSR_RX_DATA_BK0_Pos = 0x1
	// Bit mask of RX_DATA_BK0 field.
	UDP_CSR_RX_DATA_BK0_Msk = 0x2
	// Bit RX_DATA_BK0.
	UDP_CSR_RX_DATA_BK0 = 0x2
	// Position of RXSETUP field.
	UDP_CSR_RXSETUP_Pos = 0x2
	// Bit mask of RXSETUP field.
	UDP_CSR_RXSETUP_Msk = 0x4
	// Bit RXSETUP.
	UDP_CSR_RXSETUP = 0x4
	// Position of STALLSENTISOERROR field.
	UDP_CSR_STALLSENTISOERROR_Pos = 0x3
	// Bit mask of STALLSENTISOERROR field.
	UDP_CSR_STALLSENTISOERROR_Msk = 0x8
	// Bit STALLSENTISOERROR.
	UDP_CSR_STALLSENTISOERROR = 0x8
	// Position of TXPKTRDY field.
	UDP_CSR_TXPKTRDY_Pos = 0x4
	// Bit mask of TXPKTRDY field.
	UDP_CSR_TXPKTRDY_Msk = 0x10
	// Bit TXPKTRDY.
	UDP_CSR_TXPKTRDY = 0x10
	// Position of FORCESTALL field.
	UDP_CSR_FORCESTALL_Pos = 0x5
	// Bit mask of FORCESTALL field.
	UDP_CSR_FORCESTALL_Msk = 0x20
	// Bit FORCESTALL.
	UDP_CSR_FORCESTALL = 0x20
	// Position of RX_DATA_BK1 field.
	UDP_CSR_RX_DATA_BK1_Pos = 0x6
	// Bit mask of RX_DATA_BK1 field.
	UDP_CSR_RX_DATA_BK1_Msk = 0x40
	// Bit RX_DATA_BK1.
	UDP_CSR_RX_DATA_BK1 = 0x40
	// Position of DIR field.
	UDP_CSR_DIR_Pos = 0x7
	// Bit mask of DIR field.
	UDP_CSR_DIR_Msk = 0x80
	// Bit DIR.
	UDP_CSR_DIR = 0x80
	// Position of EPTYPE field.
	UDP_CSR_EPTYPE_Pos = 0x8
	// Bit mask of EPTYPE field.
	UDP_CSR_EPTYPE_Msk = 0x700
	// Position of DTGLE field.
	UDP_CSR_DTGLE_Pos = 0xb
	// Bit mask of DTGLE field.
	UDP_CSR_DTGLE_Msk = 0x800
	// Bit DTGLE.
	UDP_CSR_DTGLE = 0x800
	// Position of EPEDS field.
	UDP_CSR_EPEDS_Pos = 0xf
	// Bit mask of EPEDS field.
	UDP_CSR_EPEDS_Msk = 0x8000
	// Bit EPEDS.
	UDP_CSR_EPEDS = 0x8000
	// Position of RXBYTECNT field.
	UDP_CSR_RXBYTECNT_Pos = 0x10
	// Bit mask of RXBYTECNT field.
	UDP_CSR_RXBYTECNT_Msk = 0x7ff0000

	// FDR: Endpoint FIFO Data Register (ept_num = 0)
	// Position of FIFO_DATA field.
	UDP_FDR_FIFO_DATA_Pos = 0x0
	// Bit mask of FIFO_DATA field.
	UDP_FDR_FIFO_DATA_Msk = 0xff

	// TXVC: Transceiver Control Register
	// Position of TXVDIS field.
	UDP_TXVC_TXVDIS_Pos = 0x8
	// Bit mask of TXVDIS field.
	UDP_TXVC_TXVDIS_Msk = 0x100
	// Bit TXVDIS.
	UDP_TXVC_TXVDIS = 0x100
)

// Constants for MCI: MultiMedia Card Interface
const (
	// CR: Control Register
	// Position of MCIEN field.
	MCI_CR_MCIEN_Pos = 0x0
	// Bit mask of MCIEN field.
	MCI_CR_MCIEN_Msk = 0x1
	// Bit MCIEN.
	MCI_CR_MCIEN = 0x1
	// Position of MCIDIS field.
	MCI_CR_MCIDIS_Pos = 0x1
	// Bit mask of MCIDIS field.
	MCI_CR_MCIDIS_Msk = 0x2
	// Bit MCIDIS.
	MCI_CR_MCIDIS = 0x2
	// Position of PWSEN field.
	MCI_CR_PWSEN_Pos = 0x2
	// Bit mask of PWSEN field.
	MCI_CR_PWSEN_Msk = 0x4
	// Bit PWSEN.
	MCI_CR_PWSEN = 0x4
	// Position of PWSDIS field.
	MCI_CR_PWSDIS_Pos = 0x3
	// Bit mask of PWSDIS field.
	MCI_CR_PWSDIS_Msk = 0x8
	// Bit PWSDIS.
	MCI_CR_PWSDIS = 0x8
	// Position of SWRST field.
	MCI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	MCI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	MCI_CR_SWRST = 0x80

	// MR: Mode Register
	// Position of CLKDIV field.
	MCI_MR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	MCI_MR_CLKDIV_Msk = 0xff
	// Position of PWSDIV field.
	MCI_MR_PWSDIV_Pos = 0x8
	// Bit mask of PWSDIV field.
	MCI_MR_PWSDIV_Msk = 0x700
	// Position of RDPROOF field.
	MCI_MR_RDPROOF_Pos = 0xb
	// Bit mask of RDPROOF field.
	MCI_MR_RDPROOF_Msk = 0x800
	// Bit RDPROOF.
	MCI_MR_RDPROOF = 0x800
	// Position of WRPROOF field.
	MCI_MR_WRPROOF_Pos = 0xc
	// Bit mask of WRPROOF field.
	MCI_MR_WRPROOF_Msk = 0x1000
	// Bit WRPROOF.
	MCI_MR_WRPROOF = 0x1000
	// Position of PDCFBYTE field.
	MCI_MR_PDCFBYTE_Pos = 0xd
	// Bit mask of PDCFBYTE field.
	MCI_MR_PDCFBYTE_Msk = 0x2000
	// Bit PDCFBYTE.
	MCI_MR_PDCFBYTE = 0x2000
	// Position of PDCPADV field.
	MCI_MR_PDCPADV_Pos = 0xe
	// Bit mask of PDCPADV field.
	MCI_MR_PDCPADV_Msk = 0x4000
	// Bit PDCPADV.
	MCI_MR_PDCPADV = 0x4000
	// Position of PDCMODE field.
	MCI_MR_PDCMODE_Pos = 0xf
	// Bit mask of PDCMODE field.
	MCI_MR_PDCMODE_Msk = 0x8000
	// Bit PDCMODE.
	MCI_MR_PDCMODE = 0x8000
	// Position of BLKLEN field.
	MCI_MR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	MCI_MR_BLKLEN_Msk = 0xffff0000

	// DTOR: Data Timeout Register
	// Position of DTOCYC field.
	MCI_DTOR_DTOCYC_Pos = 0x0
	// Bit mask of DTOCYC field.
	MCI_DTOR_DTOCYC_Msk = 0xf
	// Position of DTOMUL field.
	MCI_DTOR_DTOMUL_Pos = 0x4
	// Bit mask of DTOMUL field.
	MCI_DTOR_DTOMUL_Msk = 0x70

	// SDCR: SD/SDIO Card Register
	// Position of SDCSEL field.
	MCI_SDCR_SDCSEL_Pos = 0x0
	// Bit mask of SDCSEL field.
	MCI_SDCR_SDCSEL_Msk = 0x3
	// Position of SDCBUS field.
	MCI_SDCR_SDCBUS_Pos = 0x7
	// Bit mask of SDCBUS field.
	MCI_SDCR_SDCBUS_Msk = 0x80
	// Bit SDCBUS.
	MCI_SDCR_SDCBUS = 0x80

	// ARGR: Argument Register
	// Position of ARG field.
	MCI_ARGR_ARG_Pos = 0x0
	// Bit mask of ARG field.
	MCI_ARGR_ARG_Msk = 0xffffffff

	// CMDR: Command Register
	// Position of CMDNB field.
	MCI_CMDR_CMDNB_Pos = 0x0
	// Bit mask of CMDNB field.
	MCI_CMDR_CMDNB_Msk = 0x3f
	// Position of RSPTYP field.
	MCI_CMDR_RSPTYP_Pos = 0x6
	// Bit mask of RSPTYP field.
	MCI_CMDR_RSPTYP_Msk = 0xc0
	// Position of SPCMD field.
	MCI_CMDR_SPCMD_Pos = 0x8
	// Bit mask of SPCMD field.
	MCI_CMDR_SPCMD_Msk = 0x700
	// Position of OPDCMD field.
	MCI_CMDR_OPDCMD_Pos = 0xb
	// Bit mask of OPDCMD field.
	MCI_CMDR_OPDCMD_Msk = 0x800
	// Bit OPDCMD.
	MCI_CMDR_OPDCMD = 0x800
	// Position of MAXLAT field.
	MCI_CMDR_MAXLAT_Pos = 0xc
	// Bit mask of MAXLAT field.
	MCI_CMDR_MAXLAT_Msk = 0x1000
	// Bit MAXLAT.
	MCI_CMDR_MAXLAT = 0x1000
	// Position of TRCMD field.
	MCI_CMDR_TRCMD_Pos = 0x10
	// Bit mask of TRCMD field.
	MCI_CMDR_TRCMD_Msk = 0x30000
	// Position of TRDIR field.
	MCI_CMDR_TRDIR_Pos = 0x12
	// Bit mask of TRDIR field.
	MCI_CMDR_TRDIR_Msk = 0x40000
	// Bit TRDIR.
	MCI_CMDR_TRDIR = 0x40000
	// Position of TRTYP field.
	MCI_CMDR_TRTYP_Pos = 0x13
	// Bit mask of TRTYP field.
	MCI_CMDR_TRTYP_Msk = 0x380000
	// Position of IOSPCMD field.
	MCI_CMDR_IOSPCMD_Pos = 0x18
	// Bit mask of IOSPCMD field.
	MCI_CMDR_IOSPCMD_Msk = 0x3000000

	// BLKR: Block Register
	// Position of BCNT field.
	MCI_BLKR_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	MCI_BLKR_BCNT_Msk = 0xffff
	// Position of BLKLEN field.
	MCI_BLKR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	MCI_BLKR_BLKLEN_Msk = 0xffff0000

	// RSPR: Response Register
	// Position of RSP field.
	MCI_RSPR_RSP_Pos = 0x0
	// Bit mask of RSP field.
	MCI_RSPR_RSP_Msk = 0xffffffff

	// RDR: Receive Data Register
	// Position of DATA field.
	MCI_RDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	MCI_RDR_DATA_Msk = 0xffffffff

	// TDR: Transmit Data Register
	// Position of DATA field.
	MCI_TDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	MCI_TDR_DATA_Msk = 0xffffffff

	// SR: Status Register
	// Position of CMDRDY field.
	MCI_SR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	MCI_SR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	MCI_SR_CMDRDY = 0x1
	// Position of RXRDY field.
	MCI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	MCI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	MCI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	MCI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	MCI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	MCI_SR_TXRDY = 0x4
	// Position of BLKE field.
	MCI_SR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	MCI_SR_BLKE_Msk = 0x8
	// Bit BLKE.
	MCI_SR_BLKE = 0x8
	// Position of DTIP field.
	MCI_SR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	MCI_SR_DTIP_Msk = 0x10
	// Bit DTIP.
	MCI_SR_DTIP = 0x10
	// Position of NOTBUSY field.
	MCI_SR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	MCI_SR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	MCI_SR_NOTBUSY = 0x20
	// Position of ENDRX field.
	MCI_SR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	MCI_SR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	MCI_SR_ENDRX = 0x40
	// Position of ENDTX field.
	MCI_SR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	MCI_SR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	MCI_SR_ENDTX = 0x80
	// Position of RXBUFF field.
	MCI_SR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	MCI_SR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	MCI_SR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	MCI_SR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	MCI_SR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	MCI_SR_TXBUFE = 0x8000
	// Position of RINDE field.
	MCI_SR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	MCI_SR_RINDE_Msk = 0x10000
	// Bit RINDE.
	MCI_SR_RINDE = 0x10000
	// Position of RDIRE field.
	MCI_SR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	MCI_SR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	MCI_SR_RDIRE = 0x20000
	// Position of RCRCE field.
	MCI_SR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	MCI_SR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	MCI_SR_RCRCE = 0x40000
	// Position of RENDE field.
	MCI_SR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	MCI_SR_RENDE_Msk = 0x80000
	// Bit RENDE.
	MCI_SR_RENDE = 0x80000
	// Position of RTOE field.
	MCI_SR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	MCI_SR_RTOE_Msk = 0x100000
	// Bit RTOE.
	MCI_SR_RTOE = 0x100000
	// Position of DCRCE field.
	MCI_SR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	MCI_SR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	MCI_SR_DCRCE = 0x200000
	// Position of DTOE field.
	MCI_SR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	MCI_SR_DTOE_Msk = 0x400000
	// Bit DTOE.
	MCI_SR_DTOE = 0x400000
	// Position of OVRE field.
	MCI_SR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	MCI_SR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	MCI_SR_OVRE = 0x40000000
	// Position of UNRE field.
	MCI_SR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	MCI_SR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	MCI_SR_UNRE = 0x80000000

	// IER: Interrupt Enable Register
	// Position of CMDRDY field.
	MCI_IER_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	MCI_IER_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	MCI_IER_CMDRDY = 0x1
	// Position of RXRDY field.
	MCI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	MCI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	MCI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	MCI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	MCI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	MCI_IER_TXRDY = 0x4
	// Position of BLKE field.
	MCI_IER_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	MCI_IER_BLKE_Msk = 0x8
	// Bit BLKE.
	MCI_IER_BLKE = 0x8
	// Position of DTIP field.
	MCI_IER_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	MCI_IER_DTIP_Msk = 0x10
	// Bit DTIP.
	MCI_IER_DTIP = 0x10
	// Position of NOTBUSY field.
	MCI_IER_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	MCI_IER_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	MCI_IER_NOTBUSY = 0x20
	// Position of ENDRX field.
	MCI_IER_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	MCI_IER_ENDRX_Msk = 0x40
	// Bit ENDRX.
	MCI_IER_ENDRX = 0x40
	// Position of ENDTX field.
	MCI_IER_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	MCI_IER_ENDTX_Msk = 0x80
	// Bit ENDTX.
	MCI_IER_ENDTX = 0x80
	// Position of RXBUFF field.
	MCI_IER_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	MCI_IER_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	MCI_IER_RXBUFF = 0x4000
	// Position of TXBUFE field.
	MCI_IER_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	MCI_IER_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	MCI_IER_TXBUFE = 0x8000
	// Position of RINDE field.
	MCI_IER_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	MCI_IER_RINDE_Msk = 0x10000
	// Bit RINDE.
	MCI_IER_RINDE = 0x10000
	// Position of RDIRE field.
	MCI_IER_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	MCI_IER_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	MCI_IER_RDIRE = 0x20000
	// Position of RCRCE field.
	MCI_IER_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	MCI_IER_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	MCI_IER_RCRCE = 0x40000
	// Position of RENDE field.
	MCI_IER_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	MCI_IER_RENDE_Msk = 0x80000
	// Bit RENDE.
	MCI_IER_RENDE = 0x80000
	// Position of RTOE field.
	MCI_IER_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	MCI_IER_RTOE_Msk = 0x100000
	// Bit RTOE.
	MCI_IER_RTOE = 0x100000
	// Position of DCRCE field.
	MCI_IER_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	MCI_IER_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	MCI_IER_DCRCE = 0x200000
	// Position of DTOE field.
	MCI_IER_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	MCI_IER_DTOE_Msk = 0x400000
	// Bit DTOE.
	MCI_IER_DTOE = 0x400000
	// Position of OVRE field.
	MCI_IER_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	MCI_IER_OVRE_Msk = 0x40000000
	// Bit OVRE.
	MCI_IER_OVRE = 0x40000000
	// Position of UNRE field.
	MCI_IER_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	MCI_IER_UNRE_Msk = 0x80000000
	// Bit UNRE.
	MCI_IER_UNRE = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of CMDRDY field.
	MCI_IDR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	MCI_IDR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	MCI_IDR_CMDRDY = 0x1
	// Position of RXRDY field.
	MCI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	MCI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	MCI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	MCI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	MCI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	MCI_IDR_TXRDY = 0x4
	// Position of BLKE field.
	MCI_IDR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	MCI_IDR_BLKE_Msk = 0x8
	// Bit BLKE.
	MCI_IDR_BLKE = 0x8
	// Position of DTIP field.
	MCI_IDR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	MCI_IDR_DTIP_Msk = 0x10
	// Bit DTIP.
	MCI_IDR_DTIP = 0x10
	// Position of NOTBUSY field.
	MCI_IDR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	MCI_IDR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	MCI_IDR_NOTBUSY = 0x20
	// Position of ENDRX field.
	MCI_IDR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	MCI_IDR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	MCI_IDR_ENDRX = 0x40
	// Position of ENDTX field.
	MCI_IDR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	MCI_IDR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	MCI_IDR_ENDTX = 0x80
	// Position of RXBUFF field.
	MCI_IDR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	MCI_IDR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	MCI_IDR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	MCI_IDR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	MCI_IDR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	MCI_IDR_TXBUFE = 0x8000
	// Position of RINDE field.
	MCI_IDR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	MCI_IDR_RINDE_Msk = 0x10000
	// Bit RINDE.
	MCI_IDR_RINDE = 0x10000
	// Position of RDIRE field.
	MCI_IDR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	MCI_IDR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	MCI_IDR_RDIRE = 0x20000
	// Position of RCRCE field.
	MCI_IDR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	MCI_IDR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	MCI_IDR_RCRCE = 0x40000
	// Position of RENDE field.
	MCI_IDR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	MCI_IDR_RENDE_Msk = 0x80000
	// Bit RENDE.
	MCI_IDR_RENDE = 0x80000
	// Position of RTOE field.
	MCI_IDR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	MCI_IDR_RTOE_Msk = 0x100000
	// Bit RTOE.
	MCI_IDR_RTOE = 0x100000
	// Position of DCRCE field.
	MCI_IDR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	MCI_IDR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	MCI_IDR_DCRCE = 0x200000
	// Position of DTOE field.
	MCI_IDR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	MCI_IDR_DTOE_Msk = 0x400000
	// Bit DTOE.
	MCI_IDR_DTOE = 0x400000
	// Position of OVRE field.
	MCI_IDR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	MCI_IDR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	MCI_IDR_OVRE = 0x40000000
	// Position of UNRE field.
	MCI_IDR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	MCI_IDR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	MCI_IDR_UNRE = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of CMDRDY field.
	MCI_IMR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	MCI_IMR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	MCI_IMR_CMDRDY = 0x1
	// Position of RXRDY field.
	MCI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	MCI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	MCI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	MCI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	MCI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	MCI_IMR_TXRDY = 0x4
	// Position of BLKE field.
	MCI_IMR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	MCI_IMR_BLKE_Msk = 0x8
	// Bit BLKE.
	MCI_IMR_BLKE = 0x8
	// Position of DTIP field.
	MCI_IMR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	MCI_IMR_DTIP_Msk = 0x10
	// Bit DTIP.
	MCI_IMR_DTIP = 0x10
	// Position of NOTBUSY field.
	MCI_IMR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	MCI_IMR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	MCI_IMR_NOTBUSY = 0x20
	// Position of ENDRX field.
	MCI_IMR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	MCI_IMR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	MCI_IMR_ENDRX = 0x40
	// Position of ENDTX field.
	MCI_IMR_ENDTX_Pos = 0x7
	// Bit mask of ENDTX field.
	MCI_IMR_ENDTX_Msk = 0x80
	// Bit ENDTX.
	MCI_IMR_ENDTX = 0x80
	// Position of RXBUFF field.
	MCI_IMR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	MCI_IMR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	MCI_IMR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	MCI_IMR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	MCI_IMR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	MCI_IMR_TXBUFE = 0x8000
	// Position of RINDE field.
	MCI_IMR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	MCI_IMR_RINDE_Msk = 0x10000
	// Bit RINDE.
	MCI_IMR_RINDE = 0x10000
	// Position of RDIRE field.
	MCI_IMR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	MCI_IMR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	MCI_IMR_RDIRE = 0x20000
	// Position of RCRCE field.
	MCI_IMR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	MCI_IMR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	MCI_IMR_RCRCE = 0x40000
	// Position of RENDE field.
	MCI_IMR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	MCI_IMR_RENDE_Msk = 0x80000
	// Bit RENDE.
	MCI_IMR_RENDE = 0x80000
	// Position of RTOE field.
	MCI_IMR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	MCI_IMR_RTOE_Msk = 0x100000
	// Bit RTOE.
	MCI_IMR_RTOE = 0x100000
	// Position of DCRCE field.
	MCI_IMR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	MCI_IMR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	MCI_IMR_DCRCE = 0x200000
	// Position of DTOE field.
	MCI_IMR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	MCI_IMR_DTOE_Msk = 0x400000
	// Bit DTOE.
	MCI_IMR_DTOE = 0x400000
	// Position of OVRE field.
	MCI_IMR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	MCI_IMR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	MCI_IMR_OVRE = 0x40000000
	// Position of UNRE field.
	MCI_IMR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	MCI_IMR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	MCI_IMR_UNRE = 0x80000000

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	MCI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	MCI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	MCI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	MCI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	MCI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	MCI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	MCI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	MCI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	MCI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	MCI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	MCI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	MCI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	MCI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	MCI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	MCI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	MCI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	MCI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	MCI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	MCI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	MCI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	MCI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	MCI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	MCI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	MCI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	MCI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	MCI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	MCI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	MCI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	MCI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	MCI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	MCI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	MCI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	MCI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	MCI_PTSR_TXTEN = 0x100
)

// Constants for TWI: Two-wire Interface
const (
	// CR: Control Register
	// Position of START field.
	TWI_CR_START_Pos = 0x0
	// Bit mask of START field.
	TWI_CR_START_Msk = 0x1
	// Bit START.
	TWI_CR_START = 0x1
	// Position of STOP field.
	TWI_CR_STOP_Pos = 0x1
	// Bit mask of STOP field.
	TWI_CR_STOP_Msk = 0x2
	// Bit STOP.
	TWI_CR_STOP = 0x2
	// Position of MSEN field.
	TWI_CR_MSEN_Pos = 0x2
	// Bit mask of MSEN field.
	TWI_CR_MSEN_Msk = 0x4
	// Bit MSEN.
	TWI_CR_MSEN = 0x4
	// Position of MSDIS field.
	TWI_CR_MSDIS_Pos = 0x3
	// Bit mask of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8
	// Bit MSDIS.
	TWI_CR_MSDIS = 0x8
	// Position of SVEN field.
	TWI_CR_SVEN_Pos = 0x4
	// Bit mask of SVEN field.
	TWI_CR_SVEN_Msk = 0x10
	// Bit SVEN.
	TWI_CR_SVEN = 0x10
	// Position of SVDIS field.
	TWI_CR_SVDIS_Pos = 0x5
	// Bit mask of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20
	// Bit SVDIS.
	TWI_CR_SVDIS = 0x20
	// Position of QUICK field.
	TWI_CR_QUICK_Pos = 0x6
	// Bit mask of QUICK field.
	TWI_CR_QUICK_Msk = 0x40
	// Bit QUICK.
	TWI_CR_QUICK = 0x40
	// Position of SWRST field.
	TWI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	TWI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	TWI_CR_SWRST = 0x80

	// MMR: Master Mode Register
	// Position of IADRSZ field.
	TWI_MMR_IADRSZ_Pos = 0x8
	// Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_Msk = 0x300
	// Position of MREAD field.
	TWI_MMR_MREAD_Pos = 0xc
	// Bit mask of MREAD field.
	TWI_MMR_MREAD_Msk = 0x1000
	// Bit MREAD.
	TWI_MMR_MREAD = 0x1000
	// Position of DADR field.
	TWI_MMR_DADR_Pos = 0x10
	// Bit mask of DADR field.
	TWI_MMR_DADR_Msk = 0x7f0000

	// SMR: Slave Mode Register
	// Position of SADR field.
	TWI_SMR_SADR_Pos = 0x10
	// Bit mask of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000

	// IADR: Internal Address Register
	// Position of IADR field.
	TWI_IADR_IADR_Pos = 0x0
	// Bit mask of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff

	// CWGR: Clock Waveform Generator Register
	// Position of CLDIV field.
	TWI_CWGR_CLDIV_Pos = 0x0
	// Bit mask of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff
	// Position of CHDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8
	// Bit mask of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00
	// Position of CKDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10
	// Bit mask of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000

	// SR: Status Register
	// Position of TXCOMP field.
	TWI_SR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_SR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_SR_TXRDY = 0x4
	// Position of SVREAD field.
	TWI_SR_SVREAD_Pos = 0x3
	// Bit mask of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8
	// Bit SVREAD.
	TWI_SR_SVREAD = 0x8
	// Position of SVACC field.
	TWI_SR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_SR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_SR_SVACC = 0x10
	// Position of GACC field.
	TWI_SR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_SR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_SR_GACC = 0x20
	// Position of OVRE field.
	TWI_SR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_SR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_SR_OVRE = 0x40
	// Position of NACK field.
	TWI_SR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_SR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_SR_NACK = 0x100
	// Position of ARBLST field.
	TWI_SR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_SR_ARBLST = 0x200
	// Position of SCLWS field.
	TWI_SR_SCLWS_Pos = 0xa
	// Bit mask of SCLWS field.
	TWI_SR_SCLWS_Msk = 0x400
	// Bit SCLWS.
	TWI_SR_SCLWS = 0x400
	// Position of EOSACC field.
	TWI_SR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_SR_EOSACC = 0x800

	// IER: Interrupt Enable Register
	// Position of TXCOMP field.
	TWI_IER_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IER_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IER_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IER_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IER_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IER_SVACC = 0x10
	// Position of GACC field.
	TWI_IER_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IER_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IER_GACC = 0x20
	// Position of OVRE field.
	TWI_IER_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IER_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IER_OVRE = 0x40
	// Position of NACK field.
	TWI_IER_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IER_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IER_NACK = 0x100
	// Position of ARBLST field.
	TWI_IER_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IER_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IER_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IER_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IER_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IER_EOSACC = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXCOMP field.
	TWI_IDR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IDR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IDR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IDR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IDR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IDR_SVACC = 0x10
	// Position of GACC field.
	TWI_IDR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IDR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IDR_GACC = 0x20
	// Position of OVRE field.
	TWI_IDR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IDR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IDR_OVRE = 0x40
	// Position of NACK field.
	TWI_IDR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IDR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IDR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IDR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IDR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IDR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IDR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IDR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IDR_EOSACC = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXCOMP field.
	TWI_IMR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IMR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IMR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IMR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IMR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IMR_SVACC = 0x10
	// Position of GACC field.
	TWI_IMR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IMR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IMR_GACC = 0x20
	// Position of OVRE field.
	TWI_IMR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IMR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IMR_OVRE = 0x40
	// Position of NACK field.
	TWI_IMR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IMR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IMR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IMR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IMR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IMR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IMR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IMR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IMR_EOSACC = 0x800

	// RHR: Receive Holding Register
	// Position of RXDATA field.
	TWI_RHR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXDATA field.
	TWI_THR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff
)

// Constants for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	USART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_RSTSTA = 0x100
	// Position of STTBRK field.
	USART_CR_STTBRK_Pos = 0x9
	// Bit mask of STTBRK field.
	USART_CR_STTBRK_Msk = 0x200
	// Bit STTBRK.
	USART_CR_STTBRK = 0x200
	// Position of STPBRK field.
	USART_CR_STPBRK_Pos = 0xa
	// Bit mask of STPBRK field.
	USART_CR_STPBRK_Msk = 0x400
	// Bit STPBRK.
	USART_CR_STPBRK = 0x400
	// Position of STTTO field.
	USART_CR_STTTO_Pos = 0xb
	// Bit mask of STTTO field.
	USART_CR_STTTO_Msk = 0x800
	// Bit STTTO.
	USART_CR_STTTO = 0x800
	// Position of SENDA field.
	USART_CR_SENDA_Pos = 0xc
	// Bit mask of SENDA field.
	USART_CR_SENDA_Msk = 0x1000
	// Bit SENDA.
	USART_CR_SENDA = 0x1000
	// Position of RSTIT field.
	USART_CR_RSTIT_Pos = 0xd
	// Bit mask of RSTIT field.
	USART_CR_RSTIT_Msk = 0x2000
	// Bit RSTIT.
	USART_CR_RSTIT = 0x2000
	// Position of RSTNACK field.
	USART_CR_RSTNACK_Pos = 0xe
	// Bit mask of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000
	// Bit RSTNACK.
	USART_CR_RSTNACK = 0x4000
	// Position of RETTO field.
	USART_CR_RETTO_Pos = 0xf
	// Bit mask of RETTO field.
	USART_CR_RETTO_Msk = 0x8000
	// Bit RETTO.
	USART_CR_RETTO = 0x8000
	// Position of RTSEN field.
	USART_CR_RTSEN_Pos = 0x12
	// Bit mask of RTSEN field.
	USART_CR_RTSEN_Msk = 0x40000
	// Bit RTSEN.
	USART_CR_RTSEN = 0x40000
	// Position of RTSDIS field.
	USART_CR_RTSDIS_Pos = 0x13
	// Bit mask of RTSDIS field.
	USART_CR_RTSDIS_Msk = 0x80000
	// Bit RTSDIS.
	USART_CR_RTSDIS = 0x80000

	// MR: Mode Register
	// Position of USART_MODE field.
	USART_MR_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_USART_MODE_Msk = 0xf
	// Normal mode
	USART_MR_USART_MODE_NORMAL = 0x0
	// RS485
	USART_MR_USART_MODE_RS485 = 0x1
	// Hardware Handshaking
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2
	// IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_0 = 0x4
	// IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IS07816_T_1 = 0x6
	// IrDA
	USART_MR_USART_MODE_IRDA = 0x8
	// Position of USCLKS field.
	USART_MR_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_CHRL_Msk = 0xc0
	// Character length is 5 bits
	USART_MR_CHRL_5_BIT = 0x0
	// Character length is 6 bits
	USART_MR_CHRL_6_BIT = 0x1
	// Character length is 7 bits
	USART_MR_CHRL_7_BIT = 0x2
	// Character length is 8 bits
	USART_MR_CHRL_8_BIT = 0x3
	// Position of SYNC field.
	USART_MR_SYNC_Pos = 0x8
	// Bit mask of SYNC field.
	USART_MR_SYNC_Msk = 0x100
	// Bit SYNC.
	USART_MR_SYNC = 0x100
	// Position of PAR field.
	USART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	USART_MR_PAR_Msk = 0xe00
	// Even parity
	USART_MR_PAR_EVEN = 0x0
	// Odd parity
	USART_MR_PAR_ODD = 0x1
	// Parity forced to 0 (Space)
	USART_MR_PAR_SPACE = 0x2
	// Parity forced to 1 (Mark)
	USART_MR_PAR_MARK = 0x3
	// No parity
	USART_MR_PAR_NO = 0x4
	// Multidrop mode
	USART_MR_PAR_MULTIDROP = 0x6
	// Position of NBSTOP field.
	USART_MR_NBSTOP_Pos = 0xc
	// Bit mask of NBSTOP field.
	USART_MR_NBSTOP_Msk = 0x3000
	// 1 stop bit
	USART_MR_NBSTOP_1_BIT = 0x0
	// 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_1_5_BIT = 0x1
	// 2 stop bits
	USART_MR_NBSTOP_2_BIT = 0x2
	// Position of CHMODE field.
	USART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	USART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	USART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_CHMODE_REMOTE_LOOPBACK = 0x3
	// Position of MSBF field.
	USART_MR_MSBF_Pos = 0x10
	// Bit mask of MSBF field.
	USART_MR_MSBF_Msk = 0x10000
	// Bit MSBF.
	USART_MR_MSBF = 0x10000
	// Position of MODE9 field.
	USART_MR_MODE9_Pos = 0x11
	// Bit mask of MODE9 field.
	USART_MR_MODE9_Msk = 0x20000
	// Bit MODE9.
	USART_MR_MODE9 = 0x20000
	// Position of CLKO field.
	USART_MR_CLKO_Pos = 0x12
	// Bit mask of CLKO field.
	USART_MR_CLKO_Msk = 0x40000
	// Bit CLKO.
	USART_MR_CLKO = 0x40000
	// Position of OVER field.
	USART_MR_OVER_Pos = 0x13
	// Bit mask of OVER field.
	USART_MR_OVER_Msk = 0x80000
	// Bit OVER.
	USART_MR_OVER = 0x80000
	// Position of INACK field.
	USART_MR_INACK_Pos = 0x14
	// Bit mask of INACK field.
	USART_MR_INACK_Msk = 0x100000
	// Bit INACK.
	USART_MR_INACK = 0x100000
	// Position of DSNACK field.
	USART_MR_DSNACK_Pos = 0x15
	// Bit mask of DSNACK field.
	USART_MR_DSNACK_Msk = 0x200000
	// Bit DSNACK.
	USART_MR_DSNACK = 0x200000
	// Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Pos = 0x16
	// Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk = 0x400000
	// Bit VAR_SYNC.
	USART_MR_VAR_SYNC = 0x400000
	// Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Pos = 0x18
	// Bit mask of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk = 0x7000000
	// Position of FILTER field.
	USART_MR_FILTER_Pos = 0x1c
	// Bit mask of FILTER field.
	USART_MR_FILTER_Msk = 0x10000000
	// Bit FILTER.
	USART_MR_FILTER = 0x10000000
	// Position of MAN field.
	USART_MR_MAN_Pos = 0x1d
	// Bit mask of MAN field.
	USART_MR_MAN_Msk = 0x20000000
	// Bit MAN.
	USART_MR_MAN = 0x20000000
	// Position of MODSYNC field.
	USART_MR_MODSYNC_Pos = 0x1e
	// Bit mask of MODSYNC field.
	USART_MR_MODSYNC_Msk = 0x40000000
	// Bit MODSYNC.
	USART_MR_MODSYNC = 0x40000000
	// Position of ONEBIT field.
	USART_MR_ONEBIT_Pos = 0x1f
	// Bit mask of ONEBIT field.
	USART_MR_ONEBIT_Msk = 0x80000000
	// Bit ONEBIT.
	USART_MR_ONEBIT = 0x80000000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IER_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IER_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IER_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_FRAME = 0x40
	// Position of PARE field.
	USART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IER_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IER_ITER_Msk = 0x400
	// Bit ITER.
	USART_IER_ITER = 0x400
	// Position of TXBUFE field.
	USART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IER_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IER_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IER_NACK = 0x2000
	// Position of CTSIC field.
	USART_IER_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IER_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IER_CTSIC = 0x80000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IDR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IDR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IDR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IDR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IDR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IDR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IDR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IDR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IDR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IDR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IDR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IDR_CTSIC = 0x80000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IMR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IMR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IMR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IMR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IMR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IMR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IMR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IMR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IMR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IMR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IMR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IMR_CTSIC = 0x80000

	// CSR: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_CSR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_CSR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_CSR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_CSR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_CSR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_CSR_ITER_Msk = 0x400
	// Bit ITER.
	USART_CSR_ITER = 0x400
	// Position of TXBUFE field.
	USART_CSR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_CSR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_CSR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_CSR_NACK = 0x2000
	// Position of CTSIC field.
	USART_CSR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_CSR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_CSR_CTSIC = 0x80000
	// Position of CTS field.
	USART_CSR_CTS_Pos = 0x17
	// Bit mask of CTS field.
	USART_CSR_CTS_Msk = 0x800000
	// Bit CTS.
	USART_CSR_CTS = 0x800000
	// Position of RR field.
	USART_CSR_RR_Pos = 0x18
	// Bit mask of RR field.
	USART_CSR_RR_Msk = 0x1000000
	// Bit RR.
	USART_CSR_RR = 0x1000000

	// RHR: Receiver Holding Register
	// Position of RXCHR field.
	USART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	USART_RHR_RXCHR_Msk = 0x1ff
	// Position of RXSYNH field.
	USART_RHR_RXSYNH_Pos = 0xf
	// Bit mask of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000
	// Bit RXSYNH.
	USART_RHR_RXSYNH = 0x8000

	// THR: Transmitter Holding Register
	// Position of TXCHR field.
	USART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	USART_THR_TXCHR_Msk = 0x1ff
	// Position of TXSYNH field.
	USART_THR_TXSYNH_Pos = 0xf
	// Bit mask of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000
	// Bit TXSYNH.
	USART_THR_TXSYNH = 0x8000

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	USART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	USART_BRGR_CD_Msk = 0xffff
	// Position of FP field.
	USART_BRGR_FP_Pos = 0x10
	// Bit mask of FP field.
	USART_BRGR_FP_Msk = 0x70000

	// RTOR: Receiver Time-out Register
	// Position of TO field.
	USART_RTOR_TO_Pos = 0x0
	// Bit mask of TO field.
	USART_RTOR_TO_Msk = 0xffff

	// TTGR: Transmitter Timeguard Register
	// Position of TG field.
	USART_TTGR_TG_Pos = 0x0
	// Bit mask of TG field.
	USART_TTGR_TG_Msk = 0xff

	// FIDI: FI DI Ratio Register
	// Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Pos = 0x0
	// Bit mask of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff

	// NER: Number of Errors Register
	// Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Pos = 0x0
	// Bit mask of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff

	// IF: IrDA Filter Register
	// Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Pos = 0x0
	// Bit mask of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff

	// MAN: Manchester Encoder Decoder Register
	// Position of TX_PL field.
	USART_MAN_TX_PL_Pos = 0x0
	// Bit mask of TX_PL field.
	USART_MAN_TX_PL_Msk = 0xf
	// Position of TX_PP field.
	USART_MAN_TX_PP_Pos = 0x8
	// Bit mask of TX_PP field.
	USART_MAN_TX_PP_Msk = 0x300
	// The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_TX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_TX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_TX_PP_ONE_ZERO = 0x3
	// Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Pos = 0xc
	// Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk = 0x1000
	// Bit TX_MPOL.
	USART_MAN_TX_MPOL = 0x1000
	// Position of RX_PL field.
	USART_MAN_RX_PL_Pos = 0x10
	// Bit mask of RX_PL field.
	USART_MAN_RX_PL_Msk = 0xf0000
	// Position of RX_PP field.
	USART_MAN_RX_PP_Pos = 0x18
	// Bit mask of RX_PP field.
	USART_MAN_RX_PP_Msk = 0x3000000
	// The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_RX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_RX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_RX_PP_ONE_ZERO = 0x3
	// Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Pos = 0x1c
	// Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk = 0x10000000
	// Bit RX_MPOL.
	USART_MAN_RX_MPOL = 0x10000000
	// Position of ONE field.
	USART_MAN_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	USART_MAN_ONE_Msk = 0x20000000
	// Bit ONE.
	USART_MAN_ONE = 0x20000000
	// Position of DRIFT field.
	USART_MAN_DRIFT_Pos = 0x1e
	// Bit mask of DRIFT field.
	USART_MAN_DRIFT_Msk = 0x40000000
	// Bit DRIFT.
	USART_MAN_DRIFT = 0x40000000

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	USART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	USART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	USART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	USART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	USART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	USART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	USART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	USART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	USART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	USART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	USART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	USART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	USART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	USART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	USART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	USART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	USART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	USART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	USART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	USART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	USART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	USART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	USART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	USART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	USART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	USART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTSR_TXTEN = 0x100
)

// Constants for SSC0: Synchronous Serial Controller 0
const (
	// CR: Control Register
	// Position of RXEN field.
	SSC_CR_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	SSC_CR_RXEN_Msk = 0x1
	// Bit RXEN.
	SSC_CR_RXEN = 0x1
	// Position of RXDIS field.
	SSC_CR_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2
	// Bit RXDIS.
	SSC_CR_RXDIS = 0x2
	// Position of TXEN field.
	SSC_CR_TXEN_Pos = 0x8
	// Bit mask of TXEN field.
	SSC_CR_TXEN_Msk = 0x100
	// Bit TXEN.
	SSC_CR_TXEN = 0x100
	// Position of TXDIS field.
	SSC_CR_TXDIS_Pos = 0x9
	// Bit mask of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200
	// Bit TXDIS.
	SSC_CR_TXDIS = 0x200
	// Position of SWRST field.
	SSC_CR_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000
	// Bit SWRST.
	SSC_CR_SWRST = 0x8000

	// CMR: Clock Mode Register
	// Position of DIV field.
	SSC_CMR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SSC_CMR_DIV_Msk = 0xfff

	// RCMR: Receive Clock Mode Register
	// Position of CKS field.
	SSC_RCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_RCMR_CKS_Msk = 0x3
	// Position of CKO field.
	SSC_RCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_RCMR_CKO_Msk = 0x1c
	// Position of CKI field.
	SSC_RCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_RCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_RCMR_CKI = 0x20
	// Position of CKG field.
	SSC_RCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_RCMR_CKG_Msk = 0xc0
	// Position of START field.
	SSC_RCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_RCMR_START_Msk = 0xf00
	// Position of STOP field.
	SSC_RCMR_STOP_Pos = 0xc
	// Bit mask of STOP field.
	SSC_RCMR_STOP_Msk = 0x1000
	// Bit STOP.
	SSC_RCMR_STOP = 0x1000
	// Position of STTDLY field.
	SSC_RCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_RCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_RCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_RCMR_PERIOD_Msk = 0xff000000

	// RFMR: Receive Frame Mode Register
	// Position of DATLEN field.
	SSC_RFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_RFMR_DATLEN_Msk = 0x1f
	// Position of LOOP field.
	SSC_RFMR_LOOP_Pos = 0x5
	// Bit mask of LOOP field.
	SSC_RFMR_LOOP_Msk = 0x20
	// Bit LOOP.
	SSC_RFMR_LOOP = 0x20
	// Position of MSBF field.
	SSC_RFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_RFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_RFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_RFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_RFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_RFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_RFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_RFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_RFMR_FSOS_Msk = 0x700000
	// Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_RFMR_FSEDGE = 0x1000000

	// TCMR: Transmit Clock Mode Register
	// Position of CKS field.
	SSC_TCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_TCMR_CKS_Msk = 0x3
	// Position of CKO field.
	SSC_TCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_TCMR_CKO_Msk = 0x1c
	// Position of CKI field.
	SSC_TCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_TCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_TCMR_CKI = 0x20
	// Position of CKG field.
	SSC_TCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_TCMR_CKG_Msk = 0xc0
	// Position of START field.
	SSC_TCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_TCMR_START_Msk = 0xf00
	// Position of STTDLY field.
	SSC_TCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_TCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_TCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_TCMR_PERIOD_Msk = 0xff000000

	// TFMR: Transmit Frame Mode Register
	// Position of DATLEN field.
	SSC_TFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_TFMR_DATLEN_Msk = 0x1f
	// Position of DATDEF field.
	SSC_TFMR_DATDEF_Pos = 0x5
	// Bit mask of DATDEF field.
	SSC_TFMR_DATDEF_Msk = 0x20
	// Bit DATDEF.
	SSC_TFMR_DATDEF = 0x20
	// Position of MSBF field.
	SSC_TFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_TFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_TFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_TFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_TFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_TFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_TFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_TFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_TFMR_FSOS_Msk = 0x700000
	// Position of FSDEN field.
	SSC_TFMR_FSDEN_Pos = 0x17
	// Bit mask of FSDEN field.
	SSC_TFMR_FSDEN_Msk = 0x800000
	// Bit FSDEN.
	SSC_TFMR_FSDEN = 0x800000
	// Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_TFMR_FSEDGE = 0x1000000

	// RHR: Receive Holding Register
	// Position of RDAT field.
	SSC_RHR_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff

	// THR: Transmit Holding Register
	// Position of TDAT field.
	SSC_THR_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff

	// RSHR: Receive Sync. Holding Register
	// Position of RSDAT field.
	SSC_RSHR_RSDAT_Pos = 0x0
	// Bit mask of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff

	// TSHR: Transmit Sync. Holding Register
	// Position of TSDAT field.
	SSC_TSHR_TSDAT_Pos = 0x0
	// Bit mask of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff

	// RC0R: Receive Compare 0 Register
	// Position of CP0 field.
	SSC_RC0R_CP0_Pos = 0x0
	// Bit mask of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff

	// RC1R: Receive Compare 1 Register
	// Position of CP1 field.
	SSC_RC1R_CP1_Pos = 0x0
	// Bit mask of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff

	// SR: Status Register
	// Position of TXRDY field.
	SSC_SR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_SR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_SR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_SR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_SR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_SR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_SR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_SR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_SR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_SR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_SR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_SR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_SR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_SR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_SR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_SR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_SR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_SR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_SR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_SR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_SR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_SR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_SR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_SR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_SR_CP0 = 0x100
	// Position of CP1 field.
	SSC_SR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_SR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_SR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_SR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_SR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_SR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_SR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_SR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_SR_RXSYN = 0x800
	// Position of TXEN field.
	SSC_SR_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SSC_SR_TXEN_Msk = 0x10000
	// Bit TXEN.
	SSC_SR_TXEN = 0x10000
	// Position of RXEN field.
	SSC_SR_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SSC_SR_RXEN_Msk = 0x20000
	// Bit RXEN.
	SSC_SR_RXEN = 0x20000

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	SSC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IER_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IER_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IER_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IER_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IER_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IER_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IER_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IER_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IER_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IER_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IER_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IER_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IER_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IER_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IER_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IER_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IER_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IER_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IER_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IER_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IER_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IER_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IER_CP0 = 0x100
	// Position of CP1 field.
	SSC_IER_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IER_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IER_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IER_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IER_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IER_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IER_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IER_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IER_RXSYN = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	SSC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IDR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IDR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IDR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IDR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IDR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IDR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IDR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IDR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IDR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IDR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IDR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IDR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IDR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IDR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IDR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IDR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IDR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IDR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IDR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IDR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IDR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IDR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IDR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IDR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IDR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IDR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IDR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IDR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IDR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IDR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IDR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IDR_RXSYN = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	SSC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IMR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IMR_TXEMPTY = 0x2
	// Position of ENDTX field.
	SSC_IMR_ENDTX_Pos = 0x2
	// Bit mask of ENDTX field.
	SSC_IMR_ENDTX_Msk = 0x4
	// Bit ENDTX.
	SSC_IMR_ENDTX = 0x4
	// Position of TXBUFE field.
	SSC_IMR_TXBUFE_Pos = 0x3
	// Bit mask of TXBUFE field.
	SSC_IMR_TXBUFE_Msk = 0x8
	// Bit TXBUFE.
	SSC_IMR_TXBUFE = 0x8
	// Position of RXRDY field.
	SSC_IMR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IMR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IMR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IMR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IMR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IMR_OVRUN = 0x20
	// Position of ENDRX field.
	SSC_IMR_ENDRX_Pos = 0x6
	// Bit mask of ENDRX field.
	SSC_IMR_ENDRX_Msk = 0x40
	// Bit ENDRX.
	SSC_IMR_ENDRX = 0x40
	// Position of RXBUFF field.
	SSC_IMR_RXBUFF_Pos = 0x7
	// Bit mask of RXBUFF field.
	SSC_IMR_RXBUFF_Msk = 0x80
	// Bit RXBUFF.
	SSC_IMR_RXBUFF = 0x80
	// Position of CP0 field.
	SSC_IMR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IMR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IMR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IMR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IMR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IMR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IMR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IMR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IMR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IMR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IMR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IMR_RXSYN = 0x800

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SSC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SSC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SSC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SSC_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SSC_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SSC_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SSC_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SSC_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SSC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SSC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SSC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SSC_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SSC_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SSC_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SSC_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SSC_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SSC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SSC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SSC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SSC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SSC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SSC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SSC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SSC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SSC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SSC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SSC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SSC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SSC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SSC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SSC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SSC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SSC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SSC_PTSR_TXTEN = 0x100
)

// Constants for SPI0: Serial Peripheral Interface 0
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_SR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_SR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_SR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_SR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_SR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_SR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_SR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_SR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_SR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_SR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_SR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_SR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IER_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IER_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IER_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IER_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IER_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IER_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IER_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IER_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IER_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IER_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IER_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IER_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IDR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IDR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IDR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IDR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IDR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IDR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IDR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IDR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IDR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IDR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IDR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IDR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of ENDRX field.
	SPI_IMR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPI_IMR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPI_IMR_ENDRX = 0x10
	// Position of ENDTX field.
	SPI_IMR_ENDTX_Pos = 0x5
	// Bit mask of ENDTX field.
	SPI_IMR_ENDTX_Msk = 0x20
	// Bit ENDTX.
	SPI_IMR_ENDTX = 0x20
	// Position of RXBUFF field.
	SPI_IMR_RXBUFF_Pos = 0x6
	// Bit mask of RXBUFF field.
	SPI_IMR_RXBUFF_Msk = 0x40
	// Bit RXBUFF.
	SPI_IMR_RXBUFF = 0x40
	// Position of TXBUFE field.
	SPI_IMR_TXBUFE_Pos = 0x7
	// Bit mask of TXBUFE field.
	SPI_IMR_TXBUFE_Msk = 0x80
	// Bit TXBUFE.
	SPI_IMR_TXBUFE = 0x80
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SPI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SPI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SPI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SPI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SPI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SPI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SPI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SPI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SPI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SPI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SPI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SPI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SPI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SPI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SPI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SPI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SPI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SPI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SPI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SPI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SPI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SPI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SPI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SPI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SPI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SPI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTSR_TXTEN = 0x100
)

// Constants for SDRAMC: SDRAM Controller
const (
	// MR: SDRAMC Mode Register
	// Position of MODE field.
	EBI_MR_MODE_Pos = 0x0
	// Bit mask of MODE field.
	EBI_MR_MODE_Msk = 0x7

	// TR: SDRAMC Refresh Timer Register
	// Position of COUNT field.
	EBI_TR_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	EBI_TR_COUNT_Msk = 0xfff

	// CR: SDRAMC Configuration Register
	// Position of NC field.
	EBI_CR_NC_Pos = 0x0
	// Bit mask of NC field.
	EBI_CR_NC_Msk = 0x3
	// Position of NR field.
	EBI_CR_NR_Pos = 0x2
	// Bit mask of NR field.
	EBI_CR_NR_Msk = 0xc
	// Position of NB field.
	EBI_CR_NB_Pos = 0x4
	// Bit mask of NB field.
	EBI_CR_NB_Msk = 0x10
	// Bit NB.
	EBI_CR_NB = 0x10
	// Position of CAS field.
	EBI_CR_CAS_Pos = 0x5
	// Bit mask of CAS field.
	EBI_CR_CAS_Msk = 0x60
	// Position of DBW field.
	EBI_CR_DBW_Pos = 0x7
	// Bit mask of DBW field.
	EBI_CR_DBW_Msk = 0x80
	// Bit DBW.
	EBI_CR_DBW = 0x80
	// Position of TWR field.
	EBI_CR_TWR_Pos = 0x8
	// Bit mask of TWR field.
	EBI_CR_TWR_Msk = 0xf00
	// Position of TRC field.
	EBI_CR_TRC_Pos = 0xc
	// Bit mask of TRC field.
	EBI_CR_TRC_Msk = 0xf000
	// Position of TRP field.
	EBI_CR_TRP_Pos = 0x10
	// Bit mask of TRP field.
	EBI_CR_TRP_Msk = 0xf0000
	// Position of TRCD field.
	EBI_CR_TRCD_Pos = 0x14
	// Bit mask of TRCD field.
	EBI_CR_TRCD_Msk = 0xf00000
	// Position of TRAS field.
	EBI_CR_TRAS_Pos = 0x18
	// Bit mask of TRAS field.
	EBI_CR_TRAS_Msk = 0xf000000
	// Position of TXSR field.
	EBI_CR_TXSR_Pos = 0x1c
	// Bit mask of TXSR field.
	EBI_CR_TXSR_Msk = 0xf0000000

	// LPR: SDRAMC Low Power Register
	// Position of LPCB field.
	EBI_LPR_LPCB_Pos = 0x0
	// Bit mask of LPCB field.
	EBI_LPR_LPCB_Msk = 0x3
	// Position of PASR field.
	EBI_LPR_PASR_Pos = 0x4
	// Bit mask of PASR field.
	EBI_LPR_PASR_Msk = 0x70
	// Position of TCSR field.
	EBI_LPR_TCSR_Pos = 0x8
	// Bit mask of TCSR field.
	EBI_LPR_TCSR_Msk = 0x300
	// Position of DS field.
	EBI_LPR_DS_Pos = 0xa
	// Bit mask of DS field.
	EBI_LPR_DS_Msk = 0xc00
	// Position of TIMEOUT field.
	EBI_LPR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	EBI_LPR_TIMEOUT_Msk = 0x3000

	// IER: SDRAMC Interrupt Enable Register
	// Position of RES field.
	EBI_IER_RES_Pos = 0x0
	// Bit mask of RES field.
	EBI_IER_RES_Msk = 0x1
	// Bit RES.
	EBI_IER_RES = 0x1

	// IDR: SDRAMC Interrupt Disable Register
	// Position of RES field.
	EBI_IDR_RES_Pos = 0x0
	// Bit mask of RES field.
	EBI_IDR_RES_Msk = 0x1
	// Bit RES.
	EBI_IDR_RES = 0x1

	// IMR: SDRAMC Interrupt Mask Register
	// Position of RES field.
	EBI_IMR_RES_Pos = 0x0
	// Bit mask of RES field.
	EBI_IMR_RES_Msk = 0x1
	// Bit RES.
	EBI_IMR_RES = 0x1

	// ISR: SDRAMC Interrupt Status Register
	// Position of RES field.
	EBI_ISR_RES_Pos = 0x0
	// Bit mask of RES field.
	EBI_ISR_RES_Msk = 0x1
	// Bit RES.
	EBI_ISR_RES = 0x1

	// MDR: SDRAMC Memory Device Register
	// Position of MD field.
	EBI_MDR_MD_Pos = 0x0
	// Bit mask of MD field.
	EBI_MDR_MD_Msk = 0x3
)

// Constants for MATRIX: AHB Bus Matrix
const (
	// MATRIX_MCFG: Master Configuration Register
	// Position of RCB0 field.
	MATRIX_MATRIX_MCFG_RCB0_Pos = 0x0
	// Bit mask of RCB0 field.
	MATRIX_MATRIX_MCFG_RCB0_Msk = 0x1
	// Bit RCB0.
	MATRIX_MATRIX_MCFG_RCB0 = 0x1
	// Position of RCB1 field.
	MATRIX_MATRIX_MCFG_RCB1_Pos = 0x1
	// Bit mask of RCB1 field.
	MATRIX_MATRIX_MCFG_RCB1_Msk = 0x2
	// Bit RCB1.
	MATRIX_MATRIX_MCFG_RCB1 = 0x2

	// MATRIX_SCFG: Slave Configuration Register
	// Position of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Pos = 0x0
	// Bit mask of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Msk = 0xff
	// Position of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Pos = 0x10
	// Bit mask of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Msk = 0x30000
	// Position of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12
	// Bit mask of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x1c0000

	// MATRIX_TCR: MATRIX TCM Configuration Register
	// Position of ITCM_SIZE field.
	MATRIX_MATRIX_TCR_ITCM_SIZE_Pos = 0x0
	// Bit mask of ITCM_SIZE field.
	MATRIX_MATRIX_TCR_ITCM_SIZE_Msk = 0xf
	// Position of DTCM_SIZE field.
	MATRIX_MATRIX_TCR_DTCM_SIZE_Pos = 0x4
	// Bit mask of DTCM_SIZE field.
	MATRIX_MATRIX_TCR_DTCM_SIZE_Msk = 0xf0

	// EBI_CSA: EBI Chip Select Assignment Register
	// Position of EBI_CS1A field.
	MATRIX_EBI_CSA_EBI_CS1A_Pos = 0x1
	// Bit mask of EBI_CS1A field.
	MATRIX_EBI_CSA_EBI_CS1A_Msk = 0x2
	// Bit EBI_CS1A.
	MATRIX_EBI_CSA_EBI_CS1A = 0x2
	// Position of EBI_CS3A field.
	MATRIX_EBI_CSA_EBI_CS3A_Pos = 0x3
	// Bit mask of EBI_CS3A field.
	MATRIX_EBI_CSA_EBI_CS3A_Msk = 0x8
	// Bit EBI_CS3A.
	MATRIX_EBI_CSA_EBI_CS3A = 0x8
	// Position of EBI_CS4A field.
	MATRIX_EBI_CSA_EBI_CS4A_Pos = 0x4
	// Bit mask of EBI_CS4A field.
	MATRIX_EBI_CSA_EBI_CS4A_Msk = 0x10
	// Bit EBI_CS4A.
	MATRIX_EBI_CSA_EBI_CS4A = 0x10
	// Position of EBI_CS5A field.
	MATRIX_EBI_CSA_EBI_CS5A_Pos = 0x5
	// Bit mask of EBI_CS5A field.
	MATRIX_EBI_CSA_EBI_CS5A_Msk = 0x20
	// Bit EBI_CS5A.
	MATRIX_EBI_CSA_EBI_CS5A = 0x20
	// Position of EBI_DBPUC field.
	MATRIX_EBI_CSA_EBI_DBPUC_Pos = 0x8
	// Bit mask of EBI_DBPUC field.
	MATRIX_EBI_CSA_EBI_DBPUC_Msk = 0x100
	// Bit EBI_DBPUC.
	MATRIX_EBI_CSA_EBI_DBPUC = 0x100

	// USB_PUCR: USB Pad Pull-up Control Register
	// Position of UDP_PUP_ON field.
	MATRIX_USB_PUCR_UDP_PUP_ON_Pos = 0x1e
	// Bit mask of UDP_PUP_ON field.
	MATRIX_USB_PUCR_UDP_PUP_ON_Msk = 0x40000000
	// Bit UDP_PUP_ON.
	MATRIX_USB_PUCR_UDP_PUP_ON = 0x40000000
)

// Constants for AIC: Advanced Interrupt Controller
const (
	// SMR: Source Mode Register
	// Position of PRIOR field.
	AIC_SMR_PRIOR_Pos = 0x0
	// Bit mask of PRIOR field.
	AIC_SMR_PRIOR_Msk = 0x7
	// Position of SRCTYPE field.
	AIC_SMR_SRCTYPE_Pos = 0x5
	// Bit mask of SRCTYPE field.
	AIC_SMR_SRCTYPE_Msk = 0x60

	// SVR: Source Vector Register
	// Position of VECTOR field.
	AIC_SVR_VECTOR_Pos = 0x0
	// Bit mask of VECTOR field.
	AIC_SVR_VECTOR_Msk = 0xffffffff

	// IVR: Interrupt Vector Register
	// Position of IRQV field.
	AIC_IVR_IRQV_Pos = 0x0
	// Bit mask of IRQV field.
	AIC_IVR_IRQV_Msk = 0xffffffff

	// FVR: FIQ Interrupt Vector Register
	// Position of FIQV field.
	AIC_FVR_FIQV_Pos = 0x0
	// Bit mask of FIQV field.
	AIC_FVR_FIQV_Msk = 0xffffffff

	// ISR: Interrupt Status Register
	// Position of IRQID field.
	AIC_ISR_IRQID_Pos = 0x0
	// Bit mask of IRQID field.
	AIC_ISR_IRQID_Msk = 0x1f

	// IPR: Interrupt Pending Register
	// Position of FIQ field.
	AIC_IPR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IPR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IPR_FIQ = 0x1
	// Position of SYS field.
	AIC_IPR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IPR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IPR_SYS = 0x2
	// Position of PID2 field.
	AIC_IPR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IPR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IPR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IPR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IPR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IPR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IPR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IPR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IPR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IPR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IPR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IPR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IPR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IPR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IPR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IPR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IPR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IPR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IPR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IPR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IPR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IPR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IPR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IPR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IPR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IPR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IPR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IPR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IPR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IPR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IPR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IPR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IPR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IPR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IPR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IPR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IPR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IPR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IPR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IPR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IPR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IPR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IPR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IPR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IPR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IPR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IPR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IPR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IPR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IPR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IPR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IPR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IPR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IPR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IPR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IPR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IPR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IPR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IPR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IPR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IPR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IPR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IPR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IPR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IPR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IPR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IPR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IPR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IPR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IPR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IPR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IPR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IPR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IPR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IPR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IPR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IPR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IPR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IPR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IPR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IPR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IPR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IPR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IPR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IPR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IPR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IPR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IPR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IPR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IPR_PID31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of FIQ field.
	AIC_IMR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IMR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IMR_FIQ = 0x1
	// Position of SYS field.
	AIC_IMR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IMR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IMR_SYS = 0x2
	// Position of PID2 field.
	AIC_IMR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IMR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IMR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IMR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IMR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IMR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IMR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IMR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IMR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IMR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IMR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IMR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IMR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IMR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IMR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IMR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IMR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IMR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IMR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IMR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IMR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IMR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IMR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IMR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IMR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IMR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IMR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IMR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IMR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IMR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IMR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IMR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IMR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IMR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IMR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IMR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IMR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IMR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IMR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IMR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IMR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IMR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IMR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IMR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IMR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IMR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IMR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IMR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IMR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IMR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IMR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IMR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IMR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IMR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IMR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IMR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IMR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IMR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IMR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IMR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IMR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IMR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IMR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IMR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IMR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IMR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IMR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IMR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IMR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IMR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IMR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IMR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IMR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IMR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IMR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IMR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IMR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IMR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IMR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IMR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IMR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IMR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IMR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IMR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IMR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IMR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IMR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IMR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IMR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IMR_PID31 = 0x80000000

	// CISR: Core Interrupt Status Register
	// Position of NFIQ field.
	AIC_CISR_NFIQ_Pos = 0x0
	// Bit mask of NFIQ field.
	AIC_CISR_NFIQ_Msk = 0x1
	// Bit NFIQ.
	AIC_CISR_NFIQ = 0x1
	// Position of NIRQ field.
	AIC_CISR_NIRQ_Pos = 0x1
	// Bit mask of NIRQ field.
	AIC_CISR_NIRQ_Msk = 0x2
	// Bit NIRQ.
	AIC_CISR_NIRQ = 0x2

	// IECR: Interrupt Enable Command Register
	// Position of FIQ field.
	AIC_IECR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IECR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IECR_FIQ = 0x1
	// Position of SYS field.
	AIC_IECR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IECR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IECR_SYS = 0x2
	// Position of PID2 field.
	AIC_IECR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IECR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IECR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IECR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IECR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IECR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IECR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IECR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IECR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IECR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IECR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IECR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IECR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IECR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IECR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IECR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IECR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IECR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IECR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IECR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IECR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IECR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IECR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IECR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IECR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IECR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IECR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IECR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IECR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IECR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IECR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IECR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IECR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IECR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IECR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IECR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IECR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IECR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IECR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IECR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IECR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IECR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IECR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IECR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IECR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IECR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IECR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IECR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IECR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IECR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IECR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IECR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IECR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IECR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IECR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IECR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IECR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IECR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IECR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IECR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IECR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IECR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IECR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IECR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IECR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IECR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IECR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IECR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IECR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IECR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IECR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IECR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IECR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IECR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IECR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IECR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IECR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IECR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IECR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IECR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IECR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IECR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IECR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IECR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IECR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IECR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IECR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IECR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IECR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IECR_PID31 = 0x80000000

	// IDCR: Interrupt Disable Command Register
	// Position of FIQ field.
	AIC_IDCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IDCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IDCR_FIQ = 0x1
	// Position of SYS field.
	AIC_IDCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IDCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IDCR_SYS = 0x2
	// Position of PID2 field.
	AIC_IDCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IDCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IDCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IDCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IDCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IDCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IDCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IDCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IDCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IDCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IDCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IDCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IDCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IDCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IDCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IDCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IDCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IDCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IDCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IDCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IDCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IDCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IDCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IDCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IDCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IDCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IDCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IDCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IDCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IDCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IDCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IDCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IDCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IDCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IDCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IDCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IDCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IDCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IDCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IDCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IDCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IDCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IDCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IDCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IDCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IDCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IDCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IDCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IDCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IDCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IDCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IDCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IDCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IDCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IDCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IDCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IDCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IDCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IDCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IDCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IDCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IDCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IDCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IDCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IDCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IDCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IDCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IDCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IDCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IDCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IDCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IDCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IDCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IDCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IDCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IDCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IDCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IDCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IDCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IDCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IDCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IDCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IDCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IDCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IDCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IDCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IDCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IDCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IDCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IDCR_PID31 = 0x80000000

	// ICCR: Interrupt Clear Command Register
	// Position of FIQ field.
	AIC_ICCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_ICCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_ICCR_FIQ = 0x1
	// Position of SYS field.
	AIC_ICCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_ICCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_ICCR_SYS = 0x2
	// Position of PID2 field.
	AIC_ICCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_ICCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_ICCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_ICCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_ICCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_ICCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_ICCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_ICCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_ICCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_ICCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_ICCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_ICCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_ICCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_ICCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_ICCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_ICCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_ICCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_ICCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_ICCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_ICCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_ICCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_ICCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_ICCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_ICCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_ICCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_ICCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_ICCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_ICCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_ICCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_ICCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_ICCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_ICCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_ICCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_ICCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_ICCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_ICCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_ICCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_ICCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_ICCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_ICCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_ICCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_ICCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_ICCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_ICCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_ICCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_ICCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_ICCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_ICCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_ICCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_ICCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_ICCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_ICCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_ICCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_ICCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_ICCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_ICCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_ICCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_ICCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_ICCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_ICCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_ICCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_ICCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_ICCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_ICCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_ICCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_ICCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_ICCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_ICCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_ICCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_ICCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_ICCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_ICCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_ICCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_ICCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_ICCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_ICCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_ICCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_ICCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_ICCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_ICCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_ICCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_ICCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_ICCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_ICCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_ICCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_ICCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_ICCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_ICCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_ICCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_ICCR_PID31 = 0x80000000

	// ISCR: Interrupt Set Command Register
	// Position of FIQ field.
	AIC_ISCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_ISCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_ISCR_FIQ = 0x1
	// Position of SYS field.
	AIC_ISCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_ISCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_ISCR_SYS = 0x2
	// Position of PID2 field.
	AIC_ISCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_ISCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_ISCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_ISCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_ISCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_ISCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_ISCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_ISCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_ISCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_ISCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_ISCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_ISCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_ISCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_ISCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_ISCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_ISCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_ISCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_ISCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_ISCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_ISCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_ISCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_ISCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_ISCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_ISCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_ISCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_ISCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_ISCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_ISCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_ISCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_ISCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_ISCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_ISCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_ISCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_ISCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_ISCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_ISCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_ISCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_ISCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_ISCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_ISCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_ISCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_ISCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_ISCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_ISCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_ISCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_ISCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_ISCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_ISCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_ISCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_ISCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_ISCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_ISCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_ISCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_ISCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_ISCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_ISCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_ISCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_ISCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_ISCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_ISCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_ISCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_ISCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_ISCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_ISCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_ISCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_ISCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_ISCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_ISCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_ISCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_ISCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_ISCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_ISCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_ISCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_ISCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_ISCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_ISCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_ISCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_ISCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_ISCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_ISCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_ISCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_ISCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_ISCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_ISCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_ISCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_ISCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_ISCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_ISCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_ISCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_ISCR_PID31 = 0x80000000

	// SPU: Spurious Interrupt Vector Register
	// Position of SIVR field.
	AIC_SPU_SIVR_Pos = 0x0
	// Bit mask of SIVR field.
	AIC_SPU_SIVR_Msk = 0xffffffff

	// DCR: Debug Control Register
	// Position of PROT field.
	AIC_DCR_PROT_Pos = 0x0
	// Bit mask of PROT field.
	AIC_DCR_PROT_Msk = 0x1
	// Bit PROT.
	AIC_DCR_PROT = 0x1
	// Position of GMSK field.
	AIC_DCR_GMSK_Pos = 0x1
	// Bit mask of GMSK field.
	AIC_DCR_GMSK_Msk = 0x2
	// Bit GMSK.
	AIC_DCR_GMSK = 0x2

	// FFER: Fast Forcing Enable Register
	// Position of SYS field.
	AIC_FFER_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFER_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFER_SYS = 0x2
	// Position of PID2 field.
	AIC_FFER_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFER_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFER_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFER_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFER_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFER_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFER_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFER_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFER_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFER_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFER_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFER_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFER_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFER_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFER_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFER_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFER_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFER_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFER_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFER_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFER_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFER_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFER_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFER_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFER_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFER_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFER_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFER_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFER_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFER_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFER_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFER_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFER_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFER_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFER_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFER_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFER_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFER_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFER_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFER_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFER_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFER_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFER_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFER_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFER_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFER_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFER_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFER_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFER_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFER_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFER_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFER_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFER_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFER_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFER_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFER_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFER_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFER_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFER_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFER_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFER_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFER_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFER_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFER_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFER_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFER_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFER_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFER_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFER_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFER_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFER_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFER_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFER_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFER_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFER_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFER_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFER_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFER_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFER_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFER_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFER_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFER_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFER_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFER_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFER_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFER_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFER_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFER_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFER_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFER_PID31 = 0x80000000

	// FFDR: Fast Forcing Disable Register
	// Position of SYS field.
	AIC_FFDR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFDR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFDR_SYS = 0x2
	// Position of PID2 field.
	AIC_FFDR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFDR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFDR_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFDR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFDR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFDR_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFDR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFDR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFDR_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFDR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFDR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFDR_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFDR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFDR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFDR_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFDR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFDR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFDR_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFDR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFDR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFDR_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFDR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFDR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFDR_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFDR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFDR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFDR_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFDR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFDR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFDR_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFDR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFDR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFDR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFDR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFDR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFDR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFDR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFDR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFDR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFDR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFDR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFDR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFDR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFDR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFDR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFDR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFDR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFDR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFDR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFDR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFDR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFDR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFDR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFDR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFDR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFDR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFDR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFDR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFDR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFDR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFDR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFDR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFDR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFDR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFDR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFDR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFDR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFDR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFDR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFDR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFDR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFDR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFDR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFDR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFDR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFDR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFDR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFDR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFDR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFDR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFDR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFDR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFDR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFDR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFDR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFDR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFDR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFDR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFDR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFDR_PID31 = 0x80000000

	// FFSR: Fast Forcing Status Register
	// Position of SYS field.
	AIC_FFSR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFSR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFSR_SYS = 0x2
	// Position of PID2 field.
	AIC_FFSR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFSR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFSR_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFSR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFSR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFSR_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFSR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFSR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFSR_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFSR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFSR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFSR_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFSR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFSR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFSR_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFSR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFSR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFSR_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFSR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFSR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFSR_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFSR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFSR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFSR_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFSR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFSR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFSR_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFSR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFSR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFSR_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFSR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFSR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFSR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFSR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFSR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFSR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFSR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFSR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFSR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFSR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFSR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFSR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFSR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFSR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFSR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFSR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFSR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFSR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFSR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFSR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFSR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFSR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFSR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFSR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFSR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFSR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFSR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFSR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFSR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFSR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFSR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFSR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFSR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFSR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFSR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFSR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFSR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFSR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFSR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFSR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFSR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFSR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFSR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFSR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFSR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFSR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFSR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFSR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFSR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFSR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFSR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFSR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFSR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFSR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFSR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFSR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFSR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFSR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFSR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFSR_PID31 = 0x80000000
)

// Constants for DBGU: Debug Unit
const (
	// CR: Control Register
	// Position of RSTRX field.
	DBGU_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	DBGU_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	DBGU_CR_RSTRX = 0x4
	// Position of RSTTX field.
	DBGU_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	DBGU_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	DBGU_CR_RSTTX = 0x8
	// Position of RXEN field.
	DBGU_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	DBGU_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	DBGU_CR_RXEN = 0x10
	// Position of RXDIS field.
	DBGU_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	DBGU_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	DBGU_CR_RXDIS = 0x20
	// Position of TXEN field.
	DBGU_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	DBGU_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	DBGU_CR_TXEN = 0x40
	// Position of TXDIS field.
	DBGU_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	DBGU_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	DBGU_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	DBGU_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	DBGU_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	DBGU_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	DBGU_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	DBGU_MR_PAR_Msk = 0xe00
	// Position of CHMODE field.
	DBGU_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	DBGU_MR_CHMODE_Msk = 0xc000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	DBGU_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IER_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IER_TXRDY = 0x2
	// Position of ENDRX field.
	DBGU_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	DBGU_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	DBGU_IER_ENDRX = 0x8
	// Position of ENDTX field.
	DBGU_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	DBGU_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	DBGU_IER_ENDTX = 0x10
	// Position of OVRE field.
	DBGU_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IER_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IER_FRAME = 0x40
	// Position of PARE field.
	DBGU_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IER_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IER_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IER_TXEMPTY = 0x200
	// Position of TXBUFE field.
	DBGU_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	DBGU_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	DBGU_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	DBGU_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	DBGU_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	DBGU_IER_RXBUFF = 0x1000
	// Position of COMMTX field.
	DBGU_IER_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IER_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IER_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IER_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IER_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IER_COMMRX = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	DBGU_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IDR_TXRDY = 0x2
	// Position of ENDRX field.
	DBGU_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	DBGU_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	DBGU_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	DBGU_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	DBGU_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	DBGU_IDR_ENDTX = 0x10
	// Position of OVRE field.
	DBGU_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IDR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IDR_FRAME = 0x40
	// Position of PARE field.
	DBGU_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IDR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IDR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	DBGU_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	DBGU_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	DBGU_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	DBGU_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	DBGU_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	DBGU_IDR_RXBUFF = 0x1000
	// Position of COMMTX field.
	DBGU_IDR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IDR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IDR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IDR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IDR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IDR_COMMRX = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	DBGU_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IMR_TXRDY = 0x2
	// Position of ENDRX field.
	DBGU_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	DBGU_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	DBGU_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	DBGU_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	DBGU_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	DBGU_IMR_ENDTX = 0x10
	// Position of OVRE field.
	DBGU_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IMR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IMR_FRAME = 0x40
	// Position of PARE field.
	DBGU_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IMR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IMR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	DBGU_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	DBGU_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	DBGU_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	DBGU_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	DBGU_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	DBGU_IMR_RXBUFF = 0x1000
	// Position of COMMTX field.
	DBGU_IMR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IMR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IMR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IMR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IMR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IMR_COMMRX = 0x80000000

	// SR: Status Register
	// Position of RXRDY field.
	DBGU_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_SR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_SR_TXRDY = 0x2
	// Position of ENDRX field.
	DBGU_SR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	DBGU_SR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	DBGU_SR_ENDRX = 0x8
	// Position of ENDTX field.
	DBGU_SR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	DBGU_SR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	DBGU_SR_ENDTX = 0x10
	// Position of OVRE field.
	DBGU_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_SR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_SR_FRAME = 0x40
	// Position of PARE field.
	DBGU_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_SR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_SR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_SR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	DBGU_SR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	DBGU_SR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	DBGU_SR_TXBUFE = 0x800
	// Position of RXBUFF field.
	DBGU_SR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	DBGU_SR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	DBGU_SR_RXBUFF = 0x1000
	// Position of COMMTX field.
	DBGU_SR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_SR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_SR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_SR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_SR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_SR_COMMRX = 0x80000000

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	DBGU_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	DBGU_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	DBGU_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	DBGU_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	DBGU_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	DBGU_BRGR_CD_Msk = 0xffff

	// CIDR: Chip ID Register
	// Position of VERSION field.
	DBGU_CIDR_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	DBGU_CIDR_VERSION_Msk = 0x1f
	// Position of EPROC field.
	DBGU_CIDR_EPROC_Pos = 0x5
	// Bit mask of EPROC field.
	DBGU_CIDR_EPROC_Msk = 0xe0
	// Position of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_Pos = 0x8
	// Bit mask of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_Msk = 0xf00
	// Position of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_Pos = 0xc
	// Bit mask of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_Msk = 0xf000
	// Position of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_Pos = 0x10
	// Bit mask of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_Msk = 0xf0000
	// Position of ARCH field.
	DBGU_CIDR_ARCH_Pos = 0x14
	// Bit mask of ARCH field.
	DBGU_CIDR_ARCH_Msk = 0xff00000
	// Position of NVPTYP field.
	DBGU_CIDR_NVPTYP_Pos = 0x1c
	// Bit mask of NVPTYP field.
	DBGU_CIDR_NVPTYP_Msk = 0x70000000
	// Position of EXT field.
	DBGU_CIDR_EXT_Pos = 0x1f
	// Bit mask of EXT field.
	DBGU_CIDR_EXT_Msk = 0x80000000
	// Bit EXT.
	DBGU_CIDR_EXT = 0x80000000

	// EXID: Chip ID Extension Register
	// Position of EXID field.
	DBGU_EXID_EXID_Pos = 0x0
	// Bit mask of EXID field.
	DBGU_EXID_EXID_Msk = 0xffffffff

	// FNR: Force NTRST Register
	// Position of FNTRST field.
	DBGU_FNR_FNTRST_Pos = 0x0
	// Bit mask of FNTRST field.
	DBGU_FNR_FNTRST_Msk = 0x1
	// Bit FNTRST.
	DBGU_FNR_FNTRST = 0x1

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	DBGU_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	DBGU_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	DBGU_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	DBGU_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	DBGU_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	DBGU_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	DBGU_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	DBGU_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	DBGU_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	DBGU_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	DBGU_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	DBGU_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	DBGU_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	DBGU_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	DBGU_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	DBGU_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	DBGU_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DBGU_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DBGU_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	DBGU_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	DBGU_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	DBGU_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	DBGU_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DBGU_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DBGU_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	DBGU_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	DBGU_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	DBGU_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	DBGU_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DBGU_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DBGU_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	DBGU_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DBGU_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DBGU_PTSR_TXTEN = 0x100
)

// Constants for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	// Position of P0 field.
	PIO_PER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PER_P0_Msk = 0x1
	// Bit P0.
	PIO_PER_P0 = 0x1
	// Position of P1 field.
	PIO_PER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PER_P1_Msk = 0x2
	// Bit P1.
	PIO_PER_P1 = 0x2
	// Position of P2 field.
	PIO_PER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PER_P2_Msk = 0x4
	// Bit P2.
	PIO_PER_P2 = 0x4
	// Position of P3 field.
	PIO_PER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PER_P3_Msk = 0x8
	// Bit P3.
	PIO_PER_P3 = 0x8
	// Position of P4 field.
	PIO_PER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PER_P4_Msk = 0x10
	// Bit P4.
	PIO_PER_P4 = 0x10
	// Position of P5 field.
	PIO_PER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PER_P5_Msk = 0x20
	// Bit P5.
	PIO_PER_P5 = 0x20
	// Position of P6 field.
	PIO_PER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PER_P6_Msk = 0x40
	// Bit P6.
	PIO_PER_P6 = 0x40
	// Position of P7 field.
	PIO_PER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PER_P7_Msk = 0x80
	// Bit P7.
	PIO_PER_P7 = 0x80
	// Position of P8 field.
	PIO_PER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PER_P8_Msk = 0x100
	// Bit P8.
	PIO_PER_P8 = 0x100
	// Position of P9 field.
	PIO_PER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PER_P9_Msk = 0x200
	// Bit P9.
	PIO_PER_P9 = 0x200
	// Position of P10 field.
	PIO_PER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PER_P10_Msk = 0x400
	// Bit P10.
	PIO_PER_P10 = 0x400
	// Position of P11 field.
	PIO_PER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PER_P11_Msk = 0x800
	// Bit P11.
	PIO_PER_P11 = 0x800
	// Position of P12 field.
	PIO_PER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PER_P12 = 0x1000
	// Position of P13 field.
	PIO_PER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PER_P13 = 0x2000
	// Position of P14 field.
	PIO_PER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PER_P14 = 0x4000
	// Position of P15 field.
	PIO_PER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PER_P15 = 0x8000
	// Position of P16 field.
	PIO_PER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PER_P16 = 0x10000
	// Position of P17 field.
	PIO_PER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PER_P17 = 0x20000
	// Position of P18 field.
	PIO_PER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PER_P18 = 0x40000
	// Position of P19 field.
	PIO_PER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PER_P19 = 0x80000
	// Position of P20 field.
	PIO_PER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PER_P20 = 0x100000
	// Position of P21 field.
	PIO_PER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PER_P21 = 0x200000
	// Position of P22 field.
	PIO_PER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PER_P22 = 0x400000
	// Position of P23 field.
	PIO_PER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PER_P23 = 0x800000
	// Position of P24 field.
	PIO_PER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PER_P31 = 0x80000000

	// PDR: PIO Disable Register
	// Position of P0 field.
	PIO_PDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDR_P0 = 0x1
	// Position of P1 field.
	PIO_PDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDR_P1 = 0x2
	// Position of P2 field.
	PIO_PDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDR_P2 = 0x4
	// Position of P3 field.
	PIO_PDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDR_P3 = 0x8
	// Position of P4 field.
	PIO_PDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDR_P4 = 0x10
	// Position of P5 field.
	PIO_PDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDR_P5 = 0x20
	// Position of P6 field.
	PIO_PDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDR_P6 = 0x40
	// Position of P7 field.
	PIO_PDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDR_P7 = 0x80
	// Position of P8 field.
	PIO_PDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDR_P8 = 0x100
	// Position of P9 field.
	PIO_PDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDR_P9 = 0x200
	// Position of P10 field.
	PIO_PDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDR_P10 = 0x400
	// Position of P11 field.
	PIO_PDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDR_P11 = 0x800
	// Position of P12 field.
	PIO_PDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDR_P31 = 0x80000000

	// PSR: PIO Status Register
	// Position of P0 field.
	PIO_PSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PSR_P0 = 0x1
	// Position of P1 field.
	PIO_PSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PSR_P1 = 0x2
	// Position of P2 field.
	PIO_PSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PSR_P2 = 0x4
	// Position of P3 field.
	PIO_PSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PSR_P3 = 0x8
	// Position of P4 field.
	PIO_PSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PSR_P4 = 0x10
	// Position of P5 field.
	PIO_PSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PSR_P5 = 0x20
	// Position of P6 field.
	PIO_PSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PSR_P6 = 0x40
	// Position of P7 field.
	PIO_PSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PSR_P7 = 0x80
	// Position of P8 field.
	PIO_PSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PSR_P8 = 0x100
	// Position of P9 field.
	PIO_PSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PSR_P9 = 0x200
	// Position of P10 field.
	PIO_PSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PSR_P10 = 0x400
	// Position of P11 field.
	PIO_PSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PSR_P11 = 0x800
	// Position of P12 field.
	PIO_PSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PSR_P31 = 0x80000000

	// OER: Output Enable Register
	// Position of P0 field.
	PIO_OER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OER_P0_Msk = 0x1
	// Bit P0.
	PIO_OER_P0 = 0x1
	// Position of P1 field.
	PIO_OER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OER_P1_Msk = 0x2
	// Bit P1.
	PIO_OER_P1 = 0x2
	// Position of P2 field.
	PIO_OER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OER_P2_Msk = 0x4
	// Bit P2.
	PIO_OER_P2 = 0x4
	// Position of P3 field.
	PIO_OER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OER_P3_Msk = 0x8
	// Bit P3.
	PIO_OER_P3 = 0x8
	// Position of P4 field.
	PIO_OER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OER_P4_Msk = 0x10
	// Bit P4.
	PIO_OER_P4 = 0x10
	// Position of P5 field.
	PIO_OER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OER_P5_Msk = 0x20
	// Bit P5.
	PIO_OER_P5 = 0x20
	// Position of P6 field.
	PIO_OER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OER_P6_Msk = 0x40
	// Bit P6.
	PIO_OER_P6 = 0x40
	// Position of P7 field.
	PIO_OER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OER_P7_Msk = 0x80
	// Bit P7.
	PIO_OER_P7 = 0x80
	// Position of P8 field.
	PIO_OER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OER_P8_Msk = 0x100
	// Bit P8.
	PIO_OER_P8 = 0x100
	// Position of P9 field.
	PIO_OER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OER_P9_Msk = 0x200
	// Bit P9.
	PIO_OER_P9 = 0x200
	// Position of P10 field.
	PIO_OER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OER_P10_Msk = 0x400
	// Bit P10.
	PIO_OER_P10 = 0x400
	// Position of P11 field.
	PIO_OER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OER_P11_Msk = 0x800
	// Bit P11.
	PIO_OER_P11 = 0x800
	// Position of P12 field.
	PIO_OER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OER_P12 = 0x1000
	// Position of P13 field.
	PIO_OER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OER_P13 = 0x2000
	// Position of P14 field.
	PIO_OER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OER_P14 = 0x4000
	// Position of P15 field.
	PIO_OER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OER_P15 = 0x8000
	// Position of P16 field.
	PIO_OER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OER_P16 = 0x10000
	// Position of P17 field.
	PIO_OER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OER_P17 = 0x20000
	// Position of P18 field.
	PIO_OER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OER_P18 = 0x40000
	// Position of P19 field.
	PIO_OER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OER_P19 = 0x80000
	// Position of P20 field.
	PIO_OER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OER_P20 = 0x100000
	// Position of P21 field.
	PIO_OER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OER_P21 = 0x200000
	// Position of P22 field.
	PIO_OER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OER_P22 = 0x400000
	// Position of P23 field.
	PIO_OER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OER_P23 = 0x800000
	// Position of P24 field.
	PIO_OER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OER_P31 = 0x80000000

	// ODR: Output Disable Register
	// Position of P0 field.
	PIO_ODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODR_P0 = 0x1
	// Position of P1 field.
	PIO_ODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODR_P1 = 0x2
	// Position of P2 field.
	PIO_ODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODR_P2 = 0x4
	// Position of P3 field.
	PIO_ODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODR_P3 = 0x8
	// Position of P4 field.
	PIO_ODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODR_P4 = 0x10
	// Position of P5 field.
	PIO_ODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODR_P5 = 0x20
	// Position of P6 field.
	PIO_ODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODR_P6 = 0x40
	// Position of P7 field.
	PIO_ODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODR_P7 = 0x80
	// Position of P8 field.
	PIO_ODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODR_P8 = 0x100
	// Position of P9 field.
	PIO_ODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODR_P9 = 0x200
	// Position of P10 field.
	PIO_ODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODR_P10 = 0x400
	// Position of P11 field.
	PIO_ODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODR_P11 = 0x800
	// Position of P12 field.
	PIO_ODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODR_P31 = 0x80000000

	// OSR: Output Status Register
	// Position of P0 field.
	PIO_OSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OSR_P0 = 0x1
	// Position of P1 field.
	PIO_OSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OSR_P1 = 0x2
	// Position of P2 field.
	PIO_OSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OSR_P2 = 0x4
	// Position of P3 field.
	PIO_OSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OSR_P3 = 0x8
	// Position of P4 field.
	PIO_OSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OSR_P4 = 0x10
	// Position of P5 field.
	PIO_OSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OSR_P5 = 0x20
	// Position of P6 field.
	PIO_OSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OSR_P6 = 0x40
	// Position of P7 field.
	PIO_OSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OSR_P7 = 0x80
	// Position of P8 field.
	PIO_OSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OSR_P8 = 0x100
	// Position of P9 field.
	PIO_OSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OSR_P9 = 0x200
	// Position of P10 field.
	PIO_OSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OSR_P10 = 0x400
	// Position of P11 field.
	PIO_OSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OSR_P11 = 0x800
	// Position of P12 field.
	PIO_OSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OSR_P31 = 0x80000000

	// IFER: Glitch Input Filter Enable Register
	// Position of P0 field.
	PIO_IFER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFER_P0 = 0x1
	// Position of P1 field.
	PIO_IFER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFER_P1 = 0x2
	// Position of P2 field.
	PIO_IFER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFER_P2 = 0x4
	// Position of P3 field.
	PIO_IFER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFER_P3 = 0x8
	// Position of P4 field.
	PIO_IFER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFER_P4 = 0x10
	// Position of P5 field.
	PIO_IFER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFER_P5 = 0x20
	// Position of P6 field.
	PIO_IFER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFER_P6 = 0x40
	// Position of P7 field.
	PIO_IFER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFER_P7 = 0x80
	// Position of P8 field.
	PIO_IFER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFER_P8 = 0x100
	// Position of P9 field.
	PIO_IFER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFER_P9 = 0x200
	// Position of P10 field.
	PIO_IFER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFER_P10 = 0x400
	// Position of P11 field.
	PIO_IFER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFER_P11 = 0x800
	// Position of P12 field.
	PIO_IFER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFER_P31 = 0x80000000

	// IFDR: Glitch Input Filter Disable Register
	// Position of P0 field.
	PIO_IFDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDR_P31 = 0x80000000

	// IFSR: Glitch Input Filter Status Register
	// Position of P0 field.
	PIO_IFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSR_P31 = 0x80000000

	// SODR: Set Output Data Register
	// Position of P0 field.
	PIO_SODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SODR_P0_Msk = 0x1
	// Bit P0.
	PIO_SODR_P0 = 0x1
	// Position of P1 field.
	PIO_SODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SODR_P1_Msk = 0x2
	// Bit P1.
	PIO_SODR_P1 = 0x2
	// Position of P2 field.
	PIO_SODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SODR_P2_Msk = 0x4
	// Bit P2.
	PIO_SODR_P2 = 0x4
	// Position of P3 field.
	PIO_SODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SODR_P3_Msk = 0x8
	// Bit P3.
	PIO_SODR_P3 = 0x8
	// Position of P4 field.
	PIO_SODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SODR_P4_Msk = 0x10
	// Bit P4.
	PIO_SODR_P4 = 0x10
	// Position of P5 field.
	PIO_SODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SODR_P5_Msk = 0x20
	// Bit P5.
	PIO_SODR_P5 = 0x20
	// Position of P6 field.
	PIO_SODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SODR_P6_Msk = 0x40
	// Bit P6.
	PIO_SODR_P6 = 0x40
	// Position of P7 field.
	PIO_SODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SODR_P7_Msk = 0x80
	// Bit P7.
	PIO_SODR_P7 = 0x80
	// Position of P8 field.
	PIO_SODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SODR_P8_Msk = 0x100
	// Bit P8.
	PIO_SODR_P8 = 0x100
	// Position of P9 field.
	PIO_SODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SODR_P9_Msk = 0x200
	// Bit P9.
	PIO_SODR_P9 = 0x200
	// Position of P10 field.
	PIO_SODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SODR_P10_Msk = 0x400
	// Bit P10.
	PIO_SODR_P10 = 0x400
	// Position of P11 field.
	PIO_SODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SODR_P11_Msk = 0x800
	// Bit P11.
	PIO_SODR_P11 = 0x800
	// Position of P12 field.
	PIO_SODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SODR_P12 = 0x1000
	// Position of P13 field.
	PIO_SODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SODR_P13 = 0x2000
	// Position of P14 field.
	PIO_SODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SODR_P14 = 0x4000
	// Position of P15 field.
	PIO_SODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SODR_P15 = 0x8000
	// Position of P16 field.
	PIO_SODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SODR_P16 = 0x10000
	// Position of P17 field.
	PIO_SODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SODR_P17 = 0x20000
	// Position of P18 field.
	PIO_SODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SODR_P18 = 0x40000
	// Position of P19 field.
	PIO_SODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SODR_P19 = 0x80000
	// Position of P20 field.
	PIO_SODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SODR_P20 = 0x100000
	// Position of P21 field.
	PIO_SODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SODR_P21 = 0x200000
	// Position of P22 field.
	PIO_SODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SODR_P22 = 0x400000
	// Position of P23 field.
	PIO_SODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SODR_P23 = 0x800000
	// Position of P24 field.
	PIO_SODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SODR_P31 = 0x80000000

	// CODR: Clear Output Data Register
	// Position of P0 field.
	PIO_CODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_CODR_P0_Msk = 0x1
	// Bit P0.
	PIO_CODR_P0 = 0x1
	// Position of P1 field.
	PIO_CODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_CODR_P1_Msk = 0x2
	// Bit P1.
	PIO_CODR_P1 = 0x2
	// Position of P2 field.
	PIO_CODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_CODR_P2_Msk = 0x4
	// Bit P2.
	PIO_CODR_P2 = 0x4
	// Position of P3 field.
	PIO_CODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_CODR_P3_Msk = 0x8
	// Bit P3.
	PIO_CODR_P3 = 0x8
	// Position of P4 field.
	PIO_CODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_CODR_P4_Msk = 0x10
	// Bit P4.
	PIO_CODR_P4 = 0x10
	// Position of P5 field.
	PIO_CODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_CODR_P5_Msk = 0x20
	// Bit P5.
	PIO_CODR_P5 = 0x20
	// Position of P6 field.
	PIO_CODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_CODR_P6_Msk = 0x40
	// Bit P6.
	PIO_CODR_P6 = 0x40
	// Position of P7 field.
	PIO_CODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_CODR_P7_Msk = 0x80
	// Bit P7.
	PIO_CODR_P7 = 0x80
	// Position of P8 field.
	PIO_CODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_CODR_P8_Msk = 0x100
	// Bit P8.
	PIO_CODR_P8 = 0x100
	// Position of P9 field.
	PIO_CODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_CODR_P9_Msk = 0x200
	// Bit P9.
	PIO_CODR_P9 = 0x200
	// Position of P10 field.
	PIO_CODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_CODR_P10_Msk = 0x400
	// Bit P10.
	PIO_CODR_P10 = 0x400
	// Position of P11 field.
	PIO_CODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_CODR_P11_Msk = 0x800
	// Bit P11.
	PIO_CODR_P11 = 0x800
	// Position of P12 field.
	PIO_CODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_CODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_CODR_P12 = 0x1000
	// Position of P13 field.
	PIO_CODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_CODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_CODR_P13 = 0x2000
	// Position of P14 field.
	PIO_CODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_CODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_CODR_P14 = 0x4000
	// Position of P15 field.
	PIO_CODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_CODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_CODR_P15 = 0x8000
	// Position of P16 field.
	PIO_CODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_CODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_CODR_P16 = 0x10000
	// Position of P17 field.
	PIO_CODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_CODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_CODR_P17 = 0x20000
	// Position of P18 field.
	PIO_CODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_CODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_CODR_P18 = 0x40000
	// Position of P19 field.
	PIO_CODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_CODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_CODR_P19 = 0x80000
	// Position of P20 field.
	PIO_CODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_CODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_CODR_P20 = 0x100000
	// Position of P21 field.
	PIO_CODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_CODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_CODR_P21 = 0x200000
	// Position of P22 field.
	PIO_CODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_CODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_CODR_P22 = 0x400000
	// Position of P23 field.
	PIO_CODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_CODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_CODR_P23 = 0x800000
	// Position of P24 field.
	PIO_CODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_CODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_CODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_CODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_CODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_CODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_CODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_CODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_CODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_CODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_CODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_CODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_CODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_CODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_CODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_CODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_CODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_CODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_CODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_CODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_CODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_CODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_CODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_CODR_P31 = 0x80000000

	// ODSR: Output Data Status Register
	// Position of P0 field.
	PIO_ODSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODSR_P0 = 0x1
	// Position of P1 field.
	PIO_ODSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODSR_P1 = 0x2
	// Position of P2 field.
	PIO_ODSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODSR_P2 = 0x4
	// Position of P3 field.
	PIO_ODSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODSR_P3 = 0x8
	// Position of P4 field.
	PIO_ODSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODSR_P4 = 0x10
	// Position of P5 field.
	PIO_ODSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODSR_P5 = 0x20
	// Position of P6 field.
	PIO_ODSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODSR_P6 = 0x40
	// Position of P7 field.
	PIO_ODSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODSR_P7 = 0x80
	// Position of P8 field.
	PIO_ODSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODSR_P8 = 0x100
	// Position of P9 field.
	PIO_ODSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODSR_P9 = 0x200
	// Position of P10 field.
	PIO_ODSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODSR_P10 = 0x400
	// Position of P11 field.
	PIO_ODSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODSR_P11 = 0x800
	// Position of P12 field.
	PIO_ODSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODSR_P31 = 0x80000000

	// PDSR: Pin Data Status Register
	// Position of P0 field.
	PIO_PDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDSR_P31 = 0x80000000

	// IER: Interrupt Enable Register
	// Position of P0 field.
	PIO_IER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IER_P0_Msk = 0x1
	// Bit P0.
	PIO_IER_P0 = 0x1
	// Position of P1 field.
	PIO_IER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IER_P1_Msk = 0x2
	// Bit P1.
	PIO_IER_P1 = 0x2
	// Position of P2 field.
	PIO_IER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IER_P2_Msk = 0x4
	// Bit P2.
	PIO_IER_P2 = 0x4
	// Position of P3 field.
	PIO_IER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IER_P3_Msk = 0x8
	// Bit P3.
	PIO_IER_P3 = 0x8
	// Position of P4 field.
	PIO_IER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IER_P4_Msk = 0x10
	// Bit P4.
	PIO_IER_P4 = 0x10
	// Position of P5 field.
	PIO_IER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IER_P5_Msk = 0x20
	// Bit P5.
	PIO_IER_P5 = 0x20
	// Position of P6 field.
	PIO_IER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IER_P6_Msk = 0x40
	// Bit P6.
	PIO_IER_P6 = 0x40
	// Position of P7 field.
	PIO_IER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IER_P7_Msk = 0x80
	// Bit P7.
	PIO_IER_P7 = 0x80
	// Position of P8 field.
	PIO_IER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IER_P8_Msk = 0x100
	// Bit P8.
	PIO_IER_P8 = 0x100
	// Position of P9 field.
	PIO_IER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IER_P9_Msk = 0x200
	// Bit P9.
	PIO_IER_P9 = 0x200
	// Position of P10 field.
	PIO_IER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IER_P10_Msk = 0x400
	// Bit P10.
	PIO_IER_P10 = 0x400
	// Position of P11 field.
	PIO_IER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IER_P11_Msk = 0x800
	// Bit P11.
	PIO_IER_P11 = 0x800
	// Position of P12 field.
	PIO_IER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IER_P12 = 0x1000
	// Position of P13 field.
	PIO_IER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IER_P13 = 0x2000
	// Position of P14 field.
	PIO_IER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IER_P14 = 0x4000
	// Position of P15 field.
	PIO_IER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IER_P15 = 0x8000
	// Position of P16 field.
	PIO_IER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IER_P16 = 0x10000
	// Position of P17 field.
	PIO_IER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IER_P17 = 0x20000
	// Position of P18 field.
	PIO_IER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IER_P18 = 0x40000
	// Position of P19 field.
	PIO_IER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IER_P19 = 0x80000
	// Position of P20 field.
	PIO_IER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IER_P20 = 0x100000
	// Position of P21 field.
	PIO_IER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IER_P21 = 0x200000
	// Position of P22 field.
	PIO_IER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IER_P22 = 0x400000
	// Position of P23 field.
	PIO_IER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IER_P23 = 0x800000
	// Position of P24 field.
	PIO_IER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IER_P31 = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of P0 field.
	PIO_IDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IDR_P0 = 0x1
	// Position of P1 field.
	PIO_IDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IDR_P1 = 0x2
	// Position of P2 field.
	PIO_IDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IDR_P2 = 0x4
	// Position of P3 field.
	PIO_IDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IDR_P3 = 0x8
	// Position of P4 field.
	PIO_IDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IDR_P4 = 0x10
	// Position of P5 field.
	PIO_IDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IDR_P5 = 0x20
	// Position of P6 field.
	PIO_IDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IDR_P6 = 0x40
	// Position of P7 field.
	PIO_IDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IDR_P7 = 0x80
	// Position of P8 field.
	PIO_IDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IDR_P8 = 0x100
	// Position of P9 field.
	PIO_IDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IDR_P9 = 0x200
	// Position of P10 field.
	PIO_IDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IDR_P10 = 0x400
	// Position of P11 field.
	PIO_IDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IDR_P11 = 0x800
	// Position of P12 field.
	PIO_IDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IDR_P31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of P0 field.
	PIO_IMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IMR_P0_Msk = 0x1
	// Bit P0.
	PIO_IMR_P0 = 0x1
	// Position of P1 field.
	PIO_IMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IMR_P1_Msk = 0x2
	// Bit P1.
	PIO_IMR_P1 = 0x2
	// Position of P2 field.
	PIO_IMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IMR_P2_Msk = 0x4
	// Bit P2.
	PIO_IMR_P2 = 0x4
	// Position of P3 field.
	PIO_IMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IMR_P3_Msk = 0x8
	// Bit P3.
	PIO_IMR_P3 = 0x8
	// Position of P4 field.
	PIO_IMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IMR_P4_Msk = 0x10
	// Bit P4.
	PIO_IMR_P4 = 0x10
	// Position of P5 field.
	PIO_IMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IMR_P5_Msk = 0x20
	// Bit P5.
	PIO_IMR_P5 = 0x20
	// Position of P6 field.
	PIO_IMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IMR_P6_Msk = 0x40
	// Bit P6.
	PIO_IMR_P6 = 0x40
	// Position of P7 field.
	PIO_IMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IMR_P7_Msk = 0x80
	// Bit P7.
	PIO_IMR_P7 = 0x80
	// Position of P8 field.
	PIO_IMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IMR_P8_Msk = 0x100
	// Bit P8.
	PIO_IMR_P8 = 0x100
	// Position of P9 field.
	PIO_IMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IMR_P9_Msk = 0x200
	// Bit P9.
	PIO_IMR_P9 = 0x200
	// Position of P10 field.
	PIO_IMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IMR_P10_Msk = 0x400
	// Bit P10.
	PIO_IMR_P10 = 0x400
	// Position of P11 field.
	PIO_IMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IMR_P11_Msk = 0x800
	// Bit P11.
	PIO_IMR_P11 = 0x800
	// Position of P12 field.
	PIO_IMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IMR_P12 = 0x1000
	// Position of P13 field.
	PIO_IMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IMR_P13 = 0x2000
	// Position of P14 field.
	PIO_IMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IMR_P14 = 0x4000
	// Position of P15 field.
	PIO_IMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IMR_P15 = 0x8000
	// Position of P16 field.
	PIO_IMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IMR_P16 = 0x10000
	// Position of P17 field.
	PIO_IMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IMR_P17 = 0x20000
	// Position of P18 field.
	PIO_IMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IMR_P18 = 0x40000
	// Position of P19 field.
	PIO_IMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IMR_P19 = 0x80000
	// Position of P20 field.
	PIO_IMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IMR_P20 = 0x100000
	// Position of P21 field.
	PIO_IMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IMR_P21 = 0x200000
	// Position of P22 field.
	PIO_IMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IMR_P22 = 0x400000
	// Position of P23 field.
	PIO_IMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IMR_P23 = 0x800000
	// Position of P24 field.
	PIO_IMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IMR_P31 = 0x80000000

	// ISR: Interrupt Status Register
	// Position of P0 field.
	PIO_ISR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ISR_P0_Msk = 0x1
	// Bit P0.
	PIO_ISR_P0 = 0x1
	// Position of P1 field.
	PIO_ISR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ISR_P1_Msk = 0x2
	// Bit P1.
	PIO_ISR_P1 = 0x2
	// Position of P2 field.
	PIO_ISR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ISR_P2_Msk = 0x4
	// Bit P2.
	PIO_ISR_P2 = 0x4
	// Position of P3 field.
	PIO_ISR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ISR_P3_Msk = 0x8
	// Bit P3.
	PIO_ISR_P3 = 0x8
	// Position of P4 field.
	PIO_ISR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ISR_P4_Msk = 0x10
	// Bit P4.
	PIO_ISR_P4 = 0x10
	// Position of P5 field.
	PIO_ISR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ISR_P5_Msk = 0x20
	// Bit P5.
	PIO_ISR_P5 = 0x20
	// Position of P6 field.
	PIO_ISR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ISR_P6_Msk = 0x40
	// Bit P6.
	PIO_ISR_P6 = 0x40
	// Position of P7 field.
	PIO_ISR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ISR_P7_Msk = 0x80
	// Bit P7.
	PIO_ISR_P7 = 0x80
	// Position of P8 field.
	PIO_ISR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ISR_P8_Msk = 0x100
	// Bit P8.
	PIO_ISR_P8 = 0x100
	// Position of P9 field.
	PIO_ISR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ISR_P9_Msk = 0x200
	// Bit P9.
	PIO_ISR_P9 = 0x200
	// Position of P10 field.
	PIO_ISR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ISR_P10_Msk = 0x400
	// Bit P10.
	PIO_ISR_P10 = 0x400
	// Position of P11 field.
	PIO_ISR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ISR_P11_Msk = 0x800
	// Bit P11.
	PIO_ISR_P11 = 0x800
	// Position of P12 field.
	PIO_ISR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ISR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ISR_P12 = 0x1000
	// Position of P13 field.
	PIO_ISR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ISR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ISR_P13 = 0x2000
	// Position of P14 field.
	PIO_ISR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ISR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ISR_P14 = 0x4000
	// Position of P15 field.
	PIO_ISR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ISR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ISR_P15 = 0x8000
	// Position of P16 field.
	PIO_ISR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ISR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ISR_P16 = 0x10000
	// Position of P17 field.
	PIO_ISR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ISR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ISR_P17 = 0x20000
	// Position of P18 field.
	PIO_ISR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ISR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ISR_P18 = 0x40000
	// Position of P19 field.
	PIO_ISR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ISR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ISR_P19 = 0x80000
	// Position of P20 field.
	PIO_ISR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ISR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ISR_P20 = 0x100000
	// Position of P21 field.
	PIO_ISR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ISR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ISR_P21 = 0x200000
	// Position of P22 field.
	PIO_ISR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ISR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ISR_P22 = 0x400000
	// Position of P23 field.
	PIO_ISR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ISR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ISR_P23 = 0x800000
	// Position of P24 field.
	PIO_ISR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ISR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ISR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ISR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ISR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ISR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ISR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ISR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ISR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ISR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ISR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ISR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ISR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ISR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ISR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ISR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ISR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ISR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ISR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ISR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ISR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ISR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ISR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ISR_P31 = 0x80000000

	// MDER: Multi-driver Enable Register
	// Position of P0 field.
	PIO_MDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDER_P0_Msk = 0x1
	// Bit P0.
	PIO_MDER_P0 = 0x1
	// Position of P1 field.
	PIO_MDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDER_P1_Msk = 0x2
	// Bit P1.
	PIO_MDER_P1 = 0x2
	// Position of P2 field.
	PIO_MDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDER_P2_Msk = 0x4
	// Bit P2.
	PIO_MDER_P2 = 0x4
	// Position of P3 field.
	PIO_MDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDER_P3_Msk = 0x8
	// Bit P3.
	PIO_MDER_P3 = 0x8
	// Position of P4 field.
	PIO_MDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDER_P4_Msk = 0x10
	// Bit P4.
	PIO_MDER_P4 = 0x10
	// Position of P5 field.
	PIO_MDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDER_P5_Msk = 0x20
	// Bit P5.
	PIO_MDER_P5 = 0x20
	// Position of P6 field.
	PIO_MDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDER_P6_Msk = 0x40
	// Bit P6.
	PIO_MDER_P6 = 0x40
	// Position of P7 field.
	PIO_MDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDER_P7_Msk = 0x80
	// Bit P7.
	PIO_MDER_P7 = 0x80
	// Position of P8 field.
	PIO_MDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDER_P8_Msk = 0x100
	// Bit P8.
	PIO_MDER_P8 = 0x100
	// Position of P9 field.
	PIO_MDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDER_P9_Msk = 0x200
	// Bit P9.
	PIO_MDER_P9 = 0x200
	// Position of P10 field.
	PIO_MDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDER_P10_Msk = 0x400
	// Bit P10.
	PIO_MDER_P10 = 0x400
	// Position of P11 field.
	PIO_MDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDER_P11_Msk = 0x800
	// Bit P11.
	PIO_MDER_P11 = 0x800
	// Position of P12 field.
	PIO_MDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDER_P12 = 0x1000
	// Position of P13 field.
	PIO_MDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDER_P13 = 0x2000
	// Position of P14 field.
	PIO_MDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDER_P14 = 0x4000
	// Position of P15 field.
	PIO_MDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDER_P15 = 0x8000
	// Position of P16 field.
	PIO_MDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDER_P16 = 0x10000
	// Position of P17 field.
	PIO_MDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDER_P17 = 0x20000
	// Position of P18 field.
	PIO_MDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDER_P18 = 0x40000
	// Position of P19 field.
	PIO_MDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDER_P19 = 0x80000
	// Position of P20 field.
	PIO_MDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDER_P20 = 0x100000
	// Position of P21 field.
	PIO_MDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDER_P21 = 0x200000
	// Position of P22 field.
	PIO_MDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDER_P22 = 0x400000
	// Position of P23 field.
	PIO_MDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDER_P23 = 0x800000
	// Position of P24 field.
	PIO_MDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDER_P31 = 0x80000000

	// MDDR: Multi-driver Disable Register
	// Position of P0 field.
	PIO_MDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDDR_P0 = 0x1
	// Position of P1 field.
	PIO_MDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDDR_P1 = 0x2
	// Position of P2 field.
	PIO_MDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDDR_P2 = 0x4
	// Position of P3 field.
	PIO_MDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDDR_P3 = 0x8
	// Position of P4 field.
	PIO_MDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDDR_P4 = 0x10
	// Position of P5 field.
	PIO_MDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDDR_P5 = 0x20
	// Position of P6 field.
	PIO_MDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDDR_P6 = 0x40
	// Position of P7 field.
	PIO_MDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDDR_P7 = 0x80
	// Position of P8 field.
	PIO_MDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDDR_P8 = 0x100
	// Position of P9 field.
	PIO_MDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDDR_P9 = 0x200
	// Position of P10 field.
	PIO_MDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDDR_P10 = 0x400
	// Position of P11 field.
	PIO_MDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDDR_P11 = 0x800
	// Position of P12 field.
	PIO_MDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDDR_P31 = 0x80000000

	// MDSR: Multi-driver Status Register
	// Position of P0 field.
	PIO_MDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDSR_P0 = 0x1
	// Position of P1 field.
	PIO_MDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDSR_P1 = 0x2
	// Position of P2 field.
	PIO_MDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDSR_P2 = 0x4
	// Position of P3 field.
	PIO_MDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDSR_P3 = 0x8
	// Position of P4 field.
	PIO_MDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDSR_P4 = 0x10
	// Position of P5 field.
	PIO_MDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDSR_P5 = 0x20
	// Position of P6 field.
	PIO_MDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDSR_P6 = 0x40
	// Position of P7 field.
	PIO_MDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDSR_P7 = 0x80
	// Position of P8 field.
	PIO_MDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDSR_P8 = 0x100
	// Position of P9 field.
	PIO_MDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDSR_P9 = 0x200
	// Position of P10 field.
	PIO_MDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDSR_P10 = 0x400
	// Position of P11 field.
	PIO_MDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDSR_P11 = 0x800
	// Position of P12 field.
	PIO_MDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDSR_P31 = 0x80000000

	// PUDR: Pull-up Disable Register
	// Position of P0 field.
	PIO_PUDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUDR_P0 = 0x1
	// Position of P1 field.
	PIO_PUDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUDR_P1 = 0x2
	// Position of P2 field.
	PIO_PUDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUDR_P2 = 0x4
	// Position of P3 field.
	PIO_PUDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUDR_P3 = 0x8
	// Position of P4 field.
	PIO_PUDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUDR_P4 = 0x10
	// Position of P5 field.
	PIO_PUDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUDR_P5 = 0x20
	// Position of P6 field.
	PIO_PUDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUDR_P6 = 0x40
	// Position of P7 field.
	PIO_PUDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUDR_P7 = 0x80
	// Position of P8 field.
	PIO_PUDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUDR_P8 = 0x100
	// Position of P9 field.
	PIO_PUDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUDR_P9 = 0x200
	// Position of P10 field.
	PIO_PUDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUDR_P10 = 0x400
	// Position of P11 field.
	PIO_PUDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUDR_P11 = 0x800
	// Position of P12 field.
	PIO_PUDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUDR_P31 = 0x80000000

	// PUER: Pull-up Enable Register
	// Position of P0 field.
	PIO_PUER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUER_P0_Msk = 0x1
	// Bit P0.
	PIO_PUER_P0 = 0x1
	// Position of P1 field.
	PIO_PUER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUER_P1_Msk = 0x2
	// Bit P1.
	PIO_PUER_P1 = 0x2
	// Position of P2 field.
	PIO_PUER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUER_P2_Msk = 0x4
	// Bit P2.
	PIO_PUER_P2 = 0x4
	// Position of P3 field.
	PIO_PUER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUER_P3_Msk = 0x8
	// Bit P3.
	PIO_PUER_P3 = 0x8
	// Position of P4 field.
	PIO_PUER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUER_P4_Msk = 0x10
	// Bit P4.
	PIO_PUER_P4 = 0x10
	// Position of P5 field.
	PIO_PUER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUER_P5_Msk = 0x20
	// Bit P5.
	PIO_PUER_P5 = 0x20
	// Position of P6 field.
	PIO_PUER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUER_P6_Msk = 0x40
	// Bit P6.
	PIO_PUER_P6 = 0x40
	// Position of P7 field.
	PIO_PUER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUER_P7_Msk = 0x80
	// Bit P7.
	PIO_PUER_P7 = 0x80
	// Position of P8 field.
	PIO_PUER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUER_P8_Msk = 0x100
	// Bit P8.
	PIO_PUER_P8 = 0x100
	// Position of P9 field.
	PIO_PUER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUER_P9_Msk = 0x200
	// Bit P9.
	PIO_PUER_P9 = 0x200
	// Position of P10 field.
	PIO_PUER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUER_P10_Msk = 0x400
	// Bit P10.
	PIO_PUER_P10 = 0x400
	// Position of P11 field.
	PIO_PUER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUER_P11_Msk = 0x800
	// Bit P11.
	PIO_PUER_P11 = 0x800
	// Position of P12 field.
	PIO_PUER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUER_P12 = 0x1000
	// Position of P13 field.
	PIO_PUER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUER_P13 = 0x2000
	// Position of P14 field.
	PIO_PUER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUER_P14 = 0x4000
	// Position of P15 field.
	PIO_PUER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUER_P15 = 0x8000
	// Position of P16 field.
	PIO_PUER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUER_P16 = 0x10000
	// Position of P17 field.
	PIO_PUER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUER_P17 = 0x20000
	// Position of P18 field.
	PIO_PUER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUER_P18 = 0x40000
	// Position of P19 field.
	PIO_PUER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUER_P19 = 0x80000
	// Position of P20 field.
	PIO_PUER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUER_P20 = 0x100000
	// Position of P21 field.
	PIO_PUER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUER_P21 = 0x200000
	// Position of P22 field.
	PIO_PUER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUER_P22 = 0x400000
	// Position of P23 field.
	PIO_PUER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUER_P23 = 0x800000
	// Position of P24 field.
	PIO_PUER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUER_P31 = 0x80000000

	// PUSR: Pad Pull-up Status Register
	// Position of P0 field.
	PIO_PUSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUSR_P0 = 0x1
	// Position of P1 field.
	PIO_PUSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUSR_P1 = 0x2
	// Position of P2 field.
	PIO_PUSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUSR_P2 = 0x4
	// Position of P3 field.
	PIO_PUSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUSR_P3 = 0x8
	// Position of P4 field.
	PIO_PUSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUSR_P4 = 0x10
	// Position of P5 field.
	PIO_PUSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUSR_P5 = 0x20
	// Position of P6 field.
	PIO_PUSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUSR_P6 = 0x40
	// Position of P7 field.
	PIO_PUSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUSR_P7 = 0x80
	// Position of P8 field.
	PIO_PUSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUSR_P8 = 0x100
	// Position of P9 field.
	PIO_PUSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUSR_P9 = 0x200
	// Position of P10 field.
	PIO_PUSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUSR_P10 = 0x400
	// Position of P11 field.
	PIO_PUSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUSR_P11 = 0x800
	// Position of P12 field.
	PIO_PUSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUSR_P31 = 0x80000000

	// ASR: Peripheral A Select Register
	// Position of P0 field.
	PIO_ASR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ASR_P0_Msk = 0x1
	// Bit P0.
	PIO_ASR_P0 = 0x1
	// Position of P1 field.
	PIO_ASR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ASR_P1_Msk = 0x2
	// Bit P1.
	PIO_ASR_P1 = 0x2
	// Position of P2 field.
	PIO_ASR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ASR_P2_Msk = 0x4
	// Bit P2.
	PIO_ASR_P2 = 0x4
	// Position of P3 field.
	PIO_ASR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ASR_P3_Msk = 0x8
	// Bit P3.
	PIO_ASR_P3 = 0x8
	// Position of P4 field.
	PIO_ASR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ASR_P4_Msk = 0x10
	// Bit P4.
	PIO_ASR_P4 = 0x10
	// Position of P5 field.
	PIO_ASR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ASR_P5_Msk = 0x20
	// Bit P5.
	PIO_ASR_P5 = 0x20
	// Position of P6 field.
	PIO_ASR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ASR_P6_Msk = 0x40
	// Bit P6.
	PIO_ASR_P6 = 0x40
	// Position of P7 field.
	PIO_ASR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ASR_P7_Msk = 0x80
	// Bit P7.
	PIO_ASR_P7 = 0x80
	// Position of P8 field.
	PIO_ASR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ASR_P8_Msk = 0x100
	// Bit P8.
	PIO_ASR_P8 = 0x100
	// Position of P9 field.
	PIO_ASR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ASR_P9_Msk = 0x200
	// Bit P9.
	PIO_ASR_P9 = 0x200
	// Position of P10 field.
	PIO_ASR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ASR_P10_Msk = 0x400
	// Bit P10.
	PIO_ASR_P10 = 0x400
	// Position of P11 field.
	PIO_ASR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ASR_P11_Msk = 0x800
	// Bit P11.
	PIO_ASR_P11 = 0x800
	// Position of P12 field.
	PIO_ASR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ASR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ASR_P12 = 0x1000
	// Position of P13 field.
	PIO_ASR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ASR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ASR_P13 = 0x2000
	// Position of P14 field.
	PIO_ASR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ASR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ASR_P14 = 0x4000
	// Position of P15 field.
	PIO_ASR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ASR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ASR_P15 = 0x8000
	// Position of P16 field.
	PIO_ASR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ASR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ASR_P16 = 0x10000
	// Position of P17 field.
	PIO_ASR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ASR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ASR_P17 = 0x20000
	// Position of P18 field.
	PIO_ASR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ASR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ASR_P18 = 0x40000
	// Position of P19 field.
	PIO_ASR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ASR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ASR_P19 = 0x80000
	// Position of P20 field.
	PIO_ASR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ASR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ASR_P20 = 0x100000
	// Position of P21 field.
	PIO_ASR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ASR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ASR_P21 = 0x200000
	// Position of P22 field.
	PIO_ASR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ASR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ASR_P22 = 0x400000
	// Position of P23 field.
	PIO_ASR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ASR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ASR_P23 = 0x800000
	// Position of P24 field.
	PIO_ASR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ASR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ASR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ASR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ASR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ASR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ASR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ASR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ASR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ASR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ASR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ASR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ASR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ASR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ASR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ASR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ASR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ASR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ASR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ASR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ASR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ASR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ASR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ASR_P31 = 0x80000000

	// BSR: Peripheral B Select Register
	// Position of P0 field.
	PIO_BSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_BSR_P0_Msk = 0x1
	// Bit P0.
	PIO_BSR_P0 = 0x1
	// Position of P1 field.
	PIO_BSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_BSR_P1_Msk = 0x2
	// Bit P1.
	PIO_BSR_P1 = 0x2
	// Position of P2 field.
	PIO_BSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_BSR_P2_Msk = 0x4
	// Bit P2.
	PIO_BSR_P2 = 0x4
	// Position of P3 field.
	PIO_BSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_BSR_P3_Msk = 0x8
	// Bit P3.
	PIO_BSR_P3 = 0x8
	// Position of P4 field.
	PIO_BSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_BSR_P4_Msk = 0x10
	// Bit P4.
	PIO_BSR_P4 = 0x10
	// Position of P5 field.
	PIO_BSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_BSR_P5_Msk = 0x20
	// Bit P5.
	PIO_BSR_P5 = 0x20
	// Position of P6 field.
	PIO_BSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_BSR_P6_Msk = 0x40
	// Bit P6.
	PIO_BSR_P6 = 0x40
	// Position of P7 field.
	PIO_BSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_BSR_P7_Msk = 0x80
	// Bit P7.
	PIO_BSR_P7 = 0x80
	// Position of P8 field.
	PIO_BSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_BSR_P8_Msk = 0x100
	// Bit P8.
	PIO_BSR_P8 = 0x100
	// Position of P9 field.
	PIO_BSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_BSR_P9_Msk = 0x200
	// Bit P9.
	PIO_BSR_P9 = 0x200
	// Position of P10 field.
	PIO_BSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_BSR_P10_Msk = 0x400
	// Bit P10.
	PIO_BSR_P10 = 0x400
	// Position of P11 field.
	PIO_BSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_BSR_P11_Msk = 0x800
	// Bit P11.
	PIO_BSR_P11 = 0x800
	// Position of P12 field.
	PIO_BSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_BSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_BSR_P12 = 0x1000
	// Position of P13 field.
	PIO_BSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_BSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_BSR_P13 = 0x2000
	// Position of P14 field.
	PIO_BSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_BSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_BSR_P14 = 0x4000
	// Position of P15 field.
	PIO_BSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_BSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_BSR_P15 = 0x8000
	// Position of P16 field.
	PIO_BSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_BSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_BSR_P16 = 0x10000
	// Position of P17 field.
	PIO_BSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_BSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_BSR_P17 = 0x20000
	// Position of P18 field.
	PIO_BSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_BSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_BSR_P18 = 0x40000
	// Position of P19 field.
	PIO_BSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_BSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_BSR_P19 = 0x80000
	// Position of P20 field.
	PIO_BSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_BSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_BSR_P20 = 0x100000
	// Position of P21 field.
	PIO_BSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_BSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_BSR_P21 = 0x200000
	// Position of P22 field.
	PIO_BSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_BSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_BSR_P22 = 0x400000
	// Position of P23 field.
	PIO_BSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_BSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_BSR_P23 = 0x800000
	// Position of P24 field.
	PIO_BSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_BSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_BSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_BSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_BSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_BSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_BSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_BSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_BSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_BSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_BSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_BSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_BSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_BSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_BSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_BSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_BSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_BSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_BSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_BSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_BSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_BSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_BSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_BSR_P31 = 0x80000000

	// ABSR: AB Status Register
	// Position of P0 field.
	PIO_ABSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ABSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ABSR_P0 = 0x1
	// Position of P1 field.
	PIO_ABSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ABSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ABSR_P1 = 0x2
	// Position of P2 field.
	PIO_ABSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ABSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ABSR_P2 = 0x4
	// Position of P3 field.
	PIO_ABSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ABSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ABSR_P3 = 0x8
	// Position of P4 field.
	PIO_ABSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ABSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ABSR_P4 = 0x10
	// Position of P5 field.
	PIO_ABSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ABSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ABSR_P5 = 0x20
	// Position of P6 field.
	PIO_ABSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ABSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ABSR_P6 = 0x40
	// Position of P7 field.
	PIO_ABSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ABSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ABSR_P7 = 0x80
	// Position of P8 field.
	PIO_ABSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ABSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ABSR_P8 = 0x100
	// Position of P9 field.
	PIO_ABSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ABSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ABSR_P9 = 0x200
	// Position of P10 field.
	PIO_ABSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ABSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ABSR_P10 = 0x400
	// Position of P11 field.
	PIO_ABSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ABSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ABSR_P11 = 0x800
	// Position of P12 field.
	PIO_ABSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ABSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ABSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ABSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ABSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ABSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ABSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ABSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ABSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ABSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ABSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ABSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ABSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ABSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ABSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ABSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ABSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ABSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ABSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ABSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ABSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ABSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ABSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ABSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ABSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ABSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ABSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ABSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ABSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ABSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ABSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ABSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ABSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ABSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ABSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ABSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ABSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ABSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ABSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ABSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ABSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ABSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ABSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ABSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ABSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ABSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ABSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ABSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ABSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ABSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ABSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ABSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ABSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ABSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ABSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ABSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ABSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ABSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ABSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ABSR_P31 = 0x80000000

	// OWER: Output Write Enable
	// Position of P0 field.
	PIO_OWER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWER_P0_Msk = 0x1
	// Bit P0.
	PIO_OWER_P0 = 0x1
	// Position of P1 field.
	PIO_OWER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWER_P1_Msk = 0x2
	// Bit P1.
	PIO_OWER_P1 = 0x2
	// Position of P2 field.
	PIO_OWER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWER_P2_Msk = 0x4
	// Bit P2.
	PIO_OWER_P2 = 0x4
	// Position of P3 field.
	PIO_OWER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWER_P3_Msk = 0x8
	// Bit P3.
	PIO_OWER_P3 = 0x8
	// Position of P4 field.
	PIO_OWER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWER_P4_Msk = 0x10
	// Bit P4.
	PIO_OWER_P4 = 0x10
	// Position of P5 field.
	PIO_OWER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWER_P5_Msk = 0x20
	// Bit P5.
	PIO_OWER_P5 = 0x20
	// Position of P6 field.
	PIO_OWER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWER_P6_Msk = 0x40
	// Bit P6.
	PIO_OWER_P6 = 0x40
	// Position of P7 field.
	PIO_OWER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWER_P7_Msk = 0x80
	// Bit P7.
	PIO_OWER_P7 = 0x80
	// Position of P8 field.
	PIO_OWER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWER_P8_Msk = 0x100
	// Bit P8.
	PIO_OWER_P8 = 0x100
	// Position of P9 field.
	PIO_OWER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWER_P9_Msk = 0x200
	// Bit P9.
	PIO_OWER_P9 = 0x200
	// Position of P10 field.
	PIO_OWER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWER_P10_Msk = 0x400
	// Bit P10.
	PIO_OWER_P10 = 0x400
	// Position of P11 field.
	PIO_OWER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWER_P11_Msk = 0x800
	// Bit P11.
	PIO_OWER_P11 = 0x800
	// Position of P12 field.
	PIO_OWER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWER_P12 = 0x1000
	// Position of P13 field.
	PIO_OWER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWER_P13 = 0x2000
	// Position of P14 field.
	PIO_OWER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWER_P14 = 0x4000
	// Position of P15 field.
	PIO_OWER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWER_P15 = 0x8000
	// Position of P16 field.
	PIO_OWER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWER_P16 = 0x10000
	// Position of P17 field.
	PIO_OWER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWER_P17 = 0x20000
	// Position of P18 field.
	PIO_OWER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWER_P18 = 0x40000
	// Position of P19 field.
	PIO_OWER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWER_P19 = 0x80000
	// Position of P20 field.
	PIO_OWER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWER_P20 = 0x100000
	// Position of P21 field.
	PIO_OWER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWER_P21 = 0x200000
	// Position of P22 field.
	PIO_OWER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWER_P22 = 0x400000
	// Position of P23 field.
	PIO_OWER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWER_P23 = 0x800000
	// Position of P24 field.
	PIO_OWER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWER_P31 = 0x80000000

	// OWDR: Output Write Disable
	// Position of P0 field.
	PIO_OWDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWDR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWDR_P0 = 0x1
	// Position of P1 field.
	PIO_OWDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWDR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWDR_P1 = 0x2
	// Position of P2 field.
	PIO_OWDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWDR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWDR_P2 = 0x4
	// Position of P3 field.
	PIO_OWDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWDR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWDR_P3 = 0x8
	// Position of P4 field.
	PIO_OWDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWDR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWDR_P4 = 0x10
	// Position of P5 field.
	PIO_OWDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWDR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWDR_P5 = 0x20
	// Position of P6 field.
	PIO_OWDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWDR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWDR_P6 = 0x40
	// Position of P7 field.
	PIO_OWDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWDR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWDR_P7 = 0x80
	// Position of P8 field.
	PIO_OWDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWDR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWDR_P8 = 0x100
	// Position of P9 field.
	PIO_OWDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWDR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWDR_P9 = 0x200
	// Position of P10 field.
	PIO_OWDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWDR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWDR_P10 = 0x400
	// Position of P11 field.
	PIO_OWDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWDR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWDR_P11 = 0x800
	// Position of P12 field.
	PIO_OWDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWDR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWDR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWDR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWDR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWDR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWDR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWDR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWDR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWDR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWDR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWDR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWDR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWDR_P31 = 0x80000000

	// OWSR: Output Write Status Register
	// Position of P0 field.
	PIO_OWSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWSR_P0 = 0x1
	// Position of P1 field.
	PIO_OWSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWSR_P1 = 0x2
	// Position of P2 field.
	PIO_OWSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWSR_P2 = 0x4
	// Position of P3 field.
	PIO_OWSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWSR_P3 = 0x8
	// Position of P4 field.
	PIO_OWSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWSR_P4 = 0x10
	// Position of P5 field.
	PIO_OWSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWSR_P5 = 0x20
	// Position of P6 field.
	PIO_OWSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWSR_P6 = 0x40
	// Position of P7 field.
	PIO_OWSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWSR_P7 = 0x80
	// Position of P8 field.
	PIO_OWSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWSR_P8 = 0x100
	// Position of P9 field.
	PIO_OWSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWSR_P9 = 0x200
	// Position of P10 field.
	PIO_OWSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWSR_P10 = 0x400
	// Position of P11 field.
	PIO_OWSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWSR_P11 = 0x800
	// Position of P12 field.
	PIO_OWSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWSR_P31 = 0x80000000
)

// Constants for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	// Position of UHP field.
	PMC_PMC_SCER_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCER_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCER_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCER_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCER_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCER_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCER_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCER_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCER_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCER_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCER_PCK2 = 0x400
	// Position of PCK3 field.
	PMC_PMC_SCER_PCK3_Pos = 0xb
	// Bit mask of PCK3 field.
	PMC_PMC_SCER_PCK3_Msk = 0x800
	// Bit PCK3.
	PMC_PMC_SCER_PCK3 = 0x800
	// Position of HCK0 field.
	PMC_PMC_SCER_HCK0_Pos = 0x10
	// Bit mask of HCK0 field.
	PMC_PMC_SCER_HCK0_Msk = 0x10000
	// Bit HCK0.
	PMC_PMC_SCER_HCK0 = 0x10000
	// Position of HCK1 field.
	PMC_PMC_SCER_HCK1_Pos = 0x11
	// Bit mask of HCK1 field.
	PMC_PMC_SCER_HCK1_Msk = 0x20000
	// Bit HCK1.
	PMC_PMC_SCER_HCK1 = 0x20000

	// PMC_SCDR: System Clock Disable Register
	// Position of PCK field.
	PMC_PMC_SCDR_PCK_Pos = 0x0
	// Bit mask of PCK field.
	PMC_PMC_SCDR_PCK_Msk = 0x1
	// Bit PCK.
	PMC_PMC_SCDR_PCK = 0x1
	// Position of UHP field.
	PMC_PMC_SCDR_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCDR_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCDR_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCDR_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCDR_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCDR_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCDR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCDR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCDR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCDR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCDR_PCK2 = 0x400
	// Position of PCK3 field.
	PMC_PMC_SCDR_PCK3_Pos = 0xb
	// Bit mask of PCK3 field.
	PMC_PMC_SCDR_PCK3_Msk = 0x800
	// Bit PCK3.
	PMC_PMC_SCDR_PCK3 = 0x800
	// Position of HCK0 field.
	PMC_PMC_SCDR_HCK0_Pos = 0x10
	// Bit mask of HCK0 field.
	PMC_PMC_SCDR_HCK0_Msk = 0x10000
	// Bit HCK0.
	PMC_PMC_SCDR_HCK0 = 0x10000
	// Position of HCK1 field.
	PMC_PMC_SCDR_HCK1_Pos = 0x11
	// Bit mask of HCK1 field.
	PMC_PMC_SCDR_HCK1_Msk = 0x20000
	// Bit HCK1.
	PMC_PMC_SCDR_HCK1 = 0x20000

	// PMC_SCSR: System Clock Status Register
	// Position of PCK field.
	PMC_PMC_SCSR_PCK_Pos = 0x0
	// Bit mask of PCK field.
	PMC_PMC_SCSR_PCK_Msk = 0x1
	// Bit PCK.
	PMC_PMC_SCSR_PCK = 0x1
	// Position of UHP field.
	PMC_PMC_SCSR_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCSR_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCSR_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCSR_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCSR_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCSR_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCSR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCSR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCSR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCSR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCSR_PCK2 = 0x400
	// Position of PCK3 field.
	PMC_PMC_SCSR_PCK3_Pos = 0xb
	// Bit mask of PCK3 field.
	PMC_PMC_SCSR_PCK3_Msk = 0x800
	// Bit PCK3.
	PMC_PMC_SCSR_PCK3 = 0x800
	// Position of HCK0 field.
	PMC_PMC_SCSR_HCK0_Pos = 0x10
	// Bit mask of HCK0 field.
	PMC_PMC_SCSR_HCK0_Msk = 0x10000
	// Bit HCK0.
	PMC_PMC_SCSR_HCK0 = 0x10000
	// Position of HCK1 field.
	PMC_PMC_SCSR_HCK1_Pos = 0x11
	// Bit mask of HCK1 field.
	PMC_PMC_SCSR_HCK1_Msk = 0x20000
	// Bit HCK1.
	PMC_PMC_SCSR_HCK1 = 0x20000

	// PMC_PCER: Peripheral Clock Enable Register
	// Position of PID2 field.
	PMC_PMC_PCER_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCER_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCER_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCER_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCER_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCER_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCER_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCER_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCER_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCER_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCER_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCER_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCER_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCER_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCER_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCER_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCER_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCER_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCER_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCER_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCER_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCER_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCER_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCER_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCER_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCER_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCER_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCER_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCER_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCER_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCER_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCER_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCER_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCER_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCER_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCER_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCER_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCER_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCER_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCER_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCER_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCER_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCER_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCER_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCER_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCER_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCER_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCER_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCER_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCER_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCER_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCER_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCER_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCER_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCER_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCER_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCER_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCER_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCER_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCER_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCER_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCER_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCER_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCER_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCER_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCER_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCER_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCER_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCER_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCER_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCER_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCER_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCER_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCER_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCER_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCER_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCER_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCER_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCER_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCER_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCER_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCER_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCER_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCER_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCER_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCER_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCER_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCER_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCER_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCER_PID31 = 0x80000000

	// PMC_PCDR: Peripheral Clock Disable Register
	// Position of PID2 field.
	PMC_PMC_PCDR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCDR_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCDR_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCDR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCDR_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCDR_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCDR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCDR_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCDR_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCDR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCDR_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCDR_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCDR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCDR_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCDR_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCDR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCDR_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCDR_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCDR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCDR_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCDR_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCDR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCDR_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCDR_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCDR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCDR_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCDR_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCDR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCDR_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCDR_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCDR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCDR_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCDR_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCDR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCDR_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCDR_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCDR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCDR_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCDR_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCDR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCDR_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCDR_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCDR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCDR_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCDR_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCDR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCDR_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCDR_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCDR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCDR_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCDR_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCDR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCDR_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCDR_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCDR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCDR_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCDR_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCDR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCDR_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCDR_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCDR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCDR_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCDR_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCDR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCDR_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCDR_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCDR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCDR_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCDR_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCDR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCDR_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCDR_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCDR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCDR_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCDR_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCDR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCDR_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCDR_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCDR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCDR_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCDR_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCDR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCDR_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCDR_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCDR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCDR_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCDR_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCDR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCDR_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCDR_PID31 = 0x80000000

	// PMC_PCSR: Peripheral Clock Status Register
	// Position of PID2 field.
	PMC_PMC_PCSR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCSR_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCSR_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCSR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCSR_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCSR_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCSR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCSR_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCSR_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCSR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCSR_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCSR_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCSR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCSR_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCSR_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCSR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCSR_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCSR_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCSR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCSR_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCSR_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCSR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCSR_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCSR_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCSR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCSR_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCSR_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCSR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCSR_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCSR_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCSR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCSR_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCSR_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCSR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCSR_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCSR_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCSR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCSR_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCSR_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCSR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCSR_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCSR_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCSR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCSR_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCSR_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCSR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCSR_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCSR_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCSR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCSR_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCSR_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCSR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCSR_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCSR_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCSR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCSR_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCSR_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCSR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCSR_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCSR_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCSR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCSR_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCSR_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCSR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCSR_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCSR_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCSR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCSR_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCSR_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCSR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCSR_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCSR_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCSR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCSR_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCSR_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCSR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCSR_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCSR_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCSR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCSR_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCSR_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCSR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCSR_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCSR_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCSR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCSR_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCSR_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCSR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCSR_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCSR_PID31 = 0x80000000

	// CKGR_MOR: Main Oscillator Register
	// Position of MOSCEN field.
	PMC_CKGR_MOR_MOSCEN_Pos = 0x0
	// Bit mask of MOSCEN field.
	PMC_CKGR_MOR_MOSCEN_Msk = 0x1
	// Bit MOSCEN.
	PMC_CKGR_MOR_MOSCEN = 0x1
	// Position of OSCBYPASS field.
	PMC_CKGR_MOR_OSCBYPASS_Pos = 0x1
	// Bit mask of OSCBYPASS field.
	PMC_CKGR_MOR_OSCBYPASS_Msk = 0x2
	// Bit OSCBYPASS.
	PMC_CKGR_MOR_OSCBYPASS = 0x2
	// Position of OSCOUNT field.
	PMC_CKGR_MOR_OSCOUNT_Pos = 0x8
	// Bit mask of OSCOUNT field.
	PMC_CKGR_MOR_OSCOUNT_Msk = 0xff00

	// CKGR_MCFR: Main Clock Frequency Register
	// Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Pos = 0x0
	// Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk = 0xffff
	// Position of MAINRDY field.
	PMC_CKGR_MCFR_MAINRDY_Pos = 0x10
	// Bit mask of MAINRDY field.
	PMC_CKGR_MCFR_MAINRDY_Msk = 0x10000
	// Bit MAINRDY.
	PMC_CKGR_MCFR_MAINRDY = 0x10000

	// CKGR_PLLAR: PLL A Register
	// Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk = 0xff
	// Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8
	// Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00
	// Position of OUTA field.
	PMC_CKGR_PLLAR_OUTA_Pos = 0xe
	// Bit mask of OUTA field.
	PMC_CKGR_PLLAR_OUTA_Msk = 0xc000
	// Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Pos = 0x10
	// Bit mask of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk = 0x7ff0000
	// Position of STUCKTO1 field.
	PMC_CKGR_PLLAR_STUCKTO1_Pos = 0x1d
	// Bit mask of STUCKTO1 field.
	PMC_CKGR_PLLAR_STUCKTO1_Msk = 0x20000000
	// Bit STUCKTO1.
	PMC_CKGR_PLLAR_STUCKTO1 = 0x20000000

	// CKGR_PLLBR: PLL B Register
	// Position of DIVB field.
	PMC_CKGR_PLLBR_DIVB_Pos = 0x0
	// Bit mask of DIVB field.
	PMC_CKGR_PLLBR_DIVB_Msk = 0xff
	// Position of PLLBCOUNT field.
	PMC_CKGR_PLLBR_PLLBCOUNT_Pos = 0x8
	// Bit mask of PLLBCOUNT field.
	PMC_CKGR_PLLBR_PLLBCOUNT_Msk = 0x3f00
	// Position of OUTB field.
	PMC_CKGR_PLLBR_OUTB_Pos = 0xe
	// Bit mask of OUTB field.
	PMC_CKGR_PLLBR_OUTB_Msk = 0xc000
	// Position of MULB field.
	PMC_CKGR_PLLBR_MULB_Pos = 0x10
	// Bit mask of MULB field.
	PMC_CKGR_PLLBR_MULB_Msk = 0x7ff0000
	// Position of USBDIV field.
	PMC_CKGR_PLLBR_USBDIV_Pos = 0x1c
	// Bit mask of USBDIV field.
	PMC_CKGR_PLLBR_USBDIV_Msk = 0x30000000

	// PMC_MCKR: Master Clock Register
	// Position of CSS field.
	PMC_PMC_MCKR_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_MCKR_CSS_Msk = 0x3
	// Position of PRES field.
	PMC_PMC_MCKR_PRES_Pos = 0x2
	// Bit mask of PRES field.
	PMC_PMC_MCKR_PRES_Msk = 0x1c
	// Position of MDIV field.
	PMC_PMC_MCKR_MDIV_Pos = 0x8
	// Bit mask of MDIV field.
	PMC_PMC_MCKR_MDIV_Msk = 0x300

	// PMC_PCK: Programmable Clock 0 Register
	// Position of CSS field.
	PMC_PMC_PCK_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_PCK_CSS_Msk = 0x3
	// Position of PRES field.
	PMC_PMC_PCK_PRES_Pos = 0x2
	// Bit mask of PRES field.
	PMC_PMC_PCK_PRES_Msk = 0x1c

	// PMC_IER: Interrupt Enable Register
	// Position of MOSCS field.
	PMC_PMC_IER_MOSCS_Pos = 0x0
	// Bit mask of MOSCS field.
	PMC_PMC_IER_MOSCS_Msk = 0x1
	// Bit MOSCS.
	PMC_PMC_IER_MOSCS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IER_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IER_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IER_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IER_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IER_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IER_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IER_PCKRDY2 = 0x400
	// Position of PCKRDY3 field.
	PMC_PMC_IER_PCKRDY3_Pos = 0xb
	// Bit mask of PCKRDY3 field.
	PMC_PMC_IER_PCKRDY3_Msk = 0x800
	// Bit PCKRDY3.
	PMC_PMC_IER_PCKRDY3 = 0x800

	// PMC_IDR: Interrupt Disable Register
	// Position of MOSCS field.
	PMC_PMC_IDR_MOSCS_Pos = 0x0
	// Bit mask of MOSCS field.
	PMC_PMC_IDR_MOSCS_Msk = 0x1
	// Bit MOSCS.
	PMC_PMC_IDR_MOSCS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IDR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IDR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IDR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IDR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IDR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IDR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IDR_PCKRDY2 = 0x400
	// Position of PCKRDY3 field.
	PMC_PMC_IDR_PCKRDY3_Pos = 0xb
	// Bit mask of PCKRDY3 field.
	PMC_PMC_IDR_PCKRDY3_Msk = 0x800
	// Bit PCKRDY3.
	PMC_PMC_IDR_PCKRDY3 = 0x800

	// PMC_SR: Status Register
	// Position of MOSCS field.
	PMC_PMC_SR_MOSCS_Pos = 0x0
	// Bit mask of MOSCS field.
	PMC_PMC_SR_MOSCS_Msk = 0x1
	// Bit MOSCS.
	PMC_PMC_SR_MOSCS = 0x1
	// Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_SR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_SR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_SR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_SR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_SR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_SR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_SR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_SR_PCKRDY2 = 0x400
	// Position of PCKRDY3 field.
	PMC_PMC_SR_PCKRDY3_Pos = 0xb
	// Bit mask of PCKRDY3 field.
	PMC_PMC_SR_PCKRDY3_Msk = 0x800
	// Bit PCKRDY3.
	PMC_PMC_SR_PCKRDY3 = 0x800

	// PMC_IMR: Interrupt Mask Register
	// Position of MOSCS field.
	PMC_PMC_IMR_MOSCS_Pos = 0x0
	// Bit mask of MOSCS field.
	PMC_PMC_IMR_MOSCS_Msk = 0x1
	// Bit MOSCS.
	PMC_PMC_IMR_MOSCS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IMR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IMR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IMR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IMR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IMR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IMR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IMR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IMR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IMR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IMR_PCKRDY2 = 0x400
	// Position of PCKRDY3 field.
	PMC_PMC_IMR_PCKRDY3_Pos = 0xb
	// Bit mask of PCKRDY3 field.
	PMC_PMC_IMR_PCKRDY3_Msk = 0x800
	// Bit PCKRDY3.
	PMC_PMC_IMR_PCKRDY3 = 0x800

	// PMC_PLLICPR: Charge Pump Current Register
	// Position of ICPPLLA field.
	PMC_PMC_PLLICPR_ICPPLLA_Pos = 0x0
	// Bit mask of ICPPLLA field.
	PMC_PMC_PLLICPR_ICPPLLA_Msk = 0x1
	// Bit ICPPLLA.
	PMC_PMC_PLLICPR_ICPPLLA = 0x1
	// Position of ICPPLLB field.
	PMC_PMC_PLLICPR_ICPPLLB_Pos = 0x10
	// Bit mask of ICPPLLB field.
	PMC_PMC_PLLICPR_ICPPLLB_Msk = 0x10000
	// Bit ICPPLLB.
	PMC_PMC_PLLICPR_ICPPLLB = 0x10000
)

// Constants for RSTC: Reset Controller
const (
	// CR: Control Register
	// Position of PROCRST field.
	SYSC_CR_PROCRST_Pos = 0x0
	// Bit mask of PROCRST field.
	SYSC_CR_PROCRST_Msk = 0x1
	// Bit PROCRST.
	SYSC_CR_PROCRST = 0x1
	// Position of PERRST field.
	SYSC_CR_PERRST_Pos = 0x2
	// Bit mask of PERRST field.
	SYSC_CR_PERRST_Msk = 0x4
	// Bit PERRST.
	SYSC_CR_PERRST = 0x4
	// Position of EXTRST field.
	SYSC_CR_EXTRST_Pos = 0x3
	// Bit mask of EXTRST field.
	SYSC_CR_EXTRST_Msk = 0x8
	// Bit EXTRST.
	SYSC_CR_EXTRST = 0x8
	// Position of KEY field.
	SYSC_CR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_CR_KEY_Msk = 0xff000000

	// SR: Status Register
	// Position of URSTS field.
	SYSC_SR_URSTS_Pos = 0x0
	// Bit mask of URSTS field.
	SYSC_SR_URSTS_Msk = 0x1
	// Bit URSTS.
	SYSC_SR_URSTS = 0x1
	// Position of RSTTYP field.
	SYSC_SR_RSTTYP_Pos = 0x8
	// Bit mask of RSTTYP field.
	SYSC_SR_RSTTYP_Msk = 0x700
	// Position of NRSTL field.
	SYSC_SR_NRSTL_Pos = 0x10
	// Bit mask of NRSTL field.
	SYSC_SR_NRSTL_Msk = 0x10000
	// Bit NRSTL.
	SYSC_SR_NRSTL = 0x10000
	// Position of SRCMP field.
	SYSC_SR_SRCMP_Pos = 0x11
	// Bit mask of SRCMP field.
	SYSC_SR_SRCMP_Msk = 0x20000
	// Bit SRCMP.
	SYSC_SR_SRCMP = 0x20000

	// MR: Mode Register
	// Position of URSTEN field.
	SYSC_MR_URSTEN_Pos = 0x0
	// Bit mask of URSTEN field.
	SYSC_MR_URSTEN_Msk = 0x1
	// Bit URSTEN.
	SYSC_MR_URSTEN = 0x1
	// Position of URSTIEN field.
	SYSC_MR_URSTIEN_Pos = 0x4
	// Bit mask of URSTIEN field.
	SYSC_MR_URSTIEN_Msk = 0x10
	// Bit URSTIEN.
	SYSC_MR_URSTIEN = 0x10
	// Position of ERSTL field.
	SYSC_MR_ERSTL_Pos = 0x8
	// Bit mask of ERSTL field.
	SYSC_MR_ERSTL_Msk = 0xf00
	// Position of KEY field.
	SYSC_MR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_MR_KEY_Msk = 0xff000000
)
