/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.apache.commons.httpclient.URI;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.FileCopier;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.control.ZapRelease;
import org.zaproxy.zap.extension.autoupdate.AddOnDependencyChecker;
import org.zaproxy.zap.extension.autoupdate.AutoUpdateAPI;
import org.zaproxy.zap.extension.autoupdate.CheckForUpdateCallback;
import org.zaproxy.zap.extension.autoupdate.DownloadManager;
import org.zaproxy.zap.extension.autoupdate.Downloader;
import org.zaproxy.zap.extension.autoupdate.InvalidCfuUrlException;
import org.zaproxy.zap.extension.autoupdate.ManageAddOnsDialog;
import org.zaproxy.zap.extension.autoupdate.OptionsParamCheckForUpdates;
import org.zaproxy.zap.extension.autoupdate.UninstallationProgressDialogue;
import org.zaproxy.zap.utils.ZapXmlConfiguration;
import org.zaproxy.zap.view.ScanStatus;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionAutoUpdate
extends ExtensionAdaptor
implements CheckForUpdateCallback,
CommandLineListener {
    private static final String NAME = "ExtensionAutoUpdate";
    private static final String ZAP_VERSIONS_REL_XML_DESKTOP_SHORT = "https://bit.ly/owaspzap-2-10-0";
    private static final String ZAP_VERSIONS_REL_XML_DAEMON_SHORT = "https://bit.ly/owaspzap-2-10-0d";
    private static final String ZAP_VERSIONS_REL_XML_FULL = "https://raw.githubusercontent.com/zaproxy/zap-admin/master/ZapVersions-2.10.xml";
    private static final String ZAP_VERSIONS_DEV_XML_SHORT = "https://bit.ly/owaspzap-dev";
    private static final String ZAP_VERSIONS_DEV_XML_FULL = "https://raw.githubusercontent.com/zaproxy/zap-admin/master/ZapVersions-dev.xml";
    private static final String ZAP_VERSIONS_WEEKLY_XML_SHORT = "https://bit.ly/owaspzap-devw";
    private static final String VERSION_FILE_NAME = "ZapVersions.xml";
    private ZapMenuItem menuItemCheckUpdate = null;
    private ZapMenuItem menuItemLoadAddOn = null;
    private static final Logger logger = LogManager.getLogger(ExtensionAutoUpdate.class);
    private HttpSender httpSender = null;
    private DownloadManager downloadManager = null;
    private ManageAddOnsDialog addonsDialog = null;
    private Thread downloadProgressThread = null;
    private Thread remoteCallThread = null;
    private ScanStatus scanStatus = null;
    private JButton addonsButton = null;
    private JButton checkForUpdatesButton = null;
    private JButton outOfDateButton = null;
    private AddOnCollection latestVersionInfo = null;
    private AddOnCollection localVersionInfo = null;
    private AddOnCollection previousVersionInfo = null;
    private AutoUpdateAPI api = null;
    private boolean oldZapAlertAdded = false;
    private boolean noCfuAlertAdded = false;
    private boolean installsOk = true;
    private boolean installsCompleted = true;
    private List<Downloader> downloadFiles = new ArrayList<Downloader>();
    private static final int ARG_CFU_INSTALL_IDX = 0;
    private static final int ARG_CFU_INSTALL_ALL_IDX = 1;
    private static final int ARG_CFU_UNINSTALL_IDX = 2;
    private static final int ARG_CFU_UPDATE_IDX = 3;
    private static final int ARG_CFU_LIST_IDX = 4;
    private static final int[] ARG_IDXS = new int[]{0, 1, 2, 3, 4};
    private CommandLineArgument[] arguments = new CommandLineArgument[ARG_IDXS.length];

    public ExtensionAutoUpdate() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(1);
        this.downloadManager = new DownloadManager(Model.getSingleton().getOptionsParam().getConnectionParam());
        this.downloadManager.start();
        this.getPreviousVersionInfo();
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("autoupdate.name");
    }

    @Override
    public void postInit() {
        switch (ZAP.getProcessType()) {
            case cmdline: 
            case daemon: 
            case zaas: {
                this.warnIfOutOfDate();
                break;
            }
        }
    }

    private ZapMenuItem getMenuItemCheckUpdate() {
        if (this.menuItemCheckUpdate == null) {
            this.menuItemCheckUpdate = new ZapMenuItem("cfu.help.menu.check", this.getView().getMenuShortcutKeyStroke(85, 0, false));
            this.menuItemCheckUpdate.setText(Constant.messages.getString("cfu.help.menu.check"));
            this.menuItemCheckUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionAutoUpdate.this.checkForUpdates(false);
                }
            });
        }
        return this.menuItemCheckUpdate;
    }

    private ZapMenuItem getMenuItemLoadAddOn() {
        if (this.menuItemLoadAddOn == null) {
            this.menuItemLoadAddOn = new ZapMenuItem("cfu.file.menu.loadaddon", this.getView().getMenuShortcutKeyStroke(76, 0, false));
            this.menuItemLoadAddOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        JFileChooser chooser = new JFileChooser(Model.getSingleton().getOptionsParam().getUserDirectory());
                        File file = null;
                        chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                return file.isFile() && AddOn.isAddOnFileName(file.getName());
                            }

                            @Override
                            public String getDescription() {
                                return Constant.messages.getString("file.format.zap.addon");
                            }
                        });
                        int rc = chooser.showOpenDialog(ExtensionAutoUpdate.this.getView().getMainFrame());
                        if (rc == 0) {
                            file = chooser.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            ExtensionAutoUpdate.this.installLocalAddOn(file.toPath());
                        }
                    }
                    catch (Exception e1) {
                        logger.error(e1.getMessage(), (Throwable)e1);
                    }
                }
            });
        }
        return this.menuItemLoadAddOn;
    }

    boolean installLocalAddOnQuietly(Path file) {
        File addOnFile;
        AddOn ao;
        try {
            ao = new AddOn(file);
        }
        catch (IOException e) {
            logger.warn("Failed to create the add-on: " + e.getMessage(), (Throwable)e);
            return false;
        }
        if (!ao.canLoadInCurrentVersion()) {
            logger.warn("Can not install the add-on, incompatible ZAP version.");
            return false;
        }
        AddOn installedAddOn = this.getLocalVersionInfo().getAddOn(ao.getId());
        if (installedAddOn != null) {
            try {
                if (Files.isSameFile(installedAddOn.getFile().toPath(), ao.getFile().toPath())) {
                    logger.warn("Can not install the add-on, same file already installed.");
                    return false;
                }
            }
            catch (IOException e) {
                logger.warn("An error occurred while checking the add-ons' files: " + e.getMessage(), (Throwable)e);
                return false;
            }
            if (!this.uninstallAddOn(null, installedAddOn, true)) {
                return false;
            }
        }
        try {
            addOnFile = ExtensionAutoUpdate.copyAddOnFileToLocalPluginFolder(ao);
        }
        catch (FileAlreadyExistsException e) {
            logger.warn("Unable to copy add-on, a file with the same name already exists.", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.warn("Unable to copy add-on to local plugin folder.", (Throwable)e);
            return false;
        }
        ao.setFile(addOnFile);
        return this.install(ao);
    }

    private void installLocalAddOn(Path file) throws Exception {
        AddOnDependencyChecker.AddOnChangesResult result;
        AddOn ao;
        try {
            ao = new AddOn(file);
        }
        catch (AddOn.InvalidAddOnException e) {
            AddOn.ValidationResult result2 = e.getValidationResult();
            switch (result2.getValidity()) {
                case INVALID_PATH: {
                    this.showWarningMessageInvalidAddOnFile(Constant.messages.getString("cfu.warn.invalidAddOn.invalidPath"));
                    break;
                }
                case INVALID_FILE_NAME: {
                    this.showWarningMessageInvalidAddOnFile(Constant.messages.getString("cfu.warn.invalidAddOn.noZapExtension"));
                    break;
                }
                case FILE_NOT_READABLE: {
                    this.showWarningMessageInvalidAddOnFile(Constant.messages.getString("cfu.warn.invalidAddOn.notReadable"));
                    break;
                }
                case UNREADABLE_ZIP_FILE: {
                    this.showWarningMessageInvalidAddOnFile(Constant.messages.getString("cfu.warn.invalidAddOn.errorZip", e.getMessage()));
                    break;
                }
                case IO_ERROR_FILE: {
                    this.showWarningMessageInvalidAddOnFile(Constant.messages.getString("cfu.warn.invalidAddOn.ioError", e.getMessage()));
                    break;
                }
                case MISSING_MANIFEST: {
                    this.showWarningMessageInvalidAddOnFile(Constant.messages.getString("cfu.warn.invalidAddOn.missingManifest"));
                    break;
                }
                case INVALID_MANIFEST: {
                    this.showWarningMessageInvalidAddOnFile(Constant.messages.getString("cfu.warn.invalidAddOn.invalidManifest", e.getMessage()));
                    break;
                }
                case INVALID_LIB: {
                    this.showWarningMessageInvalidAddOnFile(Constant.messages.getString("cfu.warn.invalidAddOn.invalidLib"));
                    break;
                }
                default: {
                    this.showWarningMessageInvalidAddOnFile(e.getMessage());
                    logger.warn((Object)e);
                }
            }
            return;
        }
        if (!ao.canLoadInCurrentVersion()) {
            this.showWarningMessageCantLoadAddOn(ao);
            return;
        }
        AddOnDependencyChecker dependencyChecker = new AddOnDependencyChecker(this.getLocalVersionInfo(), this.latestVersionInfo == null ? this.getLocalVersionInfo() : this.latestVersionInfo);
        boolean update = false;
        boolean uninstallBeforeAddOnCopy = false;
        AddOn installedAddOn = this.getLocalVersionInfo().getAddOn(ao.getId());
        if (installedAddOn != null) {
            if (ao.getVersion().equals(installedAddOn.getVersion())) {
                int reinstall = View.getSingleton().showYesNoDialog(this.getView().getMainFrame(), new Object[]{Constant.messages.getString("cfu.warn.addOnSameVersion", installedAddOn.getVersion(), View.getSingleton().getStatusUI(installedAddOn.getStatus()).toString(), ao.getVersion(), View.getSingleton().getStatusUI(ao.getStatus()).toString())});
                if (reinstall != 0) {
                    return;
                }
                uninstallBeforeAddOnCopy = true;
            } else if (!ao.isUpdateTo(installedAddOn)) {
                this.getView().showWarningDialog(Constant.messages.getString("cfu.warn.addOnOlderVersion", installedAddOn.getVersion(), View.getSingleton().getStatusUI(installedAddOn.getStatus()).toString(), ao.getVersion(), View.getSingleton().getStatusUI(ao.getStatus()).toString()));
                return;
            }
            result = dependencyChecker.calculateUpdateChanges(ao);
            update = true;
        } else {
            result = dependencyChecker.calculateInstallChanges(ao);
        }
        if (result.getOldVersions().isEmpty() && result.getUninstalls().isEmpty()) {
            AddOn.AddOnRunRequirements reqs = ao.calculateInstallRequirements(this.getLocalVersionInfo().getAddOns());
            if (!reqs.isRunnable() && !AddOnRunIssuesUtils.askConfirmationAddOnNotRunnable(Constant.messages.getString("cfu.warn.addOnNotRunnable.message"), Constant.messages.getString("cfu.warn.addOnNotRunnable.question"), this.getLocalVersionInfo(), ao)) {
                return;
            }
            this.installLocalAddOn(ao, uninstallBeforeAddOnCopy);
            return;
        }
        if (update) {
            if (!dependencyChecker.confirmUpdateChanges(this.getView().getMainFrame(), result)) {
                return;
            }
            result.getNewVersions().remove(ao);
        } else {
            if (!dependencyChecker.confirmInstallChanges(this.getView().getMainFrame(), result)) {
                return;
            }
            result.getInstalls().remove(ao);
        }
        this.processAddOnChanges(this.getView().getMainFrame(), result);
        this.installLocalAddOn(ao, uninstallBeforeAddOnCopy);
    }

    private void installLocalAddOn(AddOn ao, boolean uninstallBeforeAddOnCopy) {
        File addOnFile;
        if (uninstallBeforeAddOnCopy && !this.uninstallAddOn(null, this.getLocalVersionInfo().getAddOn(ao.getId()), true)) {
            return;
        }
        try {
            addOnFile = ExtensionAutoUpdate.copyAddOnFileToLocalPluginFolder(ao);
        }
        catch (FileAlreadyExistsException e) {
            ExtensionAutoUpdate.showWarningMessageAddOnFileAlreadyExists(e.getFile(), e.getOtherFile());
            logger.warn("Unable to copy add-on, a file with the same name already exists.", (Throwable)e);
            return;
        }
        catch (IOException e) {
            ExtensionAutoUpdate.showWarningMessageUnableToCopyAddOnFile();
            logger.warn("Unable to copy add-on to local plugin folder.", (Throwable)e);
            return;
        }
        ao.setFile(addOnFile);
        this.install(ao);
    }

    private void showWarningMessageInvalidAddOnFile(String reason) {
        this.getView().showWarningDialog(Constant.messages.getString("cfu.warn.invalidAddOn", reason));
    }

    private void showWarningMessageCantLoadAddOn(AddOn ao) {
        String message = Constant.messages.getString("cfu.warn.cantload", ao.getNotBeforeVersion(), ao.getNotFromVersion());
        this.getView().showWarningDialog(message);
    }

    private static File copyAddOnFileToLocalPluginFolder(AddOn addOn) throws IOException {
        if (ExtensionAutoUpdate.isFileInLocalPluginFolder(addOn.getFile())) {
            return addOn.getFile();
        }
        File targetFile = new File(Constant.FOLDER_LOCAL_PLUGIN, addOn.getNormalisedFileName());
        if (targetFile.exists()) {
            throw new FileAlreadyExistsException(addOn.getFile().getAbsolutePath(), targetFile.getAbsolutePath(), "");
        }
        FileCopier fileCopier = new FileCopier();
        fileCopier.copy(addOn.getFile(), targetFile);
        return targetFile;
    }

    private static boolean isFileInLocalPluginFolder(File file) {
        File fileLocalPluginFolder = new File(Constant.FOLDER_LOCAL_PLUGIN, file.getName());
        return fileLocalPluginFolder.getAbsolutePath().equals(file.getAbsolutePath());
    }

    private static void showWarningMessageAddOnFileAlreadyExists(String file, String targetFile) {
        String message = Constant.messages.getString("cfu.warn.addOnAlreadyExists", file, targetFile);
        View.getSingleton().showWarningDialog(message);
    }

    private static void showWarningMessageUnableToCopyAddOnFile() {
        String pathPluginFolder = new File(Constant.FOLDER_LOCAL_PLUGIN).getAbsolutePath();
        String message = Constant.messages.getString("cfu.warn.unableToCopyAddOn", pathPluginFolder);
        View.getSingleton().showWarningDialog(message);
    }

    private synchronized ManageAddOnsDialog getAddOnsDialog() {
        if (this.addonsDialog == null) {
            this.addonsDialog = new ManageAddOnsDialog(this, this.getCurrentVersion(), this.getLocalVersionInfo());
            if (this.previousVersionInfo != null) {
                this.addonsDialog.setPreviousVersionInfo(this.previousVersionInfo);
            }
            if (this.latestVersionInfo != null) {
                this.addonsDialog.setLatestVersionInfo(this.latestVersionInfo);
            }
        }
        return this.addonsDialog;
    }

    private void downloadFile(URL url, File targetFile, long size, String hash) {
        if (this.hasView()) {
            this.getView().getOutputPanel().append(Constant.messages.getString("cfu.output.downloading", url.toString(), targetFile.getAbsolutePath()) + "\n");
        }
        this.downloadFiles.add(this.downloadManager.downloadFile(url, targetFile, size, hash));
        if (this.downloadProgressThread != null && !this.downloadProgressThread.isAlive()) {
            this.downloadProgressThread = null;
        }
        if (this.downloadProgressThread == null) {
            this.downloadProgressThread = new Thread("ZAP-DownloadInstaller"){

                @Override
                public void run() {
                    while (ExtensionAutoUpdate.this.downloadManager.getCurrentDownloadCount() > 0) {
                        ExtensionAutoUpdate.this.getScanStatus().setScanCount(ExtensionAutoUpdate.this.downloadManager.getCurrentDownloadCount());
                        if (ExtensionAutoUpdate.this.addonsDialog != null && ExtensionAutoUpdate.this.addonsDialog.isVisible()) {
                            ExtensionAutoUpdate.this.addonsDialog.showProgress();
                        }
                        try {
                            3.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (ExtensionAutoUpdate.this.addonsDialog != null) {
                        ExtensionAutoUpdate.this.addonsDialog.showProgress();
                    }
                    ExtensionAutoUpdate.this.getScanStatus().setScanCount(0);
                    ExtensionAutoUpdate.this.installNewExtensions();
                }
            };
            this.installsOk = true;
            this.installsCompleted = false;
            this.downloadProgressThread.start();
        }
    }

    public void installNewExtensions() {
        OptionsParamCheckForUpdates options = this.getModel().getOptionsParam().getCheckForUpdatesParam();
        ArrayList<Downloader> handledFiles = new ArrayList<Downloader>();
        MutableBoolean allInstalled = new MutableBoolean(true);
        block4: for (Downloader dl : this.downloadFiles) {
            if (dl.getFinished() == null) continue;
            handledFiles.add(dl);
            try {
                if (!dl.isValidated()) {
                    logger.debug("Ignoring unvalidated download: " + dl.getUrl());
                    allInstalled.setFalse();
                    if (this.addonsDialog != null) {
                        this.addonsDialog.notifyAddOnDownloadFailed(dl.getUrl().toString());
                        continue;
                    }
                    String url = dl.getUrl().toString();
                    for (AddOn addOn : this.latestVersionInfo.getAddOns()) {
                        if (!url.equals(addOn.getUrl().toString())) continue;
                        addOn.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
                        continue block4;
                    }
                    continue;
                }
                if (!AddOn.isAddOnFileName(dl.getTargetFile().getName())) continue;
                File f = dl.getTargetFile();
                if (!options.getDownloadDirectory().equals(dl.getTargetFile().getParentFile())) {
                    try {
                        f = new File(options.getDownloadDirectory(), dl.getTargetFile().getName());
                        logger.info("Moving downloaded add-on from " + dl.getTargetFile().getAbsolutePath() + " to " + f.getAbsolutePath());
                        FileUtils.moveFile((File)dl.getTargetFile(), (File)f);
                    }
                    catch (Exception e) {
                        if (!f.exists() && dl.getTargetFile().exists()) {
                            logger.error("Failed to move downloaded add-on from " + dl.getTargetFile().getAbsolutePath() + " to " + f.getAbsolutePath() + " - left at original location", (Throwable)e);
                            f = dl.getTargetFile();
                        }
                        logger.error("Failed to move downloaded add-on from " + dl.getTargetFile().getAbsolutePath() + " to " + f.getAbsolutePath() + " - skipping", (Throwable)e);
                        allInstalled.setFalse();
                        continue;
                    }
                }
                AddOn.createAddOn(f.toPath()).ifPresent(ao -> {
                    if (ao.canLoadInCurrentVersion()) {
                        allInstalled.setValue(allInstalled.booleanValue() & this.install((AddOn)ao));
                    } else {
                        logger.info("Cant load add-on " + ao.getName() + " Not before=" + ao.getNotBeforeVersion() + " Not from=" + ao.getNotFromVersion() + " Version=" + Constant.PROGRAM_VERSION);
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (Downloader dl : handledFiles) {
            this.downloadFiles.remove(dl);
        }
        this.installsCompleted = true;
        this.installsOk = allInstalled.booleanValue();
    }

    public int getDownloadProgressPercent(URL url) throws Exception {
        return this.downloadManager.getProgressPercent(url);
    }

    public int getCurrentDownloadCount() {
        return this.downloadManager.getCurrentDownloadCount();
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addHelpMenuItem(this.getMenuItemCheckUpdate());
            extensionHook.getHookMenu().addFileMenuItem(this.getMenuItemLoadAddOn());
            extensionHook.getHookView().addMainToolBarComponent(this.getAddonsButton());
            extensionHook.getHookView().addMainToolBarComponent(this.getCheckForUpdatesButton());
            this.getView().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.getScanStatus().getCountLabel());
        }
        extensionHook.addCommandLine(this.getCommandLineArguments());
        this.api = new AutoUpdateAPI(this);
        this.api.addApiOptions(this.getModel().getOptionsParam().getCheckForUpdatesParam());
        extensionHook.addApiImplementor(this.api);
    }

    private ScanStatus getScanStatus() {
        if (this.scanStatus == null) {
            this.scanStatus = new ScanStatus(new ImageIcon(ExtensionAutoUpdate.class.getResource("/resource/icon/fugue/download.png")), Constant.messages.getString("cfu.downloads.icon.title"));
        }
        return this.scanStatus;
    }

    private JButton getAddonsButton() {
        if (this.addonsButton == null) {
            this.addonsButton = new JButton();
            this.addonsButton.setIcon(new ImageIcon(ExtensionAutoUpdate.class.getResource("/resource/icon/fugue/block.png")));
            this.addonsButton.setToolTipText(Constant.messages.getString("cfu.button.addons.browse"));
            this.addonsButton.setEnabled(true);
            this.addonsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionAutoUpdate.this.getAddOnsDialog().setVisible(true);
                }
            });
        }
        return this.addonsButton;
    }

    private JButton getCheckForUpdatesButton() {
        if (this.checkForUpdatesButton == null) {
            this.checkForUpdatesButton = new JButton();
            this.checkForUpdatesButton.setIcon(new ImageIcon(ExtensionAutoUpdate.class.getResource("/resource/icon/fugue/update-zap.png")));
            this.checkForUpdatesButton.setToolTipText(Constant.messages.getString("cfu.button.checkForUpdates"));
            this.checkForUpdatesButton.setEnabled(true);
            this.checkForUpdatesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionAutoUpdate.this.checkForUpdates(true);
                }
            });
        }
        return this.checkForUpdatesButton;
    }

    private void checkForUpdates(boolean force) {
        this.getAddOnsDialog().setVisible(true);
        this.getAddOnsDialog().checkForUpdates(force);
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("autoupdate.desc");
    }

    @Override
    public void destroy() {
        this.downloadManager.shutdown(true);
    }

    private HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 7);
        }
        return this.httpSender;
    }

    private int dayDiff(Date d1, Date d2) {
        long diff = d1.getTime() - d2.getTime();
        return (int)(diff / 86400000L);
    }

    public void alertIfNewVersions() {
        File f;
        ZapRelease rel;
        OptionsParamCheckForUpdates options = this.getModel().getOptionsParam().getCheckForUpdatesParam();
        if (Constant.isSilent()) {
            logger.info("Shh! No check-for-update - silent mode enabled");
            return;
        }
        if (this.hasView() && this.getPreviousVersionInfo() != null && (rel = this.getPreviousVersionInfo().getZapRelease()) != null && rel.isNewerThan(this.getCurrentVersion()) && (f = new File(Constant.FOLDER_LOCAL_PLUGIN, rel.getFileName())).exists() && f.length() >= rel.getSize()) {
            this.promptToLaunchReleaseAndClose(rel.getVersion(), f);
        }
        if (!options.checkOnStart()) {
            if (this.hasView()) {
                this.alertIfOutOfDate(false);
            }
            return;
        }
        this.getLatestVersionInfo(this, false);
    }

    private void warnIfOutOfDate() {
        OptionsParamCheckForUpdates options = this.getModel().getOptionsParam().getCheckForUpdatesParam();
        Date today = new Date();
        Date releaseCreated = Constant.getReleaseCreateDate();
        if (releaseCreated != null && this.dayDiff(today, releaseCreated) > 365) {
            if (ZAP.getProcessType().equals((Object)ZAP.ProcessType.cmdline)) {
                CommandLine.error("This ZAP installation is over a year old - its probably very out of date");
            } else {
                logger.warn("This ZAP installation is over a year old - its probably very out of date");
            }
            return;
        }
        Date lastChecked = options.getDayLastChecked();
        Date installDate = Constant.getInstallDate();
        if (installDate != null && this.dayDiff(today, installDate) >= 90 && (lastChecked == null || this.dayDiff(today, lastChecked) > 90)) {
            if (ZAP.getProcessType().equals((Object)ZAP.ProcessType.cmdline)) {
                CommandLine.error("No check for updates for over 3 month - add-ons may well be out of date");
            } else {
                logger.warn("No check for updates for over 3 month - add-ons may well be out of date");
            }
        }
    }

    private void alertIfOutOfDate(boolean alwaysPrompt) {
        OptionsParamCheckForUpdates options = this.getModel().getOptionsParam().getCheckForUpdatesParam();
        Date today = new Date();
        Date releaseCreated = Constant.getReleaseCreateDate();
        Date lastInstallWarning = options.getDayLastInstallWarned();
        int result = -1;
        logger.debug("Install created " + releaseCreated);
        if (releaseCreated != null) {
            int daysOld = this.dayDiff(today, releaseCreated);
            logger.debug("Install is " + daysOld + " days old");
            if (daysOld > 365) {
                boolean setCfuOnStart = false;
                if (alwaysPrompt || lastInstallWarning == null || this.dayDiff(today, lastInstallWarning) > 30) {
                    JCheckBox cfuOnStart = new JCheckBox(Constant.messages.getString("cfu.label.cfuonstart"));
                    cfuOnStart.setSelected(true);
                    String msg = Constant.messages.getString("cfu.label.oldzap");
                    result = View.getSingleton().showYesNoDialog(this.getView().getMainFrame(), new Object[]{msg, cfuOnStart});
                    setCfuOnStart = cfuOnStart.isSelected();
                }
                options.setDayLastInstallWarned();
                if (result == 0) {
                    if (setCfuOnStart) {
                        options.setCheckOnStart(true);
                    }
                    this.getAddOnsDialog().setVisible(true);
                    this.getAddOnsDialog().checkForUpdates(false);
                } else if (!this.oldZapAlertAdded) {
                    JButton button = new JButton(Constant.messages.getString("cfu.label.outofdatezap"));
                    button.setIcon(new ImageIcon(ExtensionAutoUpdate.class.getResource("/resource/icon/16/050.png")));
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExtensionAutoUpdate.this.alertIfOutOfDate(true);
                        }
                    });
                    this.getView().getMainFrame().getMainFooterPanel().addFooterToolbarLeftComponent(button);
                    this.oldZapAlertAdded = true;
                }
                return;
            }
        }
        Date lastChecked = options.getDayLastChecked();
        Date lastUpdateWarning = options.getDayLastUpdateWarned();
        Date installDate = Constant.getInstallDate();
        if (installDate != null && this.dayDiff(today, installDate) >= 90 && (lastChecked == null || this.dayDiff(today, lastChecked) > 90)) {
            boolean setCfuOnStart = false;
            if (alwaysPrompt || lastUpdateWarning == null || this.dayDiff(today, lastUpdateWarning) > 30) {
                JCheckBox cfuOnStart = new JCheckBox(Constant.messages.getString("cfu.label.cfuonstart"));
                cfuOnStart.setSelected(true);
                String msg = Constant.messages.getString("cfu.label.norecentcfu");
                result = View.getSingleton().showYesNoDialog(this.getView().getMainFrame(), new Object[]{msg, cfuOnStart});
                setCfuOnStart = cfuOnStart.isSelected();
            }
            options.setDayLastUpdateWarned();
            if (result == 0) {
                if (setCfuOnStart) {
                    options.setCheckOnStart(true);
                }
                this.getAddOnsDialog().setVisible(true);
                this.getAddOnsDialog().checkForUpdates(false);
                if (this.noCfuAlertAdded) {
                    this.getView().getMainFrame().getMainFooterPanel().removeFooterToolbarLeftComponent(this.getOutOfDateButton());
                }
            } else if (!this.noCfuAlertAdded) {
                this.getView().getMainFrame().getMainFooterPanel().addFooterToolbarLeftComponent(this.getOutOfDateButton());
                this.noCfuAlertAdded = true;
            }
        }
    }

    private JButton getOutOfDateButton() {
        if (this.outOfDateButton == null) {
            this.outOfDateButton = new JButton(Constant.messages.getString("cfu.label.outofdateaddons"));
            this.outOfDateButton.setIcon(new ImageIcon(ExtensionAutoUpdate.class.getResource("/resource/icon/16/050.png")));
            this.outOfDateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionAutoUpdate.this.alertIfOutOfDate(true);
                }
            });
        }
        return this.outOfDateButton;
    }

    protected AddOnCollection getLocalVersionInfo() {
        if (this.localVersionInfo == null) {
            this.localVersionInfo = ExtensionFactory.getAddOnLoader().getAddOnCollection();
        }
        return this.localVersionInfo;
    }

    private ZapXmlConfiguration getRemoteConfigurationUrl(String url) throws IOException, ConfigurationException, InvalidCfuUrlException {
        HttpMessage msg = new HttpMessage(new URI(url, true));
        this.getHttpSender().sendAndReceive(msg, true);
        if (msg.getResponseHeader().getStatusCode() != 200) {
            throw new IOException("Expected '200 OK' but got '" + msg.getResponseHeader().getStatusCode() + " " + msg.getResponseHeader().getReasonPhrase() + "'");
        }
        if (!msg.getRequestHeader().isSecure()) {
            throw new InvalidCfuUrlException(msg.getRequestHeader().getURI().toString());
        }
        ZapXmlConfiguration config = new ZapXmlConfiguration();
        config.setDelimiterParsingDisabled(true);
        config.load(new StringReader(msg.getResponseBody().toString()));
        File f = new File(Constant.FOLDER_LOCAL_PLUGIN, VERSION_FILE_NAME);
        try {
            Files.write(f.toPath(), msg.getResponseBody().getBytes(), new OpenOption[0]);
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
        return config;
    }

    protected String getLatestVersionNumber() {
        if (this.getLatestVersionInfo() == null || this.getLatestVersionInfo().getZapRelease() == null) {
            return null;
        }
        return this.getLatestVersionInfo().getZapRelease().getVersion();
    }

    protected boolean isLatestVersion() {
        if (this.getLatestVersionInfo() == null || this.getLatestVersionInfo().getZapRelease() == null) {
            return true;
        }
        return !this.getLatestVersionInfo().getZapRelease().isNewerThan(this.getCurrentVersion());
    }

    protected boolean downloadLatestRelease() {
        if (Constant.isKali()) {
            if (this.hasView()) {
                View.getSingleton().showMessageDialog(this.getAddOnsDialog(), Constant.messages.getString("cfu.kali.options"));
            }
            return false;
        }
        if (this.getLatestVersionInfo() == null || this.getLatestVersionInfo().getZapRelease() == null) {
            return false;
        }
        ZapRelease latestRelease = this.getLatestVersionInfo().getZapRelease();
        if (latestRelease.isNewerThan(this.getCurrentVersion())) {
            File f = new File(Constant.FOLDER_LOCAL_PLUGIN, latestRelease.getFileName());
            this.downloadFile(latestRelease.getUrl(), f, latestRelease.getSize(), latestRelease.getHash());
            return true;
        }
        return false;
    }

    private AddOnCollection getPreviousVersionInfo() {
        File f;
        if (this.previousVersionInfo == null && (f = new File(Constant.FOLDER_LOCAL_PLUGIN, VERSION_FILE_NAME)).exists()) {
            try {
                this.previousVersionInfo = new AddOnCollection(new ZapXmlConfiguration(f), this.getPlatform());
            }
            catch (ConfigurationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.previousVersionInfo;
    }

    protected List<Downloader> getAllDownloadsProgress() {
        return this.downloadManager.getProgress();
    }

    protected List<AddOn> getUpdatedAddOns() {
        return this.getLocalVersionInfo().getUpdatedAddOns(this.getLatestVersionInfo());
    }

    protected List<AddOn> getNewAddOns() {
        if (this.getPreviousVersionInfo() != null) {
            return this.getPreviousVersionInfo().getNewAddOns(this.getLatestVersionInfo());
        }
        return this.getLocalVersionInfo().getNewAddOns(this.getLatestVersionInfo());
    }

    protected AddOn getAddOn(String id) {
        AddOnCollection aoc = this.getLatestVersionInfo();
        if (aoc != null) {
            return aoc.getAddOn(id);
        }
        return null;
    }

    protected List<AddOn> getInstalledAddOns() {
        return this.getLocalVersionInfo().getInstalledAddOns();
    }

    protected List<AddOn> getLocalAddOns() {
        return this.getLocalVersionInfo().getAddOns();
    }

    protected List<AddOn> getMarketplaceAddOns() {
        AddOnCollection aoc = this.getLatestVersionInfo();
        if (aoc != null) {
            return aoc.getAddOns();
        }
        return Collections.emptyList();
    }

    protected AddOnCollection getLatestVersionInfo() {
        return this.getLatestVersionInfo(null, false);
    }

    protected AddOnCollection getLatestVersionInfo(final CheckForUpdateCallback callback, boolean force) {
        if (this.latestVersionInfo == null || force) {
            if (this.remoteCallThread == null || !this.remoteCallThread.isAlive()) {
                this.remoteCallThread = new Thread("ZAP-cfu"){

                    @Override
                    public void run() {
                        String longUrl;
                        String shortUrl;
                        if (Constant.isDevBuild()) {
                            shortUrl = ExtensionAutoUpdate.ZAP_VERSIONS_DEV_XML_SHORT;
                            longUrl = ExtensionAutoUpdate.ZAP_VERSIONS_DEV_XML_FULL;
                        } else if (Constant.isDailyBuild()) {
                            shortUrl = ExtensionAutoUpdate.ZAP_VERSIONS_WEEKLY_XML_SHORT;
                            longUrl = ExtensionAutoUpdate.ZAP_VERSIONS_DEV_XML_FULL;
                        } else if (View.isInitialised()) {
                            shortUrl = ExtensionAutoUpdate.ZAP_VERSIONS_REL_XML_DESKTOP_SHORT;
                            longUrl = ExtensionAutoUpdate.ZAP_VERSIONS_REL_XML_FULL;
                        } else {
                            shortUrl = ExtensionAutoUpdate.ZAP_VERSIONS_REL_XML_DAEMON_SHORT;
                            longUrl = ExtensionAutoUpdate.ZAP_VERSIONS_REL_XML_FULL;
                        }
                        boolean noInsecureUrlErrors = true;
                        logger.debug("Getting latest version info from " + shortUrl);
                        try {
                            ExtensionAutoUpdate.this.latestVersionInfo = new AddOnCollection(ExtensionAutoUpdate.this.getRemoteConfigurationUrl(shortUrl), ExtensionAutoUpdate.this.getPlatform(), false);
                        }
                        catch (Exception e1) {
                            logger.debug("Failed to access " + shortUrl, (Throwable)e1);
                            logger.debug("Getting latest version info from " + longUrl);
                            try {
                                ExtensionAutoUpdate.this.latestVersionInfo = new AddOnCollection(ExtensionAutoUpdate.this.getRemoteConfigurationUrl(longUrl), ExtensionAutoUpdate.this.getPlatform(), false);
                            }
                            catch (SSLHandshakeException | InvalidCfuUrlException e2) {
                                noInsecureUrlErrors = false;
                                if (callback != null) {
                                    callback.insecureUrl(longUrl, e2);
                                }
                            }
                            catch (Exception e2) {
                                logger.warn("Failed to check for updates using: " + longUrl, (Throwable)e2);
                            }
                        }
                        if (ExtensionAutoUpdate.this.latestVersionInfo != null) {
                            for (AddOn addOn : ExtensionAutoUpdate.this.latestVersionInfo.getAddOns()) {
                                AddOn localAddOn = ExtensionAutoUpdate.this.getLocalVersionInfo().getAddOn(addOn.getId());
                                if (localAddOn == null || addOn.isUpdateTo(localAddOn)) continue;
                                addOn.setInstallationStatus(localAddOn.getInstallationStatus());
                            }
                        }
                        if (noInsecureUrlErrors && callback != null) {
                            logger.debug("Calling callback with " + ExtensionAutoUpdate.this.latestVersionInfo);
                            callback.gotLatestData(ExtensionAutoUpdate.this.latestVersionInfo);
                        }
                        logger.debug("Done");
                    }
                };
                this.remoteCallThread.start();
            }
            if (callback == null) {
                int i = 0;
                while (this.latestVersionInfo == null && this.remoteCallThread.isAlive() && i < 60) {
                    try {
                        Thread.sleep(1000L);
                        ++i;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.latestVersionInfo;
    }

    private String getCurrentVersion() {
        return Constant.PROGRAM_VERSION;
    }

    private AddOnCollection.Platform getPlatform() {
        if (Constant.isDailyBuild()) {
            return AddOnCollection.Platform.daily;
        }
        if (Constant.isWindows()) {
            return AddOnCollection.Platform.windows;
        }
        if (Constant.isLinux()) {
            return AddOnCollection.Platform.linux;
        }
        return AddOnCollection.Platform.mac;
    }

    protected void promptToLaunchReleaseAndClose(String version, File f) {
        int ans = this.getView().showConfirmDialog(Constant.messages.getString("cfu.confirm.launch", version, f.getAbsolutePath()));
        if (ans == 0) {
            Control.getSingleton().exit(false, f);
        }
    }

    private boolean install(AddOn ao) {
        AddOn addOn;
        if (!ao.canLoadInCurrentVersion()) {
            throw new IllegalArgumentException("Cant load add-on " + ao.getName() + " Not before=" + ao.getNotBeforeVersion() + " Not from=" + ao.getNotFromVersion() + " Version=" + Constant.PROGRAM_VERSION);
        }
        AddOn installedAddOn = this.getLocalVersionInfo().getAddOn(ao.getId());
        if (installedAddOn != null && !this.uninstallAddOn(null, installedAddOn, true)) {
            return false;
        }
        logger.info("Installing new addon " + ao.getId() + " v" + ao.getVersion());
        if (this.hasView()) {
            this.getView().getOutputPanel().append(Constant.messages.getString("cfu.output.installing", ao.getName(), ao.getVersion()) + "\n");
        }
        ExtensionFactory.getAddOnLoader().addAddon(ao);
        logger.info("Finished installing new addon " + ao.getId() + " v" + ao.getVersion());
        if (this.hasView()) {
            this.getView().getOutputPanel().append(Constant.messages.getString("cfu.output.installing.finished", ao.getName(), ao.getVersion()) + "\n");
        }
        if (this.latestVersionInfo != null && (addOn = this.latestVersionInfo.getAddOn(ao.getId())) != null && AddOn.InstallationStatus.DOWNLOADING == addOn.getInstallationStatus()) {
            addOn.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
        }
        if (this.addonsDialog != null) {
            this.addonsDialog.notifyAddOnInstalled(ao);
        }
        return true;
    }

    private boolean uninstall(AddOn addOn, boolean upgrading, AddOnUninstallationProgressCallback callback) {
        logger.debug("Trying to uninstall addon " + addOn.getId() + " v" + addOn.getVersion());
        boolean removedDynamically = ExtensionFactory.getAddOnLoader().removeAddOn(addOn, upgrading, callback);
        if (removedDynamically) {
            AddOn availableAddOn;
            logger.debug("Uninstalled add-on " + addOn.getName());
            if (this.latestVersionInfo != null && (availableAddOn = this.latestVersionInfo.getAddOn(addOn.getId())) != null && availableAddOn.getInstallationStatus() != AddOn.InstallationStatus.AVAILABLE) {
                availableAddOn.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
            }
        } else {
            logger.debug("Failed to uninstall add-on " + addOn.getId() + " v" + addOn.getVersion());
        }
        return removedDynamically;
    }

    @Override
    public void insecureUrl(String url, Exception cause) {
        logger.error("Failed to get check for updates on " + url, (Throwable)cause);
        if (this.hasView()) {
            this.getView().showWarningDialog(Constant.messages.getString("cfu.warn.badurl"));
        }
    }

    @Override
    public void gotLatestData(AddOnCollection aoc) {
        if (aoc == null) {
            return;
        }
        if (this.getView() != null) {
            try {
                EventQueue.invokeAndWait(() -> this.getAddOnsDialog());
            }
            catch (InterruptedException | InvocationTargetException e) {
                logger.error("Failed to initialise the Manage Add-ons dialogue:", (Throwable)e);
            }
        }
        try {
            List<AddOn> newAddOns;
            ZapRelease rel = aoc.getZapRelease();
            OptionsParamCheckForUpdates options = this.getModel().getOptionsParam().getCheckForUpdatesParam();
            if (rel.isNewerThan(this.getCurrentVersion())) {
                logger.debug("There is a newer release: " + rel.getVersion());
                if (Constant.isKali()) {
                    if (this.hasView()) {
                        this.getAddOnsDialog().setVisible(true);
                    }
                    return;
                }
                File f = new File(Constant.FOLDER_LOCAL_PLUGIN, rel.getFileName());
                if (f.exists() && f.length() >= rel.getSize()) {
                    this.promptToLaunchReleaseAndClose(rel.getVersion(), f);
                } else if (options.isDownloadNewRelease()) {
                    logger.debug("Auto-downloading release");
                    if (this.downloadLatestRelease() && this.addonsDialog != null) {
                        this.addonsDialog.setDownloadingZap();
                    }
                } else if (this.addonsDialog != null) {
                    this.addonsDialog.setVisible(true);
                }
                return;
            }
            boolean keepChecking = this.checkForAddOnUpdates(aoc, options);
            if (keepChecking && this.addonsDialog != null && (newAddOns = this.getNewAddOns()).size() > 0) {
                boolean report = false;
                for (AddOn addon : newAddOns) {
                    switch (addon.getStatus()) {
                        case alpha: {
                            if (!options.isReportAlphaAddons()) break;
                            report = true;
                            break;
                        }
                        case beta: {
                            if (!options.isReportBetaAddons()) break;
                            report = true;
                            break;
                        }
                        case release: {
                            if (!options.isReportReleaseAddons()) break;
                            report = true;
                            break;
                        }
                    }
                }
                if (report) {
                    this.getAddOnsDialog().setVisible(true);
                    this.getAddOnsDialog().selectMarketplaceTab();
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private boolean checkForAddOnUpdates(AddOnCollection aoc, OptionsParamCheckForUpdates options) {
        List<AddOn> updates = this.getUpdatedAddOns();
        if (updates.isEmpty()) {
            return true;
        }
        logger.info("There is/are " + updates.size() + " newer addons");
        AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(this.localVersionInfo, aoc);
        HashSet<AddOn> addOns = new HashSet<AddOn>(updates);
        AddOnDependencyChecker.AddOnChangesResult result = addOnDependencyChecker.calculateUpdateChanges(addOns);
        if (!result.getUninstalls().isEmpty() || result.isNewerJavaVersionRequired()) {
            if (options.isCheckAddonUpdates()) {
                if (this.addonsDialog != null) {
                    this.getAddOnsDialog().setVisible(true);
                    return false;
                }
                logger.info("Updates not installed some add-ons would be uninstalled or require newer java version: " + result.getUninstalls());
            }
            return true;
        }
        if (options.isInstallAddonUpdates()) {
            logger.debug("Auto-downloading addons");
            this.processAddOnChanges(null, result);
            return false;
        }
        if (options.isInstallScannerRules()) {
            Iterator it = addOns.iterator();
            while (it.hasNext()) {
                if (((AddOn)it.next()).getId().contains("scanrules")) continue;
                it.remove();
            }
            logger.debug("Auto-downloading scanner rules");
            this.processAddOnChanges(null, addOnDependencyChecker.calculateUpdateChanges(addOns));
            return false;
        }
        if (options.isCheckAddonUpdates() && this.addonsDialog != null) {
            this.addonsDialog.setVisible(true);
            return false;
        }
        return true;
    }

    void processAddOnChanges(Window caller, AddOnDependencyChecker.AddOnChangesResult changes) {
        if (this.addonsDialog != null) {
            this.addonsDialog.setDownloadingUpdates();
        }
        if (this.getView() != null) {
            HashSet<AddOn> addOns = new HashSet<AddOn>(changes.getUninstalls());
            addOns.addAll(changes.getOldVersions());
            HashSet<Extension> extensions = new HashSet<Extension>();
            extensions.addAll(changes.getUnloadExtensions());
            extensions.addAll(changes.getSoftUnloadExtensions());
            if (!this.warnUnsavedResourcesOrActiveActions(caller, addOns, extensions, true)) {
                return;
            }
        }
        this.uninstallAddOns(caller, changes.getUninstalls(), false);
        HashSet<AddOn> allAddons = new HashSet<AddOn>(changes.getNewVersions());
        allAddons.addAll(changes.getInstalls());
        for (AddOn addOn : allAddons) {
            if (this.addonsDialog != null) {
                this.addonsDialog.notifyAddOnDownloading(addOn);
            }
            this.downloadAddOn(addOn);
        }
    }

    boolean warnUnsavedResourcesOrActiveActions(Window caller, Collection<AddOn> addOns, Set<Extension> extensions, boolean updating) {
        HashSet<AddOn> allAddOns = new HashSet<AddOn>(addOns);
        this.addDependents(allAddOns);
        String baseMessagePrefix = updating ? "cfu.update." : "cfu.uninstall.";
        String unsavedResources = ExtensionAutoUpdate.getExtensionsUnsavedResources(addOns, extensions);
        String activeActions = ExtensionAutoUpdate.getExtensionsActiveActions(addOns, extensions);
        String message = null;
        if (!unsavedResources.isEmpty()) {
            message = activeActions.isEmpty() ? Constant.messages.getString(baseMessagePrefix + "message.resourcesNotSaved", unsavedResources) : Constant.messages.getString(baseMessagePrefix + "message.resourcesNotSavedAndActiveActions", unsavedResources, activeActions);
        } else if (!activeActions.isEmpty()) {
            message = Constant.messages.getString(baseMessagePrefix + "message.activeActions", activeActions);
        }
        return message == null || JOptionPane.showConfirmDialog(this.getWindowParent(caller), message, "OWASP ZAP", 0) == 0;
    }

    private void addDependents(Set<AddOn> addOns) {
        for (AddOn availableAddOn : this.localVersionInfo.getInstalledAddOns()) {
            if (!availableAddOn.dependsOn(addOns) || addOns.contains(availableAddOn)) continue;
            addOns.add(availableAddOn);
            this.addDependents(addOns);
        }
    }

    private Window getWindowParent(Window caller) {
        if (caller != null) {
            return caller;
        }
        if (this.addonsDialog != null && this.addonsDialog.isFocused()) {
            return this.addonsDialog;
        }
        return this.getView().getMainFrame();
    }

    private static String getExtensionsUnsavedResources(Collection<AddOn> addOns, Set<Extension> extensions) {
        ArrayList<String> unsavedResources = new ArrayList<String>();
        for (AddOn addOn : addOns) {
            for (Extension extension : addOn.getLoadedExtensions()) {
                List<String> resources;
                if (!extension.isEnabled() || (resources = extension.getUnsavedResources()) == null) continue;
                unsavedResources.addAll(resources);
            }
        }
        for (Extension extension : extensions) {
            List<String> resources;
            if (!extension.isEnabled() || (resources = extension.getUnsavedResources()) == null) continue;
            unsavedResources.addAll(resources);
        }
        return ExtensionAutoUpdate.wrapEntriesInLiTags(unsavedResources);
    }

    private static String wrapEntriesInLiTags(List<String> entries) {
        if (entries.isEmpty()) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder(entries.size() * 15);
        for (String entry : entries) {
            strBuilder.append("<li>");
            strBuilder.append(entry);
            strBuilder.append("</li>");
        }
        return strBuilder.toString();
    }

    private static String getExtensionsActiveActions(Collection<AddOn> addOns, Set<Extension> extensions) {
        ArrayList<String> activeActions = new ArrayList<String>();
        for (AddOn addOn : addOns) {
            for (Extension extension : addOn.getLoadedExtensions()) {
                List<String> actions;
                if (!extension.isEnabled() || (actions = extension.getActiveActions()) == null) continue;
                activeActions.addAll(actions);
            }
        }
        for (Extension extension : extensions) {
            List<String> resources;
            if (!extension.isEnabled() || (resources = extension.getActiveActions()) == null) continue;
            activeActions.addAll(resources);
        }
        return ExtensionAutoUpdate.wrapEntriesInLiTags(activeActions);
    }

    private void downloadAddOn(AddOn addOn) {
        if (AddOn.InstallationStatus.DOWNLOADING == addOn.getInstallationStatus()) {
            return;
        }
        addOn.setInstallationStatus(AddOn.InstallationStatus.DOWNLOADING);
        this.downloadFile(addOn.getUrl(), addOn.getFile(), addOn.getSize(), addOn.getHash());
    }

    private boolean uninstallAddOn(Window caller, AddOn addOn, boolean update) {
        HashSet<AddOn> addOns = new HashSet<AddOn>();
        addOns.add(addOn);
        return this.uninstallAddOns(caller, addOns, update);
    }

    boolean uninstallAddOns(Window caller, Set<AddOn> addOns, boolean updates) {
        if (addOns == null || addOns.isEmpty()) {
            return true;
        }
        if (this.getView() != null) {
            return this.uninstallAddOnsWithView(caller, addOns, updates, new HashSet<AddOn>());
        }
        HashSet<AddOn> failedUninstallations = new HashSet<AddOn>();
        for (AddOn addOn : addOns) {
            if (this.uninstall(addOn, false, null)) continue;
            failedUninstallations.add(addOn);
        }
        if (!failedUninstallations.isEmpty()) {
            logger.warn("It's recommended to restart ZAP. Not all add-ons were successfully uninstalled: " + failedUninstallations);
            return false;
        }
        return true;
    }

    boolean uninstallAddOnsWithView(final Window caller, final Set<AddOn> addOns, final boolean updates, final Set<AddOn> failedUninstallations) {
        if (addOns == null || addOns.isEmpty()) {
            return true;
        }
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAutoUpdate.this.uninstallAddOnsWithView(caller, addOns, updates, failedUninstallations);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                logger.error("Failed to uninstall add-ons:", (Throwable)e);
                return false;
            }
            return failedUninstallations.isEmpty();
        }
        Window parent = this.getWindowParent(caller);
        final UninstallationProgressDialogue waitDialogue = new UninstallationProgressDialogue(parent, addOns);
        waitDialogue.addAddOnUninstallListener(new UninstallationProgressDialogue.AddOnUninstallListener(){

            @Override
            public void uninstallingAddOn(AddOn addOn, boolean updating) {
                if (updating) {
                    ExtensionAutoUpdate.this.getView().getOutputPanel().append(Constant.messages.getString("cfu.output.replacing", addOn.getName(), addOn.getVersion()) + "\n");
                }
            }

            @Override
            public void addOnUninstalled(AddOn addOn, boolean update, boolean uninstalled) {
                if (uninstalled) {
                    if (!update && ExtensionAutoUpdate.this.addonsDialog != null) {
                        ExtensionAutoUpdate.this.addonsDialog.notifyAddOnUninstalled(addOn);
                    }
                    ExtensionAutoUpdate.this.getView().getOutputPanel().append(Constant.messages.getString("cfu.output.uninstalled", addOn.getName(), addOn.getVersion()) + "\n");
                } else {
                    if (ExtensionAutoUpdate.this.addonsDialog != null) {
                        ExtensionAutoUpdate.this.addonsDialog.notifyAddOnFailedUninstallation(addOn);
                    }
                    String message = update ? Constant.messages.getString("cfu.output.replace.failed", addOn.getName(), addOn.getVersion()) : Constant.messages.getString("cfu.output.uninstall.failed", addOn.getName(), addOn.getVersion());
                    ExtensionAutoUpdate.this.getView().getOutputPanel().append(message + "\n");
                }
            }
        });
        SwingWorker<Void, UninstallationProgressDialogue.UninstallationProgressEvent> a = new SwingWorker<Void, UninstallationProgressDialogue.UninstallationProgressEvent>(){

            @Override
            protected void process(List<UninstallationProgressDialogue.UninstallationProgressEvent> events) {
                waitDialogue.update(events);
            }

            @Override
            protected Void doInBackground() {
                UninstallationProgressDialogue.UninstallationProgressHandler progressHandler = new UninstallationProgressDialogue.UninstallationProgressHandler(){

                    @Override
                    protected void publishEvent(UninstallationProgressDialogue.UninstallationProgressEvent event) {
                        this.publish(new UninstallationProgressDialogue.UninstallationProgressEvent[]{event});
                    }
                };
                for (AddOn addOn : addOns) {
                    if (ExtensionAutoUpdate.this.uninstall(addOn, updates, progressHandler)) continue;
                    failedUninstallations.add(addOn);
                }
                if (!failedUninstallations.isEmpty()) {
                    logger.warn("Not all add-ons were successfully uninstalled: " + failedUninstallations);
                }
                return null;
            }
        };
        waitDialogue.bind(a);
        a.execute();
        waitDialogue.setSynchronous(updates);
        waitDialogue.setVisible(true);
        return failedUninstallations.isEmpty();
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-addoninstall", 1, null, "", "-addoninstall <addOnId>   " + Constant.messages.getString("cfu.cmdline.install.help"));
        this.arguments[1] = new CommandLineArgument("-addoninstallall", 0, null, "", "-addoninstallall          " + Constant.messages.getString("cfu.cmdline.installall.help"));
        this.arguments[2] = new CommandLineArgument("-addonuninstall", 1, null, "", "-addonuninstall <addOnId> " + Constant.messages.getString("cfu.cmdline.uninstall.help"));
        this.arguments[3] = new CommandLineArgument("-addonupdate", 0, null, "", "-addonupdate              " + Constant.messages.getString("cfu.cmdline.update.help"));
        this.arguments[4] = new CommandLineArgument("-addonlist", 0, null, "", "-addonlist                " + Constant.messages.getString("cfu.cmdline.list.help"));
        return this.arguments;
    }

    public synchronized String installAddOns(List<String> addons) {
        StringBuilder errorMessages = new StringBuilder();
        AddOnCollection aoc = this.getLatestVersionInfo();
        if (aoc == null) {
            String error = Constant.messages.getString("cfu.cmdline.nocfu");
            errorMessages.append(error);
            CommandLine.error(error);
        } else {
            for (String aoName : addons) {
                AddOnDependencyChecker.AddOnChangesResult result;
                AddOn ao = aoc.getAddOn(aoName);
                if (ao == null) {
                    String error = Constant.messages.getString("cfu.cmdline.noaddon", aoName);
                    errorMessages.append(error);
                    errorMessages.append("\n");
                    CommandLine.error(error);
                    continue;
                }
                AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(this.getLocalVersionInfo(), aoc);
                AddOn iao = this.getLocalVersionInfo().getAddOn(aoName);
                if (iao != null) {
                    if (!ao.isUpdateTo(iao)) {
                        CommandLine.info(Constant.messages.getString("cfu.cmdline.addoninst", iao.getFile().getAbsolutePath()));
                        continue;
                    }
                    result = addOnDependencyChecker.calculateUpdateChanges(ao);
                } else {
                    result = addOnDependencyChecker.calculateInstallChanges(ao);
                }
                if (!result.getUninstalls().isEmpty()) {
                    String error = Constant.messages.getString("cfu.cmdline.addoninst.uninstalls.required", result.getUninstalls());
                    errorMessages.append(error);
                    errorMessages.append("\n");
                    CommandLine.error(error);
                    continue;
                }
                HashSet<AddOn> allAddOns = new HashSet<AddOn>();
                allAddOns.addAll(result.getInstalls());
                allAddOns.addAll(result.getNewVersions());
                for (AddOn addOn : allAddOns) {
                    CommandLine.info(Constant.messages.getString("cfu.cmdline.addonurl", addOn.getUrl()));
                }
                this.processAddOnChanges(null, result);
            }
            this.waitForDownloadInstalls();
            if (!this.installsOk) {
                errorMessages.append(Constant.messages.getString("cfu.cmdline.addoninst.error")).append("\n");
            }
        }
        return errorMessages.toString();
    }

    public synchronized String uninstallAddOns(List<String> addons) {
        StringBuilder errorMessages = new StringBuilder();
        AddOnCollection aoc = this.getLocalVersionInfo();
        if (aoc == null) {
            String error = Constant.messages.getString("cfu.cmdline.nocfu");
            errorMessages.append(error);
            CommandLine.error(error);
        } else {
            for (String aoName : addons) {
                String error;
                AddOn ao = aoc.getAddOn(aoName);
                if (ao == null) {
                    String error2 = Constant.messages.getString("cfu.cmdline.noaddon", aoName);
                    errorMessages.append(error2);
                    errorMessages.append("\n");
                    CommandLine.error(error2);
                    continue;
                }
                AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(this.getLocalVersionInfo(), aoc);
                HashSet<AddOn> addonSet = new HashSet<AddOn>();
                addonSet.add(ao);
                AddOnDependencyChecker.UninstallationResult result = addOnDependencyChecker.calculateUninstallChanges(addonSet);
                if (result.getUninstallations().size() > 1) {
                    result.getUninstallations().remove(ao);
                    error = Constant.messages.getString("cfu.cmdline.addonuninst.uninstalls.required", result.getUninstallations());
                    errorMessages.append(error);
                    errorMessages.append("\n");
                    CommandLine.error(error);
                    continue;
                }
                if (this.uninstallAddOn(null, ao, false)) {
                    CommandLine.info(Constant.messages.getString("cfu.cmdline.uninstallok", aoName));
                    continue;
                }
                error = Constant.messages.getString("cfu.cmdline.uninstallfail", aoName);
                errorMessages.append(error);
                errorMessages.append("\n");
                CommandLine.error(error);
            }
        }
        return errorMessages.toString();
    }

    @Override
    public void execute(CommandLineArgument[] args) {
        Vector<String> params;
        AddOnCollection aoc;
        if (this.arguments[3].isEnabled()) {
            aoc = this.getLatestVersionInfo();
            if (aoc == null) {
                CommandLine.error(Constant.messages.getString("cfu.cmdline.nocfu"));
            } else {
                OptionsParamCheckForUpdates options = new OptionsParamCheckForUpdates();
                options.load((FileConfiguration)new XMLPropertiesConfiguration());
                options.setCheckOnStart(true);
                options.setCheckAddonUpdates(true);
                options.setInstallAddonUpdates(true);
                this.checkForAddOnUpdates(aoc, options);
                this.waitForDownloadInstalls();
                CommandLine.info(Constant.messages.getString("cfu.cmdline.updated"));
            }
        }
        if (this.arguments[1].isEnabled()) {
            aoc = this.getLatestVersionInfo();
            if (aoc == null) {
                CommandLine.error(Constant.messages.getString("cfu.cmdline.nocfu"));
            } else {
                AddOnDependencyChecker addOnDependencyChecker = new AddOnDependencyChecker(this.getLocalVersionInfo(), aoc);
                AddOnDependencyChecker.AddOnChangesResult allResults = null;
                HashSet<AddOn> allAddOns = new HashSet<AddOn>();
                for (AddOn ao : aoc.getAddOns()) {
                    AddOnDependencyChecker.AddOnChangesResult result;
                    if (ao.getId().equals("coreLang") && (Constant.isDevBuild() || Constant.isDailyBuild())) continue;
                    AddOn iao = this.getLocalVersionInfo().getAddOn(ao.getId());
                    if (iao != null) {
                        if (!ao.isUpdateTo(iao)) continue;
                        result = addOnDependencyChecker.calculateUpdateChanges(ao);
                    } else {
                        result = addOnDependencyChecker.calculateInstallChanges(ao);
                    }
                    if (!result.getUninstalls().isEmpty()) continue;
                    allAddOns.addAll(result.getInstalls());
                    allAddOns.addAll(result.getNewVersions());
                    if (allResults == null) {
                        allResults = result;
                        continue;
                    }
                    allResults.addResults(result);
                }
                if (allAddOns.isEmpty()) {
                    return;
                }
                for (AddOn addOn : allAddOns) {
                    CommandLine.info(Constant.messages.getString("cfu.cmdline.addonurl", addOn.getUrl()));
                }
                this.processAddOnChanges(null, allResults);
                this.waitForDownloadInstalls();
            }
        }
        if (this.arguments[0].isEnabled()) {
            params = this.arguments[0].getArguments();
            this.installAddOns(params);
        }
        if (this.arguments[2].isEnabled()) {
            params = this.arguments[2].getArguments();
            this.uninstallAddOns(params);
        }
        if (this.arguments[4].isEnabled()) {
            aoc = this.getLocalVersionInfo();
            ArrayList<AddOn> aolist = new ArrayList<AddOn>(aoc.getAddOns());
            Collections.sort(aolist, new Comparator<AddOn>(){

                @Override
                public int compare(AddOn ao1, AddOn ao2) {
                    return ao1.getName().compareTo(ao2.getName());
                }
            });
            for (AddOn addon : aolist) {
                CommandLine.info(addon.getName() + "\t" + addon.getId() + "\tv" + addon.getVersion() + "\t" + addon.getStatus().name() + "\t" + addon.getDescription());
            }
        }
    }

    private void waitForDownloadInstalls() {
        while (this.downloadManager.getCurrentDownloadCount() > 0 || !this.installsCompleted) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (Downloader download : this.downloadManager.getProgress()) {
            if (download.isValidated()) {
                CommandLine.info(Constant.messages.getString("cfu.cmdline.addondown", download.getTargetFile().getAbsolutePath()));
                continue;
            }
            CommandLine.error(Constant.messages.getString("cfu.cmdline.addondown.failed", download.getTargetFile().getName()));
        }
    }

    @Override
    public boolean handleFile(File file) {
        return false;
    }

    @Override
    public List<String> getHandledExtensions() {
        return null;
    }
}

